/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable$;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u000f\u001e\u0001)BQa\u000e\u0001\u0005\u0002aBqA\u000f\u0001C\u0002\u0013E1\b\u0003\u0004[\u0001\u0001\u0006I\u0001\u0010\u0005\b7\u0002\u0011\r\u0011\"\u0005]\u0011\u0019!\u0007\u0001)A\u0005;\"9Q\r\u0001b\u0001\n\u00131\u0007B\u00026\u0001A\u0003%q\rC\u0004l\u0001\u0001\u0007I\u0011\u00027\t\u000fE\u0004\u0001\u0019!C\u0005e\"1\u0001\u0010\u0001Q!\n5DQ!\u001f\u0001\u0005BiDa\u0001 \u0001\u0005B\u0005%\u0001bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tY\u0002\u0001C!\u0003GAq!a\u0007\u0001\t\u0003\nY\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u0011q\b\u0001\u0005B\u00055\u0004bBA \u0001\u0011\u0005\u0011\u0011\u0011\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0001\u0003\u0007D\u0011\"!7\u0001#\u0003%\t!a7\t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\"9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA~\u0001\u0011\u0005\u0013Q \u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\u0011\u0011DQ1tS\u000eLe.T3n_JLH+\u00192mK\u000e\u000bG/\u00197pO*\u0011adH\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u0001\u0013%A\u0005d_:tWm\u0019;pe*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aK\u001a\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t1qJ\u00196fGR\u0004\"\u0001N\u001b\u000e\u0003uI!AN\u000f\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001b\u0001\u0003)q\u0017-\\3ta\u0006\u001cWm]\u000b\u0002yA!Q\b\u0011\"Y\u001b\u0005q$BA 0\u0003\u0011)H/\u001b7\n\u0005\u0005s$aA'baB\u00191)\u0014)\u000f\u0005\u0011SeBA#I\u001b\u00051%BA$*\u0003\u0019a$o\\8u}%\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0019\u00069\u0001/Y2lC\u001e,'\"A%\n\u00059{%\u0001\u0002'jgRT!a\u0013'\u0011\u0005E+fB\u0001*T!\t)E*\u0003\u0002U\u0019\u00061\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!F\n\u0005\u0003R3B\u0003\u0016BA!X\u0003-q\u0017-\\3ta\u0006\u001cWm\u001d\u0011\u0002\rQ\f'\r\\3t+\u0005i\u0006\u0003B\u001fA=\u0006\u0004\"\u0001N0\n\u0005\u0001l\"AC%eK:$\u0018NZ5feB\u0011AGY\u0005\u0003Gv\u0011Q\u0001V1cY\u0016\fq\u0001^1cY\u0016\u001c\b%A\tj]Z\fG.\u001b3bi\u0016$G+\u00192mKN,\u0012a\u001a\t\u0004{!t\u0016BA5?\u0005\r\u0019V\r^\u0001\u0013S:4\u0018\r\\5eCR,G\rV1cY\u0016\u001c\b%A\u0003`]\u0006lW-F\u0001n!\rqw\u000eU\u0007\u0002\u0019&\u0011\u0001\u000f\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013}s\u0017-\\3`I\u0015\fHCA:w!\tqG/\u0003\u0002v\u0019\n!QK\\5u\u0011\u001d9\u0018\"!AA\u00025\f1\u0001\u001f\u00132\u0003\u0019yf.Y7fA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007M\\X\u0010C\u0003}\u0017\u0001\u0007\u0001+\u0001\u0003oC6,\u0007\"\u0002@\f\u0001\u0004y\u0018aB8qi&|gn\u001d\t\u0005\u0003\u0003\t)!\u0004\u0002\u0002\u0004)\u0011q(I\u0005\u0005\u0003\u000f\t\u0019A\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB$\u0012\u0001U\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH\u0003BA\b\u0003+\u0001BA\\A\t=&\u0019\u00111\u0003'\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005]Q\u00021\u0001\u0002\u001a\u0005Ia.Y7fgB\f7-\u001a\t\u0005]\u0006E\u0001+A\u0005m_\u0006$G+\u00192mKR\u0019\u0011-a\b\t\r\u0005\u0005b\u00021\u0001_\u0003\u0015IG-\u001a8u)\u0015\t\u0017QEA\u0014\u0011\u0019\t\tc\u0004a\u0001=\"1\u0011\u0011F\bA\u0002A\u000bqA^3sg&|g\u000eF\u0003b\u0003[\ty\u0003\u0003\u0004\u0002\"A\u0001\rA\u0018\u0005\b\u0003c\u0001\u0002\u0019AA\u001a\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002o\u0003kI1!a\u000eM\u0005\u0011auN\\4\u0002\u001f%tg/\u00197jI\u0006$X\rV1cY\u0016$2a]A\u001f\u0011\u0019\t\t#\u0005a\u0001=\u0006Y1M]3bi\u0016$\u0016M\u00197f)%\t\u00171IA#\u0003+\n9\u0007\u0003\u0004\u0002\"I\u0001\rA\u0018\u0005\b\u0003\u000f\u0012\u0002\u0019AA%\u0003\u0019\u00198\r[3nCB!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0005\nQ\u0001^=qKNLA!a\u0015\u0002N\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b9\f\t\"a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019 \u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005\u0015\u0014q\f\u0002\n)J\fgn\u001d4pe6Dq!!\u001b\u0013\u0001\u0004\tY'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!\u0010!Q!RI\u0011-a\u001c\u0002r\u0005u\u0014q\u0010\u0005\u0007\u0003C\u0019\u0002\u0019\u00010\t\u000f\u0005M4\u00031\u0001\u0002v\u000591m\u001c7v[:\u001c\b#\u00028\u0002\u0012\u0005]\u0004c\u0001\u001b\u0002z%\u0019\u00111P\u000f\u0003\r\r{G.^7o\u0011\u001d\t9f\u0005a\u0001\u00033Bq!!\u001b\u0014\u0001\u0004\tY\u0007F\nb\u0003\u0007\u000b))a\"\u0002\n\u0006-\u00151TAT\u0003g\u000bi\f\u0003\u0004\u0002\"Q\u0001\rA\u0018\u0005\b\u0003\u000f\"\u0002\u0019AA%\u0011\u001d\t9\u0006\u0006a\u0001\u00033Bq!!\u001b\u0015\u0001\u0004\tY\u0007C\u0004\u0002\u000eR\u0001\r!a$\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!& \u00035!\u0017n\u001d;sS\n,H/[8og&!\u0011\u0011TAJ\u00051!\u0015n\u001d;sS\n,H/[8o\u0011\u001d\ti\n\u0006a\u0001\u0003?\u000b\u0001b\u001c:eKJLgn\u001a\t\u0006]\u0006E\u0011\u0011\u0015\t\u0005\u0003;\n\u0019+\u0003\u0003\u0002&\u0006}#!C*peR|%\u000fZ3s\u0011\u001d\tI\u000b\u0006a\u0001\u0003W\u000bQC]3rk&\u0014X\r\u001a(v[B\u000b'\u000f^5uS>t7\u000f\u0005\u0003o_\u00065\u0006c\u00018\u00020&\u0019\u0011\u0011\u0017'\u0003\u0007%sG\u000fC\u0005\u00026R\u0001\n\u00111\u0001\u00028\u0006aB-[:ue&\u0014W\u000f^5p]N#(/[2uYf\u0014V-];je\u0016$\u0007c\u00018\u0002:&\u0019\u00111\u0018'\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u0018\u000b\u0011\u0002\u0003\u0007\u0011QV\u0001\u0010]Vl'k\\<t!\u0016\u00148\u000b\u001d7ji\u0006)2M]3bi\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u0012BTCAAcU\u0011\t9,a2,\u0005\u0005%\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a5M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\fiMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u0019:fCR,G+\u00192mK\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0002^*\"\u0011QVAd\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\u0006C\u0006\r\u0018Q\u001d\u0005\u0007\u0003C9\u0002\u0019\u00010\t\u000f\u0005\u001dx\u00031\u0001\u0002j\u000691\r[1oO\u0016\u001c\b#\u00028\u0002l\u0006=\u0018bAAw\u0019\nQAH]3qK\u0006$X\r\u001a \u0011\u0007Q\n\t0C\u0002\u0002tv\u00111\u0002V1cY\u0016\u001c\u0005.\u00198hK\u0006IAM]8q)\u0006\u0014G.\u001a\u000b\u0005\u0003o\u000bI\u0010\u0003\u0004\u0002\"a\u0001\rAX\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0003t\u0003\u007f\u0014\u0019\u0001\u0003\u0004\u0003\u0002e\u0001\rAX\u0001\t_2$\u0017\nZ3oi\"1!QA\rA\u0002y\u000b\u0001B\\3x\u0013\u0012,g\u000e^\u0001\u0013SN$\u0016M\u00197f\u0013:4\u0018\r\\5eCR,G\r\u0006\u0003\u00028\n-\u0001BBA\u00115\u0001\u0007a,A\u0006dY\u0016\f'\u000fV1cY\u0016\u001cH#A:")
public class BasicInMemoryTableCatalog
implements TableCatalog {
    private final Map<List<String>, scala.collection.immutable.Map<String, String>> namespaces = new ConcurrentHashMap<List<String>, scala.collection.immutable.Map<String, String>>();
    private final Map<Identifier, Table> tables = new ConcurrentHashMap<Identifier, Table>();
    private final Set<Identifier> invalidatedTables = ConcurrentHashMap.newKeySet();
    private Option<String> _name = None$.MODULE$;

    public Set<TableCatalogCapability> capabilities() {
        return super.capabilities();
    }

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public Map<List<String>, scala.collection.immutable.Map<String, String>> namespaces() {
        return this.namespaces;
    }

    public Map<Identifier, Table> tables() {
        return this.tables;
    }

    private Set<Identifier> invalidatedTables() {
        return this.invalidatedTables;
    }

    private Option<String> _name() {
        return this._name;
    }

    private void _name_$eq(Option<String> x$1) {
        this._name = x$1;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this._name_$eq((Option<String>)new Some((Object)name));
    }

    public String name() {
        return (String)this._name().get();
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.tables().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicInMemoryTableCatalog.$anonfun$listTables$1(namespace, x$1)))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        Option option = Option$.MODULE$.apply((Object)this.tables().get(ident));
        if (option instanceof Some) {
            Some some = (Some)option;
            Table table = (Table)some.value();
            return table;
        }
        throw new NoSuchTableException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
    }

    public Table loadTable(Identifier ident, String version) {
        Identifier versionIdent = Identifier.of((String[])ident.namespace(), (String)new StringBuilder(0).append(ident.name()).append(version).toString());
        Option option = Option$.MODULE$.apply((Object)this.tables().get(versionIdent));
        if (option instanceof Some) {
            Some some = (Some)option;
            Table table = (Table)some.value();
            return table;
        }
        throw new NoSuchTableException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
    }

    public Table loadTable(Identifier ident, long timestamp) {
        Identifier timestampIdent = Identifier.of((String[])ident.namespace(), (String)new StringBuilder(0).append(ident.name()).append(timestamp).toString());
        Option option = Option$.MODULE$.apply((Object)this.tables().get(timestampIdent));
        if (option instanceof Some) {
            Some some = (Some)option;
            Table table = (Table)some.value();
            return table;
        }
        throw new NoSuchTableException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
    }

    public void invalidateTable(Identifier ident) {
        this.invalidatedTables().add(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        return this.createTable(ident, schema, partitions, properties, (Distribution)Distributions.unspecified(), (SortOrder[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SortOrder.class)), (Option<Object>)None$.MODULE$, this.createTable$default$8(), this.createTable$default$9());
    }

    public Table createTable(Identifier ident, Column[] columns, Transform[] partitions, Map<String, String> properties) {
        StructType schema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(columns);
        return this.createTable(ident, schema, partitions, properties);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties, Distribution distribution, SortOrder[] ordering, Option<Object> requiredNumPartitions, boolean distributionStrictlyRequired, int numRowsPerSplit) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
        String tableName = new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString();
        InMemoryTable table = new InMemoryTable(tableName, schema, partitions, properties, distribution, ordering, requiredNumPartitions, distributionStrictlyRequired, numRowsPerSplit);
        this.tables().put(ident, table);
        this.namespaces().putIfAbsent((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).toList(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    public boolean createTable$default$8() {
        return true;
    }

    public int createTable$default$9() {
        return Integer.MAX_VALUE;
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        InMemoryTable table = (InMemoryTable)this.loadTable(ident);
        Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(table.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(table.schema(), changes, (Option)None$.MODULE$, "ALTER TABLE");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).isEmpty()) {
            throw new IllegalArgumentException("Cannot drop all fields");
        }
        InMemoryTable newTable = new InMemoryTable(table.name(), schema, table.partitioning(), properties, InMemoryTable$.MODULE$.$lessinit$greater$default$5(), InMemoryTable$.MODULE$.$lessinit$greater$default$6(), InMemoryTable$.MODULE$.$lessinit$greater$default$7(), InMemoryTable$.MODULE$.$lessinit$greater$default$8(), InMemoryTable$.MODULE$.$lessinit$greater$default$9()).withData(table.data());
        this.tables().put(ident, newTable);
        return newTable;
    }

    public boolean dropTable(Identifier ident) {
        return Option$.MODULE$.apply((Object)this.tables().remove(ident)).isDefined();
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        if (this.tables().containsKey(newIdent)) {
            throw new TableAlreadyExistsException(CatalogV2Implicits$.MODULE$.IdentifierHelper(newIdent).asMultipartIdentifier());
        }
        Option option = Option$.MODULE$.apply((Object)this.tables().remove(oldIdent));
        if (option instanceof Some) {
            Some some = (Some)option;
            Table table = (Table)some.value();
            this.tables().put(newIdent, table);
            return;
        }
        throw new NoSuchTableException(CatalogV2Implicits$.MODULE$.IdentifierHelper(oldIdent).asMultipartIdentifier());
    }

    public boolean isTableInvalidated(Identifier ident) {
        return this.invalidatedTables().contains(ident);
    }

    public void clearTables() {
        this.tables().clear();
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$listTables$1(String[] namespace$1, Identifier x$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.namespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])namespace$1));
    }
}

