/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.functions;

import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.IntAverage$;
import org.apache.spark.sql.connector.catalog.functions.LongAverage$;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class IntegralAverage$
implements UnboundFunction {
    public static IntegralAverage$ MODULE$;

    static {
        new IntegralAverage$();
    }

    public String name() {
        return "iavg";
    }

    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length > 1) {
            throw new UnsupportedOperationException("Too many arguments");
        }
        if (inputType.fields()[0].nullable()) {
            throw new UnsupportedOperationException("Nullable values are not supported");
        }
        DataType dataType = inputType.fields()[0].dataType();
        if (dataType instanceof IntegerType) {
            return IntAverage$.MODULE$;
        }
        if (dataType instanceof LongType) {
            return LongAverage$.MODULE$;
        }
        throw new UnsupportedOperationException(new StringBuilder(31).append("Unsupported non-integral type: ").append(dataType).toString());
    }

    public String description() {
        return new StringOps(Predef$.MODULE$.augmentString("iavg: produces an average using integer division\n      |  iavg(int not null) -> int\n      |  iavg(bigint not null) -> bigint")).stripMargin();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private IntegralAverage$() {
        MODULE$ = this;
    }
}

