/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=2A\u0001C\u0005\u0001)!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0014\t\r1\u0002\u0001\u0015!\u0003(\u0011\u001di\u0003A1A\u0005\n\u0019BaA\f\u0001!\u0002\u00139#aD*ueV\u001cG\u000fV=qKN+\u0018\u000e^3\u000b\u0005)Y\u0011!\u0002;za\u0016\u001c(B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00163A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012!\u00029mC:\u001c(B\u0001\u0010\f\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0011\u001c\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u0013\u0005\t1/F\u0001(!\t!\u0003&\u0003\u0002*\u0013\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0005M\u0004\u0013\u0001\u00048fgR,Gm\u0015;sk\u000e$\u0018!\u00048fgR,Gm\u0015;sk\u000e$\b%A\u000btiJ,8\r^,ji\",U\u000e\u001d;z'R\u0014\u0018N\\4\u0002-M$(/^2u/&$\b.R7qif\u001cFO]5oO\u0002\u0002")
public class StructTypeSuite
extends SparkFunSuite
implements SQLHelper {
    private final StructType s;
    private final StructType nestedStruct;
    private final StructType structWithEmptyString;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        StructTypeSuite structTypeSuite = this;
        synchronized (structTypeSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private StructType s() {
        return this.s;
    }

    private StructType nestedStruct() {
        return this.nestedStruct;
    }

    private StructType structWithEmptyString() {
        return this.structWithEmptyString;
    }

    private final void checkIntervalDDL$1(byte start, byte end, Function1 fieldToString) {
        String startUnit = (String)fieldToString.apply((Object)BoxesRunTime.boxToByte((byte)start));
        String endUnit = (String)fieldToString.apply((Object)BoxesRunTime.boxToByte((byte)end));
        if (start < end) {
            StructType$.MODULE$.fromDDL(new StringBuilder(15).append("x INTERVAL ").append(startUnit).append(" TO ").append(endUnit).toString());
            return;
        }
        this.intercept((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.fromDDL(new StringBuilder(15).append("x INTERVAL ").append(startUnit).append(" TO ").append(endUnit).toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
    }

    public static final /* synthetic */ void $anonfun$new$38(StructTypeSuite $this, byte start) {
        YearMonthIntervalType$.MODULE$.yearMonthFields().foreach((Function1 & Serializable & scala.Serializable)end -> {
            $this.checkIntervalDDL$1(start, BoxesRunTime.unboxToByte((Object)end), (Function1 & Serializable & scala.Serializable)field -> YearMonthIntervalType$.MODULE$.fieldToString(BoxesRunTime.unboxToByte((Object)field)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(StructTypeSuite $this, byte start) {
        DayTimeIntervalType$.MODULE$.dayTimeFields().foreach((Function1 & Serializable & scala.Serializable)end -> {
            $this.checkIntervalDDL$1(start, BoxesRunTime.unboxToByte((Object)end), (Function1 & Serializable & scala.Serializable)field -> DayTimeIntervalType$.MODULE$.fieldToString(BoxesRunTime.unboxToByte((Object)field)));
            return BoxedUnit.UNIT;
        });
    }

    private static final void check$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Seq x$1 = field;
        Function2 x$2 = package$.MODULE$.caseInsensitiveResolution();
        boolean x$3 = input$1.findNestedField$default$2();
        Origin x$4 = input$1.findNestedField$default$4();
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(x$1, x$3, x$2, x$4);
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
    }

    private static final void caseSensitiveCheck$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Seq x$1 = field;
        Function2 x$2 = package$.MODULE$.caseSensitiveResolution();
        boolean x$3 = input$1.findNestedField$default$2();
        Origin x$4 = input$1.findNestedField$default$4();
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(x$1, x$3, x$2, x$4);
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
    }

    private static final void checkCollection$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(field, true, package$.MODULE$.caseInsensitiveResolution(), input$1.findNestedField$default$4());
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
    }

    public StructTypeSuite() {
        SQLHelper.$init$(this);
        this.s = StructType$.MODULE$.fromDDL("a INT, b STRING");
        this.test("lookup a single missing field should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.s().apply("c"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("lookup a set of missing fields should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.s().apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("lookup fieldIndex for missing field should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.s().fieldIndex("c"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("SPARK-24849: toDDL - simple struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "a INT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("SPARK-24849: round trip toDDL - fromDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct.toDDL()));
            StructType $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("SPARK-24849: round trip fromDDL - toDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String struct = "a MAP<INT, STRING>,b INT";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct).toDDL());
            String $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("SPARK-24849: toDDL must take into account case of fields.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("metaData", (DataType)new StructType().add("eventId", (DataType)StringType$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "metaData STRUCT<eventId: STRING>";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("SPARK-24849: toDDL should output field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Field's comment"), (List)Nil$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "b BOOLEAN COMMENT 'Field\\'s comment'";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.nestedStruct = new StructType().add(new StructField("a", (DataType)new StructType().add(new StructField("b", (DataType)new StructType().add(new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Deep Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: toDDL should output nested field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "a STRUCT<b: STRUCT<c: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.nestedStruct().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("SPARK-33846: fromDDL should parse nested field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a` STRUCT<`b`: STRUCT<`c`: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("SPARK-33846: round trip toDDL -> fromDDL - nested struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(this.nestedStruct().toDDL());
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("SPARK-35706: make the ':' in STRUCT data type definition optional", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a` STRUCT<`b` STRUCT<`c` STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.structWithEmptyString = new StructType().add(new StructField("a b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: empty string in a column's name should be respected by toDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.structWithEmptyString().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("SPARK-33846: empty string in a column's name should be respected by fromDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.structWithEmptyString();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("Print up to the given level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            int $org_scalatest_assert_macro_left = 5;
            int $org_scalatest_assert_macro_right = schema.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            int $org_scalatest_assert_macro_left2 = 3;
            int $org_scalatest_assert_macro_right2 = schema.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            int $org_scalatest_assert_macro_left3 = 7;
            int $org_scalatest_assert_macro_right3 = schema.treeString().split("\n").length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            int $org_scalatest_assert_macro_left4 = 7;
            int $org_scalatest_assert_macro_right4 = schema.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            int $org_scalatest_assert_macro_left5 = 7;
            int $org_scalatest_assert_macro_right5 = schema.treeString(-1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            StructType schema2 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>, c4 STRUCT<c5: INT, c6: ARRAY<ARRAY<INT>>>");
            int $org_scalatest_assert_macro_left6 = 4;
            int $org_scalatest_assert_macro_right6 = schema2.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            int $org_scalatest_assert_macro_left7 = 7;
            int $org_scalatest_assert_macro_right7 = schema2.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            int $org_scalatest_assert_macro_left8 = 9;
            int $org_scalatest_assert_macro_right8 = schema2.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            int $org_scalatest_assert_macro_left9 = 10;
            int $org_scalatest_assert_macro_right9 = schema2.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            int $org_scalatest_assert_macro_left10 = 10;
            int $org_scalatest_assert_macro_right10 = schema2.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            StructType schema3 = StructType$.MODULE$.fromDDL("c1 MAP<INT, STRUCT<c2: MAP<INT, INT>>>, c3 STRUCT<c4: MAP<INT, MAP<INT, INT>>>");
            int $org_scalatest_assert_macro_left11 = 3;
            int $org_scalatest_assert_macro_right11 = schema3.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            int $org_scalatest_assert_macro_left12 = 6;
            int $org_scalatest_assert_macro_right12 = schema3.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            int $org_scalatest_assert_macro_left13 = 9;
            int $org_scalatest_assert_macro_right13 = schema3.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            int $org_scalatest_assert_macro_left14 = 13;
            int $org_scalatest_assert_macro_right14 = schema3.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            int $org_scalatest_assert_macro_left15 = 13;
            int $org_scalatest_assert_macro_right15 = schema3.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("interval keyword in schema string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String interval = "a INTERVAL";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(interval).toDDL());
            String $org_scalatest_assert_macro_right = interval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("find missing (nested) fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.sameType((DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((x$1: org.apache.spark.sql.types.StructType) => x$1.sameType(missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            StructType source2 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing2 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameType((DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((x$2: org.apache.spark.sql.types.StructType) => x$2.sameType(missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameType((DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((x$3: org.apache.spark.sql.types.StructType) => x$3.sameType(missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c6: INT>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameType((DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((x$4: org.apache.spark.sql.types.StructType) => x$4.sameType(missing4)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("find missing (nested) fields: array and map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType schemaWithArray = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            StructType source5 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing5 = StructType$.MODULE$.fromDDL("c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source5, schemaWithArray, resolver).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameType((DataType)missing5))), "StructType.findMissingFields(source5, schemaWithArray, resolver).exists(((x$5: org.apache.spark.sql.types.StructType) => x$5.sameType(missing5)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            StructType schemaWithMap1 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>, c3 LONG");
            StructType source6 = StructType$.MODULE$.fromDDL("c1 INT, c3 LONG");
            StructType missing6 = StructType$.MODULE$.fromDDL("c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source6, schemaWithMap1, resolver).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.sameType((DataType)missing6))), "StructType.findMissingFields(source6, schemaWithMap1, resolver).exists(((x$6: org.apache.spark.sql.types.StructType) => x$6.sameType(missing6)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            StructType schemaWithMap2 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>, c3 STRING");
            StructType source7 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing7 = StructType$.MODULE$.fromDDL("c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source7, schemaWithMap2, resolver).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.sameType((DataType)missing7))), "StructType.findMissingFields(source7, schemaWithMap2, resolver).exists(((x$7: org.apache.spark.sql.types.StructType) => x$7.sameType(missing7)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            StructType source8 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>");
            Option $org_scalatest_assert_macro_left = StructType$.MODULE$.findMissingFields(source8, schemaWithArray, resolver);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            StructType source9 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT>, STRING>, c3 LONG");
            Option $org_scalatest_assert_macro_left2 = StructType$.MODULE$.findMissingFields(source9, schemaWithMap1, resolver);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            StructType source10 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT>>, c3 STRING");
            Option $org_scalatest_assert_macro_left3 = StructType$.MODULE$.findMissingFields(source10, schemaWithMap2, resolver);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("find missing (nested) fields: case sensitive cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT, C2 LONG");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameType((DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((x$8: org.apache.spark.sql.types.StructType) => x$8.sameType(missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            StructType source2 = StructType$.MODULE$.fromDDL("c2 LONG");
            StructType missing2 = StructType$.MODULE$.fromDDL("c1 INT");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.sameType((DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((x$9: org.apache.spark.sql.types.StructType) => x$9.sameType(missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<c5: INT>>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameType((DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((x$10: org.apache.spark.sql.types.StructType) => x$10.sameType(missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: Int>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<c6: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameType((DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((x$11: org.apache.spark.sql.types.StructType) => x$11.sameType(missing4)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        }), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("SPARK-35285: ANSI interval types in schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String yearMonthInterval = "ymi INTERVAL YEAR TO MONTH";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(yearMonthInterval).toDDL());
            String $org_scalatest_assert_macro_right = yearMonthInterval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            String dayTimeInterval = "dti INTERVAL DAY TO SECOND";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(StructType$.MODULE$.fromDDL(dayTimeInterval).toDDL());
            String $org_scalatest_assert_macro_right2 = dayTimeInterval;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("SPARK-35774: Prohibit the case start/end are the same with unit-to-unit interval syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            YearMonthIntervalType$.MODULE$.yearMonthFields().foreach((Function1 & Serializable & scala.Serializable)start -> {
                StructTypeSuite.$anonfun$new$38(this, BoxesRunTime.unboxToByte((Object)start));
                return BoxedUnit.UNIT;
            });
            DayTimeIntervalType$.MODULE$.dayTimeFields().foreach((Function1 & Serializable & scala.Serializable)start -> {
                StructTypeSuite.$anonfun$new$41(this, BoxesRunTime.unboxToByte((Object)start));
                return BoxedUnit.UNIT;
            });
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("findNestedField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType innerStruct = new StructType().add("s11", "int").add("s12", "int");
            StructType input = new StructType().add("s1", (DataType)innerStruct).add("s2", (DataType)new StructType().add("x", "int").add("X", "int")).add("m1", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$)).add("m2", (DataType)MapType$.MODULE$.apply((DataType)new StructType().add("a", "int"), (DataType)new StructType().add("b", "int"))).add("a1", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).add("a2", (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", "int")));
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1", (List)Nil$.MODULE$), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)new StructField("s1", (DataType)innerStruct, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"S1", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"s1", (List)new .colon.colon((Object)"S12", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"s1", (List)Nil$.MODULE$)), (Object)new StructField("s12", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"s1", (List)new .colon.colon((Object)"S12", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1.non_exist", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1", (List)new .colon.colon((Object)"S12", (List)new .colon.colon((Object)"S123", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Field name `S1`.`S12`.`S123` is invalid: `s1`.`s12` is not a struct";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            AnalysisException x$1 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S2", (List)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328))));
            String x$2 = "AMBIGUOUS_COLUMN_OR_FIELD";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"`S2`.`x`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)"2")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"s2", (List)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"s2", (List)Nil$.MODULE$)), (Object)new StructField("x", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"m1", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338))));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Field name `m1`.`key` is invalid: `m1` is not a struct";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"m1", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m1", (List)Nil$.MODULE$)), (Object)new StructField("key", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m1", (List)Nil$.MODULE$)), (Object)new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344))));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "Field name `M1`.`key`.`name` is invalid: `m1`.`key` is not a struct";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349))));
            String $org_scalatest_assert_macro_left4 = e.getMessage();
            String $org_scalatest_assert_macro_right4 = "Field name `M1`.`value`.`name` is invalid: `m1`.`value` is not a struct";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), (Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362))));
            String $org_scalatest_assert_macro_left5 = e.getMessage();
            String $org_scalatest_assert_macro_right5 = "Field name `m2`.`key`.`A`.`name` is invalid: `m2`.`key`.`a` is not a struct";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367))));
            String $org_scalatest_assert_macro_left6 = e.getMessage();
            String $org_scalatest_assert_macro_right6 = "Field name `M2`.`value`.`b`.`name` is invalid: `m2`.`value`.`b` is not a struct";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374))));
            String $org_scalatest_assert_macro_left7 = e.getMessage();
            String $org_scalatest_assert_macro_right7 = "Field name `A1`.`element` is invalid: `a1` is not a struct";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"a1", (List)Nil$.MODULE$)), (Object)new StructField("element", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379))));
            String $org_scalatest_assert_macro_left8 = e.getMessage();
            String $org_scalatest_assert_macro_right8 = "Field name `A1`.`element`.`name` is invalid: `a1`.`element` is not a struct";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"C", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"a2", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$))), (Object)new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"a2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"C", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389))));
            String $org_scalatest_assert_macro_left9 = e.getMessage();
            String $org_scalatest_assert_macro_right9 = "Field name `a2`.`element`.`C`.`name` is invalid: `a2`.`element`.`c` is not a struct";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("SPARK-36807: Merge ANSI interval types to a tightest common type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()))), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()))), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()))), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()))), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()))}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                AnsiIntervalType expected = (AnsiIntervalType)tuple2._2();
                if (tuple22 != null) {
                    AnsiIntervalType i1 = (AnsiIntervalType)tuple22._1();
                    AnsiIntervalType i2 = (AnsiIntervalType)tuple22._2();
                    StructType st1 = new StructType().add("interval", (DataType)i1);
                    StructType st2 = new StructType().add("interval", (DataType)i2);
                    StructType expectedStruct = new StructType().add("interval", (DataType)expected);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(st1.merge(st2));
                    StructType $org_scalatest_assert_macro_right = expectedStruct;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(st2.merge(st1));
                    StructType $org_scalatest_assert_macro_right2 = expectedStruct;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("SPARK-37076: Implement StructType.toString explicitly for Scala 2.13", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(struct.toString());
            String $org_scalatest_assert_macro_right = "StructType(StructField(a,IntegerType,true))";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        this.test("SPARK-37191: Merge DecimalType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType source1 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)").merge(StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(source1);
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
            StructType source2 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)").merge(StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(source2);
            StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)").merge(StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(source3);
            StructType $org_scalatest_assert_macro_right3 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            SparkException x$7 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.fromDDL("c1 DECIMAL(10, 5)").merge(StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)")), ClassTag$.MODULE$.apply(SparkException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            String x$8 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"DECIMAL(10,5)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"DECIMAL(12,2)\"")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, x$8, x$10, x$9, x$11, x$12);
            SparkException x$13 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 5)").merge(StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)")), ClassTag$.MODULE$.apply(SparkException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            String x$14 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"DECIMAL(12,5)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"DECIMAL(12,2)\"")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, x$14, x$16, x$15, x$17, x$18);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        this.test("SPARK-39143: Test parsing default column values out of struct types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType source1 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)LongType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "CAST(42 AS BIGINT)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "CAST(42 AS BIGINT)").build()), new StructField("c2", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "'abc'").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "'abc'").build()), new StructField("c3", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.genericArrayOps((Object)source1.existenceDefaultValues());
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
            Object $org_scalatest_assert_macro_left2 = source1.existenceDefaultValues()[0];
            int $org_scalatest_assert_macro_right2 = 42;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
            Object $org_scalatest_assert_macro_left3 = source1.existenceDefaultValues()[1];
            UTF8String $org_scalatest_assert_macro_right3 = UTF8String.fromString((String)"abc");
            Object object = $org_scalatest_assert_macro_left3;
            UTF8String uTF8String = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(object != null ? !object.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            Object $org_scalatest_assert_macro_left4 = source1.existenceDefaultValues()[2];
            Object $org_scalatest_assert_macro_right4 = null;
            Object object2 = $org_scalatest_assert_macro_left4;
            Object var15_14 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", null, !(object2 != null ? !object2.equals(var15_14) : var15_14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            StructType source2 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "1 + 1").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "1 + 1").build())}));
            String error = "fails to parse as a valid literal value";
            ArrayOps $org_scalatest_assert_macro_left5 = Predef$.MODULE$.genericArrayOps((Object)source2.existenceDefaultValues());
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            Object $org_scalatest_assert_macro_left6 = source2.existenceDefaultValues()[0];
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            StructType source3 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "invalid").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "invalid").build())}));
            String $org_scalatest_assert_macro_left7 = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> source3.existenceDefaultValues(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495))))).getMessage();
            String $org_scalatest_assert_macro_right7 = error;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
            StructType source4 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "(SELECT 'abc' FROM missingtable)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "(SELECT 'abc' FROM missingtable)").build())}));
            String $org_scalatest_assert_macro_left8 = ((AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> source4.existenceDefaultValues(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511))))).getMessage();
            String $org_scalatest_assert_macro_right8 = error;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
    }
}

