/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.ArrowUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\ty\u0011I\u001d:poV#\u0018\u000e\\:Tk&$XM\u0003\u0002\u0006\r\u0005!Q\u000f^5m\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0003\u0002\u0013I|WO\u001c3ue&\u0004HC\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011)f.\u001b;\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\u0005\u0011$\bCA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t9CE\u0001\u0005ECR\fG+\u001f9f\u0001")
public class ArrowUtilsSuite
extends SparkFunSuite {
    public void roundtrip(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrowUtils$.MODULE$.fromArrowSchema(ArrowUtils$.MODULE$.toArrowSchema(structType, null)));
            StructType $org_scalatest_assert_macro_right = structType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            return;
        }
        this.roundtrip((DataType)new StructType().add("value", dt));
    }

    private final void roundtripWithTz$1(String timeZoneId) {
        StructType schema = new StructType().add("value", (DataType)TimestampType$.MODULE$);
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId);
        ArrowType.Timestamp fieldType = (ArrowType.Timestamp)arrowSchema.findField("value").getType();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fieldType.getTimezone());
        String $org_scalatest_assert_macro_right = timeZoneId;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(ArrowUtils$.MODULE$.fromArrowSchema(arrowSchema));
        StructType $org_scalatest_assert_macro_right2 = schema;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    public ArrowUtilsSuite() {
        this.test("simple", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)BooleanType$.MODULE$);
            this.roundtrip((DataType)ByteType$.MODULE$);
            this.roundtrip((DataType)ShortType$.MODULE$);
            this.roundtrip((DataType)IntegerType$.MODULE$);
            this.roundtrip((DataType)LongType$.MODULE$);
            this.roundtrip((DataType)FloatType$.MODULE$);
            this.roundtrip((DataType)DoubleType$.MODULE$);
            this.roundtrip((DataType)StringType$.MODULE$);
            this.roundtrip((DataType)BinaryType$.MODULE$);
            this.roundtrip((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
            this.roundtrip((DataType)DateType$.MODULE$);
            this.roundtrip((DataType)YearMonthIntervalType$.MODULE$.apply());
            this.roundtrip((DataType)DayTimeIntervalType$.MODULE$.apply());
            IllegalStateException tsExMsg = (IllegalStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.roundtrip((DataType)TimestampType$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String $org_scalatest_assert_macro_left = tsExMsg.getMessage();
            String $org_scalatest_assert_macro_right = "timezoneId";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            SparkUnsupportedOperationException x$1 = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> ArrowUtils$.MODULE$.fromArrowType((ArrowType)new ArrowType.Int(8, false)), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            String x$2 = "UNSUPPORTED_ARROWTYPE";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"Int(8, false)")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtripWithTz$1(ZoneId.systemDefault().getId());
            this.roundtripWithTz$1("Asia/Tokyo");
            this.roundtripWithTz$1("UTC");
            this.roundtripWithTz$1(DateTimeTestUtils$.MODULE$.LA().getId());
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            this.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true));
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false));
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false));
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)new StructType());
            this.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$));
            this.roundtrip((DataType)new StructType().add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
            this.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
            this.roundtrip((DataType)new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))));
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }
}

