/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.spark.sql.connector.expressions.Cast;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Extract;
import org.apache.spark.sql.connector.expressions.GeneralScalarExpression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.UserDefinedScalarFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Avg;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.connector.expressions.aggregate.UserDefinedAggregateFunc;
import org.apache.spark.sql.types.DataType;

public class V2ExpressionSQLBuilder {
    protected String escapeSpecialCharsForLikePattern(String str) {
        StringBuilder builder = new StringBuilder();
        block5: for (char c : str.toCharArray()) {
            switch (c) {
                case '_': {
                    builder.append("\\_");
                    continue block5;
                }
                case '%': {
                    builder.append("\\%");
                    continue block5;
                }
                case '\'': {
                    builder.append("\\'");
                    continue block5;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public String build(Expression expr) {
        if (expr instanceof Literal) {
            return this.visitLiteral((Literal)expr);
        }
        if (expr instanceof NamedReference) {
            return this.visitNamedReference((NamedReference)expr);
        }
        if (expr instanceof Cast) {
            Cast cast = (Cast)expr;
            return this.visitCast(this.build(cast.expression()), cast.dataType());
        }
        if (expr instanceof Extract) {
            Extract extract2 = (Extract)expr;
            return this.visitExtract(extract2.field(), this.build(extract2.source()));
        }
        if (expr instanceof SortOrder) {
            SortOrder sortOrder = (SortOrder)expr;
            return this.visitSortOrder(this.build(sortOrder.expression()), sortOrder.direction(), sortOrder.nullOrdering());
        }
        if (expr instanceof GeneralScalarExpression) {
            String name;
            GeneralScalarExpression e = (GeneralScalarExpression)expr;
            switch (name = e.name()) {
                case "IN": {
                    Expression[] expressions = e.children();
                    List<String> children2 = this.expressionsToStringList(expressions, 1, expressions.length - 1);
                    return this.visitIn(this.build(expressions[0]), children2);
                }
                case "IS_NULL": {
                    return this.visitIsNull(this.build(e.children()[0]));
                }
                case "IS_NOT_NULL": {
                    return this.visitIsNotNull(this.build(e.children()[0]));
                }
                case "STARTS_WITH": {
                    return this.visitStartsWith(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "ENDS_WITH": {
                    return this.visitEndsWith(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "CONTAINS": {
                    return this.visitContains(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "=": 
                case "<>": 
                case "<=>": 
                case "<": 
                case "<=": 
                case ">": 
                case ">=": {
                    return this.visitBinaryComparison(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "+": 
                case "*": 
                case "/": 
                case "%": 
                case "&": 
                case "|": 
                case "^": {
                    return this.visitBinaryArithmetic(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "-": {
                    if (e.children().length == 1) {
                        return this.visitUnaryArithmetic(name, this.inputToSQL(e.children()[0]));
                    }
                    return this.visitBinaryArithmetic(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "AND": {
                    return this.visitAnd(name, this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "OR": {
                    return this.visitOr(name, this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "NOT": {
                    return this.visitNot(this.build(e.children()[0]));
                }
                case "~": {
                    return this.visitUnaryArithmetic(name, this.inputToSQL(e.children()[0]));
                }
                case "ABS": 
                case "COALESCE": 
                case "GREATEST": 
                case "LEAST": 
                case "RAND": 
                case "LOG": 
                case "LOG10": 
                case "LOG2": 
                case "LN": 
                case "EXP": 
                case "POWER": 
                case "SQRT": 
                case "FLOOR": 
                case "CEIL": 
                case "ROUND": 
                case "SIN": 
                case "SINH": 
                case "COS": 
                case "COSH": 
                case "TAN": 
                case "TANH": 
                case "COT": 
                case "ASIN": 
                case "ASINH": 
                case "ACOS": 
                case "ACOSH": 
                case "ATAN": 
                case "ATANH": 
                case "ATAN2": 
                case "CBRT": 
                case "DEGREES": 
                case "RADIANS": 
                case "SIGN": 
                case "WIDTH_BUCKET": 
                case "SUBSTRING": 
                case "UPPER": 
                case "LOWER": 
                case "TRANSLATE": 
                case "DATE_ADD": 
                case "DATE_DIFF": 
                case "TRUNC": 
                case "AES_ENCRYPT": 
                case "AES_DECRYPT": 
                case "SHA1": 
                case "SHA2": 
                case "MD5": 
                case "CRC32": 
                case "BIT_LENGTH": 
                case "CHAR_LENGTH": 
                case "CONCAT": {
                    return this.visitSQLFunction(name, this.expressionsToStringArray(e.children()));
                }
                case "CASE_WHEN": {
                    return this.visitCaseWhen(this.expressionsToStringArray(e.children()));
                }
                case "TRIM": {
                    return this.visitTrim("BOTH", this.expressionsToStringArray(e.children()));
                }
                case "LTRIM": {
                    return this.visitTrim("LEADING", this.expressionsToStringArray(e.children()));
                }
                case "RTRIM": {
                    return this.visitTrim("TRAILING", this.expressionsToStringArray(e.children()));
                }
                case "OVERLAY": {
                    return this.visitOverlay(this.expressionsToStringArray(e.children()));
                }
            }
            return this.visitUnexpectedExpr(expr);
        }
        if (expr instanceof Min) {
            Min min = (Min)expr;
            return this.visitAggregateFunction("MIN", false, this.expressionsToStringArray(min.children()));
        }
        if (expr instanceof Max) {
            Max max = (Max)expr;
            return this.visitAggregateFunction("MAX", false, this.expressionsToStringArray(max.children()));
        }
        if (expr instanceof Count) {
            Count count = (Count)expr;
            return this.visitAggregateFunction("COUNT", count.isDistinct(), this.expressionsToStringArray(count.children()));
        }
        if (expr instanceof Sum) {
            Sum sum = (Sum)expr;
            return this.visitAggregateFunction("SUM", sum.isDistinct(), this.expressionsToStringArray(sum.children()));
        }
        if (expr instanceof CountStar) {
            return this.visitAggregateFunction("COUNT", false, new String[]{"*"});
        }
        if (expr instanceof Avg) {
            Avg avg = (Avg)expr;
            return this.visitAggregateFunction("AVG", avg.isDistinct(), this.expressionsToStringArray(avg.children()));
        }
        if (expr instanceof GeneralAggregateFunc) {
            GeneralAggregateFunc f = (GeneralAggregateFunc)expr;
            return this.visitAggregateFunction(f.name(), f.isDistinct(), this.expressionsToStringArray(f.children()));
        }
        if (expr instanceof UserDefinedScalarFunc) {
            UserDefinedScalarFunc f = (UserDefinedScalarFunc)expr;
            return this.visitUserDefinedScalarFunction(f.name(), f.canonicalName(), this.expressionsToStringArray(f.children()));
        }
        if (expr instanceof UserDefinedAggregateFunc) {
            UserDefinedAggregateFunc f = (UserDefinedAggregateFunc)expr;
            return this.visitUserDefinedAggregateFunction(f.name(), f.canonicalName(), f.isDistinct(), this.expressionsToStringArray(f.children()));
        }
        return this.visitUnexpectedExpr(expr);
    }

    protected String visitLiteral(Literal<?> literal) {
        return literal.toString();
    }

    protected String visitNamedReference(NamedReference namedRef) {
        return namedRef.toString();
    }

    protected String visitIn(String v, List<String> list) {
        if (list.isEmpty()) {
            return "CASE WHEN " + v + " IS NULL THEN NULL ELSE FALSE END";
        }
        return this.joinListToString(list, ", ", v + " IN (", ")");
    }

    protected String visitIsNull(String v) {
        return v + " IS NULL";
    }

    protected String visitIsNotNull(String v) {
        return v + " IS NOT NULL";
    }

    protected String visitStartsWith(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\'";
    }

    protected String visitEndsWith(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\'";
    }

    protected String visitContains(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\'";
    }

    private String inputToSQL(Expression input) {
        if (input.children().length > 1) {
            return "(" + this.build(input) + ")";
        }
        return this.build(input);
    }

    protected String visitBinaryComparison(String name, String l, String r) {
        switch (name) {
            case "<=>": {
                return "(" + l + " = " + r + ") OR (" + l + " IS NULL AND " + r + " IS NULL)";
            }
        }
        return l + " " + name + " " + r;
    }

    protected String visitBinaryArithmetic(String name, String l, String r) {
        return l + " " + name + " " + r;
    }

    protected String visitCast(String l, DataType dataType) {
        return "CAST(" + l + " AS " + dataType.typeName() + ")";
    }

    protected String visitAnd(String name, String l, String r) {
        return "(" + l + ") " + name + " (" + r + ")";
    }

    protected String visitOr(String name, String l, String r) {
        return "(" + l + ") " + name + " (" + r + ")";
    }

    protected String visitNot(String v) {
        return "NOT (" + v + ")";
    }

    protected String visitUnaryArithmetic(String name, String v) {
        return name + v;
    }

    protected String visitCaseWhen(String[] children2) {
        StringBuilder sb = new StringBuilder("CASE");
        for (int i = 0; i < children2.length; i += 2) {
            String c = children2[i];
            int j = i + 1;
            if (j < children2.length) {
                String v = children2[j];
                sb.append(" WHEN ");
                sb.append(c);
                sb.append(" THEN ");
                sb.append(v);
                continue;
            }
            sb.append(" ELSE ");
            sb.append(c);
        }
        sb.append(" END");
        return sb.toString();
    }

    protected String visitSQLFunction(String funcName, String[] inputs) {
        return this.joinArrayToString(inputs, ", ", funcName + "(", ")");
    }

    protected String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
        if (isDistinct) {
            return this.joinArrayToString(inputs, ", ", funcName + "(DISTINCT ", ")");
        }
        return this.joinArrayToString(inputs, ", ", funcName + "(", ")");
    }

    protected String visitUserDefinedScalarFunction(String funcName, String canonicalName, String[] inputs) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support user defined function: " + funcName);
    }

    protected String visitUserDefinedAggregateFunction(String funcName, String canonicalName, boolean isDistinct, String[] inputs) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support user defined aggregate function: " + funcName);
    }

    protected String visitUnexpectedExpr(Expression expr) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unexpected V2 expression: " + expr);
    }

    protected String visitOverlay(String[] inputs) {
        assert (inputs.length == 3 || inputs.length == 4);
        if (inputs.length == 3) {
            return "OVERLAY(" + inputs[0] + " PLACING " + inputs[1] + " FROM " + inputs[2] + ")";
        }
        return "OVERLAY(" + inputs[0] + " PLACING " + inputs[1] + " FROM " + inputs[2] + " FOR " + inputs[3] + ")";
    }

    protected String visitTrim(String direction, String[] inputs) {
        assert (inputs.length == 1 || inputs.length == 2);
        if (inputs.length == 1) {
            return "TRIM(" + direction + " FROM " + inputs[0] + ")";
        }
        return "TRIM(" + direction + " " + inputs[1] + " FROM " + inputs[0] + ")";
    }

    protected String visitExtract(String field, String source) {
        return "EXTRACT(" + field + " FROM " + source + ")";
    }

    protected String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
        return sortKey + " " + (Object)((Object)sortDirection) + " " + (Object)((Object)nullOrdering);
    }

    private String joinArrayToString(String[] inputs, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (String input : inputs) {
            joiner.add(input);
        }
        return joiner.toString();
    }

    private String joinListToString(List<String> inputs, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (String input : inputs) {
            joiner.add(input);
        }
        return joiner.toString();
    }

    private String[] expressionsToStringArray(Expression[] expressions) {
        String[] result = new String[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            result[i] = this.build(expressions[i]);
        }
        return result;
    }

    private List<String> expressionsToStringList(Expression[] expressions, int offset, int length) {
        ArrayList<String> list = new ArrayList<String>(length);
        int till = Math.min(offset + length, expressions.length);
        while (offset < till) {
            list.add(this.build(expressions[offset]));
            ++offset;
        }
        return list;
    }
}

