/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Sequence;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Integral;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class Sequence$
implements scala.Serializable {
    public static Sequence$ MODULE$;

    static {
        new Sequence$();
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    private String prettyName() {
        return "sequence";
    }

    public int sequenceLength(long start, long stop, long step) {
        int n;
        try {
            long len;
            long delta = Math.subtractExact(stop, start);
            if (delta == Long.MIN_VALUE && step == -1L) {
                throw new ArithmeticException("Long overflow (Long.MinValue / -1)");
            }
            long l = len = stop == start ? 1L : Math.addExact(1L, delta / step);
            if (len > 0x7FFFFFF0L) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(BoxesRunTime.boxToLong((long)len));
            }
            n = (int)len;
        }
        catch (ArithmeticException arithmeticException) {
            BigInt safeLen = package$.MODULE$.BigInt().apply(1).$plus(package$.MODULE$.BigInt().apply(stop).$minus(package$.MODULE$.BigInt().apply(start)).$div(package$.MODULE$.BigInt().apply(step)));
            if (safeLen.$greater((Object)BigInt$.MODULE$.int2bigInt(0x7FFFFFF0))) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(safeLen);
            }
            throw SparkException$.MODULE$.internalError("Unreachable code reached.");
        }
        catch (Exception e) {
            throw e;
        }
        return n;
    }

    public <U> int org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(U start, U stop, Object step, U estimatedStep, Integral<U> num) {
        Predef$.MODULE$.require(num.mkOrderingOps(estimatedStep).$greater(num.zero()) && num.mkOrderingOps(start).$less$eq(stop) || num.mkOrderingOps(estimatedStep).$less(num.zero()) && num.mkOrderingOps(start).$greater$eq(stop) || BoxesRunTime.equals(estimatedStep, (Object)num.zero()) && BoxesRunTime.equals(start, stop), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Illegal sequence boundaries: ").append(start).append(" to ").append(stop).append(" by ").append(step).toString());
        return this.sequenceLength(num.mkNumericOps(start).toLong(), num.mkNumericOps(stop).toLong(), num.mkNumericOps(estimatedStep).toLong());
    }

    public String org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(CodegenContext ctx, String start, String stop, String step, String estimatedStep, String len) {
        String calcFn = new StringBuilder(15).append(Sequence.class.getName()).append(".sequenceLength").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(271).append("\n       |if (!((").append(estimatedStep).append(" > 0 && ").append(start).append(" <= ").append(stop).append(") ||\n       |  (").append(estimatedStep).append(" < 0 && ").append(start).append(" >= ").append(stop).append(") ||\n       |  (").append(estimatedStep).append(" == 0 && ").append(start).append(" == ").append(stop).append("))) {\n       |  throw new IllegalArgumentException(\n       |    \"Illegal sequence boundaries: \" + ").append(start).append(" + \" to \" + ").append(stop).append(" + \" by \" + ").append(step).append(");\n       |}\n       |int ").append(len).append(" = ").append(calcFn).append("((long) ").append(start).append(", (long) ").append(stop).append(", (long) ").append(estimatedStep).append(");\n       ").toString())).stripMargin();
    }

    public Sequence apply(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.start(), (Object)x$0.stop(), x$0.stepOpt(), x$0.timeZoneId()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Sequence$() {
        MODULE$ = this;
    }
}

