/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. The function returns NULL\n      if the index exceeds the length of the array and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL\n      if the key is not contained in the map and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws NoSuchElementException instead.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u0016-\u0001fB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tC\u0002\u0011\t\u0012)A\u0005=\"A!\r\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003_\u0011!!\u0007A!f\u0001\n\u0003)\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00024\t\u000b)\u0004A\u0011A6\t\u000b)\u0004A\u0011\u00019\t\u0011M\u0004\u0001R1A\u0005\nQD\u0001b \u0001\t\u0006\u0004%I!\u001a\u0005\n\u0003\u0007\u0001\u0001R1A\u0005\n\u0015D!\"a\u0002\u0001\u0011\u000b\u0007I\u0011BA\u0005\u0011%\tI\u0002\u0001EC\u0002\u0013\u0005C\u000fC\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011Q\b\u0001\u0005\n\u0005}\u0002BBA)\u0001\u0011\u0005S\rC\u0004\u0002T\u0001!\t%!\u0016\t\u0015\u0005u\u0003\u0001#b\u0001\n\u0013\ty\u0006C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u00111\u0014\u0001\u0005R\u0005u\u0005\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\t\t\fAI\u0001\n\u0003\t\u0019\fC\u0005\u0002J\u0002\t\n\u0011\"\u0001\u00024\"I\u00111\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"a9\u0001\u0003\u0003%\t!!:\t\u0013\u0005\u001d\b!!A\u0005\u0002\u0005%\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\ty\u0010AA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\u0006\u0001\t\t\u0011\"\u0011\u0003\b!I!1\u0002\u0001\u0002\u0002\u0013\u0005#QB\u0004\n\u0005ca\u0013\u0011!E\u0001\u0005g1\u0001b\u000b\u0017\u0002\u0002#\u0005!Q\u0007\u0005\u0007U\u000e\"\tA!\u0014\t\u0013\t=3%!A\u0005F\tE\u0003\"\u0003B*G\u0005\u0005I\u0011\u0011B+\u0011%\u0011ifII\u0001\n\u0003\ti\rC\u0005\u0003`\r\n\t\u0011\"!\u0003b!I!1O\u0012\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0005k\u001a\u0013\u0011!C\u0005\u0005o\u0012\u0011\"\u00127f[\u0016tG/\u0011;\u000b\u00055r\u0013aC3yaJ,7o]5p]NT!a\f\u0019\u0002\u0011\r\fG/\u00197zgRT!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u001e?\u0003\u0012[\u0015\u000b\u0005\u0002<y5\tA&\u0003\u0002>Y\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003w}J!\u0001\u0011\u0017\u0003\u001f\u001d+G/T1q-\u0006dW/Z+uS2\u0004\"a\u000f\"\n\u0005\rc#\u0001E$fi\u0006\u0013(/Y=Ji\u0016lW\u000b^5m!\t)\u0005J\u0004\u0002<\r&\u0011q\tL\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u001dc\u0003C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%a\u0002)s_\u0012,8\r\u001e\t\u0003%fs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005YC\u0014A\u0002\u001fs_>$h(C\u0001O\u0013\t9U*\u0003\u0002[7\na1+\u001a:jC2L'0\u00192mK*\u0011q)T\u0001\u0005Y\u00164G/F\u0001_!\tYt,\u0003\u0002aY\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003\u0019\u0004\"\u0001T4\n\u0005!l%a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1lgn\u001c\t\u0003w\u0001AQ\u0001X\u0004A\u0002yCQAY\u0004A\u0002yCq\u0001Z\u0004\u0011\u0002\u0003\u0007a\rF\u0002mcJDQ\u0001\u0018\u0005A\u0002yCQA\u0019\u0005A\u0002y\u000b!\"\\1q\u0017\u0016LH+\u001f9f+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=1\u0003\u0015!\u0018\u0010]3t\u0013\tQxO\u0001\u0005ECR\fG+\u001f9fQ\tIA\u0010\u0005\u0002M{&\u0011a0\u0014\u0002\niJ\fgn]5f]R\fA#\\1q-\u0006dW/Z\"p]R\f\u0017N\\:Ok2d\u0007F\u0001\u0006}\u0003E\t'O]1z\u0007>tG/Y5og:+H\u000e\u001c\u0015\u0003\u0017q\f\u0001b\u001c:eKJLgnZ\u000b\u0003\u0003\u0017\u0001RAUA\u0007\u0003#I1!a\u0004\\\u0005!y%\u000fZ3sS:<\u0007c\u0001'\u0002\u0014%\u0019\u0011QC'\u0003\u0007\u0005s\u0017\u0010\u000b\u0002\ry\u0006AA-\u0019;b)f\u0004X\r\u000b\u0002\u000ey\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u0005\u0002#\u0002*\u0002$\u0005\u001d\u0012bAA\u00137\n\u00191+Z9\u0011\u0007Y\fI#C\u0002\u0002,]\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]b&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY$!\u000e\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f1B\\;mY\u0006\u0014\u0017\u000e\\5usR)a-!\u0011\u0002H!9\u00111\t\tA\u0002\u0005\u0015\u0013\u0001C3mK6,g\u000e^:\u0011\tI\u000b\u0019C\u0018\u0005\b\u0003\u0013\u0002\u0002\u0019AA&\u0003\u001dy'\u000fZ5oC2\u00042\u0001TA'\u0013\r\ty%\u0014\u0002\u0004\u0013:$\u0018\u0001\u00038vY2\f'\r\\3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005E\u0011qKA.\u0011\u001d\tIF\u0005a\u0001\u0003#\tQA^1mk\u0016Dq!!\u0013\u0013\u0001\u0004\t\t\"A\u0006e_\u0016cW-\\3oi\u0006#XCAA1!%a\u00151MA\t\u0003#\t\t\"C\u0002\u0002f5\u0013\u0011BR;oGRLwN\u001c\u001a)\u0005Ma\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti'!\u001f\u0002\u0004B!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t1\nqaY8eK\u001e,g.\u0003\u0003\u0002x\u0005E$\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005mD\u00031\u0001\u0002~\u0005\u00191\r\u001e=\u0011\t\u0005=\u0014qP\u0005\u0005\u0003\u0003\u000b\tH\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u0015E\u00031\u0001\u0002n\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAAF!\u0011\ti)!&\u000f\t\u0005=\u0015\u0011\u0013\t\u0003)6K1!a%N\u0003\u0019\u0001&/\u001a3fM&!\u0011qSAM\u0005\u0019\u0019FO]5oO*\u0019\u00111S'\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00027\u0002 \u0006\r\u0006BBAQ-\u0001\u0007a,A\u0004oK^dUM\u001a;\t\r\u0005\u0015f\u00031\u0001_\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$r\u0001\\AV\u0003[\u000by\u000bC\u0004]/A\u0005\t\u0019\u00010\t\u000f\t<\u0002\u0013!a\u0001=\"9Am\u0006I\u0001\u0002\u00041\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kS3AXA\\W\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\u0013Ut7\r[3dW\u0016$'bAAb\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyMK\u0002g\u0003o\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\fA\u0001\\1oO*\u0011\u0011q\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u0006e\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA&\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0005\u0002l\"I\u0011Q^\u000f\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\bCBA{\u0003w\f\t\"\u0004\u0002\u0002x*\u0019\u0011\u0011`'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002~\u0006](\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2A\u001aB\u0002\u0011%\tioHA\u0001\u0002\u0004\t\t\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAk\u0005\u0013A\u0011\"!<!\u0003\u0003\u0005\r!a\u0013\u0002\r\u0015\fX/\u00197t)\r1'q\u0002\u0005\n\u0003[\f\u0013\u0011!a\u0001\u0003#A3\u0003\u0001B\n\u00053\u0011YBa\b\u0003\"\t\u0015\"q\u0005B\u0016\u0005[\u00012a\u000fB\u000b\u0013\r\u00119\u0002\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i\"AC\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK1se\u0006LH\u0006I5oI\u0016D\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0015dW-\\3oi\u0002zg\rI1se\u0006L\b%\u0019;!O&4XM\u001c\u0011)c5\u0012\u0017m]3eS\u0001Jg\u000eZ3y]\u0001Je\rI5oI\u0016D\b\u0005\u0010\u00111Y)\u0001\u0003\u0005\t\u0011!A\u0005\u001c7-Z:tKN\u0004S\r\\3nK:$8\u000f\t4s_6\u0004C\u000f[3!Y\u0006\u001cH\u000f\t;pAQDW\r\t4jeN$h\u0006\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192S\u0001\u0005\t\u0011!A\u0001Jg\r\t;iK\u0002Jg\u000eZ3yA\u0015D8-Z3eg\u0002\"\b.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010I1oI\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u00022\u0017\r\\:f])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3aA%\u001c\be]3uAQ|\u0007\u0005\u001e:vK2\u0002\u0013\u000e\u001e\u0011uQJ|wo\u001d\u0011BeJ\f\u00170\u00138eKb|U\u000f^(g\u0005>,h\u000eZ:Fq\u000e,\u0007\u000f^5p]*\u0001\u0003\u0005\t\u0011!A\u0019|'\u000fI5om\u0006d\u0017\u000e\u001a\u0011j]\u0012L7-Z:/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015nCBd\u0003e[3zS\u0001j\u0003EU3ukJt7\u000f\t<bYV,\u0007EZ8sA\u001dLg/\u001a8!W\u0016Lh\u0006\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192S\u0001\u0005\t\u0011!A\u0001Jg\r\t;iK\u0002ZW-\u001f\u0011jg\u0002rw\u000e\u001e\u0011d_:$\u0018-\u001b8fI\u0002Jg\u000e\t;iK\u0002j\u0017\r\u001d\u0011b]\u0012\u0004\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004c-\u00197tK:R\u0001\u0005\t\u0011!A\u0001Je\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016d\u0003%\u001b;!i\"\u0014xn^:!\u001d>\u001cVo\u00195FY\u0016lWM\u001c;Fq\u000e,\u0007\u000f^5p]\u0002Jgn\u001d;fC\u0012t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\t\u0002y*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\"\nD\u0006I\u0014bO1\u0002#\u0007\f\u0011(E\u001eJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t%\u0012!\u0002\u001a/i9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u0018\u0003%i\u0017\r]0gk:\u001c7/A\u0005FY\u0016lWM\u001c;BiB\u00111hI\n\u0006G\t]\"1\t\t\t\u0005s\u0011yD\u00180gY6\u0011!1\b\u0006\u0004\u0005{i\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u0003\u0012YDA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BA!\u0012\u0003L5\u0011!q\t\u0006\u0005\u0005\u0013\ni.\u0001\u0002j_&\u0019!La\u0012\u0015\u0005\tM\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005U\u0017!B1qa2LHc\u00027\u0003X\te#1\f\u0005\u00069\u001a\u0002\rA\u0018\u0005\u0006E\u001a\u0002\rA\u0018\u0005\bI\u001a\u0002\n\u00111\u0001g\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005G\u0012y\u0007E\u0003M\u0005K\u0012I'C\u0002\u0003h5\u0013aa\u00149uS>t\u0007C\u0002'\u0003lysf-C\u0002\u0003n5\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B9Q\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005s\u0002B!a6\u0003|%!!QPAm\u0005\u0019y%M[3di\u0002")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
Serializable {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static boolean apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, ElementAt>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering, boolean failOnError) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering, failOnError);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType, boolean failOnError) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType, failOnError);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)package$.MODULE$.Seq().empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(31).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(53).append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(39).append("The first argument to function ").append(this.prettyName()).append(" should ").toString()).append(new StringBuilder(29).append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").toString()).append(new StringBuilder(6).append(this.left().dataType().catalogString()).append(" type.").toString()).toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < scala.math.package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = this.failOnError() ? this.mapValueContainsNull() : true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < scala.math.package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, array.numElements());
                            }
                            object = null;
                        } else {
                            if (index == 0) {
                                throw QueryExecutionErrors$.MODULE$.sqlArrayIndexNotStartAtOneError();
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering(), this.failOnError());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())) : "";
                String indexOutOfBoundBranch = this.failOnError() ? new StringBuilder(68).append("throw QueryExecutionErrors.invalidArrayIndexError(").append(index).append(", ").append((String)eval1).append(".numElements());").toString() : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.sqlArrayIndexNotStartAtOneError();\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString()));
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType(), this.failOnError());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ElementAt copy(Expression left, Expression right, boolean failOnError) {
        return new ElementAt(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        if (this.failOnError() != elementAt.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

