/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Encode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, charset) - Encodes the first argument using the second argument character set.", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011N\u0011\u0015Q\u0006\u0001\"\u0011N\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C)\u0003\u0007A\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\t\u0013\u0005U\u0001!%A\u0005\u0002\u0005]\u0001\"CA\u0017\u0001E\u0005I\u0011AA\f\u0011%\ty\u0003AA\u0001\n\u0003\n\t\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\tijHA\u0001\u0012\u0003\tyJ\u0002\u0005\u001f?\u0005\u0005\t\u0012AAQ\u0011\u0019!\u0006\u0004\"\u0001\u0002:\"I\u00111\u0018\r\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007fC\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u0019\u0003\u0003%\t)!3\t\u0013\u0005m\u0007$!A\u0005\n\u0005u'AB#oG>$WM\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q&\r\u001b<\u0003B\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\f\u001a\n\u0005Mz\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005UBdB\u0001\u00187\u0013\t9t$A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003o}\u0001\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002C\u0013:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r.\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005]j\u0014B\u0001&L\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t9T(A\u0003wC2,X-F\u0001O!\tqs*\u0003\u0002Q?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\rY\fG.^3!\u0003\u001d\u0019\u0007.\u0019:tKR\f\u0001b\u00195beN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Y;\u0006\f\u0005\u0002/\u0001!)A*\u0002a\u0001\u001d\")!+\u0002a\u0001\u001d\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003!!\u0017\r^1UsB,W#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u001c\u0013!\u0002;za\u0016\u001c\u0018B\u00012`\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tQ\rE\u0002CMvK!aZ&\u0003\u0007M+\u0017/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002k[>\u0004\"\u0001P6\n\u00051l$aA!os\")aN\u0003a\u0001U\u00061\u0011N\u001c9viFBQ\u0001\u001d\u0006A\u0002)\fa!\u001b8qkR\u0014\u0014!\u00033p\u000f\u0016t7i\u001c3f)\r\u0019\u0018P \t\u0003i^l\u0011!\u001e\u0006\u0003m~\tqaY8eK\u001e,g.\u0003\u0002yk\nAQ\t\u001f9s\u0007>$W\rC\u0003{\u0017\u0001\u000710A\u0002dib\u0004\"\u0001\u001e?\n\u0005u,(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006\u007f.\u0001\ra]\u0001\u0003KZ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bY\u000b)!!\u0003\t\r\u0005\u001dA\u00021\u0001O\u0003\u001dqWm\u001e'fMRDa!a\u0003\r\u0001\u0004q\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006-\u0006E\u00111\u0003\u0005\b\u00196\u0001\n\u00111\u0001O\u0011\u001d\u0011V\u0002%AA\u00029\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aa*a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003mC:<'BAA\u001f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0013q\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0003c\u0001\u001f\u0002J%\u0019\u00111J\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007)\f\t\u0006C\u0005\u0002TI\t\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0017\u0011\u000b\u0005m\u0013\u0011\r6\u000e\u0005\u0005u#bAA0{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0014Q\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\u0005=\u0004c\u0001\u001f\u0002l%\u0019\u0011QN\u001f\u0003\u000f\t{w\u000e\\3b]\"A\u00111\u000b\u000b\u0002\u0002\u0003\u0007!.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001a\u0003kB\u0011\"a\u0015\u0016\u0003\u0003\u0005\r!a\u0012\u0002\r\u0015\fX/\u00197t)\u0011\tI'a\u001f\t\u0011\u0005Mc#!AA\u0002)D3\u0003AA@\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151SAL\u00033\u00032ALAA\u0013\r\t\u0019i\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI)\u0001.`\rVs5i\u0018\u0015tiJd\u0003e\u00195beN,G/\u000b\u0011.A\u0015s7m\u001c3fg\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI1sOVlWM\u001c;!kNLgn\u001a\u0011uQ\u0016\u00043/Z2p]\u0012\u0004\u0013M]4v[\u0016tG\u000fI2iCJ\f7\r^3sAM,GOL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qR\u0001D\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013MY2(Y\u0001:S\u000f\u001e4.q\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I1cG*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0016\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u00111T\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u0007\u000b:\u001cw\u000eZ3\u0011\u00059B2#\u0002\r\u0002$\u0006=\u0006cBAS\u0003WseJV\u0007\u0003\u0003OS1!!+>\u0003\u001d\u0011XO\u001c;j[\u0016LA!!,\u0002(\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gSA!!.\u0002<\u0005\u0011\u0011n\\\u0005\u0004\u0015\u0006MFCAAP\u0003!!xn\u0015;sS:<GCAA\u001a\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u00161YAc\u0011\u0015a5\u00041\u0001O\u0011\u0015\u00116\u00041\u0001O\u0003\u001d)h.\u00199qYf$B!a3\u0002XB)A(!4\u0002R&\u0019\u0011qZ\u001f\u0003\r=\u0003H/[8o!\u0015a\u00141\u001b(O\u0013\r\t).\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005eG$!AA\u0002Y\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u000e\u0005\u0003\u00026\u0005\u0005\u0018\u0002BAr\u0003o\u0011aa\u00142kK\u000e$\b")
public class Encode
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression value;
    private final Expression charset;

    public static Option<Tuple2<Expression, Expression>> unapply(Encode encode) {
        return Encode$.MODULE$.unapply(encode);
    }

    public static Function1<Tuple2<Expression, Expression>, Encode> tupled() {
        return Encode$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Encode>> curried() {
        return Encode$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression charset() {
        return this.charset;
    }

    @Override
    public Expression left() {
        return this.value();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        String toCharset = ((UTF8String)input2).toString();
        return ((UTF8String)input1).toString().getBytes(toCharset);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(string, charset) -> new StringBuilder(193).append("\n        try {\n          ").append(ev.value()).append(" = ").append((String)string).append(".toString().getBytes(").append((String)charset).append(".toString());\n        } catch (java.io.UnsupportedEncodingException e) {\n          org.apache.spark.unsafe.Platform.throwException(e);\n        }").toString());
    }

    @Override
    public Encode withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Encode copy(Expression value, Expression charset) {
        return new Encode(value, charset);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    @Override
    public String productPrefix() {
        return "Encode";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.value();
                break;
            }
            case 1: {
                object = this.charset();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Encode;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "value";
                break;
            }
            case 1: {
                string = "charset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Encode)) return false;
        boolean bl = true;
        if (!bl) return false;
        Encode encode = (Encode)x$1;
        Expression expression = this.value();
        Expression expression2 = encode.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = encode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!encode.canEqual(this)) return false;
        return true;
    }

    public Encode(Expression value, Expression charset) {
        this.value = value;
        this.charset = charset;
        ExpectsInputTypes.$init$(this);
    }
}

