/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ", since="1.1.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u00159\b\u0001\"\u0015y\u0011\u001di\b!!A\u0005\u0002yD\u0011\"a\u0001\u0001#\u0003%\t!!\u0002\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005\u0015\u0001\"CA\u000f\u0001\u0005\u0005I\u0011IA\u0010\u0011%\ty\u0003AA\u0001\n\u0003\t\t\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00131\t\u0005\n\u0003#\u0002\u0011\u0011!C\u0001\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\t\u0013\u0005u\u0003!!A\u0005B\u0005}s!CAE;\u0005\u0005\t\u0012AAF\r!aR$!A\t\u0002\u00055\u0005BB%\u0017\t\u0003\t)\u000bC\u0005\u0002(Z\t\t\u0011\"\u0012\u0002*\"I\u00111\u0016\f\u0002\u0002\u0013\u0005\u0015Q\u0016\u0005\n\u0003g3\u0012\u0011!CA\u0003kC\u0011\"a2\u0017\u0003\u0003%I!!3\u0003\u001b\u0015\u000bX/\u00197Ok2d7+\u00194f\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011\u0003\u0002\u0001,_U\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003!\tKg.\u0019:z\u0007>l\u0007/\u0019:jg>t\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002)s_\u0012,8\r\u001e\t\u0003myr!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iJ\u0013A\u0002\u001fs_>$h(C\u00013\u0013\ti\u0014'A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%\u0001D*fe&\fG.\u001b>bE2,'BA\u001f2\u0003\u0011aWM\u001a;\u0016\u0003\r\u0003\"\u0001\f#\n\u0005\u0015k\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA&M\u001bB\u0011A\u0006\u0001\u0005\u0006\u0003\u0016\u0001\ra\u0011\u0005\u0006\u000f\u0016\u0001\raQ\u0001\u0007gfl'm\u001c7\u0016\u0003A\u0003\"!U+\u000f\u0005I\u001b\u0006C\u0001\u001d2\u0013\t!\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+2\u0003!qW\u000f\u001c7bE2,W#\u0001.\u0011\u0005AZ\u0016B\u0001/2\u0005\u001d\u0011un\u001c7fC:\fA!\u001a<bYR\u0011qL\u0019\t\u0003a\u0001L!!Y\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004d\u0011A\u0005\t\u0019\u00013\u0002\u000b%t\u0007/\u001e;\u0011\u0005\u00154W\"A\u0010\n\u0005\u001d|\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007)\u0004X\u000f\u0005\u0002l]6\tAN\u0003\u0002n;\u000591m\u001c3fO\u0016t\u0017BA8m\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B9\n\u0001\u0004\u0011\u0018aA2uqB\u00111n]\u0005\u0003i2\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003w\u0013\u0001\u0007!.\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0017f\\\b\"\u0002>\u000b\u0001\u0004\u0019\u0015a\u00028fo2+g\r\u001e\u0005\u0006y*\u0001\raQ\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0011Yu0!\u0001\t\u000f\u0005[\u0001\u0013!a\u0001\u0007\"9qi\u0003I\u0001\u0002\u0004\u0019\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fQ3aQA\u0005W\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000bc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005Y\u0006twM\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\r1\u0016QE\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003g\u00012\u0001MA\u001b\u0013\r\t9$\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006u\u0002\"CA !\u0005\u0005\t\u0019AA\u001a\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\t\t\u0006\u0003\u000f\nieX\u0007\u0003\u0003\u0013R1!a\u00132\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\nIE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001.\u0002V!A\u0011q\b\n\u0002\u0002\u0003\u0007q,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0011\u00037B\u0011\"a\u0010\u0014\u0003\u0003\u0005\r!a\r\u0002\r\u0015\fX/\u00197t)\rQ\u0016\u0011\r\u0005\t\u0003\u007f!\u0012\u0011!a\u0001?\":\u0002!!\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI(! \u0002\u0000\u0005\r\u0015Q\u0011\t\u0004Y\u0005\u001d\u0014bAA5;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA8\u0003\u0005]#\u0002\t\u0011!A\u0015D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\u001a\u0018-\\3!e\u0016\u001cX\u000f\u001c;!CN\u0004C\u000f[3!\u000bF+\u0016\t\u0014\u0015>S\u0001z\u0007/\u001a:bi>\u0014\bEZ8sA9|g.\f8vY2\u0004s\u000e]3sC:$7\u000f\f\u0006!A\u0001\u0002\u0003\u0005\t2vi\u0002\u0012X\r^;s]N\u0004CO];fA%4\u0007EY8uQ\u0002\n'/\u001a\u0011ok2dG\u0006\t4bYN,\u0007%\u001b4!_:,\u0007e\u001c4!i\",\u0007\u0005\u001e5f[\u0002J7\u000f\t8vY2t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA;\u0003\tu#\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!S:\u0004S-];bY&$\u0018\u0010I2p[B\f'/[:p]:\u0002S*\u00199!if\u0004X\rI5tA9|G\u000fI:vaB|'\u000f^3e])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti\u0002\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY(AA=\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;sk\u0016\u0004sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002rU\u000b\u0014'!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0005\u0015!B\u0019/c9\u0002\u0014!B4s_V\u0004\u0018EAAD\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018!D#rk\u0006dg*\u001e7m'\u00064W\r\u0005\u0002--M)a#a$\u0002\u001cB9\u0011\u0011SAL\u0007\u000e[UBAAJ\u0015\r\t)*M\u0001\beVtG/[7f\u0013\u0011\tI*a%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+!\u000b\u0002\u0005%|\u0017bA \u0002 R\u0011\u00111R\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011E\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0017\u0006=\u0016\u0011\u0017\u0005\u0006\u0003f\u0001\ra\u0011\u0005\u0006\u000ff\u0001\raQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9,a1\u0011\u000bA\nI,!0\n\u0007\u0005m\u0016G\u0001\u0004PaRLwN\u001c\t\u0006a\u0005}6iQ\u0005\u0004\u0003\u0003\f$A\u0002+va2,'\u0007\u0003\u0005\u0002Fj\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u0017\u0004B!a\t\u0002N&!\u0011qZA\u0013\u0005\u0019y%M[3di\u0002")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public EqualNullSafe withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

