/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatString$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(strfmt, obj, ...) - Returns a formatted string from printf-style format strings.", examples="\n    Examples:\n      > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\");\n       Hello World 100 days\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\")A\n\u0001C!\u001b\")\u0011\u000b\u0001C!\u001b\")!\u000b\u0001C!'\")!\f\u0001C!7\")!\r\u0001C!G\")Q\u000e\u0001C!]\")A\u0010\u0001C!{\"9\u0011Q\u0002\u0001\u0005R\u0005=\u0001\"CA\u000e\u0001\u0005\u0005I\u0011IA\u000f\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005m\u0003!!A\u0005B\u0005us!CAA7\u0005\u0005\t\u0012AAB\r!Q2$!A\t\u0002\u0005\u0015\u0005B\u0002%\u0015\t\u0003\ti\nC\u0005\u0002 R\t\t\u0011\"\u0012\u0002\"\"I\u00111\u0015\u000b\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003S#\u0012\u0011!CA\u0003WC\u0011\"!/\u0015\u0003\u0003%I!a/\u0003\u0019\u0019{'/\\1u'R\u0014\u0018N\\4\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0015.aY\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002+]%\u0011qf\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9\u0001K]8ek\u000e$\bCA\u001c@\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<O\u00051AH]8pizJ\u0011aM\u0005\u0003}I\nq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\na1+\u001a:jC2L'0\u00192mK*\u0011aHM\u0001\tG\"LG\u000e\u001a:f]V\tA\tE\u00022\u000b&J!A\u0012\u001a\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0005dQ&dGM]3oA\u00051A(\u001b8jiz\"\"AS&\u0011\u0005)\u0002\u0001\"\u0002\"\u0004\u0001\u0004!\u0015\u0001\u00034pY\u0012\f'\r\\3\u0016\u00039\u0003\"!M(\n\u0005A\u0013$a\u0002\"p_2,\u0017M\\\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-F\u0001U!\t)\u0006,D\u0001W\u0015\t9v$A\u0003usB,7/\u0003\u0002Z-\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0018\t\u0004ou{\u0016B\u00010B\u0005\r\u0019V-\u001d\t\u0003+\u0002L!!\u0019,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001B3wC2$\"\u0001Z4\u0011\u0005E*\u0017B\u000143\u0005\r\te.\u001f\u0005\bQ\"\u0001\n\u00111\u0001j\u0003\u0015Ig\u000e];u!\tQ7.D\u0001\u001e\u0013\taWDA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003en\tqaY8eK\u001e,g.\u0003\u0002uc\nAQ\t\u001f9s\u0007>$W\rC\u0003w\u0013\u0001\u0007q/A\u0002dib\u0004\"\u0001\u001d=\n\u0005e\f(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006w&\u0001\ra\\\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005q\bcA@\u0002\b9!\u0011\u0011AA\u0002!\tI$'C\u0002\u0002\u0006I\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003e\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0015\u0006E\u0001bBA\n\u0017\u0001\u0007\u0011QC\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u00038\u0003/I\u0013bAA\r\u0003\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&!\u0011\u0011BA\u0012\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0004E\u00022\u0003gI1!!\u000e3\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r!\u00171\b\u0005\n\u0003{q\u0011\u0011!a\u0001\u0003c\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\"!\u0015\t)%a\u0013e\u001b\t\t9EC\u0002\u0002JI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u001d\u0006M\u0003\u0002CA\u001f!\u0005\u0005\t\u0019\u00013\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003?\tI\u0006C\u0005\u0002>E\t\t\u00111\u0001\u00022\u00051Q-];bYN$2ATA0\u0011!\tiDEA\u0001\u0002\u0004!\u0007f\u0005\u0001\u0002d\u0005%\u00141NA8\u0003c\n)(a\u001e\u0002|\u0005u\u0004c\u0001\u0016\u0002f%\u0019\u0011qM\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QN\u0001X?\u001a+fjQ0)gR\u0014h-\u001c;-A=\u0014'\u000e\f\u0011/]9J\u0003%\f\u0011SKR,(O\\:!C\u00022wN]7biR,G\rI:ue&tw\r\t4s_6\u0004\u0003O]5oi\u001al3\u000f^=mK\u00022wN]7bi\u0002\u001aHO]5oONt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0014A\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)E!+G\u000e\\8!/>\u0014H\u000e\u001a\u0011&I\u0002*3O\t\u0017!cA\u0002D\u0006\t\u0012eCf\u001c(%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0011\u0016dGn\u001c\u0011X_JdG\rI\u00191a\u0001\"\u0017-_:\u000bA\u0001\nQa]5oG\u0016\f#!!\u001f\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0014\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001\u0004$pe6\fGo\u0015;sS:<\u0007C\u0001\u0016\u0015'\u0015!\u0012qQAJ!\u0019\tI)a$E\u00156\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u0013\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003#\u000bYIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000b9#\u0001\u0002j_&\u0019\u0001)a&\u0015\u0005\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0011!B1qa2LHc\u0001&\u0002(\")!i\u0006a\u0001\t\u0006QQO\\1qa2L8+Z9\u0015\t\u00055\u0016Q\u0017\t\u0006c\u0005=\u00161W\u0005\u0004\u0003c\u0013$AB(qi&|g\u000eE\u00028;&B\u0001\"a.\u0019\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA_!\u0011\t\t#a0\n\t\u0005\u0005\u00171\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class FormatString
extends Expression
implements ImplicitCastInputTypes,
Serializable {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapplySeq(FormatString formatString) {
        return FormatString$.MODULE$.unapplySeq(formatString);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<FormatString, A> function1) {
        return FormatString$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, FormatString> compose(Function1<A$, Seq<Expression>> function1) {
        return FormatString$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.foldable()));
    }

    @Override
    public boolean nullable() {
        return ((Expression)this.children().apply(0)).nullable();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return ((List)package$.MODULE$.List().fill(this.children().size() - 1, (Function0 & Serializable)() -> AnyDataType$.MODULE$)).$colon$colon((Object)stringType$);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object pattern = ((Expression)this.children().apply(0)).eval(input);
        if (pattern == null) {
            uTF8String = null;
        } else {
            StringBuffer sb = new StringBuffer();
            Formatter formatter = new Formatter(sb, Locale.US);
            Seq arglist = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x$30 -> x$30.eval(input));
            formatter.format(((UTF8String)pattern).toString(), (Object[])arglist.toArray(ClassTag$.MODULE$.AnyRef()));
            uTF8String = UTF8String.fromString((String)sb.toString());
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode pattern = ((Expression)this.children().head()).genCode(ctx);
        Seq argListGen = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x -> new Tuple2((Object)x.dataType(), (Object)x.genCode(ctx)));
        String argList = ctx.freshName("argLists");
        int numArgLists = argListGen.length();
        Seq argListCode = (Seq)((IterableOps)argListGen.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 v = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = CodeGenerator$.MODULE$.boxedType((DataType)v._1());
            String string2 = CodeGenerator$.MODULE$.javaType((DataType)v._1());
            String value = (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(0).append(new StringBuilder(15).append("(").append(((ExprCode)v._2()).isNull()).append(") ? (").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append(") null : ").toString()).append(new StringBuilder(6).append("new ").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append("(").append(((ExprCode)v._2()).value()).append(")").toString()).toString() : new StringBuilder(12).append("(").append(((ExprCode)v._2()).isNull()).append(") ? null : ").append(((ExprCode)v._2()).value()).toString();
            String string3 = new StringBuilder(34).append("\n         ").append(((ExprCode)v._2()).code()).append("\n         ").append(argList).append("[").append(index).append("] = ").append(value).append(";\n       ").toString();
            return string3;
        });
        Tuple2 tuple2 = new Tuple2((Object)"Object[]", (Object)argList);
        String argListCodes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)argListCode, "valueFormatString", (Seq<Tuple2<String, String>>)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String form = ctx.freshName("formatter");
        String formatter = Formatter.class.getName();
        String sb = ctx.freshName("sb");
        String stringBuffer = StringBuffer.class.getName();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      boolean ", " = ", ";\n      ", " ", " = ", ";\n      if (!", ") {\n        ", " ", " = new ", "();\n        ", " ", " = new ", "(", ", ", ".US);\n        Object[] ", " = new Object[", "];\n        ", "\n        ", ".format(", ".toString(), ", ");\n        ", " = UTF8String.fromString(", ".toString());\n      }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pattern.code(), ev.isNull(), pattern.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), stringBuffer, sb, stringBuffer, formatter, form, formatter, sb, Locale.class.getName(), argList, BoxesRunTime.boxToInteger((int)numArgLists), argListCodes, form, pattern.value(), argList, ev.value(), sb})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "format_string");
    }

    @Override
    public FormatString withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return new FormatString((Seq<Expression>)newChildren);
    }

    @Override
    public String productPrefix() {
        return "FormatString";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatString;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatString)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatString formatString = (FormatString)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = formatString.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!formatString.canEqual(this)) return false;
        return true;
    }

    public FormatString(Seq<Expression> children2) {
        this.children = children2;
        ExpectsInputTypes.$init$(this);
        Predef$.MODULE$.require(children2.nonEmpty(), (Function0 & Serializable)() -> new StringBuilder(34).append(this.prettyName()).append("() should take at least 1 argument").toString());
    }
}

