/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.JsonPathParser$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Key$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Subscript$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Wildcard$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$FlattenStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$QuotedStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$RawStyle$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ", group="json_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u0012%\u0001FB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015q\u0006\u0001\"\u0011S\u0011\u0015y\u0006\u0001\"\u0011S\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0011\b\u0001\"\u0011t\u0011!a\b\u0001#b\u0001\n\u0013i\bbBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002\u0014\u0002!\t&!&\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAT\u0001E\u0005I\u0011AAU\u0011%\ty\fAI\u0001\n\u0003\tI\u000bC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u00111\u001b\u0001\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u0003;\u0004\u0011\u0011!C\u0001\u0003?D\u0011\"!:\u0001\u0003\u0003%\t%a:\t\u0013\u0005U\b!!A\u0005\u0002\u0005]\b\"CA~\u0001\u0005\u0005I\u0011IA\u007f\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0012\u0019aB\u0005\u0003(\u0011\n\t\u0011#\u0001\u0003*\u0019A1\u0005JA\u0001\u0012\u0003\u0011Y\u0003\u0003\u0004Z;\u0011\u0005!1\t\u0005\n\u0005\u000bj\u0012\u0011!C#\u0005\u000fB\u0011B!\u0013\u001e\u0003\u0003%\tIa\u0013\t\u0013\tES$!A\u0005\u0002\nM\u0003\"\u0003B1;\u0005\u0005I\u0011\u0002B2\u000559U\r\u001e&t_:|%M[3di*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001eYJt(\u0012\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0011\nqaY8eK\u001e,g.\u0003\u0002?w\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0019seBA$M\u001d\tA5*D\u0001J\u0015\tQ\u0005'\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011Q*Q\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002N\u0003\u0006!!n]8o+\u0005\u0019\u0006CA\u001aU\u0013\t)FE\u0001\u0006FqB\u0014Xm]:j_:\fQA[:p]\u0002\nA\u0001]1uQ\u0006)\u0001/\u0019;iA\u00051A(\u001b8jiz\"2a\u0017/^!\t\u0019\u0004\u0001C\u0003R\u000b\u0001\u00071\u000bC\u0003X\u000b\u0001\u00071+\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018AC5oaV$H+\u001f9fgV\t!\rE\u0002GG\u0016L!\u0001\u001a)\u0003\u0007M+\u0017\u000f\u0005\u0002gS6\tqM\u0003\u0002iQ\u0005)A/\u001f9fg&\u0011!n\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001f\u0003!qW\u000f\u001c7bE2,W#A8\u0011\u0005\u0001\u0003\u0018BA9B\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\u0005!\bCA;z\u001d\t1x\u000f\u0005\u0002I\u0003&\u0011\u00010Q\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y\u0003\u0006Q\u0001/\u0019:tK\u0012\u0004\u0016\r\u001e5\u0016\u0003y\u0004B\u0001Q@\u0002\u0004%\u0019\u0011\u0011A!\u0003\r=\u0003H/[8o!\u00151\u0015QAA\u0005\u0013\r\t9\u0001\u0015\u0002\u0005\u0019&\u001cH\u000fE\u00024\u0003\u0017I1!!\u0004%\u0005=\u0001\u0016\r\u001e5J]N$(/^2uS>t\u0007f\u0001\u0007\u0002\u0012A\u0019\u0001)a\u0005\n\u0007\u0005U\u0011IA\u0005ue\u0006t7/[3oi\u0006!QM^1m)\u0011\tY\"!\t\u0011\u0007\u0001\u000bi\"C\u0002\u0002 \u0005\u00131!\u00118z\u0011%\t\u0019#\u0004I\u0001\u0002\u0004\t)#A\u0003j]B,H\u000f\u0005\u0003\u0002(\u0005%R\"\u0001\u0014\n\u0007\u0005-bEA\u0006J]R,'O\\1m%><\u0018!\u00039beN,\u0007+\u0019;i)\rq\u0018\u0011\u0007\u0005\u0007/:\u0001\r!a\r\u0011\t\u0005U\u0012QH\u0007\u0003\u0003oQ1\u0001[A\u001d\u0015\r\tYDK\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005}\u0012q\u0007\u0002\u000b+R3\u0005h\u0015;sS:<\u0017AC1se\u0006L\u0018J\u001c3fqR1\u0011QIA)\u0003[\u0002b\u0001QA$\u0003\u0017z\u0017bAA%\u0003\nIa)\u001e8di&|g.\r\t\u0004\u0001\u00065\u0013bAA(\u0003\n!Aj\u001c8h\u0011\u001d\t\u0019f\u0004a\u0001\u0003+\n\u0011\u0001\u001d\t\u0005\u0003/\nI'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011\u0019wN]3\u000b\t\u0005}\u0013\u0011M\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t\u0019'!\u001a\u0002\u0013\u0019\f7\u000f^3sq6d'BAA4\u0003\r\u0019w.\\\u0005\u0005\u0003W\nIF\u0001\u0006Kg>t\u0007+\u0019:tKJDq!a\u001c\u0010\u0001\u0004\t\t(A\u0001g!\u0011\u0001\u00151O8\n\u0007\u0005U\u0014IA\u0005Gk:\u001cG/[8oa\u0005aQM^1mk\u0006$X\rU1uQRIq.a\u001f\u0002~\u0005\u001d\u0015\u0011\u0013\u0005\b\u0003'\u0002\u0002\u0019AA+\u0011\u001d\ty\b\u0005a\u0001\u0003\u0003\u000b\u0011a\u001a\t\u0005\u0003/\n\u0019)\u0003\u0003\u0002\u0006\u0006e#!\u0004&t_:<UM\\3sCR|'\u000fC\u0004\u0002\nB\u0001\r!a#\u0002\u000bM$\u0018\u0010\\3\u0011\u0007M\ni)C\u0002\u0002\u0010\u0012\u0012!b\u0016:ji\u0016\u001cF/\u001f7f\u0011\u00199\u0006\u00031\u0001\u0002\u0004\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00067\u0006]\u00151\u0014\u0005\u0007\u00033\u000b\u0002\u0019A*\u0002\u000f9,w\u000fT3gi\"1\u0011QT\tA\u0002M\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003\\\u0003G\u000b)\u000bC\u0004R%A\u0005\t\u0019A*\t\u000f]\u0013\u0002\u0013!a\u0001'\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAVU\r\u0019\u0016QV\u0016\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011X!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0006M&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017\u0001\u00027b]\u001eT!!a4\u0002\t)\fg/Y\u0005\u0004u\u0006%\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAl!\r\u0001\u0015\u0011\\\u0005\u0004\u00037\f%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000e\u0003CD\u0011\"a9\u0018\u0003\u0003\u0005\r!a6\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000f\u0005\u0004\u0002l\u0006E\u00181D\u0007\u0003\u0003[T1!a<B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\fiO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA8\u0002z\"I\u00111]\r\u0002\u0002\u0003\u0007\u00111D\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002F\u0006}\b\"CAr5\u0005\u0005\t\u0019AAl\u0003\u0019)\u0017/^1mgR\u0019qN!\u0002\t\u0013\u0005\r8$!AA\u0002\u0005m\u0001f\u0005\u0001\u0003\n\t=!\u0011\u0003B\u000b\u0005/\u0011YB!\b\u0003\"\t\r\u0002cA\u001a\u0003\f%\u0019!Q\u0002\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1C\u0001=?\u001a+fjQ0)UN|gn\u0018;yi2\u0002\u0003/\u0019;iS\u0001j\u0003%\u0012=ue\u0006\u001cGo\u001d\u0011bA)\u001cxN\u001c\u0011pE*,7\r\u001e\u0011ge>l\u0007\u0005\u00199bi\"\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011I\"A#\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ(%\u0019\u0012;E\t\u0014Sp\n\u0017!O\u0011r\u0013mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\tT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005?\t!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011)#A\u00032]Ur\u0003'A\u0007HKRT5o\u001c8PE*,7\r\u001e\t\u0003gu\u0019R!\bB\u0017\u0005s\u0001rAa\f\u00036M\u001b6,\u0004\u0002\u00032)\u0019!1G!\u0002\u000fI,h\u000e^5nK&!!q\u0007B\u0019\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)!!qHAg\u0003\tIw.C\u0002P\u0005{!\"A!\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bm\u0013iEa\u0014\t\u000bE\u0003\u0003\u0019A*\t\u000b]\u0003\u0003\u0019A*\u0002\u000fUt\u0017\r\u001d9msR!!Q\u000bB/!\u0011\u0001uPa\u0016\u0011\u000b\u0001\u0013IfU*\n\u0007\tm\u0013I\u0001\u0004UkBdWM\r\u0005\t\u0005?\n\u0013\u0011!a\u00017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0015\u0004\u0003BAd\u0005OJAA!\u001b\u0002J\n1qJ\u00196fGR\u0004")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
Serializable {
    private transient Option<List<PathInstruction>> parsedPath;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject getJsonObject) {
        return GetJsonObject$.MODULE$.unapply(getJsonObject);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private Option<List<PathInstruction>> parsedPath$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.parsedPath = this.parsePath((UTF8String)this.path().eval(this.path().eval$default$1()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.parsedPath;
    }

    private Option<List<PathInstruction>> parsedPath() {
        return !this.bitmap$trans$0 ? this.parsedPath$lzycompute() : this.parsedPath;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Option<List<PathInstruction>> parsed;
        UTF8String jsonStr = (UTF8String)this.json().eval(input);
        if (jsonStr == null) {
            return null;
        }
        Option<List<PathInstruction>> option = parsed = this.path().foldable() ? this.parsedPath() : this.parsePath((UTF8String)this.path().eval(input));
        if (parsed.isDefined()) {
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), jsonStr), (Function1 & Serializable)parser -> {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    boolean matched = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable)generator -> BoxesRunTime.boxToBoolean((boolean)GetJsonObject.$anonfun$eval$4(this, parser, parsed, generator))));
                    return matched ? UTF8String.fromBytes((byte[])output.toByteArray()) : null;
                });
            }
            catch (JsonProcessingException jsonProcessingException) {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private Option<List<PathInstruction>> parsePath(UTF8String path) {
        return path != null ? JsonPathParser$.MODULE$.parse(path.toString()) : None$.MODULE$;
    }

    private Function1<Object, Object> arrayIndex(JsonParser p, Function0<Object> f) {
        return (JFunction1.mcZJ.sp & Serializable)x0$1 -> {
            boolean bl;
            long l = x0$1;
            JsonToken jsonToken = p.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                bl = false;
            } else if (0L == l) {
                boolean dirty = f.apply$mcZ$sp();
                while (true) {
                    JsonToken jsonToken3 = p.nextToken();
                    JsonToken jsonToken4 = JsonToken.END_ARRAY;
                    if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
                    p.skipChildren();
                }
                bl = dirty;
            } else if (l > 0L) {
                p.skipChildren();
                p.nextToken();
                bl = this.arrayIndex(p, f).apply$mcZJ$sp(l - 1L);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            return bl;
        };
    }

    private boolean evaluatePath(JsonParser p, JsonGenerator g, WriteStyle style, List<PathInstruction> path) {
        boolean bl;
        block59: {
            while (true) {
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)p.getCurrentToken(), path)) != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.VALUE_STRING.equals(jsonToken)) {
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            WriteStyle writeStyle = style;
                            WriteStyle$RawStyle$ writeStyle$RawStyle$ = WriteStyle$RawStyle$.MODULE$;
                            if (!(writeStyle != null ? !writeStyle.equals(writeStyle$RawStyle$) : writeStyle$RawStyle$ != null)) {
                                if (p.hasTextCharacters()) {
                                    g.writeRaw(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                                } else {
                                    g.writeRaw(p.getText());
                                }
                                bl = true;
                                break block59;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken)) {
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list3 = list;
                        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                            WriteStyle writeStyle = style;
                            WriteStyle$FlattenStyle$ writeStyle$FlattenStyle$ = WriteStyle$FlattenStyle$.MODULE$;
                            if (!(writeStyle != null ? !writeStyle.equals(writeStyle$FlattenStyle$) : writeStyle$FlattenStyle$ != null)) {
                                boolean dirty = false;
                                while (true) {
                                    JsonToken jsonToken2 = p.nextToken();
                                    JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                    if (!(jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3))) break;
                                    dirty |= this.evaluatePath(p, g, style, (List<PathInstruction>)package$.MODULE$.Nil());
                                }
                                bl = dirty;
                                break block59;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    List list = (List)tuple2._2();
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list4 = list;
                    if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                        g.copyCurrentStructure(p);
                        bl = true;
                        break block59;
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_OBJECT.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon2.head();
                        List xs = colon2.next$access$1();
                        if (PathInstruction$Key$.MODULE$.equals(pathInstruction)) {
                            boolean dirty = false;
                            while (true) {
                                JsonParser jsonParser;
                                JsonToken jsonToken4 = p.nextToken();
                                JsonToken jsonToken5 = JsonToken.END_OBJECT;
                                if (!(jsonToken4 == null ? jsonToken5 != null : !jsonToken4.equals(jsonToken5))) break;
                                if (dirty) {
                                    jsonParser = p.skipChildren();
                                    continue;
                                }
                                dirty = this.evaluatePath(p, g, style, (List<PathInstruction>)xs);
                                jsonParser = BoxedUnit.UNIT;
                            }
                            bl = dirty;
                            break block59;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon3.head();
                        List list5 = colon3.next$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list5 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list5;
                            PathInstruction pathInstruction2 = (PathInstruction)colon4.head();
                            List list6 = colon4.next$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction2) && list6 instanceof .colon.colon) {
                                .colon.colon colon5 = (.colon.colon)list6;
                                PathInstruction pathInstruction3 = (PathInstruction)colon5.head();
                                List list7 = colon5.next$access$1();
                                if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction3) && list7 instanceof .colon.colon) {
                                    .colon.colon colon6 = (.colon.colon)list7;
                                    PathInstruction pathInstruction4 = (PathInstruction)colon6.head();
                                    List xs = colon6.next$access$1();
                                    if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction4)) {
                                        boolean dirty = false;
                                        g.writeStartArray();
                                        while (true) {
                                            JsonToken jsonToken6 = p.nextToken();
                                            JsonToken jsonToken7 = JsonToken.END_ARRAY;
                                            if (!(jsonToken6 == null ? jsonToken7 != null : !jsonToken6.equals(jsonToken7))) break;
                                            dirty |= this.evaluatePath(p, g, WriteStyle$FlattenStyle$.MODULE$, (List<PathInstruction>)xs);
                                        }
                                        g.writeEndArray();
                                        bl = dirty;
                                        break block59;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon7.head();
                        List list8 = colon7.next$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list8 instanceof .colon.colon) {
                            .colon.colon colon8 = (.colon.colon)list8;
                            PathInstruction pathInstruction5 = (PathInstruction)colon8.head();
                            List xs = colon8.next$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction5)) {
                                WriteStyle writeStyle = style;
                                WriteStyle$QuotedStyle$ writeStyle$QuotedStyle$ = WriteStyle$QuotedStyle$.MODULE$;
                                if (writeStyle == null ? writeStyle$QuotedStyle$ != null : !writeStyle.equals(writeStyle$QuotedStyle$)) {
                                    WriteStyle writeStyle2;
                                    WriteStyle writeStyle3 = style;
                                    if (WriteStyle$RawStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$QuotedStyle$.MODULE$;
                                    } else if (WriteStyle$FlattenStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$FlattenStyle$.MODULE$;
                                    } else {
                                        if (WriteStyle$QuotedStyle$.MODULE$.equals(writeStyle3)) {
                                            throw new IllegalStateException();
                                        }
                                        throw new MatchError((Object)writeStyle3);
                                    }
                                    WriteStyle$QuotedStyle$ nextStyle = writeStyle2;
                                    StringWriter buffer = new StringWriter();
                                    IntRef dirty = IntRef.create((int)0);
                                    Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((Writer)buffer), (Function1 & Serializable)flattenGenerator -> {
                                        GetJsonObject.$anonfun$evaluatePath$2(this, p, dirty, nextStyle, xs, flattenGenerator);
                                        return BoxedUnit.UNIT;
                                    });
                                    StringBuffer buf = buffer.getBuffer();
                                    if (dirty.elem > 1) {
                                        g.writeRawValue(buf.toString());
                                    } else if (dirty.elem == 1) {
                                        g.writeRawValue(buf.substring(1, buf.length() - 1));
                                    }
                                    bl = dirty.elem > 0;
                                    break block59;
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon9.head();
                        List list9 = colon9.next$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list9 instanceof .colon.colon) {
                            .colon.colon colon10 = (.colon.colon)list9;
                            PathInstruction pathInstruction6 = (PathInstruction)colon10.head();
                            List xs = colon10.next$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction6)) {
                                boolean dirty = false;
                                g.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken8 = p.nextToken();
                                    JsonToken jsonToken9 = JsonToken.END_ARRAY;
                                    if (!(jsonToken8 == null ? jsonToken9 != null : !jsonToken8.equals(jsonToken9))) break;
                                    dirty |= this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)xs);
                                }
                                g.writeEndArray();
                                bl = dirty;
                                break block59;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon11.head();
                        List list10 = colon11.next$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list10 instanceof .colon.colon) {
                            .colon.colon colon12 = (.colon.colon)list10;
                            PathInstruction pathInstruction7 = (PathInstruction)colon12.head();
                            List xs = colon12.next$access$1();
                            if (pathInstruction7 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction7;
                                long idx = index.index();
                                if (xs instanceof .colon.colon) {
                                    .colon.colon colon13;
                                    PathInstruction pathInstruction8;
                                    .colon.colon colon14 = (.colon.colon)xs;
                                    PathInstruction pathInstruction9 = (PathInstruction)colon14.head();
                                    List list11 = colon14.next$access$1();
                                    if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction9) && list11 instanceof .colon.colon && PathInstruction$Wildcard$.MODULE$.equals(pathInstruction8 = (PathInstruction)(colon13 = (.colon.colon)list11).head())) {
                                        p.nextToken();
                                        bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)colon14)).apply$mcZJ$sp(idx);
                                        break block59;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon15 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon15.head();
                        List list12 = colon15.next$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list12 instanceof .colon.colon) {
                            .colon.colon colon16 = (.colon.colon)list12;
                            PathInstruction pathInstruction10 = (PathInstruction)colon16.head();
                            List xs = colon16.next$access$1();
                            if (pathInstruction10 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction10;
                                long idx = index.index();
                                p.nextToken();
                                bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.evaluatePath(p, g, style, (List<PathInstruction>)xs)).apply$mcZJ$sp(idx);
                                break block59;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.FIELD_NAME.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon17.head();
                        List xs = colon17.next$access$1();
                        if (pathInstruction instanceof PathInstruction.Named) {
                            PathInstruction.Named named = (PathInstruction.Named)pathInstruction;
                            String name = named.name();
                            String string = p.getCurrentName();
                            String string2 = name;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JsonToken jsonToken10 = p.nextToken();
                                JsonToken jsonToken11 = JsonToken.VALUE_NULL;
                                if (jsonToken10 == null ? jsonToken11 != null : !jsonToken10.equals(jsonToken11)) {
                                    path = xs;
                                    continue;
                                }
                                bl = false;
                                break block59;
                            }
                        }
                    }
                }
                if (tuple2 == null) break;
                JsonToken jsonToken = (JsonToken)tuple2._1();
                List list = (List)tuple2._2();
                if (!JsonToken.FIELD_NAME.equals(jsonToken) || !(list instanceof .colon.colon)) break;
                .colon.colon colon18 = (.colon.colon)list;
                PathInstruction pathInstruction = (PathInstruction)colon18.head();
                List xs = colon18.next$access$1();
                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction)) break;
                p.nextToken();
                path = xs;
            }
            p.skipChildren();
            bl = false;
        }
        return bl;
    }

    @Override
    public GetJsonObject withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.json();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "json";
                break;
            }
            case 1: {
                string = "path";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(GetJsonObject $this, JsonParser parser$1, Option parsed$1, JsonGenerator generator) {
        parser$1.nextToken();
        return $this.evaluatePath(parser$1, generator, WriteStyle$RawStyle$.MODULE$, (List<PathInstruction>)((List)parsed$1.get()));
    }

    public static final /* synthetic */ void $anonfun$evaluatePath$2(GetJsonObject $this, JsonParser p$2, IntRef dirty$1, Product nextStyle$1, List xs$1, JsonGenerator flattenGenerator) {
        flattenGenerator.writeStartArray();
        while (true) {
            JsonToken jsonToken = p$2.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            dirty$1.elem = dirty$1.elem + ($this.evaluatePath(p$2, flattenGenerator, (WriteStyle)nextStyle$1, (List<PathInstruction>)xs$1) ? 1 : 0);
        }
        flattenGenerator.writeEndArray();
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

