/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ '\\%SystemDrive\\%\\\\\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u0012%\u0001FB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003\t\u0006\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000b}\u0003A\u0011\t1\t\u000b-\u0004A\u0011\t7\t\u000fu\u0004!\u0019!C#}\"9\u0011q\u0006\u0001!\u0002\u001by\bbBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\u0007S\u0001!\t%!\u000e\t\u000f\u0005]\u0002\u0001\"\u0015\u0002:!9\u0011Q\u000b\u0001\u0005R\u0005]\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tY\u0007AI\u0001\n\u0003\ti\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002n!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001bC\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0013qZ\u0004\n\u0003\u007f$\u0013\u0011!E\u0001\u0005\u00031\u0001b\t\u0013\u0002\u0002#\u0005!1\u0001\u0005\u0007-v!\tAa\u0007\t\u0013\u0005ER$!A\u0005F\tu\u0001\"\u0003B\u0010;\u0005\u0005I\u0011\u0011B\u0011\u0011%\u0011I#HA\u0001\n\u0003\u0013Y\u0003C\u0005\u0003>u\t\t\u0011\"\u0003\u0003@\t!A*[6f\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014)\u0003!\u0019\u0017\r^1msN$(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011\u0003\u0002\u00013mq\u0002\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003+M#(/\u001b8h%\u0016<W\r_#yaJ,7o]5p]B\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001fF\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002Ba\u00051AH]8pizJ\u0011!O\u0005\u0003\tb\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\na1+\u001a:jC2L'0\u00192mK*\u0011A\tO\u0001\u0005Y\u00164G/F\u0001K!\t\u00194*\u0003\u0002MI\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003))7oY1qK\u000eC\u0017M]\u000b\u0002%B\u0011qgU\u0005\u0003)b\u0012Aa\u00115be\u0006YQm]2ba\u0016\u001c\u0005.\u0019:!\u0003\u0019a\u0014N\\5u}Q!\u0001,\u0017.\\!\t\u0019\u0004\u0001C\u0003I\u000f\u0001\u0007!\nC\u0003O\u000f\u0001\u0007!\nC\u0003Q\u000f\u0001\u0007!\u000bF\u0002Y;zCQ\u0001\u0013\u0005A\u0002)CQA\u0014\u0005A\u0002)\u000ba!Z:dCB,GCA1j!\t\u0011gM\u0004\u0002dIB\u0011q\bO\u0005\u0003Kb\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\r\u000f\u0005\u0006U&\u0001\r!Y\u0001\u0002m\u00069Q.\u0019;dQ\u0016\u001cHcA7qwB\u0011qG\\\u0005\u0003_b\u0012qAQ8pY\u0016\fg\u000eC\u0003r\u0015\u0001\u0007!/A\u0003sK\u001e,\u0007\u0010\u0005\u0002ts6\tAO\u0003\u0002rk*\u0011ao^\u0001\u0005kRLGNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i$(a\u0002)biR,'O\u001c\u0005\u0006y*\u0001\r!Y\u0001\u0004gR\u0014\u0018\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#A@\u0011\u000bu\n\t!!\u0002\n\u0007\u0005\rqIA\u0002TKF\u0004B!a\u0002\u0002*9!\u0011\u0011BA\u0012\u001d\u0011\tY!a\b\u000f\t\u00055\u0011Q\u0004\b\u0005\u0003\u001f\tYB\u0004\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003/q1aPA\u000b\u0013\u0005y\u0013BA\u0017/\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0004\u0003C1\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA\u0013\u0003O\t1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011\u0011\u0005\u0014\n\t\u0005-\u0012Q\u0006\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002&\u0005\u001d\u0012!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0005u_N#(/\u001b8h)\u0005\tW#A1\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001e\u0003\u000f\n\t\u0006\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005J\u0001\bG>$WmZ3o\u0013\u0011\t)%a\u0010\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0013\u0010\u0001\u0004\tY%A\u0002dib\u0004B!!\u0010\u0002N%!\u0011qJA \u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0015\u0010\u0001\u0004\tY$\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00061\u0006e\u0013Q\f\u0005\u0007\u00037\u0002\u0002\u0019\u0001&\u0002\u000f9,w\u000fT3gi\"1\u0011q\f\tA\u0002)\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004Y\u0003K\n9'!\u001b\t\u000f!\u000b\u0002\u0013!a\u0001\u0015\"9a*\u0005I\u0001\u0002\u0004Q\u0005b\u0002)\u0012!\u0003\u0005\rAU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyGK\u0002K\u0003cZ#!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{B\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011QA<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!#+\u0007I\u000b\t(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+;\u0018\u0001\u00027b]\u001eL1aZAJ\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\nE\u00028\u0003?K1!!)9\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u0007]\nI+C\u0002\u0002,b\u00121!\u00118z\u0011%\tykFA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0003b!a.\u0002>\u0006\u001dVBAA]\u0015\r\tY\fO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA`\u0003s\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q.!2\t\u0013\u0005=\u0016$!AA\u0002\u0005\u001d\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a$\u0002L\"I\u0011q\u0016\u000e\u0002\u0002\u0003\u0007\u0011QT\u0001\u0007KF,\u0018\r\\:\u0015\u00075\f\t\u000eC\u0005\u00020n\t\t\u00111\u0001\u0002(\"Z\u0002!!6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI/!<\u0002p\u0006M\u0018Q_A}\u0003w\u00042aMAl\u0013\r\tI\u000e\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty.AA\u000bgR\u0014\be\u0018$V\u001d\u000e{\u0006\u0005]1ui\u0016\u0014hn\u0017\u0011F'\u000e\u000b\u0005+\u0012\u0011fg\u000e\f\u0007/Z/![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007e\u001d;sA5\fGo\u00195fg\u0002\u0002\u0007/\u0019;uKJt\u0007\rI<ji\"\u0004\u0003-Z:dCB,\u0007\r\f\u0011ok2d\u0007%\u001b4!C:L\b%\u0019:hk6,g\u000e^:!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!!:\u0002\u0011KS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=dKB$\u0018n\u001c8!i>\u0004C\u000f[3!M>dGn\\<j]\u001e\u00043\u000f]3dS\u0006d\u0007e]=nE>d7O\u000f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\fI7bi\u000eDWm\u001d\u0011b]f\u0004sN\\3!G\"\f'/Y2uKJ\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!]\u0001Jg\u000e\t9pg&D\bE]3hk2\f'\u000fI3yaJ,7o]5p]NL#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015\u0002S.\u0019;dQ\u0016\u001c\bE_3s_\u0002z'\u000fI7pe\u0016\u00043\r[1sC\u000e$XM]:!S:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011)g&l\u0017\u000e\\1sAQ|\u0007E\f\u0016!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001c\u0018F\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b8!_J$WM\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGn\u001d\u0011cC\u000e\\'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nr#\u0002\t\u0011!A\u0001\u0002#\u0006I3tG\u0006\u0004X\rI\u0017!C:\u00043\r[1sC\u000e$XM\u001d\u0011bI\u0012,G\rI:j]\u000e,\u0007e\u00159be.\u00043G\f\u0019/AQCW\r\t3fM\u0006,H\u000e\u001e\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002J7\u000f\t;iK\u0002:Cl\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011b]\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000f\t9sK\u000e,G-Z:!C\u0002\u001a\b/Z2jC2\u00043/_7c_2\u0004sN\u001d\u0011b]>$\b.\u001a:!KN\u001c\u0017\r]3!G\"\f'/Y2uKJd\u0003\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8mY><\u0018N\\4!G\"\f'/Y2uKJ\u0004\u0013n\u001d\u0011nCR\u001c\u0007.\u001a3!Y&$XM]1mYft\u0003%\u0013;!SN\u0004\u0013N\u001c<bY&$\u0007\u0005^8!KN\u001c\u0017\r]3!C:L\be\u001c;iKJ\u00043\r[1sC\u000e$XM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003W\fA1\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001:s\f]1sW\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012+!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cX\b\u001e:vKnR\u0001\u0005\t\u0011!A\u0001\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0005ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/Vg\u0016\u00148\u000f\u0018&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006e\n/&'f\u001cH/Z7Ee&4X\rX\u0013]9V\u001bXM]:&OmR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E\u000bI:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mgv2\u0017\r\\:fw)\u0001\u0003\u0005\t\u0011!AM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7/\u00034bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/]+N,'o\u001d/]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcF\fX+tKJ\u001cXeJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-J\u0018Vg\u0016\u00148o\f&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006eJ\u0018&'f\u001cH/Z7Ee&4XmL\u00130_U\u001bXM]:&O\u0001*5kQ!Q\u000b\u0002:sfJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003c\fQH\u0003\u0011!A\u0001*6/\u001a\u0011S\u0019&[U\t\t;pA5\fGo\u00195!o&$\b\u000eI:uC:$\u0017M\u001d3!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u000bA\u0001\nQa]5oG\u0016\f#!a>\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0018a\u00049sK\u0012L7-\u0019;f?\u001a,hnY:\u0002\t1K7.\u001a\t\u0003gu\u0019R!\bB\u0003\u0005#\u0001\u0002Ba\u0002\u0003\u000e)S%\u000bW\u0007\u0003\u0005\u0013Q1Aa\u00039\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0004\u0003\n\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006x\u0003\tIw.C\u0002G\u0005+!\"A!\u0001\u0015\u0005\u0005=\u0015!B1qa2LHc\u0002-\u0003$\t\u0015\"q\u0005\u0005\u0006\u0011\u0002\u0002\rA\u0013\u0005\u0006\u001d\u0002\u0002\rA\u0013\u0005\u0006!\u0002\u0002\rAU\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iC!\u000f\u0011\u000b]\u0012yCa\r\n\u0007\tE\u0002H\u0001\u0004PaRLwN\u001c\t\u0007o\tU\"J\u0013*\n\u0007\t]\u0002H\u0001\u0004UkBdWm\r\u0005\t\u0005w\t\u0013\u0011!a\u00011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0005\u0003\u0003BAI\u0005\u0007JAA!\u0012\u0002\u0014\n1qJ\u00196fGR\u0004")
public class Like
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;
    private final Seq<Enumeration.Value> nodePatterns;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String toString() {
        String string;
        char c = this.escapeChar();
        switch (c) {
            case '\\': {
                string = new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
                break;
            }
            default: {
                string = new StringBuilder(16).append(this.left()).append(" LIKE ").append(this.right()).append(" ESCAPE '").append(c).append("'").toString();
                break;
            }
        }
        return string;
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.left().sql()).append(" ").append(this.prettyName().toUpperCase(Locale.ROOT)).append(" ").append(this.right().sql()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName()), "$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            String escapedEscapeChar = StringEscapeUtils.escapeJava((String)Character.toString(this.escapeChar()));
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> new StringBuilder(133).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(\n            ").append(escapeFunc).append("(").append(rightStr).append(", '").append(escapedEscapeChar).append("'));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    @Override
    public Like withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToCharacter((char)this.escapeChar());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "escapeChar";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        if (this.escapeChar() != like.escapeChar()) return false;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.LIKE_FAMLIY()}));
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

