/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted. The result data type is consistent with the value of\n      configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011!9\u0006A!f\u0001\n\u0003B\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\u0001\u0004!Q3A\u0005\u00021C\u0001\"\u0019\u0001\u0003\u0012\u0003\u0006I!\u0014\u0005\u0006E\u0002!\ta\u0019\u0005\u0006E\u0002!\t!\u001b\u0005\u0006E\u0002!\t\u0001\u001c\u0005\u0006]\u0002!\te\u001c\u0005\u0006m\u0002!\te\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0017\u0001A\u0011KA\u0007\u0011%\t\u0019\u0002AA\u0001\n\u0003\t)\u0002C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!I\u0011q\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003{\u0001\u0011\u0013!C\u0001\u0003\u007fA\u0011\"a\u0011\u0001#\u0003%\t!!\t\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001d\u0003\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000bC\u0011\"!#\u0001\u0003\u0003%\t%a#\b\u0013\u0005UF%!A\t\u0002\u0005]f\u0001C\u0012%\u0003\u0003E\t!!/\t\r\tlB\u0011AAi\u0011%\t\u0019.HA\u0001\n\u000b\n)\u000eC\u0005\u0002Xv\t\t\u0011\"!\u0002Z\"I\u00111]\u000f\u0002\u0002\u0013\u0005\u0015Q\u001d\u0005\n\u0003gl\u0012\u0011!C\u0005\u0003k\u0014\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u000b\u0005\u00152\u0013aC3yaJ,7o]5p]NT!a\n\u0015\u0002\u0011\r\fG/\u00197zgRT!!\u000b\u0016\u0002\u0007M\fHN\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001a7s}\u0002\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"aM\u001c\n\u0005a\"#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tB\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u001d[\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aR\u001e\u0002\t1,g\r^\u000b\u0002\u001bB\u00111GT\u0005\u0003\u001f\u0012\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u00191wN]7biV\t1\u000bE\u0002;)6K!!V\u001e\u0003\r=\u0003H/[8o\u0003\u001d1wN]7bi\u0002\n\u0001\u0002Z1uCRK\b/Z\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A\fK\u0001\u0006if\u0004Xm]\u0005\u0003=n\u0013\u0001\u0002R1uCRK\b/Z\u0001\nI\u0006$\u0018\rV=qK\u0002\nQa\u00195jY\u0012\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003eK\u001a<\u0007\u000e\u0005\u00024\u0001!)1*\u0003a\u0001\u001b\")\u0011+\u0003a\u0001'\")q+\u0003a\u00013\")\u0001-\u0003a\u0001\u001bR\u0019AM[6\t\u000b-S\u0001\u0019A'\t\u000bES\u0001\u0019A'\u0015\u0005\u0011l\u0007\"B&\f\u0001\u0004i\u0015!\u00044mCR\f%oZ;nK:$8/F\u0001q!\r\u0001\u0015o]\u0005\u0003e*\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003uQL!!^\u001e\u0003\u0007\u0005s\u00170A\u0007fqB\u00148OU3qY\u0006\u001cW\rZ\u000b\u0002qB\u0019\u0001)_'\n\u0005iT%aA*fc\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003u\u00042A`A\u0003\u001d\ry\u0018\u0011\u0001\t\u0003\u0005nJ1!a\u0001<\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111A\u001e\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r!\u0017q\u0002\u0005\u0007\u0003#y\u0001\u0019A'\u0002\u00119,wo\u00115jY\u0012\fAaY8qsRIA-a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\b\u0017B\u0001\n\u00111\u0001N\u0011\u001d\t\u0006\u0003%AA\u0002MCqa\u0016\t\u0011\u0002\u0003\u0007\u0011\fC\u0004a!A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0005\u0016\u0004\u001b\u0006\u00152FAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E2(\u0001\u0006b]:|G/\u0019;j_:LA!!\u000e\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\b\u0016\u0004'\u0006\u0015\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0003R3!WA\u0013\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\b\u00055\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA.!\rQ\u0014QL\u0005\u0004\u0003?Z$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA:\u0002f!I\u0011qM\f\u0002\u0002\u0003\u0007\u00111L\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0004#BA8\u0003k\u001aXBAA9\u0015\r\t\u0019hO\u0001\u000bG>dG.Z2uS>t\u0017b\u0001:\u0002r\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\u0005\u0005\u0005c\u0001\u001e\u0002~%\u0019\u0011qP\u001e\u0003\u000f\t{w\u000e\\3b]\"A\u0011qM\r\u0002\u0002\u0003\u00071/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA%\u0003\u000fC\u0011\"a\u001a\u001b\u0003\u0003\u0005\r!a\u0017\u0002\r\u0015\fX/\u00197t)\u0011\tY(!$\t\u0011\u0005\u001d4$!AA\u0002MDs\u0003AAI\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u000by+!-\u0011\u0007M\n\u0019*C\u0002\u0002\u0016\u0012\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001c\u0006\u0011IK\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007oX:uenc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G/[7fgR\fW\u000e]0tiJ\u0004\u0007%\u001a=qe\u0016\u001c8/[8oA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003MZ7uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t;pA\u0005\u0004C/[7fgR\fW\u000e\u001d\u0018!%\u0016$XO\u001d8tA9,H\u000e\u001c\u0011xSRD\u0007%\u001b8wC2LG\rI5oaV$h\u0006\t\"zA\u0011,g-Y;mi2\u0002\u0013\u000e\u001e\u0011g_2dwn^:!G\u0006\u001cH/\u001b8hAI,H.Z:!i>T\u0001\u0005\t\u0011!A\u0001\n\u0007\u0005^5nKN$\u0018-\u001c9!S\u001a\u0004C\u000f[3!A\u001alG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t\u0003\u0005\u00165fAI,7/\u001e7uA\u0011\fG/\u0019\u0011usB,\u0007%[:!G>t7/[:uK:$\be^5uQ\u0002\"\b.\u001a\u0011wC2,X\rI8g\u0015\u0001\u0002\u0003\u0005\t\u0011!G>tg-[4ve\u0006$\u0018n\u001c8!AN\u0004\u0018M]6/gFdg\u0006^5nKN$\u0018-\u001c9UsB,\u0007M\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003C\u000b!Q\b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z:uC6\u0004xl\u001d;sA5\u0002\u0013\tI:ue&tw\r\t;pA\t,\u0007\u0005]1sg\u0016$\u0007\u0005^8!i&lWm\u001d;b[Bt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005V5nKN$\u0018-\u001c9!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0Cz\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9+AA)\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[E\u0012TfM\u0019!aAR\u0014G\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004GO\u00193uA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T&\r\u001a.gE:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!\u0003\u00159'o\\;qC\t\ti+\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005M\u0016!\u0002\u001a/e9\u0002\u0014\u0001\u0005)beN,Gk\u001c+j[\u0016\u001cH/Y7q!\t\u0019TdE\u0003\u001e\u0003w\u000b9\rE\u0005\u0002>\u0006\rWjU-NI6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\\\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\fyLA\tBEN$(/Y2u\rVt7\r^5p]R\u0002B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\f\t&\u0001\u0002j_&\u0019\u0011*a3\u0015\u0005\u0005]\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0013!B1qa2LH#\u00033\u0002\\\u0006u\u0017q\\Aq\u0011\u0015Y\u0005\u00051\u0001N\u0011\u0015\t\u0006\u00051\u0001T\u0011\u00159\u0006\u00051\u0001Z\u0011\u0015\u0001\u0007\u00051\u0001N\u0003\u001d)h.\u00199qYf$B!a:\u0002pB!!\bVAu!\u001dQ\u00141^'T36K1!!<<\u0005\u0019!V\u000f\u001d7fi!A\u0011\u0011_\u0011\u0002\u0002\u0003\u0007A-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a>\u0011\t\u0005-\u0013\u0011`\u0005\u0005\u0003w\fiE\u0001\u0004PE*,7\r\u001e")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final DataType dataType;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Option<Expression>, DataType, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple4<Expression, Option<Expression>, DataType, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<DataType, Function1<Expression, ParseToTimestamp>>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public ParseToTimestamp withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        DataType x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, DataType dataType, Expression child) {
        return new ParseToTimestamp(left, format, dataType, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public DataType copy$default$3() {
        return this.dataType();
    }

    public Expression copy$default$4() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.dataType();
                break;
            }
            case 3: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "dataType";
                break;
            }
            case 3: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = parseToTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, DataType dataType, Expression child) {
        this.left = left;
        this.format = format;
        this.dataType = dataType;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), SQLConf$.MODULE$.get().timestampType(), new GetTimestamp(left, format, SQLConf$.MODULE$.get().timestampType(), GetTimestamp$.MODULE$.apply$default$4(), GetTimestamp$.MODULE$.apply$default$5()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().timestampType(), new Cast(left, SQLConf$.MODULE$.get().timestampType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }
}

