/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfCsv$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(csv[, options]) - Returns schema in the DDL format of CSV string.", examples="\n    Examples:\n      > SELECT _FUNC_('1,abc');\n       STRUCT<`_c0`: INT, `_c1`: STRING>\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001\u0002\u0011\"\u0001:B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005_\u0001\tE\t\u0015!\u0003T\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015y\u0006\u0001\"\u0001e\u0011\u0015y\u0006\u0001\"\u0001g\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015\t\b\u0001\"\u0011s\u0011!1\b\u0001#b\u0001\n\u00139\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!!\r\u0001\t#\n\u0019\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<!I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u00033\u0002\u0011\u0013!C\u0001\u00037B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t\u0019\tAA\u0001\n\u0003\n)\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003?\u0003\u0011\u0011!C!\u0003C;\u0011\"!2\"\u0003\u0003E\t!a2\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003\u0013Daa\u0018\u000e\u0005\u0002\u0005\u0005\b\"CAr5\u0005\u0005IQIAs\u0011%\t9OGA\u0001\n\u0003\u000bI\u000fC\u0005\u0002pj\t\t\u0011\"!\u0002r\"I!1\u0001\u000e\u0002\u0002\u0013%!Q\u0001\u0002\f'\u000eDW-\\1PM\u000e\u001bhO\u0003\u0002#G\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0015\u0001qfM\u001d@!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!t'D\u00016\u0015\t1\u0014%A\u0004d_\u0012,w-\u001a8\n\u0005a*$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\t\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001R\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA$<\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u001d[\u0014!B2iS2$W#A'\u0011\u0005Ar\u0015BA(\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u000f=\u0004H/[8ogV\t1\u000b\u0005\u0003U1n[fBA+W!\t\u00115(\u0003\u0002Xw\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\u00075\u000b\u0007O\u0003\u0002XwA\u0011A\u000bX\u0005\u0003;j\u0013aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\r\t'm\u0019\t\u0003a\u0001AQaS\u0003A\u00025CQ!U\u0003A\u0002M#\"!Y3\t\u000b-3\u0001\u0019A'\u0015\u0007\u0005<\u0007\u000eC\u0003L\u000f\u0001\u0007Q\nC\u0003R\u000f\u0001\u0007Q*\u0001\u0005eCR\fG+\u001f9f+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018&\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001XN\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,W#A:\u0011\u0005i\"\u0018BA;<\u0005\u001d\u0011un\u001c7fC:\f1aY:w+\u0005A\bCA=~\u001b\u0005Q(B\u00018|\u0015\tax%\u0001\u0004v]N\fg-Z\u0005\u0003}j\u0014!\"\u0016+GqM#(/\u001b8hQ\rQ\u0011\u0011\u0001\t\u0004u\u0005\r\u0011bAA\u0003w\tIAO]1og&,g\u000e^\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#\u0019\u0013\u0001C1oC2L8/[:\n\t\u0005U\u0011q\u0002\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006!QM^1m)\u0011\tY\"!\t\u0011\u0007i\ni\"C\u0002\u0002 m\u00121!\u00118z\u0011%\t\u0019\u0003\u0004I\u0001\u0002\u0004\t)#A\u0001w!\u0011\t9#!\u000b\u000e\u0003\rJ1!a\u000b$\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001\\\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019\u0011-!\u000e\t\r\u0005]b\u00021\u0001N\u0003!qWm^\"iS2$\u0017\u0001B2paf$R!YA\u001f\u0003\u007fAqaS\b\u0011\u0002\u0003\u0007Q\nC\u0004R\u001fA\u0005\t\u0019A*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\t\u0016\u0004\u001b\u0006\u001d3FAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M3(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0016\u0002N\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\f\u0016\u0004'\u0006\u001d\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014\u0001\u00027b]\u001eT!!!\u001c\u0002\t)\fg/Y\u0005\u0004;\u0006\u001d\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA;!\rQ\u0014qO\u0005\u0004\u0003sZ$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000e\u0003\u007fB\u0011\"!!\u0015\u0003\u0003\u0005\r!!\u001e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\t\u0005\u0004\u0002\n\u0006=\u00151D\u0007\u0003\u0003\u0017S1!!$<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\u000bYI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA:\u0002\u0018\"I\u0011\u0011\u0011\f\u0002\u0002\u0003\u0007\u00111D\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002d\u0005u\u0005\"CAA/\u0005\u0005\t\u0019AA;\u0003\u0019)\u0017/^1mgR\u00191/a)\t\u0013\u0005\u0005\u0005$!AA\u0002\u0005m\u0001f\u0005\u0001\u0002(\u00065\u0016qVAZ\u0003k\u000bI,a/\u0002@\u0006\u0005\u0007c\u0001\u0019\u0002*&\u0019\u00111V\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011W\u0001I?\u001a+fjQ0)GN48\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI:dQ\u0016l\u0017\rI5oAQDW\r\t#E\u0019\u00022wN]7bi\u0002zg\rI\"T-\u0002\u001aHO]5oO:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003o\u000b!L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(c1\n'mY\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001aFKU+D)r\u0002wl\u0019\u0019au\u0001Je\n\u0016\u0017!A~\u001b\u0017\u0007\u0019\u001e!'R\u0013\u0016JT$?\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA_\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\t\u0019-A\u0005dgZ|f-\u001e8dg\u0006Y1k\u00195f[\u0006|emQ:w!\t\u0001$dE\u0003\u001b\u0003\u0017\f9\u000eE\u0004\u0002N\u0006MWjU1\u000e\u0005\u0005='bAAiw\u00059!/\u001e8uS6,\u0017\u0002BAk\u0003\u001f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\tI.a8\u000e\u0005\u0005m'\u0002BAo\u0003W\n!![8\n\u0007%\u000bY\u000e\u0006\u0002\u0002H\u0006AAo\\*ue&tw\r\u0006\u0002\u0002d\u0005)\u0011\r\u001d9msR)\u0011-a;\u0002n\")1*\ba\u0001\u001b\")\u0011+\ba\u0001'\u00069QO\\1qa2LH\u0003BAz\u0003\u007f\u0004RAOA{\u0003sL1!a><\u0005\u0019y\u0005\u000f^5p]B)!(a?N'&\u0019\u0011Q`\u001e\u0003\rQ+\b\u000f\\33\u0011!\u0011\tAHA\u0001\u0002\u0004\t\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0001\t\u0005\u0003K\u0012I!\u0003\u0003\u0003\f\u0005\u001d$AB(cU\u0016\u001cG\u000f")
public class SchemaOfCsv
extends UnaryExpression
implements CodegenFallback,
Serializable {
    private transient UTF8String csv;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfCsv schemaOfCsv) {
        return SchemaOfCsv$.MODULE$.unapply(schemaOfCsv);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfCsv> tupled() {
        return SchemaOfCsv$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfCsv>> curried() {
        return SchemaOfCsv$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private UTF8String csv$lzycompute() {
        SchemaOfCsv schemaOfCsv = this;
        synchronized (schemaOfCsv) {
            if (!this.bitmap$trans$0) {
                this.csv = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = true;
            }
        }
        return this.csv;
    }

    private UTF8String csv() {
        return !this.bitmap$trans$0 ? this.csv$lzycompute() : this.csv;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.csv() != null ? super.checkInputDataTypes() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("The input csv should be a foldable string expression and not null; ").append(new StringBuilder(14).append("however, got ").append(this.child().sql()).append(".").toString()).toString());
    }

    @Override
    public Object eval(InternalRow v) {
        CSVOptions parsedOptions = new CSVOptions(this.options(), true, "UTC");
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        String[] row = parser.parseLine(this.csv().toString());
        Predef$.MODULE$.assert(row != null, (Function0 & Serializable)() -> "Parsed CSV record should not be null.");
        String[] header = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(2).append("_c").append(index).toString();
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
        CSVInferSchema inferSchema = new CSVInferSchema(parsedOptions);
        DataType[] fieldTypes = inferSchema.inferRowType(startType, row);
        StructType st = new StructType(inferSchema.toStructFields(fieldTypes, header));
        return UTF8String.fromString((String)st.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_csv";
    }

    @Override
    public SchemaOfCsv withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfCsv copy(Expression child, Map<String, String> options) {
        return new SchemaOfCsv(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfCsv";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfCsv;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfCsv schemaOfCsv = (SchemaOfCsv)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfCsv.canEqual(this)) return false;
        return true;
    }

    public SchemaOfCsv(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfCsv(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfCsv(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

