/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005]!A\u0001\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005R\u0001\tE\t\u0015!\u0003/\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015)\u0007\u0001\"\u0011g\u0011!Q\u0007\u0001#b\u0001\n\u0003Z\u0007\"B8\u0001\t\u0003Z\u0007\"\u00029\u0001\t#\n\bbB<\u0001\u0003\u0003%\t\u0001\u001f\u0005\bw\u0002\t\n\u0011\"\u0001}\u0011!\ty\u0001AI\u0001\n\u0003a\b\"CA\t\u0001\u0005\u0005I\u0011IA\n\u0011%\t)\u0003AA\u0001\n\u0003\t9\u0003C\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013q\b\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005e\u0003!!A\u0005B\u0005msaBACA!\u0005\u0011q\u0011\u0004\u0007?\u0001B\t!!#\t\rI;B\u0011AAN\u0011%\tij\u0006b\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002 ^\u0001\u000b\u0011BA\u000b\u0011\u001d\t\tk\u0006C\u0001\u0003GC\u0011\"!)\u0018\u0003\u0003%\t)a.\t\u0013\u0005uv#!A\u0005\u0002\u0006}\u0006\"CAi/\u0005\u0005I\u0011BAj\u00055\u0019Vm]:j_:<\u0016N\u001c3po*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0004\u0001]I*\u0004hO!\u0011\u0005=\u0002T\"\u0001\u0011\n\u0005E\u0002#AC#yaJ,7o]5p]B\u0011qfM\u0005\u0003i\u0001\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003_YJ!a\u000e\u0011\u0003\u0017UsWM^1mk\u0006\u0014G.\u001a\t\u0003_eJ!A\u000f\u0011\u0003!9{gnU)M\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005*s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019c\u0013A\u0002\u001fs_>$h(C\u0001?\u0013\tIU(A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'BA%>\u0003)!\u0018.\\3D_2,XN\\\u000b\u0002]\u0005YA/[7f\u0007>dW/\u001c8!\u0003-9\u0017\r\u001d#ve\u0006$\u0018n\u001c8\u0002\u0019\u001d\f\u0007\u000fR;sCRLwN\u001c\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003_\u0001AQ!T\u0003A\u00029BQ\u0001U\u0003A\u00029\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u00023B\u0019!I\u0017\u0018\n\u0005mc%aA*fc\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003y\u00032A\u0011.`!\t\u00017-D\u0001b\u0015\t\u0011G%A\u0003usB,7/\u0003\u0002eC\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tq\r\u0005\u0002aQ&\u0011\u0011.\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006A!/Z:pYZ,G-F\u0001m!\taT.\u0003\u0002o{\t9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGC\u0001\u0018s\u0011\u0015\u00198\u00021\u0001u\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007\t+h&\u0003\u0002w\u0019\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0004)fT\bbB'\r!\u0003\u0005\rA\f\u0005\b!2\u0001\n\u00111\u0001/\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012! \u0016\u0003]y\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nu\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0006\t\u0004y\u0005-\u0012bAA\u0017{\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111GA\u001d!\ra\u0014QG\u0005\u0004\u0003oi$aA!os\"I\u00111H\t\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0003CBA\"\u0003\u0013\n\u0019$\u0004\u0002\u0002F)\u0019\u0011qI\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0015#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001\\A)\u0011%\tYdEA\u0001\u0002\u0004\t\u0019$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u000b\u0003/B\u0011\"a\u000f\u0015\u0003\u0003\u0005\r!!\u000b\u0002\r\u0015\fX/\u00197t)\ra\u0017Q\f\u0005\n\u0003w)\u0012\u0011!a\u0001\u0003gAs\u0003AA1\u0003O\nI'!\u001c\u0002p\u0005M\u0014QOA=\u0003w\ny(!!\u0011\u0007=\n\u0019'C\u0002\u0002f\u0001\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002l\u0005\u0011)L\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3`G>dW/\u001c8-A\u001d\f\u0007o\u00183ve\u0006$\u0018n\u001c8*A5\u0002s)\u001a8fe\u0006$Xm\u001d\u0011tKN\u001c\u0018n\u001c8!o&tGm\\<!O&4XM\u001c\u0011bAQLW.Z:uC6\u0004\be\u001d9fG&4\u00170\u001b8hA\r|G.^7oA\u0005tG\rI4ba\u0002\"WO]1uS>tgF\u0003\u0011!A\u0001\u0002\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:ueV\u001cG/\u001e:fI6\u001aHO]3b[&tw-\f9s_\u001e\u0014\u0018-\\7j]\u001els-^5eK:BG/\u001c7$if\u0004Xm]\u0017pM6\"\u0018.\\3.o&tGm\\<tEy:C+\u001f9fg\u0002zg\r\t;j[\u0016\u0004s/\u001b8e_^\u001cx\u0005P\u0018b}\u0001Jg\u000eI*ueV\u001cG/\u001e:fI\u0002\u001aFO]3b[&tw\rI4vS\u0012,\u0007\u0005Z8dA\u0019|'\u000f\t3fi\u0006LG.\u001a3!Kb\u0004H.\u00198bi&|g\u000eI1oI\u0002*\u00070Y7qY\u0016\u001chF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002r\u0005!\tF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWmX2pYVlg\u000eI\u0017!)\",\u0007eY8mk6t\u0007e\u001c:!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007%^:fA\u0005\u001c\b\u0005\u001e5fAQLW.Z:uC6\u0004\bEZ8sA]Lg\u000eZ8xS:<\u0007EY=!i&lWM\f\u0011UQ\u0016\u0004C/[7fA\r|G.^7oA5,8\u000f\u001e\u0011cK\u0002zg\r\t+j[\u0016\u001cH/Y7q)f\u0004XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!O\u0006\u0004x\fZ;sCRLwN\u001c\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007\u0005^5nK>,H\u000fI8gAQDW\rI:fgNLwN\u001c\u0011sKB\u0014Xm]3oi\u0016$\u0007%Y:!E%tG/\u001a:wC2\u0004c/\u00197vK\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005K*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.Y&$XM]1mg:BG/\u001c7$S:$XM\u001d<bY6b\u0017\u000e^3sC2\u0014c(\u00138uKJ4\u0018\r\u001c\u0011MSR,'/\u00197=_\u0005t\u0004EZ8sA5|'/\u001a\u0011eKR\f\u0017\u000e\\:/S\u00012wN\u001d\u0011uQ\u0016\u0004c-\u001b=fI\u0002:\u0017\r\u001d\u0011ekJ\fG/[8oY\u0001z'O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI5tA\u0005\u0004\b\u000f\\5fI\u00022wN\u001d\u0011fC\u000eD\u0007%\u001b8qkR\u0004\u0013M\u001c3!KZ\fG.^1uK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004#%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XM\t\u0011g_J\u0004C\u000f[3!Ift\u0017-\\5dA\u001d\f\u0007\u000f\t3ve\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0014\u0001c\u000e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003e]3tg&|gnX<j]\u0012|wOL:uCJ$H\u0006I:fgNLwN\\0xS:$wn\u001e\u0018f]\u0012d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I0G+:\u001bu\f\u000b2-A\u001d*\u0004%\\5okR,7oJ\u0015!\u001fJ#UI\u0015\u0011C3\u0002\nG\u0006I:uCJ$8H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uAJ$h\r\u0019\ne)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00196uA\u0002\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002dG\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!g\u0016\u001c8/[8o?^Lg\u000eZ8x]M$\u0018M\u001d;-AM,7o]5p]~;\u0018N\u001c3po:*g\u000e\u001a\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJC\u0006\t\u0015(\u0003J:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ii\u001a\u0004gJ\u0015!\u0003N\u0003C/\u00192)C2\u0002#-\u000b\u0011H%>+\u0006\u000b\t2zA\u0005d\u0003e\u0018$V\u001d\u000e{\u0006F\u0019\u0017!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\rI\u001f!O\u0005\u000bt\u0005\t+I\u000b:\u0003s%\u000e\u0011nS:,H/Z:(A]CUI\u0014\u0011bAu\u0002s%\u0011\u001a(AQCUI\u0014\u0011(c\u0001j\u0017N\\;uK\u001e\u0002S\tT*FA\u001d\n\u0004\u0007I7j]V$Xm]\u0014!\u000b:#\u0015\u0006I(S\t\u0016\u0013\u0006EQ-!C2\u00023\u000f^1sinR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1si\u001a\u0004'\u0003\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014'\u000e\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!3\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\n$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aIR\u0004\u0007M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;gAJ\u0011G\u0003\u0011!\u0003\u00159'o\\;qC\t\ti(\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005\r\u0015!B\u001a/e9\u0002\u0014!D*fgNLwN\\,j]\u0012|w\u000f\u0005\u00020/M)q#a#\u0002\u0012B\u0019A(!$\n\u0007\u0005=UH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*!\u0011qSA\u000f\u0003\tIw.C\u0002L\u0003+#\"!a\"\u0002\r5\f'o[3s\u0003\u001di\u0017M]6fe\u0002\nQ!\u00199qYf$R\u0001VAS\u0003OCQ!T\u000eA\u00029Ba\u0001U\u000eA\u0002\u0005%\u0006\u0003BAV\u0003gsA!!,\u00020B\u0011A)P\u0005\u0004\u0003ck\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005U&bAAY{Q)A+!/\u0002<\")Q\n\ba\u0001]!)\u0001\u000b\ba\u0001]\u00059QO\\1qa2LH\u0003BAa\u0003\u001b\u0004R\u0001PAb\u0003\u000fL1!!2>\u0005\u0019y\u0005\u000f^5p]B)A(!3/]%\u0019\u00111Z\u001f\u0003\rQ+\b\u000f\\33\u0011!\ty-HA\u0001\u0002\u0004!\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u001b\t\u0005\u0003/\t9.\u0003\u0003\u0002Z\u0006e!AB(cU\u0016\u001cG\u000f")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow sessionWindow) {
        return SessionWindow$.MODULE$.unapply(sessionWindow);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.timeColumn(), this.gapDuration()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TimestampType$.MODULE$, AnyDataType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeColumn();
                break;
            }
            case 1: {
                object = this.gapDuration();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeColumn";
                break;
            }
            case 1: {
                string = "gapDuration";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
    }
}

