/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringDecode$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(bin, charset) - Decodes the first argument using the second argument character set.", examples="\n    Examples:\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011N\u0011\u0015Q\u0006\u0001\"\u0011N\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C)\u0003\u0007A\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\t\u0013\u0005U\u0001!%A\u0005\u0002\u0005]\u0001\"CA\u0017\u0001E\u0005I\u0011AA\f\u0011%\ty\u0003AA\u0001\n\u0003\n\t\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\tijHA\u0001\u0012\u0003\tyJ\u0002\u0005\u001f?\u0005\u0005\t\u0012AAQ\u0011\u0019!\u0006\u0004\"\u0001\u0002:\"I\u00111\u0018\r\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007fC\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u0019\u0003\u0003%\t)!3\t\u0013\u0005m\u0007$!A\u0005\n\u0005u'\u0001D*ue&tw\rR3d_\u0012,'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001i\u0013\u0007N\u001eB!\tqs&D\u0001 \u0013\t\u0001tD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003kar!A\f\u001c\n\u0005]z\u0012a\u00029bG.\fw-Z\u0005\u0003si\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u00028?A\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\"J\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002GW\u00051AH]8pizJ\u0011AP\u0005\u0003ouJ!AS&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005]j\u0014a\u00012j]V\ta\n\u0005\u0002/\u001f&\u0011\u0001k\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u00022j]\u0002\nqa\u00195beN,G/\u0001\u0005dQ\u0006\u00148/\u001a;!\u0003\u0019a\u0014N\\5u}Q\u0019ak\u0016-\u0011\u00059\u0002\u0001\"\u0002'\u0006\u0001\u0004q\u0005\"\u0002*\u0006\u0001\u0004q\u0015\u0001\u00027fMR\fQA]5hQR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mI\u0001\u0006if\u0004Xm]\u0005\u0003E~\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A3\u0011\u0007\t3W,\u0003\u0002h\u0017\n\u00191+Z9\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007)lw\u000e\u0005\u0002=W&\u0011A.\u0010\u0002\u0004\u0003:L\b\"\u00028\u000b\u0001\u0004Q\u0017AB5oaV$\u0018\u0007C\u0003q\u0015\u0001\u0007!.\u0001\u0004j]B,HOM\u0001\nI><UM\\\"pI\u0016$2a]=\u007f!\t!x/D\u0001v\u0015\t1x$A\u0004d_\u0012,w-\u001a8\n\u0005a,(\u0001C#yaJ\u001cu\u000eZ3\t\u000bi\\\u0001\u0019A>\u0002\u0007\r$\b\u0010\u0005\u0002uy&\u0011Q0\u001e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015y8\u00021\u0001t\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)a+!\u0002\u0002\n!1\u0011q\u0001\u0007A\u00029\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\f1\u0001\rAT\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u00151\u0016\u0011CA\n\u0011\u001daU\u0002%AA\u00029CqAU\u0007\u0011\u0002\u0003\u0007a*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e!f\u0001(\u0002\u001c-\u0012\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0002(u\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY#!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\tAA[1wC&!\u0011\u0011IA\u001c\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\t\t\u0004y\u0005%\u0013bAA&{\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.!\u0015\t\u0013\u0005M##!AA\u0002\u0005\u001d\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002ZA)\u00111LA1U6\u0011\u0011Q\f\u0006\u0004\u0003?j\u0014AC2pY2,7\r^5p]&!\u00111MA/\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0014q\u000e\t\u0004y\u0005-\u0014bAA7{\t9!i\\8mK\u0006t\u0007\u0002CA*)\u0005\u0005\t\u0019\u00016\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003g\t)\bC\u0005\u0002TU\t\t\u00111\u0001\u0002H\u00051Q-];bYN$B!!\u001b\u0002|!A\u00111\u000b\f\u0002\u0002\u0003\u0007!\u000eK\n\u0001\u0003\u007f\n))a\"\u0002\f\u00065\u0015\u0011SAJ\u0003/\u000bI\nE\u0002/\u0003\u0003K1!a! \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!#\u00025~3UKT\"`Q\tLg\u000e\f\u0011dQ\u0006\u00148/\u001a;*A5\u0002C)Z2pI\u0016\u001c\b\u0005\u001e5fA\u0019L'o\u001d;!CJ<W/\\3oi\u0002*8/\u001b8hAQDW\rI:fG>tG\rI1sOVlWM\u001c;!G\"\f'/Y2uKJ\u00043/\u001a;/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAH\u0003QS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u001a8d_\u0012,\u0007fJ1cG\u001eb\u0003eJ;uM6Bt%\u000b\u0017!OU$h-\f\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013MY2\u000bA\u0001\nQa]5oG\u0016\f#!!&\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005m\u0015\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&tw\rR3d_\u0012,\u0007C\u0001\u0018\u0019'\u0015A\u00121UAX!\u001d\t)+a+O\u001dZk!!a*\u000b\u0007\u0005%V(A\u0004sk:$\u0018.\\3\n\t\u00055\u0016q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAY\u0003ok!!a-\u000b\t\u0005U\u00161H\u0001\u0003S>L1ASAZ)\t\ty*\u0001\u0005u_N#(/\u001b8h)\t\t\u0019$A\u0003baBd\u0017\u0010F\u0003W\u0003\u0007\f)\rC\u0003M7\u0001\u0007a\nC\u0003S7\u0001\u0007a*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0017q\u001b\t\u0006y\u00055\u0017\u0011[\u0005\u0004\u0003\u001fl$AB(qi&|g\u000eE\u0003=\u0003'te*C\u0002\u0002Vv\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAm9\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002`B!\u0011QGAq\u0013\u0011\t\u0019/a\u000e\u0003\r=\u0013'.Z2u\u0001")
public class StringDecode
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression bin;
    private final Expression charset;

    public static Option<Tuple2<Expression, Expression>> unapply(StringDecode stringDecode) {
        return StringDecode$.MODULE$.unapply(stringDecode);
    }

    public static Function1<Tuple2<Expression, Expression>, StringDecode> tupled() {
        return StringDecode$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringDecode>> curried() {
        return StringDecode$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression bin() {
        return this.bin;
    }

    public Expression charset() {
        return this.charset;
    }

    @Override
    public Expression left() {
        return this.bin();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        String fromCharset = ((UTF8String)input2).toString();
        return UTF8String.fromString((String)new String((byte[])input1, fromCharset));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(bytes, charset) -> new StringBuilder(215).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(new String(").append((String)bytes).append(", ").append((String)charset).append(".toString()));\n        } catch (java.io.UnsupportedEncodingException e) {\n          org.apache.spark.unsafe.Platform.throwException(e);\n        }\n      ").toString());
    }

    @Override
    public StringDecode withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringDecode copy(Expression bin, Expression charset) {
        return new StringDecode(bin, charset);
    }

    public Expression copy$default$1() {
        return this.bin();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    @Override
    public String productPrefix() {
        return "StringDecode";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.bin();
                break;
            }
            case 1: {
                object = this.charset();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringDecode;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "bin";
                break;
            }
            case 1: {
                string = "charset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringDecode)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringDecode stringDecode = (StringDecode)x$1;
        Expression expression = this.bin();
        Expression expression2 = stringDecode.bin();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = stringDecode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringDecode.canEqual(this)) return false;
        return true;
    }

    public StringDecode(Expression bin, Expression charset) {
        this.bin = bin;
        this.charset = charset;
        ExpectsInputTypes.$init$(this);
    }
}

