/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000b\t\u0004A\u0011I2\t\u000b)\u0004A\u0011I6\t\u000b=\u0004A\u0011I*\t\u000bA\u0004A\u0011I*\t\u000bE\u0004A\u0011I*\t\u000bq\u0003A\u0011\u0001:\t\u000bY\u0004A\u0011I<\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\r\u0001\t#\n\u0019\u0004C\u0005\u0002B\u0001\t\t\u0011\"\u0001\u0002D!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u001a\u0001#\u0003%\t!!\u0014\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\u0019\tAA\u0001\n\u0003\t)\tC\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003O\u0003\u0011\u0011!C!\u0003SC\u0011\"!,\u0001\u0003\u0003%\t%a,\b\u0013\u0005eW%!A\t\u0002\u0005mg\u0001\u0003\u0013&\u0003\u0003E\t!!8\t\rqsB\u0011AA{\u0011%\t9PHA\u0001\n\u000b\nI\u0010C\u0005\u0002|z\t\t\u0011\"!\u0002~\"I!Q\u0001\u0010\u0002\u0002\u0013\u0005%q\u0001\u0005\n\u00053q\u0012\u0011!C\u0005\u00057\u00111b\u0015;sS:<7\u000b\u001d7ji*\u0011aeJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002)S\u0005A1-\u0019;bYf\u001cHO\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001g]R\u0014i\u0012\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002<}9\u0011A\u0007P\u0005\u0003{\u0015\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001f&!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001S(\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'2\u0003\u0019a$o\\8u}%\tA)\u0003\u0002>\u0007&\u0011\u0001+\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003{\r\u000b1a\u001d;s+\u0005!\u0006C\u0001\u001bV\u0013\t1VE\u0001\u0006FqB\u0014Xm]:j_:\fAa\u001d;sA\u0005)!/Z4fq\u00061!/Z4fq\u0002\nQ\u0001\\5nSR\fa\u0001\\5nSR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003_?\u0002\f\u0007C\u0001\u001b\u0001\u0011\u0015\u0011v\u00011\u0001U\u0011\u0015Av\u00011\u0001U\u0011\u0015Qv\u00011\u0001U\u0003!!\u0017\r^1UsB,W#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dL\u0013!\u0002;za\u0016\u001c\u0018BA5g\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tA\u000eE\u0002I[\u0012L!A\\)\u0003\u0007M+\u0017/A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000f\u001a\u000b\u0004=N,\b\"\u0002;\u000e\u0001\u0004!\u0016aA3ya\")\u0001,\u0004a\u0001)\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u0001p_?\u007f!\t\u0011\u00150\u0003\u0002{\u0007\n\u0019\u0011I\\=\t\u000bqt\u0001\u0019\u0001=\u0002\rM$(/\u001b8h\u0011\u0015Af\u00021\u0001y\u0011\u0015Qf\u00021\u0001y\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0004\u0005=\u0011\u0011\u0004\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0013\u0002\u000f\r|G-Z4f]&!\u0011QBA\u0004\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\t\u001f\u0001\u0007\u00111C\u0001\u0004GRD\b\u0003BA\u0003\u0003+IA!a\u0006\u0002\b\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u000e\u001f\u0001\u0007\u00111A\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t\t\u0003\u0005\u0003\u0002$\u0005-b\u0002BA\u0013\u0003O\u0001\"AS\"\n\u0007\u0005%2)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u0019\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dq\u0016QGA\u001d\u0003{Aa!a\u000e\u0012\u0001\u0004!\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005m\u0012\u00031\u0001U\u0003%qWm^*fG>tG\r\u0003\u0004\u0002@E\u0001\r\u0001V\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dq\u0016QIA$\u0003\u0013BqA\u0015\n\u0011\u0002\u0003\u0007A\u000bC\u0004Y%A\u0005\t\u0019\u0001+\t\u000fi\u0013\u0002\u0013!a\u0001)\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA(U\r!\u0016\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011QL\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0005!!.\u0019<b\u0013\u0011\ti#a\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0004c\u0001\"\u0002\u0000%\u0019\u0011\u0011Q\"\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007a\f9\tC\u0005\u0002\nb\t\t\u00111\u0001\u0002~\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a$\u0011\u000b\u0005E\u0015q\u0013=\u000e\u0005\u0005M%bAAK\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00151\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002 \u0006\u0015\u0006c\u0001\"\u0002\"&\u0019\u00111U\"\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\u0012\u000e\u0002\u0002\u0003\u0007\u00010\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA6\u0003WC\u0011\"!#\u001c\u0003\u0003\u0005\r!! \u0002\r\u0015\fX/\u00197t)\u0011\ty*!-\t\u0011\u0005%E$!AA\u0002aDs\u0003AA[\u0003w\u000bi,!1\u0002D\u0006\u001d\u0017\u0011ZAg\u0003\u001f\f\u0019.!6\u0011\u0007Q\n9,C\u0002\u0002:\u0016\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002@\u0006\tIa\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3yY\u0001b\u0017.\\5uS\u0001j\u0003e\u00159mSR\u001c\b\u0005Y:ue\u0002\u0004\u0013M]8v]\u0012\u0004snY2veJ,gnY3tAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t1sK\u001e,\u0007\u0010\u0019\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0011xSRD\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\nG\u000fI7pgR\u0004\u0003\r\\5nSR\u0004\u0017!C1sOVlWM\u001c;tC\t\t)-\u0001Ca\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007e\u001d9mSRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1LW.\u001b;![\u0001\ng\u000eI5oi\u0016<WM\u001d\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002\u001awN\u001c;s_2\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007\u0005^5nKN\u0004C\u000f[3!e\u0016<W\r\u001f\u0011jg\u0002\n\u0007\u000f\u001d7jK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!U\u0001b\u0017.\\5uAy\u0002\u0003G\u000f\u0011UQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017pJ:!Y\u0016tw\r\u001e5!o&dG\u000e\t8pi\u0002\u0012W\rI7pe\u0016\u0004C\u000f[1oA\u0001d\u0017.\\5uA2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;iK\u0002\u0012Xm];mi&tw\rI1se\u0006Lxe\u001d\u0011mCN$\b%\u001a8uef\u0004s/\u001b7mA\r|g\u000e^1j]\u0002\nG\u000e\u001c\u0011j]B,HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#-Z=p]\u0012\u0004C\u000f[3!Y\u0006\u001cH\u000fI7bi\u000eDW\r\u001a\u0011sK\u001e,\u0007P\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0003\u0005\\5nSR\u0004C(\u0010\u00111u\u0001\u0002'/Z4fq\u0002\u0004s/\u001b7mA\t,\u0007%\u00199qY&,G\rI1tA5\fg.\u001f\u0011uS6,7\u000fI1tAA|7o]5cY\u0016d\u0003%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017\u0010I2b]\u0002\u0012W\rI8gA\u0005t\u0017\u0010I:ju\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a3\u0002\u0005+Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012p]\u0016\u0014CF\t;x_\nb#\u0005\u001e5sK\u0016\u0014CF\t\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014-A5\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E=tWM\t\u0017#i^|'\u0005\f\u0012uQJ,WM\t\u0017#EuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\nzg.\u001a\u0012-EQ<xN\u0011;ie\u0016,7II/\u000bA\u0001\nQa]5oG\u0016\f#!!5\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005]\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018aC*ue&twm\u00159mSR\u0004\"\u0001\u000e\u0010\u0014\u000by\ty.a;\u0011\u0011\u0005\u0005\u0018q\u001d+U)zk!!a9\u000b\u0007\u0005\u00158)A\u0004sk:$\u0018.\\3\n\t\u0005%\u00181\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BAw\u0003gl!!a<\u000b\t\u0005E\u00181O\u0001\u0003S>L1\u0001UAx)\t\tY.\u0001\u0005u_N#(/\u001b8h)\t\tY'A\u0003baBd\u0017\u0010F\u0004_\u0003\u007f\u0014\tAa\u0001\t\u000bI\u000b\u0003\u0019\u0001+\t\u000ba\u000b\u0003\u0019\u0001+\t\u000bi\u000b\u0003\u0019\u0001+\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0002B\u000b!\u0015\u0011%1\u0002B\b\u0013\r\u0011ia\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\t\u0013\t\u0002\u0016+U\u0013\r\u0011\u0019b\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t]!%!AA\u0002y\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u0002\u0005\u0003\u0002n\t}\u0011\u0002\u0002B\u0011\u0003_\u0012aa\u00142kK\u000e$\b")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression regex;
    private final Expression limit;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.regex();
    }

    @Override
    public Expression third() {
        return this.limit();
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, regex, limit) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(19).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)regex).append(",").append((String)limit).append("));").toString())));
    }

    @Override
    public String prettyName() {
        return "split";
    }

    @Override
    public StringSplit withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.regex();
                break;
            }
            case 2: {
                object = this.limit();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "regex";
                break;
            }
            case 2: {
                string = "limit";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

