/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.StringTrimBoth$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(str, trimStr) - Remove the leading and trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(encode('    SparkSQL   ', 'utf-8'));\n       SparkSQL\n      > SELECT _FUNC_('SSparkSQLS', 'SL');\n       parkSQ\n      > SELECT _FUNC_(encode('SSparkSQLS', 'utf-8'), encode('SL', 'utf-8'));\n       parkSQ\n  ", since="3.2.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003Q\u0011!!\u0006A!f\u0001\n\u0003I\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000bY\u0003A\u0011A0\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011K=\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u00111\u0001\u0001\u0012\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003;A\u0011\"!\t\u0001#\u0003%\t!!\u0002\t\u0013\u0005\r\u0002!!A\u0005B\u0005\u0015\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\b\u0013\u0005M\u0015%!A\t\u0002\u0005Ue\u0001\u0003\u0011\"\u0003\u0003E\t!a&\t\rYSB\u0011AAX\u0011%\t\tLGA\u0001\n\u000b\n\u0019\fC\u0005\u00026j\t\t\u0011\"!\u00028\"I\u0011q\u0018\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u001fT\u0012\u0011!C\u0005\u0003#\u0014ab\u0015;sS:<GK]5n\u0005>$\bN\u0003\u0002#G\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0015\u0001qf\r\u001c=!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"!P#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002Eq\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0005(\u0001\u0004te\u000e\u001cFO]\u000b\u0002\u0015B\u0011\u0001gS\u0005\u0003\u0019\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u001d\u0019(oY*ue\u0002\nq\u0001\u001e:j[N#(/F\u0001Q!\r9\u0014KS\u0005\u0003%b\u0012aa\u00149uS>t\u0017\u0001\u0003;sS6\u001cFO\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q!\u0001,\u0017.\\!\t\u0001\u0004\u0001C\u0003I\u000f\u0001\u0007!\nC\u0003O\u000f\u0001\u0007\u0001\u000bC\u0003U\u000f\u0001\u0007!\nF\u0002Y;zCQ\u0001\u0013\u0005A\u0002)CQA\u0014\u0005A\u0002)#\"\u0001\u00171\t\u000b!K\u0001\u0019\u0001&\u0002\u001b\u0015D\bO]:SKBd\u0017mY3e+\u0005\u0019\u0007cA\u001fe\u0015&\u0011Qm\u0012\u0002\u0004'\u0016\f\u0018!\u00044mCR\f%oZ;nK:$8/F\u0001i!\ri\u0014n[\u0005\u0003U\u001e\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003o1L!!\u001c\u001d\u0003\u0007\u0005s\u00170\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u001d\t\u0003cVt!A]:\u0011\u0005}B\u0014B\u0001;9\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QD\u0014\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0002Yu\")10\u0004a\u0001\u0015\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#\u0002-\u007f\u007f\u0006\u0005\u0001b\u0002%\u000f!\u0003\u0005\rA\u0013\u0005\b\u001d:\u0001\n\u00111\u0001Q\u0011\u001d!f\u0002%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b)\u001a!*!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00069\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002 )\u001a\u0001+!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005!A.\u00198h\u0015\t\t\t$\u0001\u0003kCZ\f\u0017b\u0001<\u0002,\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\b\t\u0004o\u0005m\u0012bAA\u001fq\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191.a\u0011\t\u0013\u0005\u0015C#!AA\u0002\u0005e\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002LA)\u0011QJA*W6\u0011\u0011q\n\u0006\u0004\u0003#B\u0014AC2pY2,7\r^5p]&\u0019!.a\u0014\u0002\u0011\r\fg.R9vC2$B!!\u0017\u0002`A\u0019q'a\u0017\n\u0007\u0005u\u0003HA\u0004C_>dW-\u00198\t\u0011\u0005\u0015c#!AA\u0002-\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qEA3\u0011%\t)eFA\u0001\u0002\u0004\tI$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\nY\u0007\u0003\u0005\u0002Fa\t\t\u00111\u0001lQ]\u0001\u0011qNA;\u0003o\nY(! \u0002\u0002\u0006\r\u0015qQAE\u0003\u001b\u000by\tE\u00021\u0003cJ1!a\u001d\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001f\u0002\u0003CR\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t7fC\u0012Lgn\u001a\u0011b]\u0012\u0004CO]1jY&tw\rI:qC\u000e,\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\"(/[7TiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u0004\u0003\r\u001e:j[N#(\u000f\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ty(AA\u000f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"(/[7TiJ\u0004S\u0006\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\b\u0005^8!iJLW\u000e\f\u0011uQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011bAMLgn\u001a7fAM\u0004\u0018mY3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\u000b!Q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*gnY8eK\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003e\n\u0017!OU$h-\f\u001d(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u001b\u0006/\u0019:l'Fc5k\n\u0017!OMcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0015t7m\u001c3fQ\u001d\u001a6\u000b]1sWN\u000bFjU\u0014-A\u001d*HOZ\u00179O%b\u0003%\u001a8d_\u0012,\u0007fJ*MO1\u0002s%\u001e;g[a:\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\nQa]5oG\u0016\f#!a#\u0002\u000bMr#G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005E\u0015\u0001D:ue&twm\u00184v]\u000e\u001c\u0018AD*ue&tw\r\u0016:j[\n{G\u000f\u001b\t\u0003ai\u0019RAGAM\u0003K\u0003\u0002\"a'\u0002\"*\u0003&\nW\u0007\u0003\u0003;S1!a(9\u0003\u001d\u0011XO\u001c;j[\u0016LA!a)\u0002\u001e\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SSA!a+\u00020\u0005\u0011\u0011n\\\u0005\u0004\r\u0006%FCAAK\u0003!!xn\u0015;sS:<GCAA\u0014\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA\u0016\u0011XA^\u0003{CQ\u0001S\u000fA\u0002)CQAT\u000fA\u0002ACQ\u0001V\u000fA\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002D\u0006-\u0007\u0003B\u001cR\u0003\u000b\u0004baNAd\u0015BS\u0015bAAeq\t1A+\u001e9mKNB\u0001\"!4\u001f\u0003\u0003\u0005\r\u0001W\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAj!\u0011\tI#!6\n\t\u0005]\u00171\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimBoth
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(StringTrimBoth stringTrimBoth) {
        return StringTrimBoth$.MODULE$.unapply(stringTrimBoth);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, StringTrimBoth> tupled() {
        return StringTrimBoth$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, StringTrimBoth>>> curried() {
        return StringTrimBoth$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        StringTrimBoth stringTrimBoth = this;
        synchronized (stringTrimBoth) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.srcStr();
        return (Seq)Option$.MODULE$.option2Iterable(this.trimStr()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.srcStr(), this.trimStr()}));
    }

    @Override
    public String prettyName() {
        return "btrim";
    }

    @Override
    public StringTrimBoth withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public StringTrimBoth copy(Expression srcStr, Option<Expression> trimStr, Expression child) {
        return new StringTrimBoth(srcStr, trimStr, child);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "StringTrimBoth";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcStr();
                break;
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimBoth;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcStr";
                break;
            }
            case 1: {
                string = "trimStr";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimBoth)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimBoth stringTrimBoth = (StringTrimBoth)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimBoth.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimBoth.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = stringTrimBoth.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringTrimBoth.canEqual(this)) return false;
        return true;
    }

    public StringTrimBoth(Expression srcStr, Option<Expression> trimStr, Expression child) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public StringTrimBoth(Expression srcStr, Expression trimStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr), StringTrim$.MODULE$.apply(srcStr, trimStr));
    }

    public StringTrimBoth(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$, StringTrim$.MODULE$.apply(srcStr));
    }
}

