/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u0012%\u0001FB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003\u0011\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B*\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000b9\u0004A\u0011\t*\t\u000b=\u0004A\u0011\t*\t\u000bA\u0004A\u0011\t*\t\u000bE\u0004A\u0011\t:\t\u000bm\u0004A\u0011\t?\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u00111\u0006\u0001\u0005R\u00055\u0002\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u0011%\t)\u0005AI\u0001\n\u0003\t9\u0005C\u0005\u0002^\u0001\t\n\u0011\"\u0001\u0002H!I\u0011q\f\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\t\u0013\u0005u\u0004!!A\u0005\u0002\u0005}\u0004\"CAC\u0001\u0005\u0005I\u0011IAD\u0011%\t)\nAA\u0001\n\u0003\t9\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0011\u0002$\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011V\u0004\n\u0003\u001b$\u0013\u0011!E\u0001\u0003\u001f4\u0001b\t\u0013\u0002\u0002#\u0005\u0011\u0011\u001b\u0005\u00077v!\t!!;\t\u0013\u0005-X$!A\u0005F\u00055\b\"CAx;\u0005\u0005I\u0011QAy\u0011%\tI0HA\u0001\n\u0003\u000bY\u0010C\u0005\u0003\u000eu\t\t\u0011\"\u0003\u0003\u0010\tq1+\u001e2tiJLgnZ%oI\u0016D(BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0011d'\u000f!G!\t\u0019D'D\u0001%\u0013\t)DEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"aM\u001c\n\u0005a\"#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005ijdBA\u001a<\u0013\taD%A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003y\u0011\u0002\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002H\u001d:\u0011\u0001*\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017B\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005q\u0012\u0015BA(Q\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta$)A\u0004tiJ,\u0005\u0010\u001d:\u0016\u0003M\u0003\"a\r+\n\u0005U##AC#yaJ,7o]5p]\u0006A1\u000f\u001e:FqB\u0014\b%A\u0005eK2LW.\u0012=qe\u0006QA-\u001a7j[\u0016C\bO\u001d\u0011\u0002\u0013\r|WO\u001c;FqB\u0014\u0018AC2pk:$X\t\u001f9sA\u00051A(\u001b8jiz\"B!\u00180`AB\u00111\u0007\u0001\u0005\u0006#\u001e\u0001\ra\u0015\u0005\u0006/\u001e\u0001\ra\u0015\u0005\u00063\u001e\u0001\raU\u0001\tI\u0006$\u0018\rV=qKV\t1\r\u0005\u0002eO6\tQM\u0003\u0002gQ\u0005)A/\u001f9fg&\u0011\u0001.\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003-\u00042a\u00127d\u0013\ti\u0007KA\u0002TKF\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017A\u00039sKR$\u0018PT1nKV\t1\u000f\u0005\u0002uq:\u0011QO\u001e\t\u0003\u0013\nK!a\u001e\"\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003o\n\u000bAB\\;mYN\u000bg-Z#wC2$r!`A\u0001\u0003\u000b\tI\u0001\u0005\u0002B}&\u0011qP\u0011\u0002\u0004\u0003:L\bBBA\u0002\u001d\u0001\u0007Q0A\u0002tiJDa!a\u0002\u000f\u0001\u0004i\u0018!\u00023fY&l\u0007BBA\u0006\u001d\u0001\u0007Q0A\u0003d_VtG/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011CA\u000f\u0003O\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/!\u0013aB2pI\u0016<WM\\\u0005\u0005\u00037\t)B\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tyb\u0004a\u0001\u0003C\t1a\u0019;y!\u0011\t\u0019\"a\t\n\t\u0005\u0015\u0012Q\u0003\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIc\u0004a\u0001\u0003#\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB/\u00020\u0005M\u0012q\u0007\u0005\u0007\u0003c\u0001\u0002\u0019A*\u0002\u00119,wOR5sgRDa!!\u000e\u0011\u0001\u0004\u0019\u0016!\u00038foN+7m\u001c8e\u0011\u0019\tI\u0004\u0005a\u0001'\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB/\u0002@\u0005\u0005\u00131\t\u0005\b#F\u0001\n\u00111\u0001T\u0011\u001d9\u0016\u0003%AA\u0002MCq!W\t\u0011\u0002\u0003\u00071+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%#fA*\u0002L-\u0012\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003%)hn\u00195fG.,GMC\u0002\u0002X\t\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY&!\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!A.\u00198h\u0015\t\ty'\u0001\u0003kCZ\f\u0017bA=\u0002j\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u000f\t\u0004\u0003\u0006e\u0014bAA>\u0005\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q0!!\t\u0013\u0005\ru#!AA\u0002\u0005]\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\nB)\u00111RAI{6\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f\u0013\u0015AC2pY2,7\r^5p]&!\u00111SAG\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0015q\u0014\t\u0004\u0003\u0006m\u0015bAAO\u0005\n9!i\\8mK\u0006t\u0007\u0002CAB3\u0005\u0005\t\u0019A?\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003K\n)\u000bC\u0005\u0002\u0004j\t\t\u00111\u0001\u0002x\u00051Q-];bYN$B!!'\u0002,\"A\u00111Q\u000e\u0002\u0002\u0003\u0007Q\u0010K\n\u0001\u0003_\u000b),a.\u0002<\u0006u\u0016\u0011YAb\u0003\u000f\fI\rE\u00024\u0003cK1!a-%\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!/\u0002\u0007\u0013S\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t3fY&lG\u0006I2pk:$\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:vEN$(/\u001b8hA\u0019\u0014x.\u001c\u0011agR\u0014\b\r\t2fM>\u0014X\r\t1d_VtG\u000f\u0019\u0011pG\u000e,(O]3oG\u0016\u001c\be\u001c4!i\",\u0007\u0005Z3mS6LG/\u001a:!A\u0012,G.[7a])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y2pk:$\b\rI5tAA|7/\u001b;jm\u0016d\u0003%\u001a<fef$\b.\u001b8hAQ|\u0007\u0005\u001e5fA1,g\r\u001e\u0011pM\u0002\"\b.\u001a\u0011gS:\fG\u000e\t3fY&l\u0017\u000e^3sA!\u001aw.\u001e8uS:<\u0007E\u001a:p[\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t7fMRL\u0003%[:!e\u0016$XO\u001d8fI:\u0002\u0013J\u001a\u0011aG>,h\u000e\u001e1!SN\u0004c.Z4bi&4X\r\f\u0011fm\u0016\u0014\u0018\u0010\u001e5j]\u001e\u0004Co\u001c\u0011uQ\u0016\u0004#/[4ii\u0002zg\r\t;iK\u00022\u0017N\\1mA\u0011,G.[7ji\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0003fY8v]RLgn\u001a\u0011ge>l\u0007\u0005\u001e5fAILw\r\u001b;*A%\u001c\bE]3ukJtW\r\u001a\u0018!)\",\u0007EZ;oGRLwN\u001c\u0011tk\n\u001cHO]5oO~Kg\u000eZ3yAA,'OZ8s[N\u0004\u0013\rI2bg\u0016l3/\u001a8tSRLg/\u001a\u0011nCR\u001c\u0007N\u0003\u0011!A\u0001\u0002\u0003e\u001e5f]\u0002\u001aX-\u0019:dQ&tw\r\t4pe\u0002\u0002G-\u001a7j[\u0002t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a0\u0002)*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse^<x]\u0005\u0004\u0018m\u00195f]=\u0014xm\n\u0017!O9:C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001:xo\u001e\u0018ba\u0006\u001c\u0007.\u001a\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QY\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0017\fAb\u001d;sS:<wLZ;oGN\fabU;cgR\u0014\u0018N\\4J]\u0012,\u0007\u0010\u0005\u00024;M)Q$a5\u0002`BA\u0011Q[An'N\u001bV,\u0004\u0002\u0002X*\u0019\u0011\u0011\u001c\"\u0002\u000fI,h\u000e^5nK&!\u0011Q\\Al\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003C\f9/\u0004\u0002\u0002d*!\u0011Q]A7\u0003\tIw.C\u0002P\u0003G$\"!a4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fu\u000b\u00190!>\u0002x\")\u0011\u000b\ta\u0001'\")q\u000b\ta\u0001'\")\u0011\f\ta\u0001'\u00069QO\\1qa2LH\u0003BA\u007f\u0005\u0013\u0001R!QA\u0000\u0005\u0007I1A!\u0001C\u0005\u0019y\u0005\u000f^5p]B1\u0011I!\u0002T'NK1Aa\u0002C\u0005\u0019!V\u000f\u001d7fg!A!1B\u0011\u0002\u0002\u0003\u0007Q,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0005\u0011\t\u0005\u001d$1C\u0005\u0005\u0005+\tIG\u0001\u0004PE*,7\r\u001e")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Expression first() {
        return this.strExpr();
    }

    @Override
    public Expression second() {
        return this.delimExpr();
    }

    @Override
    public Expression third() {
        return this.countExpr();
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, delim, count) -> new StringBuilder(19).append((String)str).append(".subStringIndex(").append((String)delim).append(", ").append((String)count).append(")").toString());
    }

    @Override
    public SubstringIndex withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.strExpr();
                break;
            }
            case 1: {
                object = this.delimExpr();
                break;
            }
            case 2: {
                object = this.countExpr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "strExpr";
                break;
            }
            case 1: {
                string = "delimExpr";
                break;
            }
            case 2: {
                string = "countExpr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

