/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the negated value of `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       -1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015a\u0006\u0001\"\u0001b\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015\u0019\b\u0001\"\u0011u\u0011!i\b\u0001#b\u0001\n\u0013q\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003S\u0001A\u0011KA\u0016\u0011\u0019A\u0003\u0001\"\u0011\u00022!9\u00111\u0007\u0001\u0005R\u0005U\u0002\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u0011%\t\u0019\u0005AI\u0001\n\u0003\t)\u0005C\u0005\u0002\\\u0001\t\n\u0011\"\u0001\u0002^!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"! \u0001\u0003\u0003%\t!a \t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAK\u0001\u0005\u0005I\u0011AAL\u0011%\tY\nAA\u0001\n\u0003\ni\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0011\u0002$\u001eI\u0011qY\u0012\u0002\u0002#\u0005\u0011\u0011\u001a\u0004\tE\r\n\t\u0011#\u0001\u0002L\"1AL\u0007C\u0001\u0003GD\u0001b\u001d\u000e\u0002\u0002\u0013\u0015\u0013Q\u001d\u0005\n\u0003OT\u0012\u0011!CA\u0003SD\u0011\"a<\u001b#\u0003%\t!!\u0018\t\u0013\u0005E($!A\u0005\u0002\u0006M\b\"\u0003B\u00035E\u0005I\u0011AA/\u0011%\u00119AGA\u0001\n\u0013\u0011IA\u0001\u0006V]\u0006\u0014\u00180T5okNT!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0007\u0001E*\u0004hP#\u0011\u0005I\u001aT\"A\u0012\n\u0005Q\u001a#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I2\u0014BA\u001c$\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003sqr!A\r\u001e\n\u0005m\u001a\u0013a\u00029bG.\fw-Z\u0005\u0003{y\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002<GA\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n9\u0001K]8ek\u000e$\bC\u0001$N\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002K_\u00051AH]8pizJ\u0011AQ\u0005\u0003w\u0005K!AT(\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005m\n\u0015!B2iS2$W#\u0001*\u0011\u0005I\u001a\u0016B\u0001+$\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u00021B\u0011\u0001)W\u0005\u00035\u0006\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004=~\u0003\u0007C\u0001\u001a\u0001\u0011\u0015\u0001V\u00011\u0001S\u0011\u001d1V\u0001%AA\u0002a#\"A\u00182\t\u000bA3\u0001\u0019\u0001*\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001f!\r1e\r[\u0005\u0003O>\u00131aU3r!\tIG.D\u0001k\u0015\tYw%A\u0003usB,7/\u0003\u0002nU\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0001\u000f\u0005\u0002jc&\u0011!O\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006AAo\\*ue&tw\rF\u0001v!\t1(P\u0004\u0002xqB\u0011\u0001*Q\u0005\u0003s\u0006\u000ba\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u00110Q\u0001\b]VlWM]5d+\u0005y\b#\u0002$\u0002\u0002\u0005\u0015\u0011bAA\u0002\u001f\n9a*^7fe&\u001c\u0007c\u0001!\u0002\b%\u0019\u0011\u0011B!\u0003\u0007\u0005s\u00170A\u0005e_\u001e+gnQ8eKR1\u0011qBA\u000e\u0003K\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\u0019\u0013aB2pI\u0016<WM\\\u0005\u0005\u00033\t\u0019B\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tib\u0003a\u0001\u0003?\t1a\u0019;y!\u0011\t\t\"!\t\n\t\u0005\r\u00121\u0003\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t9c\u0003a\u0001\u0003\u001f\t!!\u001a<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005\u0015\u0011Q\u0006\u0005\b\u0003_a\u0001\u0019AA\u0003\u0003\u0015Ig\u000e];u+\u0005)\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002_\u0003oAa!!\u000f\u000f\u0001\u0004\u0011\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006=\u0006}\u0012\u0011\t\u0005\b!>\u0001\n\u00111\u0001S\u0011\u001d1v\u0002%AA\u0002a\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002H)\u001a!+!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002`)\u001a\u0001,!\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003_\nAA[1wC&\u001910!\u001b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0004c\u0001!\u0002z%\u0019\u00111P!\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u0011\u0011\u0011\u0005\n\u0003\u0007#\u0012\u0011!a\u0001\u0003o\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAE!\u0019\tY)!%\u0002\u00065\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f\u000b\u0015AC2pY2,7\r^5p]&!\u00111SAG\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007a\u000bI\nC\u0005\u0002\u0004Z\t\t\u00111\u0001\u0002\u0006\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)'a(\t\u0013\u0005\ru#!AA\u0002\u0005]\u0014AB3rk\u0006d7\u000fF\u0002Y\u0003KC\u0011\"a!\u0019\u0003\u0003\u0005\r!!\u0002)'\u0001\tI+a,\u00022\u0006U\u0016qWA^\u0003{\u000b\t-a1\u0011\u0007I\nY+C\u0002\u0002.\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00024\u0006\u0019tLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002rWmZ1uK\u0012\u0004c/\u00197vK\u0002zg\r\t1fqB\u0014\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011X\u00016\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011.c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002@\u0006)\u0011G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QY\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018AC+oCJLX*\u001b8vgB\u0011!GG\n\u00065\u00055\u0017\u0011\u001c\t\b\u0003\u001f\f)N\u0015-_\u001b\t\t\tNC\u0002\u0002T\u0006\u000bqA];oi&lW-\u0003\u0003\u0002X\u0006E'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u00111\\Aq\u001b\t\tiN\u0003\u0003\u0002`\u00065\u0014AA5p\u0013\rq\u0015Q\u001c\u000b\u0003\u0003\u0013$\"!!\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000by\u000bY/!<\t\u000bAk\u0002\u0019\u0001*\t\u000fYk\u0002\u0013!a\u00011\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U(\u0011\u0001\t\u0006\u0001\u0006]\u00181`\u0005\u0004\u0003s\f%AB(qi&|g\u000eE\u0003A\u0003{\u0014\u0006,C\u0002\u0002\u0000\u0006\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0002?\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0017\u0001B!a\u001a\u0003\u000e%!!qBA5\u0005\u0019y%M[3di\u0002")
public class UnaryMinus
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return UnaryMinus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnaryMinus unaryMinus) {
        return UnaryMinus$.MODULE$.unapply(unaryMinus);
    }

    public static boolean apply$default$2() {
        return UnaryMinus$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, UnaryMinus> tupled() {
        return UnaryMinus$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, UnaryMinus>> curried() {
        return UnaryMinus$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.NumericAndInterval()}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public String toString() {
        return new StringBuilder(1).append("-").append(this.child()).toString();
    }

    private Numeric<Object> numeric$lzycompute() {
        UnaryMinus unaryMinus = this;
        synchronized (unaryMinus) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(15).append((String)c).append(".unary_$minus()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                    String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                    String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                    String originValue = ctx.freshName("origin");
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n           |").append(javaType).append(" ").append(originValue).append(" = (").append(javaType).append(")(").append((String)eval).append(");\n           |if (").append(originValue).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n           |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append(originValue).append(");\n           |}\n           |").append(ev.value()).append(" = (").append(javaType).append(")(-(").append(originValue).append("));\n           ").toString()));
                });
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                        String mathClass = Math.class.getName();
                        return new StringBuilder(18).append(ev.value()).append(" = ").append(mathClass).append(".negateExact(").append((String)eval).append(");").toString();
                    });
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                        String originValue = ctx.freshName("origin");
                        return new StringBuilder(45).append("\n        ").append(CodeGenerator$.MODULE$.javaType(numericType)).append(" ").append(originValue).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(").append((String)eval).append(");\n        ").append(ev.value()).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(-(").append(originValue).append("));\n      ").toString();
                    });
                } else if (dataType instanceof CalendarIntervalType) {
                    String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName()), "$");
                    String method = this.failOnError() ? "negateExact" : "negate";
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(3).append(iu).append(".").append(method).append("(").append((String)c).append(")").toString());
                } else if (dataType instanceof AnsiIntervalType) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                        String mathClass = Math.class.getName();
                        return new StringBuilder(18).append(ev.value()).append(" = ").append(mathClass).append(".negateExact(").append((String)eval).append(");").toString();
                    });
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return exprCode;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input) {
        void var2_10;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negateExact((CalendarInterval)input);
                return var2_10;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negate((CalendarInterval)input);
            return var2_10;
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            Long l = BoxesRunTime.boxToLong((long)Math.negateExact(BoxesRunTime.unboxToLong((Object)input)));
            return var2_10;
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            Integer n = BoxesRunTime.boxToInteger((int)Math.negateExact(BoxesRunTime.unboxToInt((Object)input)));
            return var2_10;
        }
        Object object = this.numeric().negate(input);
        return var2_10;
    }

    @Override
    public String sql() {
        String string;
        block5: {
            String string2;
            block4: {
                string2 = (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "-");
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case 45: {
                        if ("-".equals(string2)) {
                            break;
                        }
                        break block4;
                    }
                    default: {
                        break block4;
                    }
                }
                string = new StringBuilder(4).append("(- ").append(this.child().sql()).append(")").toString();
                break block5;
            }
            string = new StringBuilder(2).append(string2).append("(").append(this.child().sql()).append(")").toString();
        }
        return string;
    }

    @Override
    public UnaryMinus withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public UnaryMinus copy(Expression child, boolean failOnError) {
        return new UnaryMinus(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnaryMinus";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnaryMinus;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnaryMinus)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnaryMinus unaryMinus = (UnaryMinus)x$1;
        if (this.failOnError() != unaryMinus.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unaryMinus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unaryMinus.canEqual(this)) return false;
        return true;
    }

    public UnaryMinus(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnaryMinus(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

