/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u0016-\u0001nB\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tC\u0002\u0011\t\u0012)A\u0005\u0015\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005h\u0001\tE\t\u0015!\u0003e\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015A\u0007\u0001\"\u0001n\u0011\u0015y\u0007\u0001\"\u0011d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007A\u0011\"!\u0005\u0001\u0005\u0004%)%a\u0005\t\u0011\u0005u\u0002\u0001)A\u0007\u0003+A!\"a\u0010\u0001\u0011\u000b\u0007I\u0011BA!\u0011)\ti\u0006\u0001EC\u0002\u0013%\u0011q\f\u0005\u000b\u0003O\u0002\u0001R1A\u0005\n\u0005}\u0003BCA5\u0001!\u0015\r\u0011\"\u0003\u0002l!Q\u00111\u000f\u0001\t\u0006\u0004%\t%!\u001e\t\u0015\u0005e\u0004\u0001#b\u0001\n\u0003\nY\b\u0003\u0006\u0002\u0000\u0001A)\u0019!C!\u0003wB!\"!!\u0001\u0011\u000b\u0007I\u0011IA>\u0011%\t\u0019\t\u0001EC\u0002\u0013\u0005\u0003\rC\u0004\u0002\u0006\u0002!\t&a\"\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OC\u0011\"!0\u0001#\u0003%\t!a0\t\u0013\u0005\r\u0007!!A\u0005B\u0005\u0015\u0007\"CAj\u0001\u0005\u0005I\u0011AAk\u0011%\ti\u000eAA\u0001\n\u0003\ty\u000eC\u0005\u0002f\u0002\t\t\u0011\"\u0011\u0002h\"I\u00111\u001f\u0001\u0002\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0003s\u0004\u0011\u0011!C!\u0003wD\u0011\"a@\u0001\u0003\u0003%\tE!\u0001\b\u0013\t\u0015B&!A\t\u0002\t\u001db\u0001C\u0016-\u0003\u0003E\tA!\u000b\t\r!\u001cC\u0011\u0001B\u001c\u0011%\u0011IdIA\u0001\n\u000b\u0012Y\u0004C\u0005\u0003>\r\n\t\u0011\"!\u0003@!I!QI\u0012\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0005\u000f\u001a\u0013\u0011!CA\u0005\u0013B\u0011Ba\u0017$#\u0003%\t!a0\t\u0013\tu3%!A\u0005\n\t}#aA*v[*\u0011QFL\u0001\nC\u001e<'/Z4bi\u0016T!a\f\u0019\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003cI\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\u0007\u0001q\u0002E)T*\u0011\u0005urT\"\u0001\u0017\n\u0005}b#\u0001\u0006#fG2\f'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002B\u00056\ta&\u0003\u0002D]\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002F\u0011*k\u0011A\u0012\u0006\u0003\u000fB\nQ\u0001\u001e:fKNL!!\u0013$\u0003\u0013Us\u0017M]=MS.,\u0007CA!L\u0013\taeF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002U9:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031j\na\u0001\u0010:p_Rt\u0014\"\u0001)\n\u0005m{\u0015a\u00029bG.\fw-Z\u0005\u0003;z\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aW(\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003)\u000baa\u00195jY\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012\u0001\u001a\t\u0003\u001d\u0016L!AZ(\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"2A[6m!\ti\u0004\u0001C\u0003`\u000b\u0001\u0007!\nC\u0004c\u000bA\u0005\t\u0019\u00013\u0015\u0005)t\u0007\"B0\u0007\u0001\u0004Q\u0015\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kJ\nQ\u0001^=qKNL!a\u001e;\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Q\bc\u0001+|{&\u0011AP\u0018\u0002\u0004'\u0016\f\bCA:\u007f\u0013\tyHO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0019\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u0004\u0002\n\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0007o_\u0012,\u0007+\u0019;uKJt7/\u0006\u0002\u0002\u0016A!Ak_A\f!\u0011\tI\"a\u000e\u000f\t\u0005m\u00111\u0007\b\u0005\u0003;\t\tD\u0004\u0003\u0002 \u0005=b\u0002BA\u0011\u0003[qA!a\t\u0002,9!\u0011QEA\u0015\u001d\r1\u0016qE\u0005\u0002s%\u0011q\u0007O\u0005\u0003kYJ!a\r\u001b\n\u0005E\u0012\u0014BA$1\u0013\r\t)DR\u0001\f)J,W\rU1ui\u0016\u0014h.\u0003\u0003\u0002:\u0005m\"a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T1!!\u000eG\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005Q!/Z:vYR$\u0016\u0010]3\u0016\u0005\u0005\r#cBA#\u0003\u0013j\u0015q\n\u0004\u0007\u0003\u000f\u0002\u0001!a\u0011\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007M\fY%C\u0002\u0002NQ\u0014!\"\u0011;p[&\u001cG+\u001f9f!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n!![8\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006L1!XA*\u0003\r\u0019X/\\\u000b\u0003\u0003C\u00022!QA2\u0013\r\t)G\f\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0004jg\u0016k\u0007\u000f^=\u0002\ti,'o\\\u000b\u0003\u0003[\u00022!QA8\u0013\r\t\tH\f\u0002\b\u0019&$XM]1m\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\t\t9\b\u0005\u0003Uw\u0006\u0005\u0014!D5oSRL\u0017\r\u001c,bYV,7/\u0006\u0002\u0002~A\u0019Ak\u001f&\u0002#U\u0004H-\u0019;f\u000bb\u0004(/Z:tS>t7/\u0001\tnKJ<W-\u0012=qe\u0016\u001c8/[8og\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019!.!#\t\r\u0005-e\u00031\u0001K\u0003!qWm^\"iS2$\u0017!\u00044mCR\f%oZ;nK:$8/\u0006\u0002\u0002\u0012B)A+a%\u0002\u0018&\u0019\u0011Q\u00130\u0003\u0011%#XM]1u_J\u00042ATAM\u0013\r\tYj\u0014\u0002\u0004\u0003:L\u0018\u0001B2paf$RA[AQ\u0003GCqa\u0018\r\u0011\u0002\u0003\u0007!\nC\u0004c1A\u0005\t\u0019\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0016\u0016\u0004\u0015\u0006-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]v*\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0019\u0016\u0004I\u0006-\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002HB!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006]\u0013\u0001\u00027b]\u001eLA!!5\u0002L\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a6\u0011\u00079\u000bI.C\u0002\u0002\\>\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a&\u0002b\"I\u00111]\u000f\u0002\u0002\u0003\u0007\u0011q[\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\bCBAv\u0003c\f9*\u0004\u0002\u0002n*\u0019\u0011q^(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0016\u00065\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0011\f9\u0010C\u0005\u0002d~\t\t\u00111\u0001\u0002\u0018\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9-!@\t\u0013\u0005\r\b%!AA\u0002\u0005]\u0017AB3rk\u0006d7\u000fF\u0002e\u0005\u0007A\u0011\"a9\"\u0003\u0003\u0005\r!a&)'\u0001\u00119A!\u0004\u0003\u0010\tM!Q\u0003B\r\u00057\u0011yB!\t\u0011\u0007\u0005\u0013I!C\u0002\u0003\f9\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0012\u0005\tuLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aX/\u001c\u0011dC2\u001cW\u000f\\1uK\u0012\u0004cM]8nAY\fG.^3tA=4\u0007%\u0019\u0011he>,\bOL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qC\u0001\u0002\u0000*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)k%b\u0003\u0005K\u00191S1\u0002\u0003&M\u001b*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!Q9+F\nT\u0015-A!\n\u0004'\u000b\u0017!QE*\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003EM\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u0015O+2c\u0015\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003\u001e\u0005I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005G\tQ!\r\u00181]A\n1aU;n!\ti4eE\u0003$\u0005W\ty\u0005E\u0004\u0003.\tM\"\n\u001a6\u000e\u0005\t=\"b\u0001B\u0019\u001f\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001b\u0005_\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u00119#\u0001\u0005u_N#(/\u001b8h)\t\t9-A\u0003baBd\u0017\u0010F\u0003k\u0005\u0003\u0012\u0019\u0005C\u0003`M\u0001\u0007!\nC\u0004cMA\u0005\t\u0019\u00013\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003L\t]\u0003#\u0002(\u0003N\tE\u0013b\u0001B(\u001f\n1q\n\u001d;j_:\u0004RA\u0014B*\u0015\u0012L1A!\u0016P\u0005\u0019!V\u000f\u001d7fe!A!\u0011\f\u0015\u0002\u0002\u0003\u0007!.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B1!\u0011\tIMa\u0019\n\t\t\u0015\u00141\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression> {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final boolean failOnError;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Sum sum) {
        return Sum$.MODULE$.unapply(sum);
    }

    public static boolean apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}))}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child().dataType(), "sum");
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    atomicType = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    atomicType = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    atomicType = dayTimeIntervalType;
                } else {
                    atomicType = DoubleType$.MODULE$;
                }
                this.resultType = atomicType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 2) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("isEmpty", x$2, false, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("isEmpty", x$2, false, x$4);
                this.isEmpty = new AttributeReference("isEmpty", x$2, false, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        return (this.bitmap$0 & 4) == 0 ? this.isEmpty$lzycompute() : this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default(this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        return (this.bitmap$0 & 8) == 0 ? this.zero$lzycompute() : this.zero;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = package$.MODULE$.Nil().$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                AtomicType atomicType = this.resultType();
                Seq seq = atomicType instanceof DecimalType ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{this.zero(), new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$)})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{new Literal(null, this.resultType())}));
                this.initialValues = seq;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Seq seq;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast(this.resultType()))) : package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$);
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{sumExpr, isEmptyExpr}));
                } else {
                    seq = this.child().nullable() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType())), this.sum()}))})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType()))}));
                }
                this.updateExpressions = seq;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Seq seq;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, this.resultType()), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.RichAttribute(this.sum()).left())).$plus(new KnownNotNull(this.RichAttribute(this.sum()).right()))), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))}));
                } else {
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()}))).$plus(this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()}))}));
                }
                this.mergeExpressions = seq;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x80) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, this.resultType()), new CheckOverflowInSum(this.sum(), decimalType, !this.failOnError()));
                } else {
                    expression = this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x100) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public Sum withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    public Sum copy(Expression child, boolean failOnError) {
        return new Sum(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        if (this.failOnError() != sum.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.SUM()}));
    }

    public Sum(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

