/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ", since="3.0.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u000e\u001d\u0001&B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")a\f\u0001C!?\")1\r\u0001C!I\")Q\u000e\u0001C!]\")q\u000e\u0001C!a\")a\u0010\u0001C)\u007f\"9\u00111\u0002\u0001\u0005R\u00055\u0001\"CA\n\u0001\u0005\u0005I\u0011AA\u000b\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0005\u00022\u0001\t\t\u0011\"\u0011\u00024!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA9\u0001\u0005\u0005I\u0011IA:\u0011%\t9\bAA\u0001\n\u0003\nIhB\u0005\u0002\u001er\t\t\u0011#\u0001\u0002 \u001aA1\u0004HA\u0001\u0012\u0003\t\t\u000b\u0003\u0004P+\u0011\u0005\u0011\u0011\u0018\u0005\tGV\t\t\u0011\"\u0012\u0002<\"I\u0011QX\u000b\u0002\u0002\u0013\u0005\u0015q\u0018\u0005\n\u0003\u0007,\u0012\u0011!CA\u0003\u000bD\u0011\"!5\u0016\u0003\u0003%I!a5\u0003\u0019\tKGo^5tK\u000e{WO\u001c;\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0016/car\u0004CA\u0016-\u001b\u0005a\u0012BA\u0017\u001d\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00160\u0013\t\u0001DDA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"AM\u001b\u000f\u0005-\u001a\u0014B\u0001\u001b\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011A\u0007\b\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\b!J|G-^2u!\tydI\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tK\u0001\u0007yI|w\u000e\u001e \n\u0003mJ!\u0001\u000e\u001e\n\u0005\u001dC%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001b;\u0003\u0015\u0019\u0007.\u001b7e+\u0005Y\u0005CA\u0016M\u0013\tiED\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002R%B\u00111\u0006\u0001\u0005\u0006\u0013\u000e\u0001\raS\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A+\u0011\u0007}2\u0006,\u0003\u0002X\u0011\n\u00191+Z9\u0011\u0005ecV\"\u0001.\u000b\u0005m\u0003\u0013!\u0002;za\u0016\u001c\u0018BA/[\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\u0001\u0007CA-b\u0013\t\u0011'L\u0001\u0005ECR\fG+\u001f9f\u0003!!xn\u0015;sS:<G#A3\u0011\u0005\u0019TgBA4i!\t\t%(\u0003\u0002ju\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI'(\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!Z\u0001\nI><UM\\\"pI\u0016$2!]<}!\t\u0011X/D\u0001t\u0015\t!H$A\u0004d_\u0012,w-\u001a8\n\u0005Y\u001c(\u0001C#yaJ\u001cu\u000eZ3\t\u000baD\u0001\u0019A=\u0002\u0007\r$\b\u0010\u0005\u0002su&\u00111p\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015i\b\u00021\u0001r\u0003\t)g/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA\u001d\u0002\u0004%\u0019\u0011Q\u0001\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\n%\u0001\r!!\u0001\u0002\u000b%t\u0007/\u001e;\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\t\u0016q\u0002\u0005\u0007\u0003#Q\u0001\u0019A&\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019\u0011+a\u0006\t\u000f%[\u0001\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000fU\rY\u0015qD\u0016\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0006\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0005\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!A.\u00198h\u0015\t\ty$\u0001\u0003kCZ\f\u0017bA6\u0002:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\t\t\u0004s\u0005%\u0013bAA&u\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011AA)\u0011%\t\u0019fDA\u0001\u0002\u0004\t9%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0002b!a\u0017\u0002b\u0005\u0005QBAA/\u0015\r\tyFO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011NA8!\rI\u00141N\u0005\u0004\u0003[R$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'\n\u0012\u0011!a\u0001\u0003\u0003\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QGA;\u0011%\t\u0019FEA\u0001\u0002\u0004\t9%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\nY\bC\u0005\u0002TM\t\t\u00111\u0001\u0002\u0002!\u001a\u0002!a \u0002\u0006\u0006\u001d\u00151RAG\u0003#\u000b\u0019*a&\u0002\u001aB\u00191&!!\n\u0007\u0005\rEDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0015!a\u0006`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t8v[\n,'\u000fI8gA\tLGo\u001d\u0011uQ\u0006$\b%\u0019:fAM,G\u000fI5oAQDW\rI1sOVlWM\u001c;!Kb\u0004(\u000fI1tA\u0005t\u0007%\u001e8tS\u001etW\r\u001a\u00117i5\u0012\u0017\u000e\u001e\u0011j]R,w-\u001a:-A=\u0014\bET+M\u0019\u0002Jg\r\t;iK\u0002\n'oZ;nK:$\b%[:!\u001dVcEJL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qR\u00015\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAK\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\tY*A\u0007cSR<\u0018n]3`MVt7m]\u0001\r\u0005&$x/[:f\u0007>,h\u000e\u001e\t\u0003WU\u0019R!FAR\u0003_\u0003b!!*\u0002,.\u000bVBAAT\u0015\r\tIKO\u0001\beVtG/[7f\u0013\u0011\ti+a*\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u00022\u0006]VBAAZ\u0015\u0011\t),!\u0010\u0002\u0005%|\u0017bA$\u00024R\u0011\u0011q\u0014\u000b\u0003\u0003k\tQ!\u00199qYf$2!UAa\u0011\u0015I\u0005\u00041\u0001L\u0003\u001d)h.\u00199qYf$B!a2\u0002NB!\u0011(!3L\u0013\r\tYM\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005=\u0017$!AA\u0002E\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u000e\u0005\u0003\u00028\u0005]\u0017\u0002BAm\u0003s\u0011aa\u00142kK\u000e$\b")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount x$0) {
        return BitwiseCount$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> g) {
        return BitwiseCount$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, BitwiseCount> compose(Function1<A$, Expression> g) {
        return BitwiseCount$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append("bit_count(").append(this.child()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "bit_count";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        ExprCode exprCode = BooleanType$.MODULE$.equals(dataType) ? this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(14).append("if (").append((String)c).append(") 1 else 0").toString()) : this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(25).append("java.lang.Long.bitCount(").append((String)c).append(")").toString());
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.unboxToBoolean((Object)input) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public BitwiseCount withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

