/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.PadExpressionBuilderBase;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the right with space characters if it is\n      a character string, and with zeros if it is a binary string.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n       hi\n      > SELECT hex(_FUNC_(unhex('aabb'), 5));\n       AABB000000\n      > SELECT hex(_FUNC_(unhex('aabb'), 5, unhex('1122')));\n       AABB112211\n  ", since="1.5.0", group="string_funcs")
public final class RPadExpressionBuilder$
implements PadExpressionBuilderBase {
    public static final RPadExpressionBuilder$ MODULE$ = new RPadExpressionBuilder$();

    static {
        PadExpressionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return PadExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Expression createStringPad(Expression str, Expression len, Expression pad) {
        return new StringRPad(str, len, pad);
    }

    private RPadExpressionBuilder$() {
    }
}

