/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000bq\u0003A\u0011\u00012\t\u000b\u0015\u0004A\u0011\t4\t\u000bA\u0004A\u0011I9\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ty\u0001\u0001C!\u0003#Aa!!\u0007\u0001\t\u0003\u001a\u0006BBA\u000e\u0001\u0011\u00053\u000b\u0003\u0004\u0002\u001e\u0001!\te\u0015\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0004\u0001C)\u0003kA\u0011\"a\u0011\u0001\u0003\u0003%\t!!\u0012\t\u0013\u00055\u0003!%A\u0005\u0002\u0005=\u0003\"CA3\u0001E\u0005I\u0011AA(\u0011%\t9\u0007AI\u0001\n\u0003\ty\u0005C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000fC\u0011\"!$\u0001\u0003\u0003%\t%a$\t\u0013\u0005u\u0005!!A\u0005\u0002\u0005}\u0005\"CAU\u0001\u0005\u0005I\u0011IAV\u0011%\ty\u000bAA\u0001\n\u0003\n\tlB\u0005\u0002\\\u0016\n\t\u0011#\u0001\u0002^\u001aAA%JA\u0001\u0012\u0003\ty\u000e\u0003\u0004]=\u0011\u0005\u0011q\u001f\u0005\n\u0003st\u0012\u0011!C#\u0003wD\u0011\"!@\u001f\u0003\u0003%\t)a@\t\u0013\t\u001da$!A\u0005\u0002\n%\u0001\"\u0003B\u000e=\u0005\u0005I\u0011\u0002B\u000f\u00055\u0019FO]5oOJ+\u0007\u000f\\1dK*\u0011aeJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002)S\u0005A1-\u0019;bYf\u001cHO\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001g]R\u0014i\u0012\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002<}9\u0011A\u0007P\u0005\u0003{\u0015\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001f&!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001S(\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'2\u0003\u0019a$o\\8u}%\tA)\u0003\u0002>\u0007&\u0011\u0001+\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003{\r\u000bqa\u001d:d\u000bb\u0004(/F\u0001U!\t!T+\u0003\u0002WK\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0011M\u00148-\u0012=qe\u0002\n!b]3be\u000eDW\t\u001f9s\u0003-\u0019X-\u0019:dQ\u0016C\bO\u001d\u0011\u0002\u0017I,\u0007\u000f\\1dK\u0016C\bO]\u0001\re\u0016\u0004H.Y2f\u000bb\u0004(\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\ty{\u0006-\u0019\t\u0003i\u0001AQAU\u0004A\u0002QCQ\u0001W\u0004A\u0002QCQAW\u0004A\u0002Q#2AX2e\u0011\u0015\u0011\u0006\u00021\u0001U\u0011\u0015A\u0006\u00021\u0001U\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u00119'\u000e\u001c8\u0011\u0005\tC\u0017BA5D\u0005\r\te.\u001f\u0005\u0006W&\u0001\raZ\u0001\bgJ\u001cWI^1m\u0011\u0015i\u0017\u00021\u0001h\u0003)\u0019X-\u0019:dQ\u00163\u0018\r\u001c\u0005\u0006_&\u0001\raZ\u0001\fe\u0016\u0004H.Y2f\u000bZ\fG.A\u0005e_\u001e+gnQ8eKR\u0019!\u000f_?\u0011\u0005M4X\"\u0001;\u000b\u0005U,\u0013aB2pI\u0016<WM\\\u0005\u0003oR\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006s*\u0001\rA_\u0001\u0004GRD\bCA:|\u0013\taHO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000byT\u0001\u0019\u0001:\u0002\u0005\u00154\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011&A\u0003usB,7/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u0014A)\u0001*!\u0006\u0002\u0004%\u0019\u0011qC)\u0003\u0007M+\u0017/A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000baJ,G\u000f^=OC6,WCAA\u0012!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0003\u0015\u000eK1!a\u000bD\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111F\"\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00020\u00028\u0005m\u0012q\b\u0005\u0007\u0003s\t\u0002\u0019\u0001+\u0002\u00119,wOR5sgRDa!!\u0010\u0012\u0001\u0004!\u0016!\u00038foN+7m\u001c8e\u0011\u0019\t\t%\u0005a\u0001)\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHc\u00020\u0002H\u0005%\u00131\n\u0005\b%J\u0001\n\u00111\u0001U\u0011\u001dA&\u0003%AA\u0002QCqA\u0017\n\u0011\u0002\u0003\u0007A+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E#f\u0001+\u0002T-\u0012\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003%)hn\u00195fG.,GMC\u0002\u0002`\r\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019'!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!A.\u00198h\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003c\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a \u0011\u0007\t\u000b\t)C\u0002\u0002\u0004\u000e\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aZAE\u0011%\tY\tGA\u0001\u0002\u0004\ty(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0003R!a%\u0002\u001a\u001el!!!&\u000b\u0007\u0005]5)\u0001\u0006d_2dWm\u0019;j_:LA!a'\u0002\u0016\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t+a*\u0011\u0007\t\u000b\u0019+C\u0002\u0002&\u000e\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\fj\t\t\u00111\u0001h\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u00055\u0014Q\u0016\u0005\n\u0003\u0017[\u0012\u0011!a\u0001\u0003\u007f\na!Z9vC2\u001cH\u0003BAQ\u0003gC\u0001\"a#\u001d\u0003\u0003\u0005\ra\u001a\u0015\u0018\u0001\u0005]\u0016QXA`\u0003\u0007\f)-!3\u0002L\u0006=\u0017\u0011[Ak\u0003/\u00042\u0001NA]\u0013\r\tY,\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t-A+`\rVs5i\u0018\u0015tiJd\u0003e]3be\u000eD7\f\f\u0011sKBd\u0017mY3^S\u0001j\u0003EU3qY\u0006\u001cWm\u001d\u0011bY2\u0004snY2veJ,gnY3tA=4\u0007\u0005Y:fCJ\u001c\u0007\u000e\u0019\u0011xSRD\u0007\u0005\u0019:fa2\f7-\u001a1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002H\u0006\u0011\tH\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u0006\u00148\r\u001b\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/A%3\u0007\u0005Y:fCJ\u001c\u0007\u000e\u0019\u0011jg\u0002rw\u000e\u001e\u0011g_VtG\rI5oA\u0001\u001cHO\u001d1-A\u0001\u001cHO\u001d1!SN\u0004#/\u001a;ve:,G\rI;oG\"\fgnZ3e])\u0001\u0003\u0005\t\u0011!A)\u0002#/\u001a9mC\u000e,\u0007%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\f\u0011JM\u0002\u0002'/\u001a9mC\u000e,\u0007\rI5tA9|G\u000fI:qK\u000eLg-[3eA=\u0014\b%[:!C:\u0004S-\u001c9us\u0002\u001aHO]5oO2\u0002cn\u001c;iS:<\u0007E]3qY\u0006\u001cWm\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011tiJLgn\u001a\u0011uQ\u0006$\b%[:!e\u0016lwN^3eA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002N\u0006q%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014B\u0005\u000e\u000b'mY\u0014-A\u001d\n'mY\u0014-A\u001d\"UIR\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n%i\u0011#F\r*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002T\u0006)!GL\u001a/a\u0005)qM]8va\u0006\u0012\u0011\u0011\\\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u000e'R\u0014\u0018N\\4SKBd\u0017mY3\u0011\u0005Qr2#\u0002\u0010\u0002b\u00065\b\u0003CAr\u0003S$F\u000b\u00160\u000e\u0005\u0005\u0015(bAAt\u0007\u00069!/\u001e8uS6,\u0017\u0002BAv\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\ty/!>\u000e\u0005\u0005E(\u0002BAz\u0003k\n!![8\n\u0007A\u000b\t\u0010\u0006\u0002\u0002^\u0006AAo\\*ue&tw\r\u0006\u0002\u0002n\u0005)\u0011\r\u001d9msR9aL!\u0001\u0003\u0004\t\u0015\u0001\"\u0002*\"\u0001\u0004!\u0006\"\u0002-\"\u0001\u0004!\u0006\"\u0002.\"\u0001\u0004!\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00119\u0002E\u0003C\u0005\u001b\u0011\t\"C\u0002\u0003\u0010\r\u0013aa\u00149uS>t\u0007C\u0002\"\u0003\u0014Q#F+C\u0002\u0003\u0016\r\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\rE\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003 A!\u0011q\u000eB\u0011\u0013\u0011\u0011\u0019#!\u001d\u0003\r=\u0013'.Z2u\u0001")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace x$0) {
        return StringReplace$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Expression first() {
        return this.srcExpr();
    }

    @Override
    public Expression second() {
        return this.searchExpr();
    }

    @Override
    public Expression third() {
        return this.replaceExpr();
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    @Override
    public StringReplace withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcExpr();
                break;
            }
            case 1: {
                object = this.searchExpr();
                break;
            }
            case 2: {
                object = this.replaceExpr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcExpr";
                break;
            }
            case 1: {
                string = "searchExpr";
                break;
            }
            case 2: {
                string = "replaceExpr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

