/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u0013'\u0001NB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000ba\u0003A\u0011A-\t\u000ba\u0003A\u0011\u00010\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bM\u0004A\u0011\t6\t\u000bQ\u0004A\u0011\t6\t\u0011U\u0004\u0001R1A\u0005\nYDQ! \u0001\u0005RyDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0012\u0001!\t&a\u0005\t\u0013\u0005u\u0001!!A\u0005\u0002\u0005}\u0001\"CA\u0014\u0001E\u0005I\u0011AA\u0015\u0011%\ty\u0004AI\u0001\n\u0003\tI\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"a\u0019\u0001\u0003\u0003%\t!!\u001a\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019\tC\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\u001eI\u0011Q\u0016\u0014\u0002\u0002#\u0005\u0011q\u0016\u0004\tK\u0019\n\t\u0011#\u0001\u00022\"1\u0001,\bC\u0001\u0003\u0013D\u0011\"a3\u001e\u0003\u0003%)%!4\t\u0013\u0005=W$!A\u0005\u0002\u0006E\u0007\"CAm;E\u0005I\u0011AA\"\u0011%\tY.HA\u0001\n\u0003\u000bi\u000eC\u0005\u0002lv\t\n\u0011\"\u0001\u0002D!I\u0011Q^\u000f\u0002\u0002\u0013%\u0011q\u001e\u0002\t'V\u0014GO]1di*\u0011q\u0005K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002*U\u0005A1-\u0019;bYf\u001cHO\u0003\u0002,Y\u0005\u00191/\u001d7\u000b\u00055r\u0013!B:qCJ\\'BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001iar\u0004CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005A\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7\r\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0004Qe>$Wo\u0019;\u0011\u0005}:eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019%'\u0001\u0004=e>|GOP\u0005\u0002w%\u0011aIO\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Gu\u0005!A.\u001a4u+\u0005a\u0005CA\u001bN\u0013\tqeE\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012\u0001\u0016\t\u0003sUK!A\u0016\u001e\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"BAW.];B\u0011Q\u0007\u0001\u0005\u0006\u0015\u001e\u0001\r\u0001\u0014\u0005\u0006!\u001e\u0001\r\u0001\u0014\u0005\b%\u001e\u0001\n\u00111\u0001U)\rQv\f\u0019\u0005\u0006\u0015\"\u0001\r\u0001\u0014\u0005\u0006!\"\u0001\r\u0001T\u0001\nS:\u0004X\u000f\u001e+za\u0016,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M*\nQ\u0001^=qKNL!\u0001[3\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017AB:z[\n|G.F\u0001l!\ta\u0007O\u0004\u0002n]B\u0011\u0011IO\u0005\u0003_j\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qNO\u0001\u000eI\u0016\u001c\u0017.\\1m\u001b\u0016$\bn\u001c3\u0002-\r\fG.\u001a8eCJLe\u000e^3sm\u0006dW*\u001a;i_\u0012\fqA\\;nKJL7-F\u0001x!\ry\u0004P_\u0005\u0003s&\u0013qAT;nKJL7\r\u0005\u0002:w&\u0011AP\u000f\u0002\u0004\u0003:L\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002>\u0000\u0003\u0007Aa!!\u0001\u000f\u0001\u0004Q\u0018AB5oaV$\u0018\u0007\u0003\u0004\u0002\u00069\u0001\rA_\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002\u001f\u0015D\u0018m\u0019;NCRDW*\u001a;i_\u0012,\"!a\u0003\u0011\te\nia[\u0005\u0004\u0003\u001fQ$AB(qi&|g.A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)!,!\u0006\u0002\u001a!1\u0011q\u0003\tA\u00021\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001cA\u0001\r\u0001T\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001dQ\u0016\u0011EA\u0012\u0003KAqAS\t\u0011\u0002\u0003\u0007A\nC\u0004Q#A\u0005\t\u0019\u0001'\t\u000fI\u000b\u0002\u0013!a\u0001)\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0016U\ra\u0015QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\b\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bR3\u0001VA\u0017\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0013\u0001\u00026bm\u0006L1!]A(\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0006E\u0002:\u0003?J1!!\u0019;\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rQ\u0018q\r\u0005\n\u0003S:\u0012\u0011!a\u0001\u0003;\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA8!\u0015\t\t(a\u001e{\u001b\t\t\u0019HC\u0002\u0002vi\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI(a\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004)\u0006}\u0004\u0002CA53\u0005\u0005\t\u0019\u0001>\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0017\n)\tC\u0005\u0002ji\t\t\u00111\u0001\u0002^\u00051Q-];bYN$2\u0001VAF\u0011!\tIgGA\u0001\u0002\u0004Q\bf\u0005\u0001\u0002\u0010\u0006U\u0015qSAN\u0003;\u000b\t+a)\u0002(\u0006%\u0006cA\u001b\u0002\u0012&\u0019\u00111\u0013\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011T\u0001.Kb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:2A6\u0002W\r\u001f9se\u0001t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005}\u0015!\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\n4H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!*\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0016AC7bi\"|f-\u001e8dg\u0006A1+\u001e2ue\u0006\u001cG\u000f\u0005\u00026;M)Q$a-\u0002@BA\u0011QWA^\u00192#&,\u0004\u0002\u00028*\u0019\u0011\u0011\u0018\u001e\u0002\u000fI,h\u000e^5nK&!\u0011QXA\\\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYA*\u0003\tIw.C\u0002I\u0003\u0007$\"!a,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fi\u000b\u0019.!6\u0002X\")!\n\ta\u0001\u0019\")\u0001\u000b\ta\u0001\u0019\"9!\u000b\tI\u0001\u0002\u0004!\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011q\\At!\u0015I\u0014QBAq!\u0019I\u00141\u001d'M)&\u0019\u0011Q\u001d\u001e\u0003\rQ+\b\u000f\\34\u0011!\tIOIA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!=\u0011\t\u00055\u00131_\u0005\u0005\u0003k\fyE\u0001\u0004PE*,7\r\u001e")
public class Subtract
extends BinaryArithmetic {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Subtract x$0) {
        return Subtract$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Subtract>>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public String calendarIntervalMethod() {
        return this.failOnError() ? "subtractExact" : "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        void var3_13;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
                return var3_13;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
            return var3_13;
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            Long l = BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2)));
            return var3_13;
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            Integer n = BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2)));
            return var3_13;
        }
        if (dataType2 instanceof IntegerType && this.failOnError()) {
            Integer n = BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2), this.queryContext()));
            return var3_13;
        }
        if (dataType2 instanceof LongType && this.failOnError()) {
            Long l = BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2), this.queryContext()));
            return var3_13;
        }
        Object object = this.numeric().minus(input1, input2);
        return var3_13;
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    @Override
    public Subtract withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Subtract copy(Expression left, Expression right, boolean failOnError) {
        return new Subtract(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        if (this.failOnError() != subtract.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

