/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u0011#\u0001>B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0012)A\u0005\u001d\")Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00013\")!\f\u0001C!7\")q\f\u0001C!A\"A1\r\u0001EC\u0002\u0013\u0005C\rC\u0003i\u0001\u0011\u0005C\rC\u0003j\u0001\u0011\u0005#\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u0005e\")A\u0010\u0001C){\"9\u0011Q\u0002\u0001\u0005R\u0005=\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\u0007\u0003\u0003\u0002A\u0011I-\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA%\u0001E\u0005I\u0011AA&\u0011%\t\t\u0007AA\u0001\n\u0003\n\u0019\u0007C\u0005\u0002v\u0001\t\t\u0011\"\u0001\u0002x!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007C\u0011\"!%\u0001\u0003\u0003%\t!a%\t\u0013\u0005]\u0005!!A\u0005B\u0005e\u0005\"CAO\u0001\u0005\u0005I\u0011IAP\u000f%\tIMIA\u0001\u0012\u0003\tYM\u0002\u0005\"E\u0005\u0005\t\u0012AAg\u0011\u0019)\u0016\u0004\"\u0001\u0002f\"I\u0011q]\r\u0002\u0002\u0013\u0015\u0013\u0011\u001e\u0005\n\u0003WL\u0012\u0011!CA\u0003[D\u0011\"!=\u001a#\u0003%\t!a\u0013\t\u0013\u0005M\u0018$!A\u0005\u0002\u0006U\b\"CA\u007f3E\u0005I\u0011AA&\u0011%\ty0GA\u0001\n\u0013\u0011\tA\u0001\u0003Vk&$'BA\u0012%\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00152\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Dg\u000e\u001eA!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c#\u0005!\u0019F/\u0019;fMVd\u0007CA\u00199\u0013\tI$E\u0001\rFqB\u0014Xm]:j_:<\u0016\u000e\u001e5SC:$w.\\*fK\u0012\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u0013:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b:\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005!c\u0014a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0013\u001f\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001O!\rYt*U\u0005\u0003!r\u0012aa\u00149uS>t\u0007CA\u001eS\u0013\t\u0019FH\u0001\u0003M_:<\u0017a\u0003:b]\u0012|WnU3fI\u0002\na\u0001P5oSRtDCA,Y!\t\t\u0004\u0001C\u0004M\u0007A\u0005\t\u0019\u0001(\u0015\u0003]\u000bab]3fI\u0016C\bO]3tg&|g.F\u0001]!\t\tT,\u0003\u0002_E\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003/\u0006DQA\u0019\u0004A\u0002E\u000bAa]3fI\u0006A!/Z:pYZ,G-F\u0001f!\tYd-\u0003\u0002hy\t9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001a\nQ\u0001^=qKNL!\u0001]7\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqB]1oI>lw)\u001a8fe\u0006$xN\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0012\nA!\u001e;jY&\u0011q\u000f\u001e\u0002\u0014%\u0006tGm\\7V+&#u)\u001a8fe\u0006$xN\u001d\u0015\u0003\u0015e\u0004\"a\u000f>\n\u0005md$!\u0003;sC:\u001c\u0018.\u001a8u\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\u0007y\f\u0019\u0001\u0005\u0002<\u007f&\u0019\u0011\u0011\u0001\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000bY\u0001\u0019AA\u0004\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042aOA\u0005\u0013\r\tY\u0001\u0010\u0002\u0004\u0013:$\u0018\u0001D3wC2Le\u000e^3s]\u0006dG\u0003BA\t\u0003/\u00012aOA\n\u0013\r\t)\u0002\u0010\u0002\u0004\u0003:L\bbBA\r\u0019\u0001\u0007\u00111D\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003;\ty\"D\u0001%\u0013\r\t\t\u0003\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011qEA\u001a\u0003{\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[\u0011\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003c\tYC\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)$\u0004a\u0001\u0003o\t1a\u0019;y!\u0011\tI#!\u000f\n\t\u0005m\u00121\u0006\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\ty$\u0004a\u0001\u0003O\t!!\u001a<\u0002\u0013\u0019\u0014Xm\u001d5D_BL\u0018\u0001B2paf$2aVA$\u0011\u001dau\u0002%AA\u00029\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002N)\u001aa*a\u0014,\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0017=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\n)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001\\1oO*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002t\u0005%$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\b\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\t\u0003{B\u0011\"a \u0014\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\t\u0005\u0004\u0002\b\u00065\u0015\u0011C\u0007\u0003\u0003\u0013S1!a#=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\u000bII\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA3\u0002\u0016\"I\u0011qP\u000b\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002f\u0005m\u0005\"CA@-\u0005\u0005\t\u0019AA\u0004\u0003\u0019)\u0017/^1mgR\u0019Q-!)\t\u0013\u0005}t#!AA\u0002\u0005E\u0001f\u0006\u0001\u0002&\u0006-\u0016QVAY\u0003g\u000b9,!/\u0002>\u0006}\u00161YAc!\r\t\u0014qU\u0005\u0004\u0003S\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003_\u000b\u00111A0G+:\u001bu\fK\u0015![\u0001\u0012V\r^;s]N\u0004\u0013M\u001c\u0011v]&4XM]:bY2L\b%\u001e8jcV,\u0007%\u001b3f]RLg-[3sA!*V+\u0013#*AM$(/\u001b8h]\u0001\"\u0006.\u001a\u0011wC2,X\rI5tAI,G/\u001e:oK\u0012\u0004\u0013m\u001d\u0011bA\r\fgn\u001c8jG\u0006d\u0007%V+J\t\u0002\u001ad'L2iCJ\f7\r^3sAM$(/\u001b8h]\u0005AQ\r_1na2,7/\t\u0002\u00026\u00061&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ2t\u0007M\u001cesIj\u0003G\r45[QB\u0014gN\u00179cE2T&\u0019\u001bdg\t\u00144'\u001a\u001c3mYR\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002<\u0006Q#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAa\u0003\u0015\u0011df\r\u00181\u0003\u00159'o\\;qC\t\t9-\u0001\u0006nSN\u001cwLZ;oGN\fA!V;jIB\u0011\u0011'G\n\u00063\u0005=\u00171\u001c\t\u0007\u0003#\f9NT,\u000e\u0005\u0005M'bAAky\u00059!/\u001e8uS6,\u0017\u0002BAm\u0003'\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\ti.a9\u000e\u0005\u0005}'\u0002BAq\u0003[\n!![8\n\u0007)\u000by\u000e\u0006\u0002\u0002L\u0006AAo\\*ue&tw\r\u0006\u0002\u0002f\u0005)\u0011\r\u001d9msR\u0019q+a<\t\u000f1c\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u0018\u0011 \t\u0004w=s\u0005\u0002CA~=\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0007\u0001B!a\u001a\u0003\u0006%!!qAA5\u0005\u0019y%M[3di\u0002")
public class Uuid
extends LeafExpression
implements Stateful,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid x$0) {
        return Uuid$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> g) {
        return Uuid$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Uuid> compose(Function1<A$, Option<Object>> g) {
        return Uuid$.MODULE$.compose(g);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState("org.apache.spark.sql.catalyst.util.RandomUUIDGenerator", x$2, x$5, true, false);
        ctx.addPartitionInitializationStatement(new StringBuilder(59).append(new StringBuilder(3).append(randomGen).append(" = ").toString()).append("new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(").append(new StringBuilder(20).append(this.randomSeed().get()).append("L + partitionIndex);").toString()).toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Uuid freshCopy() {
        return new Uuid(this.randomSeed());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.randomSeed();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "randomSeed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }
}

