/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005ug!\u0002\r\u001a\u0001u)\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000by\u0002A\u0011A \t\u000f\t\u0003!\u0019!C\u0005\u0007\"1q\u000b\u0001Q\u0001\n\u0011Cq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0011\u0007\u0001)A\u00055\")1\r\u0001C\u0005I\")!\u0010\u0001C\u0001w\"9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\u0002CA+\u0001\u0011\u00051$a\u0016\b\u000f\u0005\u0005\u0014\u0004#\u0001\u0002d\u00191\u0001$\u0007E\u0001\u0003KBaA\u0010\b\u0005\u0002\u0005E\u0004\"CA:\u001d\t\u0007I\u0011AA;\u0011!\tiH\u0004Q\u0001\n\u0005]\u0004bBAN\u001d\u0011\u0005\u0011Q\u0014\u0005\b\u0003_sA\u0011AAY\u0011\u001d\t\tM\u0004C\u0001\u0003\u0007D\u0001\"a3\u000fA\u0003%\u0011\u0011\u0016\u0005\b\u0003\u001btA\u0011AAh\u0011%\tINDA\u0001\n\u0013\tYNA\bKg>t\u0017J\u001c4feN\u001b\u0007.Z7b\u0015\tQ2$\u0001\u0003kg>t'B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sON\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\ticG\u0004\u0002/i9\u0011qfM\u0007\u0002a)\u0011\u0011GM\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\t\u0011&\u0003\u00026Q\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0004&A\u0004paRLwN\\:\u0011\u0005mbT\"A\r\n\u0005uJ\"a\u0003&T\u001f:{\u0005\u000f^5p]N\fa\u0001P5oSRtDC\u0001!B!\tY\u0004\u0001C\u0003:\u0005\u0001\u0007!(A\u0007eK\u000eLW.\u00197QCJ\u001cXM]\u000b\u0002\tB!q%R$P\u0013\t1\u0005FA\u0005Gk:\u001cG/[8ocA\u0011\u0001\n\u0014\b\u0003\u0013*\u0003\"a\f\u0015\n\u0005-C\u0013A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\u0015\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001B7bi\"T\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\nQ!)[4EK\u000eLW.\u00197\u0002\u001d\u0011,7-[7bYB\u000b'o]3sA\u0005\u0011B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s+\u0005Q\u0006CA._\u001b\u0005a&BA/\u001c\u0003\u0011)H/\u001b7\n\u0005}c&A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\f1\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0002\nQ\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'/\u0001\fuS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:!\u0003mA\u0017M\u001c3mK*\u001bxN\\#se>\u00148OQ=QCJ\u001cX-T8eKR!QM\\:v!\r9c\r[\u0005\u0003O\"\u0012aa\u00149uS>t\u0007CA5m\u001b\u0005Q'BA6\u001e\u0003\u0015!\u0018\u0010]3t\u0013\ti'N\u0001\u0006TiJ,8\r\u001e+za\u0016DQa\\\u0005A\u0002A\f\u0011\u0002]1sg\u0016lu\u000eZ3\u0011\u0005m\u000b\u0018B\u0001:]\u0005%\u0001\u0016M]:f\u001b>$W\rC\u0003u\u0013\u0001\u0007q)A\rd_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$\u0007\"\u0002<\n\u0001\u00049\u0018!A3\u0011\u00055B\u0018BA=9\u0005%!\u0006N]8xC\ndW-A\u0003j]\u001a,'/F\u0002}\u0003\u001b!B\u0001[?\u0002 !)!D\u0003a\u0001}B)q0!\u0002\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0012a\u0001:eI&!\u0011qAA\u0001\u0005\r\u0011F\t\u0012\t\u0005\u0003\u0017\ti\u0001\u0004\u0001\u0005\u000f\u0005=!B1\u0001\u0002\u0012\t\tA+\u0005\u0003\u0002\u0014\u0005e\u0001cA\u0014\u0002\u0016%\u0019\u0011q\u0003\u0015\u0003\u000f9{G\u000f[5oOB\u0019q%a\u0007\n\u0007\u0005u\u0001FA\u0002B]fDq!!\t\u000b\u0001\u0004\t\u0019#\u0001\u0007de\u0016\fG/\u001a)beN,'\u000fE\u0005(\u0003K\tI#!\u0003\u0002B%\u0019\u0011q\u0005\u0015\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA\u0016\u0003{i!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005G>\u0014XM\u0003\u0003\u00024\u0005U\u0012a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003o\tI$A\u0005gCN$XM\u001d=nY*\u0011\u00111H\u0001\u0004G>l\u0017\u0002BA \u0003[\u00111BS:p]\u001a\u000b7\r^8ssB!\u00111FA\"\u0013\u0011\t)%!\f\u0003\u0015)\u001bxN\u001c)beN,'/\u0001\u0006j]\u001a,'OR5fY\u0012$B!a\u0013\u0002RA\u0019\u0011.!\u0014\n\u0007\u0005=#N\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\t\u0019f\u0003a\u0001\u0003\u0003\na\u0001]1sg\u0016\u0014\u0018\u0001E2b]>t\u0017nY1mSj,G+\u001f9f)\u0019\tI&a\u0017\u0002`A!qEZA&\u0011\u001d\ti\u0006\u0004a\u0001\u0003\u0017\n1\u0001\u001e9f\u0011\u0015ID\u00021\u0001;\u0003=Q5o\u001c8J]\u001a,'oU2iK6\f\u0007CA\u001e\u000f'\u0011qa%a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001cT\u0003\tIw.C\u00028\u0003W\"\"!a\u0019\u0002+M$(/^2u\r&,G\u000eZ\"p[B\f'/\u0019;peV\u0011\u0011q\u000f\n\u0007\u0003s\ny(a#\u0007\r\u0005m\u0014\u0003AA<\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003Y\u0019HO];di\u001aKW\r\u001c3D_6\u0004\u0018M]1u_J\u0004\u0003\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u00155+\u0001\u0003mC:<\u0017\u0002BAE\u0003\u0007\u0013aa\u00142kK\u000e$\bCBAG\u0003#\u000b)*\u0004\u0002\u0002\u0010*\u0011QlU\u0005\u0005\u0003'\u000byI\u0001\u0006D_6\u0004\u0018M]1u_J\u00042![AL\u0013\r\tIJ\u001b\u0002\f'R\u0014Xo\u0019;GS\u0016dG-\u0001\u0005jgN{'\u000f^3e)\u0011\ty*!*\u0011\u0007\u001d\n\t+C\u0002\u0002$\"\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002(J\u0001\r!!+\u0002\u0007\u0005\u0014(\u000fE\u0003(\u0003W\u000b)*C\u0002\u0002.\"\u0012Q!\u0011:sCf\f\u0001c^5uQ\u000e{'O];qi\u001aKW\r\u001c3\u0015\u0013!\f\u0019,a.\u0002<\u0006}\u0006BBA['\u0001\u0007\u0001.\u0001\u0004tiJ,8\r\u001e\u0005\b\u0003s\u001b\u0002\u0019AA&\u0003\u0015yG\u000f[3s\u0011\u0019\til\u0005a\u0001\u000f\u0006Q2m\u001c7v[:t\u0015-\\3PM\u000e{'O];qiJ+7m\u001c:eg\")qn\u0005a\u0001a\u0006\u00112m\\7qCRL'\r\\3S_>$H+\u001f9f)\u0019\t)-a2\u0002JBIq%!\n\u0002L\u0005-\u00131\n\u0005\u0007\u0003{#\u0002\u0019A$\t\u000b=$\u0002\u0019\u00019\u0002+\u0015l\u0007\u000f^=TiJ,8\r\u001e$jK2$\u0017I\u001d:bs\u0006q1m\\7qCRL'\r\\3UsB,GCBA&\u0003#\f)\u000eC\u0004\u0002TZ\u0001\r!a\u0013\u0002\u0005Q\f\u0004bBAl-\u0001\u0007\u00111J\u0001\u0003iJ\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a ")
public class JsonInferSchema
implements Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;

    public static DataType compatibleType(DataType t1, DataType t2) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode);
    }

    public static StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(struct, other, columnNameOfCorruptRecords, parseMode);
    }

    public static boolean isSorted(StructField[] arr) {
        return JsonInferSchema$.MODULE$.isSorted(arr);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        None$ none$;
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            none$ = new Some((Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})))));
        } else if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            none$ = None$.MODULE$;
        } else {
            if (FailFastMode$.MODULE$.equals(parseMode2)) {
                throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e);
            }
            throw new MatchError((Object)parseMode2);
        }
        return none$;
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable)row -> {
                Option<StructType> option;
                try {
                    option = (Option<StructType>)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                    return option;
                }
                catch (Throwable throwable) {
                    Option<StructType> option2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
                    if (bl) {
                        option2 = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2);
                    } else {
                        if (!(throwable2 instanceof CharConversionException)) throw throwable;
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if (!$this.options.encoding().isEmpty()) throw throwable;
                        String msg = new StringBuilder(0).append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |"))).append(charConversionException.getMessage()).toString();
                        CharConversionException wrappedCharException = new CharConversionException(msg);
                        wrappedCharException.initCause(charConversionException);
                        option2 = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException);
                    }
                    option = option2;
                }
                return option;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType inferField(JsonParser parser) {
        void var2_16;
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        boolean bl2 = jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2);
        if (bl2) {
            NullType$ nullType$ = NullType$.MODULE$;
            return var2_16;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            DataType dataType = this.inferField(parser);
            return var2_16;
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                NullType$ nullType$ = NullType$.MODULE$;
                return var2_16;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            StringType$ stringType$ = this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined() ? (DataType)this.decimalTry$1(decimalTry$lzy, field).get() : (this.options.inferTimestamp() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined() ? SQLConf$.MODULE$.get().timestampType() : (this.options.inferTimestamp() && this.timestampFormatter().parseOptional(field).isDefined() ? TimestampType$.MODULE$ : StringType$.MODULE$));
            return var2_16;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (true) {
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                    StructField[] fields = (StructField[])builder.result();
                    Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
                    StructType structType = new StructType(fields);
                    return var2_16;
                }
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ nullType$ = NullType$.MODULE$;
            while (true) {
                void var20_22;
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                    ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)var20_22);
                    return var2_16;
                }
                DataType dataType = JsonInferSchema$.MODULE$.compatibleType((DataType)var20_22, this.inferField(parser));
            }
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl3 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (bl4 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl5) {
            void var4_33;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                LongType$ longType$ = LongType$.MODULE$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && this.options.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    }
                }
            }
            void var2_14 = var4_33;
            return var2_16;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (!bl10) throw QueryExecutionErrors$.MODULE$.malformedJSONError();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return var2_16;
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy((DataType)t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields())), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class))))) ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        return decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
    }
}

