/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayAggregate$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.QuaternaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(expr, start, merge, finish) - Applies a binary operator to an initial state and all\n      elements in the array, and reduces this to a single state. The final state is converted\n      into the final result by applying a finish function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 0, (acc, x) -> acc + x);\n       6\n      > SELECT _FUNC_(array(1, 2, 3), 0, (acc, x) -> acc + x, acc -> acc * 10);\n       60\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5e\u0001B\u00193\u0001~B\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u0001\"A\u0001\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005j\u0001\tE\t\u0015!\u0003A\u0011!Q\u0007A!f\u0001\n\u00031\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u00111\u0004!Q3A\u0005\u0002\u0019D\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006I\u0001\u0011\u0005\u0006]\u0002!\ta\u001c\u0005\u0006]\u0002!\t!\u001e\u0005\u0006s\u0002!\tE\u001f\u0005\u0006}\u0002!\te \u0005\u0007\u0003\u001f\u0001A\u0011\t>\t\r\u0005E\u0001\u0001\"\u0011\u0000\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!a\u00111\u000b\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0002V!Q\u0011q\f\u0001\t\u0006\u0004%\t!!\u0019\t\u0015\u0005-\u0004\u0001#b\u0001\n\u0003\t\t\u0007\u0003\u0006\u0002p\u0001A)\u0019!C\u0001\u0003CBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\n\u0002!\t%a#\t\r\u0005u\u0005\u0001\"\u0011g\u0011\u0019\ty\n\u0001C!M\"1\u0011\u0011\u0015\u0001\u0005B\u0019Da!a)\u0001\t\u00032\u0007bBAS\u0001\u0011E\u0013q\u0015\u0005\n\u0003c\u0003\u0011\u0011!C\u0001\u0003gC\u0011\"!0\u0001#\u0003%\t!a0\t\u0013\u0005U\u0007!%A\u0005\u0002\u0005}\u0006\"CAl\u0001E\u0005I\u0011AA`\u0011%\tI\u000eAI\u0001\n\u0003\ty\fC\u0005\u0002\\\u0002\t\t\u0011\"\u0011\u0002^\"I\u0011Q\u001e\u0001\u0002\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003o\u0004\u0011\u0011!C\u0001\u0003sD\u0011\"a@\u0001\u0003\u0003%\tE!\u0001\t\u0013\t=\u0001!!A\u0005\u0002\tE\u0001\"\u0003B\u000b\u0001\u0005\u0005I\u0011\tB\f\u0011%\u0011Y\u0002AA\u0001\n\u0003\u0012ibB\u0005\u0003BI\n\t\u0011#\u0001\u0003D\u0019A\u0011GMA\u0001\u0012\u0003\u0011)\u0005\u0003\u0004oW\u0011\u0005!Q\f\u0005\n\u0005?Z\u0013\u0011!C#\u0005CB\u0011Ba\u0019,\u0003\u0003%\tI!\u001a\t\u0013\t=4&!A\u0005\u0002\nE\u0004\"\u0003BBW\u0005\u0005I\u0011\u0002BC\u00059\t%O]1z\u0003\u001e<'/Z4bi\u0016T!a\r\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003kY\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003oa\n1a]9m\u0015\tI$(A\u0003ta\u0006\u00148N\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<7\u0001A\n\b\u0001\u0001#u)T*Z!\t\t%)D\u00013\u0013\t\u0019%G\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!Q#\n\u0005\u0019\u0013$a\u0005%jO\",'o\u0014:eKJ4UO\\2uS>t\u0007C\u0001%L\u001b\u0005I%B\u0001&3\u0003\u001d\u0019w\u000eZ3hK:L!\u0001T%\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u00042AT)A\u001b\u0005y%B\u0001)5\u0003\u0015!(/Z3t\u0013\t\u0011vJ\u0001\bRk\u0006$XM\u001d8befd\u0015n[3\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\u000fA\u0013x\u000eZ;diB\u0011!L\u0019\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018 \u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016BA1V\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0005,\u0016\u0001C1sOVlWM\u001c;\u0016\u0003\u0001\u000b\u0011\"\u0019:hk6,g\u000e\u001e\u0011\u0002\ti,'o\\\u0001\u0006u\u0016\u0014x\u000eI\u0001\u0006[\u0016\u0014x-Z\u0001\u0007[\u0016\u0014x-\u001a\u0011\u0002\r\u0019Lg.[:i\u0003\u001d1\u0017N\\5tQ\u0002\na\u0001P5oSRtD#\u00029reN$\bCA!\u0001\u0011\u0015)\u0017\u00021\u0001A\u0011\u0015A\u0017\u00021\u0001A\u0011\u0015Q\u0017\u00021\u0001A\u0011\u0015a\u0017\u00021\u0001A)\u0011\u0001ho\u001e=\t\u000b\u0015T\u0001\u0019\u0001!\t\u000b!T\u0001\u0019\u0001!\t\u000b)T\u0001\u0019\u0001!\u0002\u0013\u0005\u0014x-^7f]R\u001cX#A>\u0011\u0007ic\b)\u0003\u0002~I\n\u00191+Z9\u0002\u001b\u0005\u0014x-^7f]R$\u0016\u0010]3t+\t\t\t\u0001\u0005\u0003[y\u0006\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%a'A\u0003usB,7/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003%1WO\\2uS>t7/A\u0007gk:\u001cG/[8o)f\u0004Xm]\u0001\t]VdG.\u00192mKV\u0011\u0011q\u0003\t\u0004)\u0006e\u0011bAA\u000e+\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0003\u0003GIA!!\n\u0002\b\tAA)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022Q\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003k\tyCA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0011\u0011\u0017N\u001c3\u0015\u0007A\fY\u0004C\u0004\u0002>I\u0001\r!a\u0010\u0002\u0003\u0019\u0004\u0002\u0002VA!\u0001\u0006\u0015\u0013QJ\u0005\u0004\u0003\u0007*&!\u0003$v]\u000e$\u0018n\u001c83!\u0011QF0a\u0012\u0011\u000fQ\u000bI%!\t\u0002\u0018%\u0019\u00111J+\u0003\rQ+\b\u000f\\33!\r\t\u0015qJ\u0005\u0004\u0003#\u0012$A\u0004'b[\n$\u0017MR;oGRLwN\\\u0001\u0005q\u0012\u0012\u0014'\u0006\u0002\u0002XA9A+!\u0013\u0002Z\u0005e\u0003cA!\u0002\\%\u0019\u0011Q\f\u001a\u0003'9\u000bW.\u001a3MC6\u0014G-\u0019,be&\f'\r\\3\u0002\u001d\u0005\u001c7MR8s\u001b\u0016\u0014x-\u001a,beV\u0011\u0011\u0011\f\u0015\u0004)\u0005\u0015\u0004c\u0001+\u0002h%\u0019\u0011\u0011N+\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AC3mK6,g\u000e\u001e,be\"\u001aQ#!\u001a\u0002\u001f\u0005\u001c7MR8s\r&t\u0017n\u001d5WCJD3AFA3\u0003\u0011)g/\u00197\u0015\t\u0005]\u0014Q\u0010\t\u0004)\u0006e\u0014bAA>+\n\u0019\u0011I\\=\t\u0013\u0005}t\u0003%AA\u0002\u0005\u0005\u0015!B5oaV$\b\u0003BAB\u0003\u000bk\u0011\u0001N\u0005\u0004\u0003\u000f#$aC%oi\u0016\u0014h.\u00197S_^\f!\u0002\u001d:fiRLh*Y7f+\t\ti\t\u0005\u0003\u0002\u0010\u0006]e\u0002BAI\u0003'\u0003\"\u0001X+\n\u0007\u0005UU+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\u000bYJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003++\u0016!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0004g_V\u0014H\u000f[\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\u0012\u0002]AU\u0003W\u000bi+a,\t\r\u0005uU\u00041\u0001A\u0011\u0019\ty*\ba\u0001\u0001\"1\u0011\u0011U\u000fA\u0002\u0001Ca!a)\u001e\u0001\u0004\u0001\u0015\u0001B2paf$\u0012\u0002]A[\u0003o\u000bI,a/\t\u000f\u0015t\u0002\u0013!a\u0001\u0001\"9\u0001N\bI\u0001\u0002\u0004\u0001\u0005b\u00026\u001f!\u0003\u0005\r\u0001\u0011\u0005\bYz\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!1+\u0007\u0001\u000b\u0019m\u000b\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!C;oG\",7m[3e\u0015\r\ty-V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAj\u0003\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t1\fgn\u001a\u0006\u0003\u0003S\fAA[1wC&!\u0011\u0011TAr\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0010E\u0002U\u0003gL1!!>V\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9(a?\t\u0013\u0005uX%!AA\u0002\u0005E\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0004A1!Q\u0001B\u0006\u0003oj!Aa\u0002\u000b\u0007\t%Q+\u0001\u0006d_2dWm\u0019;j_:LAA!\u0004\u0003\b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9Ba\u0005\t\u0013\u0005ux%!AA\u0002\u0005]\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a8\u0003\u001a!I\u0011Q \u0015\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]!q\u0004\u0005\n\u0003{L\u0013\u0011!a\u0001\u0003oB3\u0003\u0001B\u0012\u0005S\u0011YCa\f\u00032\tU\"q\u0007B\u001e\u0005{\u00012!\u0011B\u0013\u0013\r\u00119C\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i#AA\u0000\u0015\u0001\u0002\u0003\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011ti\u0006\u0014H\u000f\f\u0011nKJ<W\r\f\u0011gS:L7\u000f[\u0015![\u0001\n\u0005\u000f\u001d7jKN\u0004\u0013\r\t2j]\u0006\u0014\u0018\u0010I8qKJ\fGo\u001c:!i>\u0004\u0013M\u001c\u0011j]&$\u0018.\u00197!gR\fG/\u001a\u0011b]\u0012\u0004\u0013\r\u001c7\u000bA\u0001\u0002\u0003\u0005\t\u0011fY\u0016lWM\u001c;tA%t\u0007\u0005\u001e5fA\u0005\u0014(/Y=-A\u0005tG\r\t:fIV\u001cWm\u001d\u0011uQ&\u001c\b\u0005^8!C\u0002\u001a\u0018N\\4mK\u0002\u001aH/\u0019;f]\u0001\"\u0006.\u001a\u0011gS:\fG\u000eI:uCR,\u0007%[:!G>tg/\u001a:uK\u0012T\u0001\u0005\t\u0011!A\u0001Jg\u000e^8!i\",\u0007EZ5oC2\u0004#/Z:vYR\u0004#-\u001f\u0011baBd\u00170\u001b8hA\u0005\u0004c-\u001b8jg\"\u0004c-\u001e8di&|gN\f\u0006!A\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tM\u0012!a\u001a\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114S1\u0002\u0003\u0007\f\u0011)C\u000e\u001cG\u0006\t=*A5r\u0004%Y2dA-\u0002\u00030K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!m)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006\t\u0019-A!\n7m\u0019\u0017!q&\u0002SF\u0010\u0011bG\u000e\u00043\u0006\t=-A\u0005\u001c7\rI\u0017?A\u0005\u001c7\r\t\u0016!cAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001c1\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u001d\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u00159'o\\;qC\t\u0011y$\u0001\u0007mC6\u0014G-Y0gk:\u001c7/\u0001\bBeJ\f\u00170Q4he\u0016<\u0017\r^3\u0011\u0005\u0005[3#B\u0016\u0003H\tM\u0003#\u0003B%\u0005\u001f\u0002\u0005\t\u0011!q\u001b\t\u0011YEC\u0002\u0003NU\u000bqA];oi&lW-\u0003\u0003\u0003R\t-#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!Q\u000bB.\u001b\t\u00119F\u0003\u0003\u0003Z\u0005\u001d\u0018AA5p\u0013\r\u0019'q\u000b\u000b\u0003\u0005\u0007\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\fQ!\u00199qYf$\u0012\u0002\u001dB4\u0005S\u0012YG!\u001c\t\u000b\u0015t\u0003\u0019\u0001!\t\u000b!t\u0003\u0019\u0001!\t\u000b)t\u0003\u0019\u0001!\t\u000b1t\u0003\u0019\u0001!\u0002\u000fUt\u0017\r\u001d9msR!!1\u000fB@!\u0015!&Q\u000fB=\u0013\r\u00119(\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fQ\u0013Y\b\u0011!A\u0001&\u0019!QP+\u0003\rQ+\b\u000f\\35\u0011!\u0011\tiLA\u0001\u0002\u0004\u0001\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0011\t\u0005\u0003C\u0014I)\u0003\u0003\u0003\f\u0006\r(AB(cU\u0016\u001cG\u000f")
public class ArrayAggregate
extends Expression
implements HigherOrderFunction,
CodegenFallback,
QuaternaryLike<Expression>,
Serializable {
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21;
    private transient NamedLambdaVariable accForMergeVar;
    private transient NamedLambdaVariable elementVar;
    private transient NamedLambdaVariable accForFinishVar;
    private final Expression argument;
    private final Expression zero;
    private final Expression merge;
    private final Expression finish;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(ArrayAggregate x$0) {
        return ArrayAggregate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, ArrayAggregate> tupled() {
        return ArrayAggregate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, ArrayAggregate>>>> curried() {
        return ArrayAggregate$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return QuaternaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return QuaternaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = QuaternaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression argument() {
        return this.argument;
    }

    public Expression zero() {
        return this.zero;
    }

    public Expression merge() {
        return this.merge;
    }

    public Expression finish() {
        return this.finish;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.argument();
        Expression expression2 = this.zero();
        return package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        ArrayType$ arrayType$ = ArrayType$.MODULE$;
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)anyDataType$).$colon$colon((Object)arrayType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.merge();
        Expression expression2 = this.finish();
        return package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        DataType dataType = this.zero().dataType();
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)anyDataType$).$colon$colon((Object)dataType);
    }

    @Override
    public boolean nullable() {
        return this.argument().nullable() || this.finish().nullable();
    }

    @Override
    public DataType dataType() {
        return this.finish().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = this.checkArgumentDataTypes();
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? (!DataType$.MODULE$.equalsStructurally(this.zero().dataType(), this.merge().dataType(), true) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(27).append("argument 3 requires ").append(this.zero().dataType().simpleString()).append(" type, ").toString()).append(new StringBuilder(24).append("however, '").append(this.merge().sql()).append("' is of ").append(this.merge().dataType().catalogString()).append(" type.").toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$) : typeCheckResult;
        return typeCheckResult2;
    }

    @Override
    public ArrayAggregate bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Tuple2 acc;
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = acc = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.zero().dataType()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction newMerge = (LambdaFunction)f.apply((Object)this.merge(), (Object)package$.MODULE$.Nil().$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Tuple2 tuple25 = acc;
        LambdaFunction newFinish = (LambdaFunction)f.apply((Object)this.finish(), (Object)package$.MODULE$.Nil().$colon$colon((Object)tuple25));
        LambdaFunction x$1 = newMerge;
        LambdaFunction x$2 = newFinish;
        Expression x$3 = this.copy$default$1();
        Expression x$4 = this.copy$default$2();
        return this.copy(x$3, x$4, x$1, x$2);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21$lzycompute() {
        block5: {
            ArrayAggregate arrayAggregate = this;
            synchronized (arrayAggregate) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression elementVar;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.merge();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) break block6;
                        NamedExpression accForMergeVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        elementVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (!(accForMergeVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)accForMergeVar;
                        if (elementVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)elementVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$21 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$21;
    }

    private /* synthetic */ Tuple2 x$21() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$21$lzycompute() : this.x$21;
    }

    private NamedLambdaVariable accForMergeVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.accForMergeVar = (NamedLambdaVariable)this.x$21()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.accForMergeVar;
    }

    public NamedLambdaVariable accForMergeVar() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.accForMergeVar$lzycompute() : this.accForMergeVar;
    }

    private NamedLambdaVariable elementVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementVar = (NamedLambdaVariable)this.x$21()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementVar;
    }

    public NamedLambdaVariable elementVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementVar$lzycompute() : this.elementVar;
    }

    private NamedLambdaVariable accForFinishVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression accForFinishVar;
                SeqOps seqOps;
                LambdaFunction lambdaFunction;
                Seq<NamedExpression> seq;
                Expression expression = this.finish();
                if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0 || !((accForFinishVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof NamedLambdaVariable)) {
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = namedLambdaVariable = (NamedLambdaVariable)accForFinishVar;
                this.accForFinishVar = namedLambdaVariable2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.accForFinishVar;
    }

    public NamedLambdaVariable accForFinishVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.accForFinishVar$lzycompute() : this.accForFinishVar;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        ArrayData arr = (ArrayData)this.argument().eval(input);
        if (arr == null) {
            object = null;
        } else {
            SeqOps seqOps;
            Seq<Expression> seq = this.functionsForEval();
            if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
                throw new MatchError(seq);
            }
            Expression mergeForEval = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Expression finishForEval = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Tuple2 tuple2 = new Tuple2((Object)mergeForEval, (Object)finishForEval);
            Tuple2 tuple22 = tuple2;
            Expression mergeForEval2 = (Expression)tuple22._1();
            Expression finishForEval2 = (Expression)tuple22._2();
            this.accForMergeVar().value().set(this.zero().eval(input));
            for (int i = 0; i < arr.numElements(); ++i) {
                this.elementVar().value().set(arr.get(i, this.elementVar().dataType()));
                this.accForMergeVar().value().set(InternalRow$.MODULE$.copyValue(mergeForEval2.eval(input)));
            }
            this.accForFinishVar().value().set(this.accForMergeVar().value().get());
            object = finishForEval2.eval(input);
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "aggregate";
    }

    @Override
    public Expression first() {
        return this.argument();
    }

    @Override
    public Expression second() {
        return this.zero();
    }

    @Override
    public Expression third() {
        return this.merge();
    }

    @Override
    public Expression fourth() {
        return this.finish();
    }

    @Override
    public ArrayAggregate withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public ArrayAggregate copy(Expression argument, Expression zero, Expression merge, Expression finish) {
        return new ArrayAggregate(argument, zero, merge, finish);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.zero();
    }

    public Expression copy$default$3() {
        return this.merge();
    }

    public Expression copy$default$4() {
        return this.finish();
    }

    @Override
    public String productPrefix() {
        return "ArrayAggregate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.argument();
                break;
            }
            case 1: {
                object = this.zero();
                break;
            }
            case 2: {
                object = this.merge();
                break;
            }
            case 3: {
                object = this.finish();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayAggregate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "argument";
                break;
            }
            case 1: {
                string = "zero";
                break;
            }
            case 2: {
                string = "merge";
                break;
            }
            case 3: {
                string = "finish";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayAggregate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayAggregate arrayAggregate = (ArrayAggregate)x$1;
        Expression expression = this.argument();
        Expression expression2 = arrayAggregate.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.zero();
        Expression expression4 = arrayAggregate.zero();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.merge();
        Expression expression6 = arrayAggregate.merge();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.finish();
        Expression expression8 = arrayAggregate.finish();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!arrayAggregate.canEqual(this)) return false;
        return true;
    }

    public ArrayAggregate(Expression argument, Expression zero, Expression merge, Expression finish) {
        this.argument = argument;
        this.zero = zero;
        this.merge = merge;
        this.finish = finish;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        QuaternaryLike.$init$(this);
        Statics.releaseFence();
    }

    public ArrayAggregate(Expression argument, Expression zero, Expression merge) {
        this(argument, zero, merge, LambdaFunction$.MODULE$.identity());
    }
}

