/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0\n  ", since="1.4.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u000e\u001d\u0001&BQa\u0011\u0001\u0005\u0002\u0011C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u00139\u0003\u0001\u0019!A!B\u00139\u0005\"\u0002)\u0001\t#\n\u0006\"\u0002.\u0001\t\u0003Z\u0006\"B0\u0001\t\u0003\u0002\u0007\"B4\u0001\t#B\u0007\"B8\u0001\t\u0003\u0002\b\"\u0002@\u0001\t\u0003z\b\"B\u0011\u0001\t\u0003z\bBBA\t\u0001\u0011\u0005C\t\u0003\u0005\u0002\u0014\u0001\t\t\u0011\"\u0001E\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003wA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0003\"CA+\u0001\u0005\u0005I\u0011IA,\u000f%\tY\bHA\u0001\u0012\u0003\tiH\u0002\u0005\u001c9\u0005\u0005\t\u0012AA@\u0011\u0019\u0019U\u0003\"\u0001\u0002\u0018\"I\u0011\u0011T\u000b\u0002\u0002\u0013\u0015\u00131\u0014\u0005\t\u0003;+\u0012\u0011!CA\t\"I\u0011qT\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003O+\u0012\u0011!C\u0005\u0003S\u0013\u0011$T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4J\t*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007CA\u00160\u0013\t\u0001DD\u0001\u0005Ti\u0006$XMZ;m!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000f!\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f)\u0003\u0019a$o\\8u}%\tA'\u0003\u0002@g\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty4'\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u00111\u0006A\u0001\u0006G>,h\u000e\u001e\t\u0003e!K!!S\u001a\u0003\t1{gn\u001a\u0015\u0003\u0005-\u0003\"A\r'\n\u00055\u001b$!\u0003;sC:\u001c\u0018.\u001a8u\u00035\u0001\u0018M\u001d;ji&|g.T1tW\"\u00121aS\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0002S+B\u0011!gU\u0005\u0003)N\u0012A!\u00168ji\")a\u000b\u0002a\u0001/\u0006q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\u001aY\u0013\tI6GA\u0002J]R\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u00029B\u0011!'X\u0005\u0003=N\u0012qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013!\u0003\u0015!\u0018\u0010]3t\u0013\t17M\u0001\u0005ECR\fG+\u001f9f\u00031)g/\u00197J]R,'O\\1m)\t9\u0015\u000eC\u0003k\u000f\u0001\u00071.A\u0003j]B,H\u000f\u0005\u0002m[6\ta$\u0003\u0002o=\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\rF\u0002ror\u0004\"A];\u000e\u0003MT!\u0001\u001e\u000f\u0002\u000f\r|G-Z4f]&\u0011ao\u001d\u0002\t\u000bb\u0004(oQ8eK\")\u0001\u0010\u0003a\u0001s\u0006\u00191\r\u001e=\u0011\u0005IT\u0018BA>t\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ! \u0005A\u0002E\f!!\u001a<\u0002\u00119|G-\u001a(b[\u0016,\"!!\u0001\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002;g%\u0019\u0011\u0011B\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIaM\u0001\nMJ,7\u000f[\"paf\fAaY8qs\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003;\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012aV\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty#!\u000e\u0011\u0007I\n\t$C\u0002\u00024M\u00121!\u00118z\u0011!\t9dDA\u0001\u0002\u00049\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>A1\u0011qHA#\u0003_i!!!\u0011\u000b\u0007\u0005\r3'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0012\u0002B\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ra\u0016Q\n\u0005\n\u0003o\t\u0012\u0011!a\u0001\u0003_\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011DA*\u0011!\t9DEA\u0001\u0002\u00049\u0016AB3rk\u0006d7\u000fF\u0002]\u00033B\u0011\"a\u000e\u0014\u0003\u0003\u0005\r!a\f)'\u0001\ti&a\u0019\u0002f\u0005%\u00141NA8\u0003c\n)(a\u001e\u0011\u0007-\ny&C\u0002\u0002bq\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002h\u0005!iD\u0003\u0011!A\u0001zf)\u0016(D?\"J\u0003%\f\u0011SKR,(O\\:![>tw\u000e^8oS\u000e\fG\u000e\\=!S:\u001c'/Z1tS:<\u0007E\u000e\u001b.E&$\b%\u001b8uK\u001e,'o\u001d\u0018!)\",\u0007eZ3oKJ\fG/\u001a3!\u0013\u0012\u0003\u0013n\u001d\u0011hk\u0006\u0014\u0018M\u001c;fK\u0012T\u0001\u0005\t\u0011!A\u0001\"x\u000e\t2fA5|gn\u001c;p]&\u001c\u0017\r\u001c7zA%t7M]3bg&tw\rI1oI\u0002*h.[9vK2\u0002#-\u001e;!]>$\beY8og\u0016\u001cW\u000f^5wK:\u0002C\u000b[3!GV\u0014(/\u001a8uA%l\u0007\u000f\\3nK:$\u0018\r^5p]*\u0001\u0003\u0005\t\u0011!AA,Ho\u001d\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\u001c\u0011J\t\u0002Jg\u000e\t;iK\u0002*\b\u000f]3sAM\n\u0004EY5ug2\u0002\u0013M\u001c3!i\",\u0007\u0005\\8xKJ\u00043g\r\u0011cSR\u001c\bE]3qe\u0016\u001cXM\u001c;!i\",\u0007E]3d_J$\u0007E\\;nE\u0016\u0014(\u0002\t\u0011!A\u0001\u0002s/\u001b;iS:\u0004S-Y2iAA\f'\u000f^5uS>tg\u0006\t+iK\u0002\n7o];naRLwN\u001c\u0011jg\u0002\"\b.\u0019;!i\",\u0007\u0005Z1uC\u00022'/Y7fA!\f7\u000f\t7fgN\u0004C\u000f[1oAE\u0002#-\u001b7mS>t'\u0002\t\u0011!A\u0001\u0002\u0003/\u0019:uSRLwN\\:-A\u0005tG\rI3bG\"\u0004\u0003/\u0019:uSRLwN\u001c\u0011iCN\u0004C.Z:tAQD\u0017M\u001c\u00119A\tLG\u000e\\5p]\u0002\u0012XmY8sINt#\u0002\t\u0011!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002\u0012WmY1vg\u0016\u0004\u0013\u000e^:!e\u0016\u001cX\u000f\u001c;!I\u0016\u0004XM\u001c3tA=t\u0007\u0005]1si&$\u0018n\u001c8!\u0013\u0012\u001bhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA7\u0003MR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002t\u0005)\u0011G\f\u001b/a\u0005)qM]8va\u0006\u0012\u0011\u0011P\u0001\u000b[&\u001c8m\u00184v]\u000e\u001c\u0018!G'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h\u0013\u0012\u0003\"aK\u000b\u0014\u000bU\t\t)!$\u0011\u000b\u0005\r\u0015\u0011R#\u000e\u0005\u0005\u0015%bAADg\u00059!/\u001e8uS6,\u0017\u0002BAF\u0003\u000b\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81!\u0011\ty)!&\u000e\u0005\u0005E%\u0002BAJ\u0003C\t!![8\n\u0007\u0005\u000b\t\n\u0006\u0002\u0002~\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u0005)\u0011\r\u001d9ms\u00069QO\\1qa2LHc\u0001/\u0002$\"A\u0011QU\r\u0002\u0002\u0003\u0007Q)A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a+\u0011\t\u0005m\u0011QV\u0005\u0005\u0003_\u000biB\u0001\u0004PE*,7\r\u001e")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID x$0) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(x$0);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return !this.bitmap$0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String nodeName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        String string = (String)Statics.ioobe((int)x$1);
        return string;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof MonotonicallyIncreasingID;
        return bl && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }
}

