/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Rank$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the rank of a value in a group of values. The result is one plus the number\n      of rows preceding or equal to the current row in the ordering of the partition. The values\n      will produce gaps in the sequence.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t3\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\f\u0019\u0001\u0016B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005}!)Q\t\u0001C\u0001\r\")Q\t\u0001C\u0001\u0013\")!\n\u0001C!\u0017\")a\n\u0001C)\u001f\"9Q\u000bAA\u0001\n\u00031\u0006b\u0002-\u0001#\u0003%\t!\u0017\u0005\bI\u0002\t\t\u0011\"\u0011f\u0011\u001dq\u0007!!A\u0005\u0002=Dqa\u001d\u0001\u0002\u0002\u0013\u0005A\u000fC\u0004{\u0001\u0005\u0005I\u0011I>\t\u0013\u0005\u0015\u0001!!A\u0005\u0002\u0005\u001d\u0001\"CA\t\u0001\u0005\u0005I\u0011IA\n\u0011%\t9\u0002AA\u0001\n\u0003\nIbB\u0005\u0002Da\t\t\u0011#\u0001\u0002F\u0019Aq\u0003GA\u0001\u0012\u0003\t9\u0005\u0003\u0004F#\u0011\u0005\u0011q\f\u0005\n\u0003C\n\u0012\u0011!C#\u0003GB\u0011\"!\u001a\u0012\u0003\u0003%\t)a\u001a\t\u0013\u0005-\u0014#!A\u0005\u0002\u00065\u0004\"CA=#\u0005\u0005I\u0011BA>\u0005\u0011\u0011\u0016M\\6\u000b\u0005eQ\u0012aC3yaJ,7o]5p]NT!a\u0007\u000f\u0002\u0011\r\fG/\u00197zgRT!!\b\u0010\u0002\u0007M\fHN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0014+aA\u0011q\u0005K\u0007\u00021%\u0011\u0011\u0006\u0007\u0002\t%\u0006t7\u000eT5lKB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t9\u0001K]8ek\u000e$\bCA\u0019:\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026I\u00051AH]8pizJ\u0011!L\u0005\u0003q1\nq\u0001]1dW\u0006<W-\u0003\u0002;w\ta1+\u001a:jC2L'0\u00192mK*\u0011\u0001\bL\u0001\tG\"LG\u000e\u001a:f]V\ta\bE\u00022\u007f\u0005K!\u0001Q\u001e\u0003\u0007M+\u0017\u000f\u0005\u0002(\u0005&\u00111\t\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!C2iS2$'/\u001a8!\u0003\u0019a\u0014N\\5u}Q\u0011q\t\u0013\t\u0003O\u0001AQ\u0001P\u0002A\u0002y\"\u0012aR\u0001\no&$\bn\u0014:eKJ$\"a\u0012'\t\u000b5+\u0001\u0019\u0001 \u0002\u000b=\u0014H-\u001a:\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGCA$Q\u0011\u0015\tf\u00011\u0001S\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007E\u001a\u0016)\u0003\u0002Uw\tQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0003\u000f^Cq\u0001P\u0004\u0011\u0002\u0003\u0007a(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iS#AP.,\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0013Ut7\r[3dW\u0016$'BA1-\u0003)\tgN\\8uCRLwN\\\u0005\u0003Gz\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\ta\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A.\u00198h\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0001\bCA\u0016r\u0013\t\u0011HFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002vqB\u00111F^\u0005\u0003o2\u00121!\u00118z\u0011\u001dI8\"!AA\u0002A\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001?\u0011\tu\f\t!^\u0007\u0002}*\u0011q\u0010L\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0002}\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI!a\u0004\u0011\u0007-\nY!C\u0002\u0002\u000e1\u0012qAQ8pY\u0016\fg\u000eC\u0004z\u001b\u0005\u0005\t\u0019A;\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004M\u0006U\u0001bB=\u000f\u0003\u0003\u0005\r\u0001]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00111\u0004\u0005\bs>\t\t\u00111\u0001vQ]\u0001\u0011qDA\u0013\u0003O\tY#!\f\u00022\u0005M\u0012qGA\u001d\u0003{\ty\u0004E\u0002(\u0003CI1!a\t\u0019\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u000b\u0002\u0003GT\u0001\u0005\t\u0011!?\u001a+fjQ0)S\u0001j\u0003eQ8naV$Xm\u001d\u0011uQ\u0016\u0004#/\u00198lA=4\u0007%\u0019\u0011wC2,X\rI5oA\u0005\u0004sM]8va\u0002zg\r\t<bYV,7O\f\u0011UQ\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011p]\u0016\u0004\u0003\u000f\\;tAQDW\r\t8v[\n,'O\u0003\u0011!A\u0001\u0002\u0003e\u001c4!e><8\u000f\t9sK\u000e,G-\u001b8hA=\u0014\b%Z9vC2\u0004Co\u001c\u0011uQ\u0016\u00043-\u001e:sK:$\bE]8xA%t\u0007\u0005\u001e5fA=\u0014H-\u001a:j]\u001e\u0004sN\u001a\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\u001c\u0018!)\",\u0007E^1mk\u0016\u001c(\u0002\t\u0011!A\u0001\u0002s/\u001b7mAA\u0014x\u000eZ;dK\u0002:\u0017\r]:!S:\u0004C\u000f[3!g\u0016\fX/\u001a8dK:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a\f\u0002\u0003\u000fT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I2iS2$'/\u001a8![\u0001\"\b.[:!SN\u0004Co\u001c\u0011cCN,\u0007\u0005\u001e5fAI\fgn\u001b\u0011p]n\u0002\u0013\rI2iC:<W\rI5oAQDW\r\t<bYV,\u0007e\u001c4!_:,\u0007\u0005\u001e5fA\rD\u0017\u000e\u001c3sK:\u0004s/\u001b7m\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e:jO\u001e,'\u000fI1!G\"\fgnZ3!S:\u0004#/\u00198l]\u0001\"\u0006.[:!SN\u0004\u0013M\u001c\u0011j]R,'O\\1mAA\f'/Y7fi\u0016\u0014\b%\u00198eA]LG\u000e\u001c\u0011cK\u0002\n7o]5h]\u0016$\u0007EY=!i\",'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0003:\fG._:fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QG\u0001\u0002\u0018*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\r\f\u0011cY\u0001zf)\u0016(D?\"\u0012\u0017\u0006I(W\u000bJ\u0003\u0003\u0006U!S)&#\u0016j\u0014(!\u0005f\u0003\u0013\rI(S\t\u0016\u0013\u0006EQ-!E&\u0002cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-AIJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*Y\u0001Bs%\u0011\u001a(Y\u0001\u001a\u0014\u0006\f\u0011)O\u0005\u000bt\u0005\f\u00112S\u0001\"\u0018M\u0019\u0015bY\u0001\u0012\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0014b\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0019\u0014\"\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111H\u0001\u0006e9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0003\nAb^5oI><xLZ;oGN\fAAU1oWB\u0011q%E\n\u0006#\u0005%\u0013Q\u000b\t\u0007\u0003\u0017\n\tFP$\u000e\u0005\u00055#bAA(Y\u00059!/\u001e8uS6,\u0017\u0002BA*\u0003\u001b\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.U\u0006\u0011\u0011n\\\u0005\u0004u\u0005eCCAA#\u0003!!xn\u0015;sS:<G#\u00014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u001d\u000bI\u0007C\u0003=)\u0001\u0007a(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u0014Q\u000f\t\u0005W\u0005Ed(C\u0002\u0002t1\u0012aa\u00149uS>t\u0007\u0002CA<+\u0005\u0005\t\u0019A$\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002~A\u0019q-a \n\u0007\u0005\u0005\u0005N\u0001\u0004PE*,7\r\u001e")
public class Rank
extends RankLike {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapply(Rank x$0) {
        return Rank$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Rank, A> g) {
        return Rank$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Rank> compose(Function1<A$, Seq<Expression>> g) {
        return Rank$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public Rank withOrder(Seq<Expression> order) {
        return new Rank(order);
    }

    @Override
    public Rank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public Rank copy(Seq<Expression> children2) {
        return new Rank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Rank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rank;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rank)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rank rank = (Rank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = rank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!rank.canEqual(this)) return false;
        return true;
    }

    public Rank(Seq<Expression> children2) {
        this.children = children2;
    }

    public Rank() {
        this((Seq<Expression>)package$.MODULE$.Nil());
    }
}

