/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralValueProtoConverter$ {
    public static LiteralValueProtoConverter$ MODULE$;
    private org.apache.spark.connect.proto.DataType nullType;
    private volatile boolean bitmap$0;

    static {
        new LiteralValueProtoConverter$();
    }

    private org.apache.spark.connect.proto.DataType nullType$lzycompute() {
        LiteralValueProtoConverter$ literalValueProtoConverter$ = this;
        synchronized (literalValueProtoConverter$) {
            if (!this.bitmap$0) {
                this.nullType = org.apache.spark.connect.proto.DataType.newBuilder().setNull(DataType.NULL.getDefaultInstance()).build();
                this.bitmap$0 = true;
            }
        }
        return this.nullType;
    }

    private org.apache.spark.connect.proto.DataType nullType() {
        if (!this.bitmap$0) {
            return this.nullType$lzycompute();
        }
        return this.nullType;
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal) {
        Object object;
        Expression.Literal.Builder builder;
        while (true) {
            builder = Expression.Literal.newBuilder();
            object = literal;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return builder.setBoolean(bl);
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                return builder.setByte(by);
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                return builder.setShort(s);
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return builder.setInteger(n);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return builder.setLong(l);
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return builder.setFloat(f);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return builder.setDouble(d);
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof String) {
                String string = (String)object;
                return builder.setString(string);
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                return builder.setString(Character.toString(c));
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return builder.setString(String.valueOf(cArray));
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return builder.setBinary(ByteString.copyFrom((byte[])byArray));
            }
            if (!(object instanceof WrappedArray)) break;
            WrappedArray wrappedArray = (WrappedArray)object;
            literal = wrappedArray.array();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return builder.setDate((int)localDate.toEpochDay());
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(Math.max(decimal.precision(), decimal.scale()), decimal.scale(), decimal.toString(), builder));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return builder.setTimestamp(DateTimeUtils$.MODULE$.instantToMicros(instant));
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return builder.setTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return builder.setTimestampNtz(DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return builder.setDate(DateTimeUtils$.MODULE$.fromJavaDate(date));
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return builder.setDayTimeInterval(IntervalUtils$.MODULE$.durationToMicros(duration));
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return builder.setYearMonthInterval(IntervalUtils$.MODULE$.periodToMonths(period));
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return builder.setArray(this.arrayBuilder$1(object2, builder));
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return builder.setCalendarInterval(LiteralValueProtoConverter$.calendarIntervalBuilder$1(calendarInterval.months, calendarInterval.days, calendarInterval.microseconds, builder));
        }
        if (object == null) {
            return builder.setNull(this.nullType());
        }
        throw new UnsupportedOperationException(new StringBuilder(29).append("literal ").append(literal).append(" not supported (yet).").toString());
    }

    public Expression.Literal toLiteralProto(Object literal) {
        return this.toLiteralProtoBuilder(literal).build();
    }

    private DataType toDataType(Class<?> clz) {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                Class<?> clazz = clz;
                                Class<Short> clazz2 = Short.TYPE;
                                Class<?> clazz3 = clazz;
                                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                                    return ShortType$.MODULE$;
                                }
                                Class<Integer> clazz4 = Integer.TYPE;
                                Class<?> clazz5 = clazz;
                                if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                                    return IntegerType$.MODULE$;
                                }
                                Class<Long> clazz6 = Long.TYPE;
                                Class<?> clazz7 = clazz;
                                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                                    return LongType$.MODULE$;
                                }
                                Class<Double> clazz8 = Double.TYPE;
                                Class<?> clazz9 = clazz;
                                if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                                    return DoubleType$.MODULE$;
                                }
                                Class<Byte> clazz10 = Byte.TYPE;
                                Class<?> clazz11 = clazz;
                                if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                    return ByteType$.MODULE$;
                                }
                                Class<Float> clazz12 = Float.TYPE;
                                Class<?> clazz13 = clazz;
                                if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                    return FloatType$.MODULE$;
                                }
                                Class<Boolean> clazz14 = Boolean.TYPE;
                                Class<?> clazz15 = clazz;
                                if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                    return BooleanType$.MODULE$;
                                }
                                Class<Character> clazz16 = Character.TYPE;
                                Class<?> clazz17 = clazz;
                                if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                                    return StringType$.MODULE$;
                                }
                                Class<?> clazz18 = clz;
                                Class<LocalDate> clazz19 = LocalDate.class;
                                if (!(clazz18 == null ? clazz19 != null : !clazz18.equals(clazz19))) break block33;
                                Class<?> clazz20 = clz;
                                Class<Date> clazz21 = Date.class;
                                if (clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null) break block34;
                            }
                            return DateType$.MODULE$;
                        }
                        Class<?> clazz = clz;
                        Class<Instant> clazz22 = Instant.class;
                        if (!(clazz == null ? clazz22 != null : !clazz.equals(clazz22))) break block35;
                        Class<?> clazz23 = clz;
                        Class<Timestamp> clazz24 = Timestamp.class;
                        if (clazz23 != null ? !clazz23.equals(clazz24) : clazz24 != null) break block36;
                    }
                    return TimestampType$.MODULE$;
                }
                Class<?> clazz = clz;
                Class<LocalDateTime> clazz25 = LocalDateTime.class;
                if (!(clazz != null ? !clazz.equals(clazz25) : clazz25 != null)) {
                    return TimestampNTZType$.MODULE$;
                }
                Class<?> clazz26 = clz;
                Class<Duration> clazz27 = Duration.class;
                if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null)) {
                    return DayTimeIntervalType$.MODULE$.DEFAULT();
                }
                Class<?> clazz28 = clz;
                Class<Period> clazz29 = Period.class;
                if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
                    return YearMonthIntervalType$.MODULE$.DEFAULT();
                }
                Class<?> clazz30 = clz;
                Class<java.math.BigDecimal> clazz31 = java.math.BigDecimal.class;
                if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
                    return DecimalType$.MODULE$.SYSTEM_DEFAULT();
                }
                Class<?> clazz32 = clz;
                Class<byte[]> clazz33 = byte[].class;
                if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
                    return BinaryType$.MODULE$;
                }
                Class<?> clazz34 = clz;
                Class<char[]> clazz35 = char[].class;
                if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
                    return StringType$.MODULE$;
                }
                Class<?> clazz36 = clz;
                Class<Short> clazz37 = Short.class;
                if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
                    return ShortType$.MODULE$;
                }
                Class<?> clazz38 = clz;
                Class<Integer> clazz39 = Integer.class;
                if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
                    return IntegerType$.MODULE$;
                }
                Class<?> clazz40 = clz;
                Class<Long> clazz41 = Long.class;
                if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
                    return LongType$.MODULE$;
                }
                Class<?> clazz42 = clz;
                Class<Double> clazz43 = Double.class;
                if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
                    return DoubleType$.MODULE$;
                }
                Class<?> clazz44 = clz;
                Class<Byte> clazz45 = Byte.class;
                if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
                    return ByteType$.MODULE$;
                }
                Class<?> clazz46 = clz;
                Class<Float> clazz47 = Float.class;
                if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
                    return FloatType$.MODULE$;
                }
                Class<?> clazz48 = clz;
                Class<Boolean> clazz49 = Boolean.class;
                if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
                    return BooleanType$.MODULE$;
                }
                Class<?> clazz50 = clz;
                Class<String> clazz51 = String.class;
                if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
                    return StringType$.MODULE$;
                }
                Class<?> clazz52 = clz;
                Class<BigInt> clazz53 = BigInt.class;
                if (!(clazz52 == null ? clazz53 != null : !clazz52.equals(clazz53))) break block37;
                Class<?> clazz54 = clz;
                Class<BigDecimal> clazz55 = BigDecimal.class;
                if (clazz54 != null ? !clazz54.equals(clazz55) : clazz55 != null) break block38;
            }
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz = clz;
        Class<CalendarInterval> clazz56 = CalendarInterval.class;
        if (!(clazz != null ? !clazz.equals(clazz56) : clazz56 != null)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (clz.isArray()) {
            return ArrayType$.MODULE$.apply(this.toDataType(clz.getComponentType()));
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported component type ").append(clz).append(" in arrays.").toString());
    }

    private static final Expression.Literal.Decimal.Builder decimalBuilder$1(int precision, int scale, String value, Expression.Literal.Builder builder$1) {
        return builder$1.getDecimalBuilder().setPrecision(precision).setScale(scale).setValue(value);
    }

    private static final Expression.Literal.CalendarInterval.Builder calendarIntervalBuilder$1(int months, int days, long microseconds, Expression.Literal.Builder builder$1) {
        return builder$1.getCalendarIntervalBuilder().setMonths(months).setDays(days).setMicroseconds(microseconds);
    }

    private final Expression.Literal.Array.Builder arrayBuilder$1(Object array, Expression.Literal.Builder builder$1) {
        Expression.Literal.Array.Builder ab = builder$1.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(this.toDataType(array.getClass().getComponentType())));
        Predef$.MODULE$.genericArrayOps(array).foreach((Function1 & Serializable & scala.Serializable)x -> ab.addElements(MODULE$.toLiteralProto(x)));
        return ab;
    }

    private LiteralValueProtoConverter$() {
        MODULE$ = this;
    }
}

