/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import org.sparkproject.connect.grpc.Metadata;
import org.sparkproject.connect.grpc.ServerCall;
import org.sparkproject.connect.grpc.ServerCallHandler;
import org.sparkproject.connect.grpc.ServerInterceptor;
import org.sparkproject.connect.grpc.Status;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u0001-!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0004;\u0001\t\u0007I\u0011A\u001e\t\r\u0015\u0003\u0001\u0015!\u0003=\u0011\u001d1\u0005A1A\u0005\u0002\u001dCa\u0001\u0013\u0001!\u0002\u0013\u0019\u0005\"B%\u0001\t\u0003R%!\n)sKNC\u0017M]3e\u0017\u0016L\u0018)\u001e;iK:$\u0018nY1uS>t\u0017J\u001c;fe\u000e,\u0007\u000f^8s\u0015\tQ1\"A\u0004tKJ4\u0018nY3\u000b\u00051i\u0011aB2p]:,7\r\u001e\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]y\u0002C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011a\u0017M\\4\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001B4sa\u000eT\u0011\u0001J\u0001\u0003S>L!AJ\u0011\u0003#M+'O^3s\u0013:$XM]2faR|'/A\u0003u_.,g\u000e\u0005\u0002*e9\u0011!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0003[U\ta\u0001\u0010:p_Rt$\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er\u0013A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0018\u0002\rqJg.\u001b;?)\t9\u0014\b\u0005\u00029\u00015\t\u0011\u0002C\u0003(\u0005\u0001\u0007\u0001&\u0001\rbkRDwN]5{CRLwN\\'fi\u0006$\u0017\r^1LKf,\u0012\u0001\u0010\t\u0004{\u0001\u001beB\u0001\u0011?\u0013\ty\u0014%\u0001\u0005NKR\fG-\u0019;b\u0013\t\t%IA\u0002LKfT!aP\u0011\u0011\u0005a!\u0015BA\u001a\u001a\u0003e\tW\u000f\u001e5pe&T\u0018\r^5p]6+G/\u00193bi\u0006\\U-\u001f\u0011\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f+\u0005\u0019\u0015AD3ya\u0016\u001cG/\u001a3WC2,X\rI\u0001\u000eS:$XM]2faR\u001c\u0015\r\u001c7\u0016\u0007-+V\r\u0006\u0003M?\u001ed\u0007cA'Q':\u0011\u0001ET\u0005\u0003\u001f\u0006\n!bU3sm\u0016\u00148)\u00197m\u0013\t\t&K\u0001\u0005MSN$XM\\3s\u0015\ty\u0015\u0005\u0005\u0002U+2\u0001A!\u0002,\b\u0005\u00049&\u0001\u0002*fcR\u000b\"\u0001\u0017/\u0011\u0005eSV\"\u0001\u0018\n\u0005ms#a\u0002(pi\"Lgn\u001a\t\u00033vK!A\u0018\u0018\u0003\u0007\u0005s\u0017\u0010C\u0003a\u000f\u0001\u0007\u0011-\u0001\u0003dC2d\u0007\u0003\u0002\u0011c'\u0012L!aY\u0011\u0003\u0015M+'O^3s\u0007\u0006dG\u000e\u0005\u0002UK\u0012)am\u0002b\u0001/\n)!+Z:q)\")\u0001n\u0002a\u0001S\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0002!U&\u00111.\t\u0002\t\u001b\u0016$\u0018\rZ1uC\")Qn\u0002a\u0001]\u0006!a.\u001a=u!\u0011\u0001sn\u00153\n\u0005A\f#!E*feZ,'oQ1mY\"\u000bg\u000e\u001a7fe\u0002")
public class PreSharedKeyAuthenticationInterceptor
implements ServerInterceptor {
    private final Metadata.Key<String> authorizationMetadataKey = Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER);
    private final String expectedValue;

    public Metadata.Key<String> authorizationMetadataKey() {
        return this.authorizationMetadataKey;
    }

    public String expectedValue() {
        return this.expectedValue;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> next) {
        String authHeaderValue = metadata.get(this.authorizationMetadataKey());
        if (authHeaderValue == null) {
            Status status = Status.UNAUTHENTICATED.withDescription("No authentication token provided");
            call.close(status, new Metadata());
            return new ServerCall.Listener<ReqT>(null){};
        }
        String string = authHeaderValue;
        String string2 = this.expectedValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            Status status = Status.UNAUTHENTICATED.withDescription("Invalid authentication token");
            call.close(status, new Metadata());
            return new ServerCall.Listener<ReqT>(null){};
        }
        return next.startCall(call, metadata);
    }

    public PreSharedKeyAuthenticationInterceptor(String token) {
        this.expectedValue = "Bearer " + token;
    }
}

