/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointer;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.util.PeriodicRDDCheckpointer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Pregel$
implements Logging {
    public static final Pregel$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Pregel$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public <VD, ED, A> Graph<VD, ED> apply(Graph<VD, ED> graph, A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg2, Function2<A, A, A> mergeMsg, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2, ClassTag<A> evidence$3) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0)new Serializable(maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum number of iterations must be greater than 0,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}))).toString();
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        int checkpointInterval = graph.vertices().sparkContext().getConf().getInt("spark.graphx.pregel.checkpointInterval", -1);
        Graph<VD, ED> g = graph.mapVertices(new Serializable(initialMsg, vprog){
            public static final long serialVersionUID = 0L;
            private final Object initialMsg$1;
            private final Function3 vprog$1;

            public final VD apply(long vid, VD vdata) {
                return (VD)this.vprog$1.apply((Object)BoxesRunTime.boxToLong((long)vid), vdata, this.initialMsg$1);
            }
            {
                this.initialMsg$1 = initialMsg$1;
                this.vprog$1 = vprog$1;
            }
        }, evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
        PeriodicGraphCheckpointer graphCheckpointer = new PeriodicGraphCheckpointer(checkpointInterval, graph.vertices().sparkContext());
        graphCheckpointer.update(g);
        VertexRDD<A> messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg2, mergeMsg, GraphXUtils$.MODULE$.mapReduceTriplets$default$4(), evidence$1, evidence$2, evidence$3);
        PeriodicRDDCheckpointer messageCheckpointer = new PeriodicRDDCheckpointer(checkpointInterval, graph.vertices().sparkContext());
        messageCheckpointer.update(messages);
        long activeMessages = messages.count();
        Graph<VD, ED> prevG = null;
        IntRef i = new IntRef(0);
        while (activeMessages > 0L && i.elem < maxIterations) {
            prevG = g;
            g = Graph$.MODULE$.graphToGraphOps(g, evidence$1, evidence$2).joinVertices(messages, vprog, evidence$3);
            graphCheckpointer.update(g);
            VertexRDD<A> oldMessages = messages;
            messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg2, mergeMsg, (Option<Tuple2<VertexRDD<?>, EdgeDirection>>)new Some((Object)new Tuple2(oldMessages, (Object)activeDirection)), evidence$1, evidence$2, evidence$3);
            messageCheckpointer.update(messages);
            activeMessages = messages.count();
            this.logInfo((Function0<String>)new Serializable(i){
                public static final long serialVersionUID = 0L;
                private final IntRef i$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Pregel finished iteration ").append((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem)).toString();
                }
                {
                    this.i$1 = i$1;
                }
            });
            oldMessages.unpersist(false);
            prevG.unpersistVertices(false);
            prevG.edges().unpersist(false);
            ++i.elem;
        }
        messageCheckpointer.unpersistDataSet();
        graphCheckpointer.deleteAllCheckpoints();
        messageCheckpointer.deleteAllCheckpoints();
        return g;
    }

    public <VD, ED, A> int apply$default$3() {
        return Integer.MAX_VALUE;
    }

    public <VD, ED, A> EdgeDirection apply$default$4() {
        return EdgeDirection$.MODULE$.Either();
    }

    private Pregel$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

