/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Edge$mcD$sp;
import org.apache.spark.graphx.Edge$mcI$sp;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class GraphGenerators$
implements Logging {
    public static GraphGenerators$ MODULE$;
    private final double RMATa;
    private final double RMATb;
    private final double RMATd;
    private final double RMATc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GraphGenerators$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double RMATa() {
        return this.RMATa;
    }

    public double RMATb() {
        return this.RMATb;
    }

    public double RMATd() {
        return this.RMATd;
    }

    public Graph<Object, Object> logNormalGraph(SparkContext sc, int numVertices, int numEParts, double mu, double sigma, long seed) {
        int evalNumEParts = numEParts == 0 ? sc.defaultParallelism() : numEParts;
        Random seedRand = seed == -1L ? new Random() : new Random(seed);
        int seed1 = seedRand.nextInt();
        int seed2 = seedRand.nextInt();
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numVertices), evalNumEParts, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)src -> GraphGenerators$.$anonfun$logNormalGraph$1(mu, sigma, numVertices, seed1, BoxesRunTime.unboxToInt((Object)src)), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> new ArrayOps.ofRef(GraphGenerators$.$anonfun$logNormalGraph$2(numVertices, seed2, x0$1)), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToLong((long)0L), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int());
    }

    public int logNormalGraph$default$3() {
        return 0;
    }

    public double logNormalGraph$default$4() {
        return 4.0;
    }

    public double logNormalGraph$default$5() {
        return 1.3;
    }

    public long logNormalGraph$default$6() {
        return -1L;
    }

    public double RMATc() {
        return this.RMATc;
    }

    public Edge<Object>[] generateRandomEdges(int src, int numEdges, int maxVertexId, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        return (Edge[])Array$.MODULE$.fill(numEdges, (Function0 & Serializable & scala.Serializable)() -> new Edge$mcI$sp((long)src, (long)rand.nextInt(maxVertexId), 1), ClassTag$.MODULE$.apply(Edge.class));
    }

    public long generateRandomEdges$default$4() {
        return -1L;
    }

    public int sampleLogNormal(double mu, double sigma, int maxVal, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        double X = maxVal;
        while (X >= (double)maxVal) {
            double Z = rand.nextGaussian();
            X = package$.MODULE$.exp(mu + sigma * Z);
        }
        return (int)package$.MODULE$.floor(X);
    }

    public long sampleLogNormal$default$4() {
        return -1L;
    }

    public Graph<Object, Object> rmatGraph(SparkContext sc, int requestedNumVertices, int numEdges) {
        int numVertices = (int)package$.MODULE$.round(package$.MODULE$.pow(2.0, package$.MODULE$.ceil(package$.MODULE$.log((double)requestedNumVertices) / package$.MODULE$.log(2.0))));
        int numEdgesUpperBound = (int)package$.MODULE$.pow(2.0, (double)2 * (package$.MODULE$.log((double)numVertices) / package$.MODULE$.log(2.0) - 1.0));
        if (numEdgesUpperBound < numEdges) {
            throw new IllegalArgumentException(new StringBuilder(29).append("numEdges must be <= ").append(numEdgesUpperBound).append(" but was ").append(numEdges).toString());
        }
        ObjectRef edges = ObjectRef.create((Object)Set$.MODULE$.empty());
        while (((Set)edges.elem).size() < numEdges) {
            if (((Set)edges.elem).size() % 100 == 0) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(((Set)edges$1.elem).size()).append(" edges").toString());
            }
            ((Set)edges.elem).$plus$eq(this.addEdge(numVertices));
        }
        return this.outDegreeFromEdges(sc.parallelize((Seq)((Set)edges.elem).toList(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Int());
    }

    private <ED> Graph<Object, ED> outDegreeFromEdges(RDD<Edge<ED>> edges, ClassTag<ED> evidence$1) {
        RDD vertices = RDD$.MODULE$.rddToPairRDDFunctions(edges.flatMap((Function1 & Serializable & scala.Serializable)edge -> new .colon.colon((Object)new Tuple2.mcJI.sp(edge.srcId(), 1), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            int degree = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(vid, degree);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToInteger((int)0), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Int(), evidence$1);
    }

    private Edge<Object> addEdge(int numVertices) {
        int v = (int)package$.MODULE$.round((double)numVertices / 2.0);
        Tuple2<Object, Object> tuple2 = this.chooseCell(v, v, v);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int src = tuple2._1$mcI$sp();
        int dst = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(src, dst);
        Tuple2.mcII.sp sp3 = sp2;
        int src2 = sp3._1$mcI$sp();
        int dst2 = sp3._2$mcI$sp();
        return new Edge$mcI$sp((long)src2, (long)dst2, 1);
    }

    private Tuple2<Object, Object> chooseCell(int x, int y, int t) {
        block6: while (t > 1) {
            int newT = (int)package$.MODULE$.round((double)t / 2.0);
            int n = this.pickQuadrant(this.RMATa(), this.RMATb(), this.RMATc(), this.RMATd());
            switch (n) {
                case 0: {
                    t = newT;
                    continue block6;
                }
                case 1: {
                    t = newT;
                    x += newT;
                    continue block6;
                }
                case 2: {
                    t = newT;
                    y += newT;
                    continue block6;
                }
                case 3: {
                    t = newT;
                    y += newT;
                    x += newT;
                    continue block6;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return new Tuple2.mcII.sp(x, y);
    }

    private int pickQuadrant(double a, double b, double c, double d) {
        if (a + b + c + d != 1.0) {
            throw new IllegalArgumentException(new StringBuilder(55).append("R-MAT probability parameters sum to ").append(a + b + c + d).append(", should sum to 1.0").toString());
        }
        Random rand = new Random();
        double result = rand.nextDouble();
        double d2 = result;
        int n = d2 < a ? 0 : (d2 >= a && d2 < a + b ? 1 : (d2 >= a + b && d2 < a + b + c ? 2 : 3));
        return n;
    }

    public Graph<Tuple2<Object, Object>, Object> gridGraph(SparkContext sc, int rows, int cols) {
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).flatMap((Function1 & Serializable & scala.Serializable)r -> GraphGenerators$.$anonfun$gridGraph$1(cols, BoxesRunTime.unboxToInt((Object)r)), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            int r = tuple2._1$mcI$sp();
            int c = tuple2._2$mcI$sp();
            Seq seq = (Seq)((TraversableLike)(r + 1 < rows ? new .colon.colon((Object)new Tuple2.mcJJ.sp(GraphGenerators$.sub2ind$1(r, c, cols), GraphGenerators$.sub2ind$1(r + 1, c, cols)), (List)Nil$.MODULE$) : Nil$.MODULE$)).$plus$plus((GenTraversableOnce)(c + 1 < cols ? new .colon.colon((Object)new Tuple2.mcJJ.sp(GraphGenerators$.sub2ind$1(r, c, cols), GraphGenerators$.sub2ind$1(r, c + 1, cols)), (List)Nil$.MODULE$) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long src = tuple2._1$mcJ$sp();
            long dst = tuple2._2$mcJ$sp();
            Edge$mcD$sp edge$mcD$sp = new Edge$mcD$sp(src, dst, 1.0);
            return edge$mcD$sp;
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> starGraph(SparkContext sc, int nverts) {
        RDD edges = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), nverts), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)vid -> GraphGenerators$.$anonfun$starGraph$1(BoxesRunTime.unboxToInt((Object)vid)), ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.fromEdgeTuples((RDD<Tuple2<Object, Object>>)edges, BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ Tuple2 $anonfun$logNormalGraph$1(double mu$1, double sigma$1, int numVertices$1, int seed1$1, int src) {
        return new Tuple2.mcJJ.sp((long)src, (long)MODULE$.sampleLogNormal(mu$1, sigma$1, numVertices$1, seed1$1 ^ src));
    }

    public static final /* synthetic */ Object[] $anonfun$logNormalGraph$2(int numVertices$1, int seed2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long src = tuple2._1$mcJ$sp();
        long degree = tuple2._2$mcJ$sp();
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])MODULE$.generateRandomEdges((int)src, (int)degree, numVertices$1, (long)seed2$1 ^ src));
        return objectArray;
    }

    private static final long sub2ind$1(int r, int c, int cols$1) {
        return r * cols$1 + c;
    }

    public static final /* synthetic */ Tuple2 $anonfun$gridGraph$2(int r$1, int cols$1, int c) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphGenerators$.sub2ind$1(r$1, c, cols$1)), (Object)new Tuple2.mcII.sp(r$1, c));
    }

    public static final /* synthetic */ TraversableOnce $anonfun$gridGraph$1(int cols$1, int r) {
        return (TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cols$1).map((Function1 & Serializable & scala.Serializable)c -> GraphGenerators$.$anonfun$gridGraph$2(r, cols$1, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$starGraph$1(int vid) {
        return new Tuple2.mcJJ.sp((long)vid, 0L);
    }

    private GraphGenerators$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.RMATa = 0.45;
        this.RMATb = 0.15;
        this.RMATd = 0.25;
        this.RMATc = 0.15;
    }
}

