/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.cli.HiveFileProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetCrossReferenceOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetPrimaryKeysOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSessionImpl
implements HiveSession {
    private final SessionHandle sessionHandle;
    private String username;
    private final String password;
    private HiveConf hiveConf;
    private SessionState sessionState;
    private String ipAddress;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final Logger LOG = LoggerFactory.getLogger(HiveSessionImpl.class);
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private final Set<OperationHandle> opHandleSet = new HashSet<OperationHandle>();
    private boolean isOperationLogEnabled;
    private File sessionLogDir;
    private volatile long lastAccessTime;
    private volatile long lastIdleTime;

    public HiveSessionImpl(TProtocolVersion protocol, String username, String password, HiveConf serverhiveConf, String ipAddress) {
        this.username = username;
        this.password = password;
        this.sessionHandle = new SessionHandle(protocol);
        this.hiveConf = new HiveConf(serverhiveConf);
        this.ipAddress = ipAddress;
        try {
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS) && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_MAP_FAIR_SCHEDULER_QUEUE)) {
                ShimLoader.getHadoopShims().refreshDefaultQueue((Configuration)this.hiveConf, username);
            }
        }
        catch (IOException e) {
            LOG.warn("Error setting scheduler queue: " + e, (Throwable)e);
        }
        this.hiveConf.set(HiveConf.ConfVars.HIVESESSIONID.varname, this.sessionHandle.getHandleIdentifier().toString());
        this.hiveConf.set("list.sink.output.formatter", ThriftFormatter.class.getName());
        this.hiveConf.setInt("list.sink.output.protocol", protocol.getValue());
    }

    @Override
    public void open(Map<String, String> sessionConfMap) throws HiveSQLException {
        this.sessionState = new SessionState(this.hiveConf, this.username);
        this.sessionState.setUserIpAddress(this.ipAddress);
        this.sessionState.setIsHiveServerQuery(true);
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        try {
            this.sessionState.loadAuxJars();
            this.sessionState.loadReloadableAuxJars();
        }
        catch (IOException e) {
            String msg = "Failed to load reloadable jar file path: " + e;
            LOG.error(msg, (Throwable)e);
            throw new HiveSQLException(msg, e);
        }
        this.processGlobalInitFile();
        if (sessionConfMap != null) {
            this.configureSession(sessionConfMap);
        }
        this.lastIdleTime = this.lastAccessTime = System.currentTimeMillis();
    }

    private void processGlobalInitFile() {
        GlobalHivercFileProcessor processor = new GlobalHivercFileProcessor();
        try {
            String hiverc = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_GLOBAL_INIT_FILE_LOCATION);
            if (hiverc != null) {
                File hivercFile = new File(hiverc);
                if (hivercFile.isDirectory()) {
                    hivercFile = new File(hivercFile, ".hiverc");
                }
                if (hivercFile.isFile()) {
                    LOG.info("Running global init file: " + hivercFile);
                    int rc = processor.processFile(hivercFile.getAbsolutePath());
                    if (rc != 0) {
                        LOG.error("Failed on initializing global .hiverc file");
                    }
                } else {
                    LOG.debug("Global init file " + hivercFile + " does not exist");
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed on initializing global .hiverc file", (Throwable)e);
        }
    }

    private void configureSession(Map<String, String> sessionConfMap) throws HiveSQLException {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        for (Map.Entry<String, String> entry : sessionConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("set:")) {
                try {
                    HiveSessionImpl.setVariable(key.substring(4), entry.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new HiveSQLException(e);
                }
            }
            if (key.startsWith("use:")) {
                SessionState.get().setCurrentDatabase(entry.getValue());
                continue;
            }
            this.hiveConf.verifyAndSet(key, entry.getValue());
        }
    }

    public static int setVariable(String varname, String varvalue) throws Exception {
        SessionState ss = SessionState.get();
        VariableSubstitution substitution = new VariableSubstitution(() -> ss.getHiveVariables());
        if (varvalue.contains("\n")) {
            ss.err.println("Warning: Value had a \\n character in it.");
        }
        if ((varname = varname.trim()).startsWith("env:")) {
            ss.err.println("env:* variables can not be set.");
            return 1;
        }
        if (varname.startsWith("system:")) {
            String propName = varname.substring("system:".length());
            System.getProperties().setProperty(propName, substitution.substitute(ss.getConf(), varvalue));
        } else if (varname.startsWith("hiveconf:")) {
            String propName = varname.substring("hiveconf:".length());
            HiveSessionImpl.setConf(varname, propName, varvalue, true);
        } else if (varname.startsWith("hivevar:")) {
            String propName = varname.substring("hivevar:".length());
            ss.getHiveVariables().put(propName, substitution.substitute(ss.getConf(), varvalue));
        } else if (varname.startsWith("metaconf:")) {
            String propName = varname.substring("metaconf:".length());
            Hive hive = Hive.get((HiveConf)ss.getConf());
            hive.setMetaConf(propName, substitution.substitute(ss.getConf(), varvalue));
        } else {
            HiveSessionImpl.setConf(varname, varname, varvalue, true);
        }
        return 0;
    }

    private static void setConf(String varname, String key, String varvalue, boolean register) throws IllegalArgumentException {
        VariableSubstitution substitution = new VariableSubstitution(() -> SessionState.get().getHiveVariables());
        HiveConf conf = SessionState.get().getConf();
        String value = substitution.substitute(conf, varvalue);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVECONFVALIDATION)) {
            HiveConf.ConfVars confVars = HiveConf.getConfVars((String)key);
            if (confVars != null) {
                if (!confVars.isType(value)) {
                    StringBuilder message = new StringBuilder();
                    message.append("'SET ").append(varname).append('=').append(varvalue);
                    message.append("' FAILED because ").append(key).append(" expects ");
                    message.append(confVars.typeString()).append(" type value.");
                    throw new IllegalArgumentException(message.toString());
                }
                String fail = confVars.validate(value);
                if (fail != null) {
                    StringBuilder message = new StringBuilder();
                    message.append("'SET ").append(varname).append('=').append(varvalue);
                    message.append("' FAILED in validation : ").append(fail).append('.');
                    throw new IllegalArgumentException(message.toString());
                }
            } else if (key.startsWith("hive.")) {
                throw new IllegalArgumentException("hive configuration " + key + " does not exists.");
            }
        }
        conf.verifyAndSet(key, value);
        if (register) {
            SessionState.get().getOverriddenConfigurations().put(key, value);
        }
    }

    @Override
    public void setOperationLogSessionDir(File operationLogRootDir) {
        if (!operationLogRootDir.exists()) {
            LOG.warn("The operation log root directory is removed, recreating: " + operationLogRootDir.getAbsolutePath());
            if (!operationLogRootDir.mkdirs()) {
                LOG.warn("Unable to create operation log root directory: " + operationLogRootDir.getAbsolutePath());
            }
        }
        if (!operationLogRootDir.canWrite()) {
            LOG.warn("The operation log root directory is not writable: " + operationLogRootDir.getAbsolutePath());
        }
        this.sessionLogDir = new File(operationLogRootDir, this.sessionHandle.getHandleIdentifier().toString());
        this.isOperationLogEnabled = true;
        if (!this.sessionLogDir.exists() && !this.sessionLogDir.mkdir()) {
            LOG.warn("Unable to create operation log session directory: " + this.sessionLogDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (this.isOperationLogEnabled) {
            LOG.info("Operation log session directory is created: " + this.sessionLogDir.getAbsolutePath());
        }
    }

    @Override
    public boolean isOperationLogEnabled() {
        return this.isOperationLogEnabled;
    }

    @Override
    public File getOperationLogSessionDir() {
        return this.sessionLogDir;
    }

    @Override
    public TProtocolVersion getProtocolVersion() {
        return this.sessionHandle.getProtocolVersion();
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    protected synchronized void acquire(boolean userAccess) {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    protected synchronized void release(boolean userAccess) {
        SessionState.detachSession();
        if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
            ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
            currentThread.cacheThreadLocalRawStore();
        }
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
        }
        this.lastIdleTime = this.opHandleSet.isEmpty() ? System.currentTimeMillis() : 0L;
    }

    @Override
    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public HiveConf getHiveConf() {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.hiveConf;
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        try {
            return Hive.get((HiveConf)this.getHiveConf()).getMSC();
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to get metastore connection", e);
        }
        catch (MetaException e) {
            throw new HiveSQLException("Failed to get metastore connection", e);
        }
    }

    @Override
    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire(true);
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue(HiveVersionInfo.getVersion());
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, false, 0L);
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, false, queryTimeout);
    }

    @Override
    public OperationHandle executeStatementAsync(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, true, 0L);
    }

    @Override
    public OperationHandle executeStatementAsync(String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, true, queryTimeout);
    }

    private OperationHandle executeStatementInternal(String statement, Map<String, String> confOverlay, boolean runAsync, long queryTimeout) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        ExecuteStatementOperation operation = operationManager.newExecuteStatementOperation(this.getSession(), statement, confOverlay, runAsync, queryTimeout);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetTypeInfoOperation operation = operationManager.newGetTypeInfoOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetCatalogsOperation operation = operationManager.newGetCatalogsOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetSchemasOperation operation = operationManager.newGetSchemasOperation(this.getSession(), catalogName, schemaName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        MetadataOperation operation = operationManager.newGetTablesOperation(this.getSession(), catalogName, schemaName, tableName, tableTypes);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetTableTypesOperation operation = operationManager.newGetTableTypesOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire(true);
        String addedJars = Utilities.getResourceFiles((Configuration)this.hiveConf, (SessionState.ResourceType)SessionState.ResourceType.JAR);
        if (StringUtils.isNotBlank((CharSequence)addedJars)) {
            IMetaStoreClient metastoreClient = this.getSession().getMetaStoreClient();
            metastoreClient.setHiveAddedJars(addedJars);
        }
        OperationManager operationManager = this.getOperationManager();
        GetColumnsOperation operation = operationManager.newGetColumnsOperation(this.getSession(), catalogName, schemaName, tableName, columnName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetFunctionsOperation operation = operationManager.newGetFunctionsOperation(this.getSession(), catalogName, schemaName, functionName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire(true);
            for (OperationHandle opHandle : this.opHandleSet) {
                try {
                    this.operationManager.closeOperation(opHandle);
                }
                catch (Exception e) {
                    LOG.warn("Exception is thrown closing operation " + opHandle, (Throwable)e);
                }
            }
            this.opHandleSet.clear();
            this.cleanupSessionLogDir();
            this.cleanupPipeoutFile();
            HiveHistory hiveHist = this.sessionState.getHiveHistory();
            if (null != hiveHist) {
                hiveHist.closeStream();
            }
            try {
                this.sessionState.close();
            }
            finally {
                this.sessionState = null;
            }
        }
        catch (IOException ioe) {
            throw new HiveSQLException("Failure to close", ioe);
        }
        finally {
            if (this.sessionState != null) {
                try {
                    this.sessionState.close();
                }
                catch (Throwable t) {
                    LOG.warn("Error closing session", t);
                }
                this.sessionState = null;
            }
            this.release(true);
        }
    }

    private void cleanupPipeoutFile() {
        String sessionID;
        String lScratchDir = this.hiveConf.getVar(HiveConf.ConfVars.LOCALSCRATCHDIR);
        File[] fileAry = new File(lScratchDir).listFiles((arg_0, arg_1) -> HiveSessionImpl.lambda$cleanupPipeoutFile$2(sessionID = this.hiveConf.getVar(HiveConf.ConfVars.HIVESESSIONID), arg_0, arg_1));
        if (fileAry == null) {
            LOG.error("Unable to access pipeout files in " + lScratchDir);
        } else {
            for (File file : fileAry) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (Exception e) {
                    LOG.error("Failed to cleanup pipeout file: " + file, (Throwable)e);
                }
            }
        }
    }

    private void cleanupSessionLogDir() {
        if (this.isOperationLogEnabled) {
            try {
                FileUtils.forceDelete((File)this.sessionLogDir);
            }
            catch (Exception e) {
                LOG.error("Failed to cleanup session log dir: " + this.sessionHandle, (Throwable)e);
            }
        }
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void closeExpiredOperations() {
        List<Operation> operations;
        OperationHandle[] handles = this.opHandleSet.toArray(new OperationHandle[this.opHandleSet.size()]);
        if (handles.length > 0 && !(operations = this.operationManager.removeExpiredOperations(handles)).isEmpty()) {
            this.closeTimedOutOperations(operations);
        }
    }

    @Override
    public long getNoOperationTime() {
        return this.lastIdleTime > 0L ? System.currentTimeMillis() - this.lastIdleTime : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTimedOutOperations(List<Operation> operations) {
        this.acquire(false);
        try {
            for (Operation operation : operations) {
                this.opHandleSet.remove(operation.getHandle());
                try {
                    operation.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception is thrown closing timed-out operation " + operation.getHandle(), (Throwable)e);
                }
            }
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            this.sessionManager.getOperationManager().cancelOperation(opHandle);
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            this.operationManager.closeOperation(opHandle);
            this.opHandleSet.remove(opHandle);
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public TTableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            TTableSchema tTableSchema = this.sessionManager.getOperationManager().getOperationResultSetSchema(opHandle);
            return tTableSchema;
        }
        finally {
            this.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        this.acquire(true);
        try {
            if (fetchType == FetchType.QUERY_OUTPUT) {
                TRowSet tRowSet = this.operationManager.getOperationNextRowSet(opHandle, orientation, maxRows);
                return tRowSet;
            }
            TRowSet tRowSet = this.operationManager.getOperationLogRowSet(opHandle, orientation, maxRows);
            return tRowSet;
        }
        finally {
            this.release(true);
        }
    }

    protected HiveSession getSession() {
        return this;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), owner, this.getIpAddress(), this.getHiveConf());
        return authFactory.getDelegationToken(owner, renewer, this.getIpAddress());
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.renewDelegationToken(tokenStr);
    }

    private String getUserFromToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        return authFactory.getUserFromToken(tokenStr);
    }

    @Override
    public OperationHandle getPrimaryKeys(String catalog, String schema, String table) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetPrimaryKeysOperation operation = operationManager.newGetPrimaryKeysOperation(this.getSession(), catalog, schema, table);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetCrossReferenceOperation operation = operationManager.newGetCrossReferenceOperation(this.getSession(), primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    private static /* synthetic */ boolean lambda$cleanupPipeoutFile$2(String sessionID, File dir, String name) {
        return name.startsWith(sessionID) && name.endsWith(".pipeout");
    }

    private class GlobalHivercFileProcessor
    extends HiveFileProcessor {
        private GlobalHivercFileProcessor() {
        }

        protected BufferedReader loadFile(String fileName) throws IOException {
            FileInputStream initStream = null;
            BufferedReader bufferedReader = null;
            initStream = new FileInputStream(fileName);
            bufferedReader = new BufferedReader(new InputStreamReader(initStream));
            return bufferedReader;
        }

        protected int processCmd(String cmd) {
            int rc = 0;
            String cmd_trimmed = cmd.trim();
            try {
                HiveSessionImpl.this.executeStatementInternal(cmd_trimmed, null, false, 0L);
            }
            catch (HiveSQLException e) {
                rc = -1;
                LOG.warn("Failed to execute HQL command in global .hiverc file.", (Throwable)e);
            }
            return rc;
        }
    }
}

