/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class HiveClientImpl$ {
    public static final HiveClientImpl$ MODULE$;
    private final Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;

    static {
        new HiveClientImpl$();
    }

    public FieldSchema toHiveColumn(StructField c) {
        String typeString = c.metadata().contains(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) ? c.metadata().getString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) : c.dataType().catalogString();
        return new FieldSchema(c.name(), typeString, (String)c.getComment().orNull(Predef$.MODULE$.$conforms()));
    }

    public DataType org$apache$spark$sql$hive$client$HiveClientImpl$$getSparkSQLDataType(FieldSchema hc) {
        try {
            return CatalystSqlParser$.MODULE$.parseDataType(hc.getType());
        }
        catch (ParseException parseException) {
            throw new SparkException(new StringBuilder().append((Object)"Cannot recognize hive type string: ").append((Object)hc.getType()).toString(), (Throwable)parseException);
        }
    }

    public StructField fromHiveColumn(FieldSchema hc) {
        DataType columnType = this.org$apache$spark$sql$hive$client$HiveClientImpl$$getSparkSQLDataType(hc);
        String string = hc.getType();
        String string2 = columnType.catalogString();
        Metadata metadata = !(string != null ? !string.equals(string2) : string2 != null) ? Metadata$.MODULE$.empty() : new MetadataBuilder().putString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING(), hc.getType()).build();
        StructField field = new StructField(hc.getName(), columnType, true, metadata);
        return (StructField)Option$.MODULE$.apply((Object)hc.getComment()).map((Function1)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final StructField field$1;

            public final StructField apply(String comment) {
                return this.field$1.withComment(comment);
            }
            {
                this.field$1 = field$1;
            }
        }).getOrElse((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final StructField field$1;

            public final StructField apply() {
                return this.field$1;
            }
            {
                this.field$1 = field$1;
            }
        });
    }

    public void org$apache$spark$sql$hive$client$HiveClientImpl$$verifyColumnDataType(StructType schema) {
        schema.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField col) {
                return HiveClientImpl$.MODULE$.org$apache$spark$sql$hive$client$HiveClientImpl$$getSparkSQLDataType(HiveClientImpl$.MODULE$.toHiveColumn(col));
            }
        });
    }

    public Class<? extends InputFormat<?, ?>> org$apache$spark$sql$hive$client$HiveClientImpl$$toInputFormat(String name) {
        return Utils$.MODULE$.classForName(name);
    }

    public Class<? extends HiveOutputFormat<?, ?>> org$apache$spark$sql$hive$client$HiveClientImpl$$toOutputFormat(String name) {
        return Utils$.MODULE$.classForName(name);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Table toHiveTable(CatalogTable table, Option<String> userName) {
        CatalogTableType catalogTableType;
        block10: {
            void var3_3;
            Tuple2 tuple2;
            TableType tableType;
            Table hiveTable;
            block8: {
                block9: {
                    block7: {
                        hiveTable = new Table(table.database(), table.identifier().table());
                        catalogTableType = table.tableType();
                        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
                        CatalogTableType catalogTableType3 = catalogTableType;
                        if (catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) break block7;
                        hiveTable.setProperty("EXTERNAL", "TRUE");
                        tableType = TableType.EXTERNAL_TABLE;
                        break block8;
                    }
                    CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
                    CatalogTableType catalogTableType5 = catalogTableType;
                    if (catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null) break block9;
                    tableType = TableType.MANAGED_TABLE;
                    break block8;
                }
                CatalogTableType catalogTableType6 = CatalogTableType$.MODULE$.VIEW();
                CatalogTableType catalogTableType7 = catalogTableType;
                if (catalogTableType6 != null ? !catalogTableType6.equals(catalogTableType7) : catalogTableType7 != null) break block10;
                tableType = TableType.VIRTUAL_VIEW;
            }
            hiveTable.setTableType(tableType);
            Tuple2 tuple22 = ((TraversableLike)table.schema().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FieldSchema apply(StructField c) {
                    return HiveClientImpl$.MODULE$.toHiveColumn(c);
                }
            }, Seq$.MODULE$.canBuildFrom())).partition((Function1)new Serializable(table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$1;

                public final boolean apply(FieldSchema c) {
                    return this.table$1.partitionColumnNames().contains((Object)c.getName());
                }
                {
                    this.table$1 = table$1;
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Seq partCols = (Seq)tuple22._1();
            Seq schema = (Seq)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)partCols, (Object)schema);
            Seq partCols2 = (Seq)tuple23._1();
            Seq schema2 = (Seq)tuple23._2();
            hiveTable.setFields((List)JavaConverters$.MODULE$.seqAsJavaListConverter(schema2).asJava());
            hiveTable.setPartCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter(partCols2).asJava());
            userName.foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(String x$1) {
                    this.hiveTable$4.setOwner(x$1);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            hiveTable.setCreateTime((int)(table.createTime() / 1000L));
            hiveTable.setLastAccessTime((int)(table.lastAccessTime() / 1000L));
            table.storage().locationUri().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(URI uri) {
                    return CatalogUtils$.MODULE$.URIToString(uri);
                }
            }).foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(String loc) {
                    this.hiveTable$4.getTTable().getSd().setLocation(loc);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            table.storage().inputFormat().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<? extends InputFormat<?, ?>> apply(String name) {
                    return HiveClientImpl$.MODULE$.org$apache$spark$sql$hive$client$HiveClientImpl$$toInputFormat(name);
                }
            }).foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(Class<? extends InputFormat<?, ?>> x$1) {
                    this.hiveTable$4.setInputFormatClass(x$1);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            table.storage().outputFormat().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<? extends HiveOutputFormat<?, ?>> apply(String name) {
                    return HiveClientImpl$.MODULE$.org$apache$spark$sql$hive$client$HiveClientImpl$$toOutputFormat(name);
                }
            }).foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(Class<? extends OutputFormat<?, ?>> x$1) {
                    this.hiveTable$4.setOutputFormatClass(x$1);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            hiveTable.setSerializationLib((String)table.storage().serde().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                }
            }));
            table.storage().properties().foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final String apply(Tuple2<String, String> x0$5) {
                    Tuple2<String, String> tuple2 = x0$5;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        String string = this.hiveTable$4.setSerdeParam(k, v);
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            table.properties().foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(Tuple2<String, String> x0$6) {
                    Tuple2<String, String> tuple2 = x0$6;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        this.hiveTable$4.setProperty(k, v);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            table.comment().foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(String c) {
                    this.hiveTable$4.setProperty("comment", c);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            table.viewText().foreach((Function1)new Serializable(hiveTable){
                public static final long serialVersionUID = 0L;
                private final Table hiveTable$4;

                public final void apply(String t) {
                    this.hiveTable$4.setViewOriginalText(t);
                    this.hiveTable$4.setViewExpandedText(t);
                }
                {
                    this.hiveTable$4 = hiveTable$4;
                }
            });
            Option option = table.bucketSpec();
            if (option instanceof Some) {
                Some some = (Some)option;
                BucketSpec bucketSpec = (BucketSpec)some.x();
                if (DDLUtils$.MODULE$.isHiveTable(table)) {
                    BoxedUnit boxedUnit;
                    hiveTable.setNumBuckets(bucketSpec.numBuckets());
                    hiveTable.setBucketCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bucketSpec.bucketColumnNames().toList()).asJava());
                    if (bucketSpec.sortColumnNames().nonEmpty()) {
                        hiveTable.setSortCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)bucketSpec.sortColumnNames().map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Order apply(String col) {
                                return new Order(col, BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toList()).asJava());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return var3_3;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return var3_3;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown table type is found at toHiveTable: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogTableType})));
    }

    public Option<String> toHiveTable$default$2() {
        return None$.MODULE$;
    }

    public Partition toHivePartition(CatalogTablePartition p, Table ht) {
        org.apache.hadoop.hive.metastore.api.Partition tpart = new org.apache.hadoop.hive.metastore.api.Partition();
        Buffer partValues = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ht.getPartCols()).asScala()).map((Function1)new Serializable(p){
            public static final long serialVersionUID = 0L;
            public final CatalogTablePartition p$1;

            public final String apply(FieldSchema hc) {
                return (String)this.p$1.spec().get((Object)hc.getName()).getOrElse((Function0)new Serializable(this, hc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.27 $outer;
                    private final FieldSchema hc$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec is missing a value for column '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hc$1.getName(), this.$outer.p$1.spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hc$1 = hc$1;
                    }
                });
            }
            {
                this.p$1 = p$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        StorageDescriptor storageDesc = new StorageDescriptor();
        SerDeInfo serdeInfo = new SerDeInfo();
        p.storage().locationUri().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URI x$18) {
                return CatalogUtils$.MODULE$.URIToString(x$18);
            }
        }).foreach((Function1)new Serializable(storageDesc){
            public static final long serialVersionUID = 0L;
            private final StorageDescriptor storageDesc$1;

            public final void apply(String x$1) {
                this.storageDesc$1.setLocation(x$1);
            }
            {
                this.storageDesc$1 = storageDesc$1;
            }
        });
        p.storage().inputFormat().foreach((Function1)new Serializable(storageDesc){
            public static final long serialVersionUID = 0L;
            private final StorageDescriptor storageDesc$1;

            public final void apply(String x$1) {
                this.storageDesc$1.setInputFormat(x$1);
            }
            {
                this.storageDesc$1 = storageDesc$1;
            }
        });
        p.storage().outputFormat().foreach((Function1)new Serializable(storageDesc){
            public static final long serialVersionUID = 0L;
            private final StorageDescriptor storageDesc$1;

            public final void apply(String x$1) {
                this.storageDesc$1.setOutputFormat(x$1);
            }
            {
                this.storageDesc$1 = storageDesc$1;
            }
        });
        p.storage().serde().foreach((Function1)new Serializable(serdeInfo){
            public static final long serialVersionUID = 0L;
            private final SerDeInfo serdeInfo$1;

            public final void apply(String x$1) {
                this.serdeInfo$1.setSerializationLib(x$1);
            }
            {
                this.serdeInfo$1 = serdeInfo$1;
            }
        });
        serdeInfo.setParameters((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)p.storage().properties()).asJava());
        storageDesc.setSerdeInfo(serdeInfo);
        tpart.setDbName(ht.getDbName());
        tpart.setTableName(ht.getTableName());
        tpart.setValues((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partValues).asJava());
        tpart.setSd(storageDesc);
        tpart.setCreateTime((int)(p.createTime() / 1000L));
        tpart.setLastAccessTime((int)(p.lastAccessTime() / 1000L));
        tpart.setParameters((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply(p.parameters().toSeq())).asJava());
        return new Partition(ht, tpart);
    }

    public CatalogTablePartition fromHivePartition(Partition hp) {
        org.apache.hadoop.hive.metastore.api.Partition apiPartition = hp.getTPartition();
        scala.collection.immutable.Map properties = hp.getParameters() == null ? Predef$.MODULE$.Map().empty() : ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(hp.getParameters()).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map x$64 = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)hp.getSpec()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(LinkedHashMap<String, String> x$19) {
                return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$19).asScala()).toMap(Predef$.MODULE$.$conforms());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        CatalogStorageFormat x$65 = new CatalogStorageFormat(Option$.MODULE$.apply((Object)CatalogUtils$.MODULE$.stringToURI(apiPartition.getSd().getLocation())), Option$.MODULE$.apply((Object)apiPartition.getSd().getInputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getOutputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getSerializationLib()), apiPartition.getSd().isCompressed(), (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getParameters()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(java.util.Map<String, String> x$20) {
                return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$20).asScala()).toMap(Predef$.MODULE$.$conforms());
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        long x$66 = (long)apiPartition.getCreateTime() * 1000L;
        long x$67 = (long)apiPartition.getLastAccessTime() * 1000L;
        scala.collection.immutable.Map x$68 = properties;
        Option<CatalogStatistics> x$69 = this.org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats((scala.collection.immutable.Map<String, String>)properties);
        return new CatalogTablePartition(x$64, x$65, x$68, x$66, x$67, x$69);
    }

    public Option<CatalogStatistics> org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats(scala.collection.immutable.Map<String, String> properties) {
        Option totalSize = properties.get((Object)"totalSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(String x$21) {
                return package$.MODULE$.BigInt().apply(x$21);
            }
        });
        Option rawDataSize = properties.get((Object)"rawDataSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(String x$22) {
                return package$.MODULE$.BigInt().apply(x$22);
            }
        });
        Option rowCount = properties.get((Object)"numRows").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(String x$23) {
                return package$.MODULE$.BigInt().apply(x$23);
            }
        });
        return totalSize.isDefined() && ((BigInt)totalSize.get()).$greater(BigInt$.MODULE$.long2bigInt(0L)) ? new Some((Object)new CatalogStatistics((BigInt)totalSize.get(), rowCount.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BigInt x$24) {
                return x$24.$greater(BigInt$.MODULE$.int2bigInt(0));
            }
        }), CatalogStatistics$.MODULE$.apply$default$3())) : (rawDataSize.isDefined() && ((BigInt)rawDataSize.get()).$greater(BigInt$.MODULE$.int2bigInt(0)) ? new Some((Object)new CatalogStatistics((BigInt)rawDataSize.get(), rowCount.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BigInt x$25) {
                return x$25.$greater(BigInt$.MODULE$.int2bigInt(0));
            }
        }), CatalogStatistics$.MODULE$.apply$default$3())) : None$.MODULE$);
    }

    public Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties() {
        return this.org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;
    }

    private HiveClientImpl$() {
        MODULE$ = this;
        this.org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COLUMN_STATS_ACCURATE", "numFiles", "numPartitions", "numRows", "rawDataSize", "totalSize"}));
    }
}

