/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class OrcFileOperator$
implements Logging {
    public static OrcFileOperator$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcFileOperator$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<Reader> getFileReader(String basePath, Option<Configuration> config, boolean ignoreCorruptFiles) {
        Configuration conf = (Configuration)config.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Configuration());
        Path hdfsPath = new Path(basePath);
        FileSystem fs = hdfsPath.getFileSystem(conf);
        return this.listOrcFiles(basePath, conf).iterator().map((Function1 & Serializable & scala.Serializable)path -> {
            Some some;
            try {
                some = new Some((Object)OrcFile.createReader((FileSystem)fs, (Path)path));
            }
            catch (IOException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(path).toString(), e);
                    some = None$.MODULE$;
                }
                throw new SparkException(new StringBuilder(32).append("Could not read footer for file: ").append(path).toString(), (Throwable)e);
            }
            Some reader = some;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path), (Object)reader);
        }).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Path, Option<Reader>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    Reader reader;
                    Path path = (Path)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader = (Reader)(some = (Some)option).value())) {
                        object = reader;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Path, Option<Reader>> x1) {
                Tuple2<Path, Option<Reader>> tuple2 = x1;
                if (tuple2 == null) return false;
                Path path = (Path)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return false;
                Some some = (Some)option;
                Reader reader = (Reader)some.value();
                if (!OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader)) return false;
                return true;
            }
        });
    }

    public Option<Configuration> getFileReader$default$2() {
        return None$.MODULE$;
    }

    public boolean getFileReader$default$3() {
        return false;
    }

    public Option<StructType> readSchema(Seq<String> paths, Option<Configuration> conf, boolean ignoreCorruptFiles) {
        return paths.toIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.getFileReader((String)x$1, conf, ignoreCorruptFiles)).collectFirst((PartialFunction)new scala.Serializable(paths){
            public static final long serialVersionUID = 0L;
            private final Seq paths$1;

            public final <A1 extends Option<Reader>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Reader reader = (Reader)some.value();
                    StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
                    String schema = readerInspector.getTypeName();
                    OrcFileOperator$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reading schema from file ").append($this.paths$1).append(", got Hive schema string: ").append(schema).toString());
                    object = (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Reader> x1) {
                Option<Reader> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
            {
                this.paths$1 = paths$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.hive.orc.OrcFileOperator$$anonfun$readSchema$2 java.lang.String )}, serializedLambda);
            }
        });
    }

    public Option<StructObjectInspector> getObjectInspector(String path, Option<Configuration> conf) {
        return this.getFileReader(path, conf, this.getFileReader$default$3()).map((Function1 & Serializable & scala.Serializable)x$2 -> (StructObjectInspector)x$2.getObjectInspector());
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)OrcFileOperator$.$anonfun$listOrcFiles$3(x$5)))).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OrcFileOperator$.$anonfun$listOrcFiles$4(x$6)));
        return paths;
    }

    public final boolean org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(Path path, Reader reader) {
        boolean bl;
        StructObjectInspector structObjectInspector;
        ObjectInspector objectInspector = reader.getObjectInspector();
        if (objectInspector instanceof StructObjectInspector && (structObjectInspector = (StructObjectInspector)objectInspector).getAllStructFieldRefs().size() == 0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("ORC file ").append(path).append(" has empty schema, it probably contains no rows. ").append("Trying to read another ORC file to figure out the schema.").toString());
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$3(Path x$5) {
        return x$5.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$4(Path x$6) {
        return x$6.getName().startsWith(".");
    }

    private OrcFileOperator$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

