/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class OrcFilters$
implements Logging {
    public static OrcFilters$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcFilters$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<SearchArgument> createFilter(StructType schema, Filter[] filters) {
        Map dataTypeMap = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Filter[] convertibleFilters = (Filter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).flatMap((Function1 & Serializable & scala.Serializable)filter -> Option$.MODULE$.option2Iterable(MODULE$.buildSearchArgument((Map<String, DataType>)dataTypeMap, (Filter)filter, SearchArgumentFactory.newBuilder()).map((Function1 & Serializable & scala.Serializable)_ -> filter)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Filter.class)));
        return org.apache.spark.sql.execution.datasources.orc.OrcFilters$.MODULE$.buildTree((Seq)Predef$.MODULE$.wrapRefArray((Object[])convertibleFilters)).flatMap((Function1 & Serializable & scala.Serializable)conjunction -> MODULE$.buildSearchArgument((Map<String, DataType>)dataTypeMap, (Filter)conjunction, SearchArgumentFactory.newBuilder()).map((Function1 & Serializable & scala.Serializable)builder -> builder.build()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<SearchArgument.Builder> buildSearchArgument(Map<String, DataType> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        IsNotNull isNotNull;
        String attribute;
        IsNull isNull;
        String attribute2;
        Filter filter = expression;
        if (filter instanceof And) {
            And and = (And)filter;
            Filter left = and.left();
            Filter right = and.right();
            return this.buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.buildSearchArgument(dataTypeMap, right, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, left, builder.startAnd()).flatMap((Function1 & Serializable & scala.Serializable)lhs -> MODULE$.buildSearchArgument(dataTypeMap, right, (SearchArgument.Builder)lhs).map((Function1 & Serializable & scala.Serializable)rhs -> rhs.end()))));
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter left = or.left();
            Filter right = or.right();
            return this.buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.buildSearchArgument(dataTypeMap, right, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, left, builder.startOr()).flatMap((Function1 & Serializable & scala.Serializable)lhs -> MODULE$.buildSearchArgument(dataTypeMap, right, (SearchArgument.Builder)lhs).map((Function1 & Serializable & scala.Serializable)rhs -> rhs.end()))));
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter child = not.child();
            return this.buildSearchArgument(dataTypeMap, child, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, child, builder.startNot()).map((Function1 & Serializable & scala.Serializable)negate -> negate.end()));
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attribute3 = equalTo.attribute();
            Object value = equalTo.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute3))) {
                return new Some((Object)builder.startAnd().equals(attribute3, value).end());
            }
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attribute4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute4))) {
                return new Some((Object)builder.startAnd().nullSafeEquals(attribute4, value).end());
            }
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attribute5 = lessThan.attribute();
            Object value = lessThan.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute5))) {
                return new Some((Object)builder.startAnd().lessThan(attribute5, value).end());
            }
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attribute6 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute6))) {
                return new Some((Object)builder.startAnd().lessThanEquals(attribute6, value).end());
            }
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attribute7 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute7))) {
                return new Some((Object)builder.startNot().lessThanEquals(attribute7, value).end());
            }
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attribute8 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute8))) {
                return new Some((Object)builder.startNot().lessThan(attribute8, value).end());
            }
        }
        if (filter instanceof IsNull && OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)(attribute2 = (isNull = (IsNull)filter).attribute())))) {
            return new Some((Object)builder.startAnd().isNull(attribute2).end());
        }
        if (filter instanceof IsNotNull && OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)(attribute = (isNotNull = (IsNotNull)filter).attribute())))) {
            return new Some((Object)builder.startNot().isNull(attribute).end());
        }
        if (!(filter instanceof In)) return None$.MODULE$;
        In in = (In)filter;
        String attribute9 = in.attribute();
        Object[] values = in.values();
        if (!OrcFilters$.isSearchableType$1((DataType)dataTypeMap.apply((Object)attribute9))) return None$.MODULE$;
        return new Some((Object)builder.startAnd().in(attribute9, (Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()))).end());
    }

    private static final boolean isSearchableType$1(DataType dataType) {
        boolean bl;
        boolean bl2;
        DataType dataType2 = dataType;
        boolean bl3 = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)));
        boolean bl4 = bl3 ? true : ((bl2 = IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (StringType$.MODULE$.equals(dataType2) ? true : BooleanType$.MODULE$.equals(dataType2)))) ? true : (bl = TimestampType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DecimalType));
        return bl4;
    }

    private OrcFilters$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

