/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u0013&\u0001IB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006/\u0002!\t\u0005\u0017\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u00191\u0007\u0001)A\u0005?\"9q\r\u0001b\u0001\n\u0013A\u0007BB5\u0001A\u0003%a\tC\u0004k\u0001\t\u0007I\u0011\u00025\t\r-\u0004\u0001\u0015!\u0003G\u0011\u001da\u0007A1A\u0005\n5Da!\u001d\u0001!\u0002\u0013q\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003u\u0011!\t\u0019\u0001\u0001b\u0001\n\u0013\u0019\bbBA\u0003\u0001\u0001\u0006I\u0001\u001e\u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0005\u0001A\u0003%\u00111\u0002\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u00033\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0007\u0001A\u0003%\u00111\u0002\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"a\n\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003WA\u0001\"!\u000f\u0001A\u0003%\u0011Q\u0006\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002F\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0003bCA'\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u007fAq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002^\u0001!I!a\u0018\t\r\u0005E\u0004\u0001\"\u0011Y\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!a\u001d\u0001\t\u0013\t9\u000bC\u0004\u0002t\u0001!I!a0\t\u000f\u0005M\u0004\u0001\"\u0003\u0002P\nY\u0002*\u001b<f!\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;fe&twmU;ji\u0016T!AJ\u0014\u0002\r\rd\u0017.\u001a8u\u0015\tA\u0013&\u0001\u0003iSZ,'B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011\u0003\u0002\u00014ou\u0002\"\u0001N\u001b\u000e\u0003\u0015J!AN\u0013\u0003!!Kg/\u001a,feNLwN\\*vSR,\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e0\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002=s\t\t\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018\t\u001c7\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015!\u00029mC:\u001c(B\u0001\"*\u0003!\u0019\u0017\r^1msN$\u0018B\u0001#@\u0005%\u0019\u0016\u000b\u0014%fYB,'/A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005\u001d\u0003fB\u0001%O!\tIE*D\u0001K\u0015\tY\u0015'\u0001\u0004=e>|GO\u0010\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\nT\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P\u0019\u00061A(\u001b8jiz\"\"!\u0016,\u0011\u0005Q\u0002\u0001\"B#\u0003\u0001\u00041\u0015A\u00032fM>\u0014X-R1dQR\t\u0011\f\u0005\u0002[76\tA*\u0003\u0002]\u0019\n!QK\\5u\u0003=!(/\u001f#je\u0016\u001cGoU9m\u0017\u0016LX#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002RC\u0006\u0001BO]=ESJ,7\r^*rY.+\u0017\u0010I\u0001\fM\u0006dGNY1dW.+\u00170F\u0001G\u000311\u0017\r\u001c7cC\u000e\\7*Z=!\u0003M\u0001(/\u001e8j]\u001e4\u0015m\u001d;GC2d'-Y2l\u0003Q\u0001(/\u001e8j]\u001e4\u0015m\u001d;GC2d'-Y2lA\u0005\u0001B-\u001a4bk2$\b+\u0019:uSRLwN\\\u000b\u0002]B\u0019!l\\0\n\u0005Ad%AB(qi&|g.A\teK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]\u0002\nq\u0001Z:WC2,X-F\u0001u!\t)XP\u0004\u0002ww6\tqO\u0003\u0002ys\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003u2\u000b!bY8mY\u0016\u001cG/[8o\u0013\tax/A\u0003SC:<W-\u0003\u0002\u007f\u007f\nI\u0011J\\2mkNLg/\u001a\u0006\u0003y^\f\u0001\u0002Z:WC2,X\rI\u0001\u0007QZ\u000bG.^3\u0002\u000f!4\u0016\r\\;fA\u0005Q1\r[;oWZ\u000bG.^3\u0016\u0005\u0005-\u0001#BA\u0007\u0003\u001fyV\"A=\n\u0007\u0005E\u0011PA\u0002TKF\f1b\u00195v].4\u0016\r\\;fA\u0005IA-\u0019;f-\u0006dW/Z\u0001\u000bI\u0006$XMV1mk\u0016\u0004\u0013\u0001\u00043bi\u0016\u001cFO\u001d,bYV,\u0017!\u00043bi\u0016\u001cFO\u001d,bYV,\u0007%\u0001\nuKN$\b+\u0019:uSRLwN\\\"pk:$XCAA\u0011!\rQ\u00161E\u0005\u0004\u0003Ka%aA%oi\u0006\u0019B/Z:u!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005i1\u000f^8sC\u001e,gi\u001c:nCR,\"!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rB\u0003\u001d\u0019\u0017\r^1m_\u001eLA!a\u000e\u00022\t!2)\u0019;bY><7\u000b^8sC\u001e,gi\u001c:nCR\fab\u001d;pe\u0006<WMR8s[\u0006$\b%\u0001\fdY&,g\u000e^,ji\"|W\u000f\u001e#je\u0016\u001cGoU9m+\t\ty\u0004E\u00025\u0003\u0003J1!a\u0011&\u0005)A\u0015N^3DY&,g\u000e^\u0001\u001bG2LWM\u001c;XSRDw.\u001e;ESJ,7\r^*rY~#S-\u001d\u000b\u00043\u0006%\u0003\"CA&7\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u0018G2LWM\u001c;XSRDw.\u001e;ESJ,7\r^*rY\u0002\nA!\u001b8jiR!\u0011qHA*\u0011\u001d\t)&\ba\u0001\u0003/\nA\u0002\u001e:z\t&\u0014Xm\u0019;Tc2\u00042AWA-\u0013\r\tY\u0006\u0014\u0002\b\u0005>|G.Z1o\u0003\u0011\tG\u000f\u001e:\u0015\t\u0005\u0005\u0014Q\u000e\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM!\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003W\n)GA\u0005BiR\u0014\u0018NY;uK\"1\u0011q\u000e\u0010A\u0002\u0019\u000bAA\\1nK\u0006I!-\u001a4pe\u0016\fE\u000e\\\u0001 i\u0016\u001cH/T3uCN$xN]3QCJ$\u0018\u000e^5p]\u001aKG\u000e^3sS:<G#D-\u0002x\u0005\u0005\u0015QSAM\u0003?\u000b\u0019\u000bC\u0004\u0002z\u0001\u0002\r!a\u001f\u0002\u0015\u0019LG\u000e^3s\u000bb\u0004(\u000f\u0005\u0003\u0002d\u0005u\u0014\u0002BA@\u0003K\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t\u0019\t\ta\u0001\u0003\u000b\u000b!\"\u001a=qK\u000e$X\r\u001a#t!\u0019\t9)!%\u0002\"9!\u0011\u0011RAG\u001d\rI\u00151R\u0005\u0002\u001b&\u0019\u0011q\u0012'\u0002\u000fA\f7m[1hK&!\u0011\u0011CAJ\u0015\r\ty\t\u0014\u0005\b\u0003/\u0003\u0003\u0019AAC\u0003%)\u0007\u0010]3di\u0016$\u0007\nC\u0004\u0002\u001c\u0002\u0002\r!!(\u0002\u001d\u0015D\b/Z2uK\u0012\u001c\u0005.\u001e8lgB)\u0011qQAI\r\"9\u0011\u0011\u0015\u0011A\u0002\u0005u\u0015!C3ya\u0016\u001cG/\u001a3E\u0011\u001d\t)\u000b\ta\u0001\u0003;\u000bq\"\u001a=qK\u000e$X\r\u001a#bi\u0016\u001cHO\u001d\u000b\u00103\u0006%\u00161VAW\u0003_\u000b\t,a-\u00026\"9\u0011\u0011P\u0011A\u0002\u0005m\u0004bBABC\u0001\u0007\u0011Q\u0011\u0005\b\u0003/\u000b\u0003\u0019AAC\u0011\u001d\tY*\ta\u0001\u0003;Cq!!)\"\u0001\u0004\ti\nC\u0004\u0002&\u0006\u0002\r!!(\t\u000f\u0005]\u0016\u00051\u0001\u0002:\u0006IAO]1og\u001a|'/\u001c\t\b5\u0006m\u00161PA>\u0013\r\ti\f\u0014\u0002\n\rVt7\r^5p]F\"R!WAa\u0003\u0007Dq!!\u001f#\u0001\u0004\tY\bC\u0004\u0002F\n\u0002\r!a2\u0002-\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gnQ;cKN\u0004b!a\"\u0002\u0012\u0006%\u0007#\u0004.\u0002L\u0006\u0015\u0015QQAO\u0003;\u000bi*C\u0002\u0002N2\u0013a\u0001V;qY\u0016,DcB-\u0002R\u0006M\u0017Q\u001b\u0005\b\u0003s\u001a\u0003\u0019AA>\u0011\u001d\t)m\ta\u0001\u0003\u000fDq!a.$\u0001\u0004\tI\f")
public class HivePartitionFilteringSuite
extends HiveVersionSuite
implements SQLHelper {
    private final String tryDirectSqlKey;
    private final String fallbackKey;
    private final String pruningFastFallback;
    private final Option<String> defaultPartition;
    private final Range.Inclusive dsValue;
    private final Range.Inclusive hValue;
    private final Seq<String> chunkValue;
    private final Seq<String> dateValue;
    private final Seq<String> dateStrValue;
    private final int testPartitionCount;
    private final CatalogStorageFormat storageFormat;
    private HiveClient clientWithoutDirectSql;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        HivePartitionFilteringSuite hivePartitionFilteringSuite = this;
        synchronized (hivePartitionFilteringSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        System.gc();
    }

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private String fallbackKey() {
        return this.fallbackKey;
    }

    private String pruningFastFallback() {
        return this.pruningFastFallback;
    }

    private Option<String> defaultPartition() {
        return this.defaultPartition;
    }

    private Range.Inclusive dsValue() {
        return this.dsValue;
    }

    private Range.Inclusive hValue() {
        return this.hValue;
    }

    private Seq<String> chunkValue() {
        return this.chunkValue;
    }

    private Seq<String> dateValue() {
        return this.dateValue;
    }

    private Seq<String> dateStrValue() {
        return this.dateStrValue;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    private HiveClient clientWithoutDirectSql() {
        return this.clientWithoutDirectSql;
    }

    private void clientWithoutDirectSql_$eq(HiveClient x$1) {
        this.clientWithoutDirectSql = x$1;
    }

    private HiveClient init(boolean tryDirectSql) {
        IndexedSeq partitions;
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir().toURI().toString());
        HiveClient client = this.buildClient(hadoopConf);
        StructType tableSchema = new StructType().add("value", "int").add("ds", "int").add("h", "int").add("chunk", "string").add("d", "date").add("datestr", "string");
        TableIdentifier x$1 = TableIdentifier$.MODULE$.apply("test", (Option)new Some((Object)"default"));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = tableSchema;
        Seq x$4 = (Seq)new .colon.colon((Object)"ds", (List)new .colon.colon((Object)"h", (List)new .colon.colon((Object)"chunk", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"datestr", (List)Nil$.MODULE$)))));
        CatalogStorageFormat x$5 = this.storageFormat();
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable table = new CatalogTable(x$1, x$2, x$5, x$3, x$6, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        client.createTable(table, false);
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)this.dsValue().flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$init$1(this, BoxesRunTime.unboxToInt((Object)ds)), IndexedSeq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        client.createPartitions("default", "test", (Seq)partitions, false);
        return client;
    }

    private Attribute attr(String name) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields())).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HivePartitionFilteringSuite.$anonfun$attr$1(name, field)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField field2 = (StructField)some.value();
            String x$1 = field2.name();
            DataType x$2 = field2.dataType();
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
            return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        }
        if (None$.MODULE$.equals(option)) {
            throw this.fail(new StringBuilder(37).append("Illegal name of partition attribute: ").append(name).toString(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }
        throw new MatchError((Object)option);
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
        this.clientWithoutDirectSql_$eq(this.init(false));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Function1<Expression, Expression> transform) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)((Expression)transform.apply((Object)filterExpr)), (List)Nil$.MODULE$));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple5 tuple5 = x0$2;
            if (tuple5 != null) {
                Seq expectedDs = (Seq)tuple5._1();
                Seq expectedH = (Seq)tuple5._2();
                Seq expectedChunks = (Seq)tuple5._3();
                Seq expectedD = (Seq)tuple5._4();
                Seq expectedDatestr = (Seq)tuple5._5();
                return (Seq)expectedDs.flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, expectedD, expectedDatestr, BoxesRunTime.unboxToInt((Object)ds)), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple5);
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> (Seq)x$18.$plus$plus((GenTraversableOnce)x$19, Seq$.MODULE$.canBuildFrom()));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Expected ").append(expectedPartitionCount).append(" partitions but got ").append(actualFilteredPartitionCount).toString(), Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        Set $org_scalatest_assert_macro_left2 = ((TraversableOnce)filteredPartitions.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.spec().toSet(), Seq$.MODULE$.canBuildFrom())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(HivePartitionFilteringSuite $this, int ds$1, int h) {
        return (Seq)$this.chunkValue().flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)$this.dateValue().flatMap((Function1 & Serializable & scala.Serializable)date -> (Seq)$this.dateStrValue().map((Function1 & Serializable & scala.Serializable)dateStr -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), dateStr)})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(HivePartitionFilteringSuite $this, int ds) {
        return (IndexedSeq)$this.hValue().flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$init$2($this, ds, BoxesRunTime.unboxToInt((Object)h)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    private final void check$1(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)result, this.dateValue(), this.dateStrValue());
    }

    private final void check$2(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)result, this.dateStrValue());
    }

    public static final /* synthetic */ void $anonfun$new$66(HivePartitionFilteringSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String pruningFastFallbackEnabled = (String)tuple2._1();
            Seq prunedPartition = (Seq)tuple2._2();
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)$this.attr("datestr")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20200104)), (Seq<Object>)$this.dsValue(), (Seq<Object>)$this.hValue(), $this.chunkValue(), $this.dateValue(), (Seq<String>)prunedPartition));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple5 x0$1) {
        Tuple5 tuple5 = x0$1;
        if (tuple5 != null) {
            Seq expectedDs = (Seq)tuple5._1();
            Seq expectedH = (Seq)tuple5._2();
            Seq expectedChunks = (Seq)tuple5._3();
            Seq expectedD = (Seq)tuple5._4();
            Seq expectedDatestr = (Seq)tuple5._5();
            return expectedDs.size() * expectedH.size() * expectedChunks.size() * expectedD.size() * expectedDatestr.size();
        }
        throw new MatchError((Object)tuple5);
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)expectedD$1.flatMap((Function1 & Serializable & scala.Serializable)d -> (Seq)expectedDatestr$1.map((Function1 & Serializable & scala.Serializable)datestr -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), d), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), datestr)})), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, expectedD$1, expectedDatestr$1, ds, BoxesRunTime.unboxToInt((Object)h)), Seq$.MODULE$.canBuildFrom());
    }

    public HivePartitionFilteringSuite(String version) {
        super(version);
        SQLHelper.$init$((SQLHelper)this);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.fallbackKey = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key();
        this.pruningFastFallback = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FAST_FALLBACK().key();
        this.defaultPartition = new StringOps(Predef$.MODULE$.augmentString(version)).$greater$eq((Object)"2.0") ? new Some((Object)ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME()) : None$.MODULE$;
        this.dsValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103);
        this.hValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4);
        this.chunkValue = (Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))));
        this.dateValue = (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.defaultPartition()), Seq$.MODULE$.canBuildFrom());
        this.dateStrValue = (Seq)new .colon.colon((Object)"2020-01-01", (List)new .colon.colon((Object)"2020-01-02", (List)new .colon.colon((Object)"2020-01-03", (List)new .colon.colon((Object)"20200104", (List)new .colon.colon((Object)"20200105", (List)Nil$.MODULE$)))));
        this.testPartitionCount = this.dsValue().size() * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        this.test(new StringBuilder(55).append("getPartitionsByFilter returns all partitions when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test(new StringBuilder(45).append("getPartitionsByFilter should fail when ").append(this.fallbackKey()).append("=false").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Caught Hive MetaException";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 0), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("getPartitionsByFilter: ds=20170101 and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof In) {
                In in = (In)expression;
                Expression v = in.value();
                Seq list = in.list();
                if (in.inSetConvertible()) {
                    return new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                }
            }
            throw new MatchError((Object)expression);
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
            Expression expression = x0$2;
            if (expression instanceof In) {
                In in = (In)expression;
                Expression v = in.value();
                Seq list = in.list();
                if (in.inSetConvertible()) {
                    return new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                }
            }
            throw new MatchError((Object)expression);
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                Expression expression = x0$3;
                if (expression instanceof In) {
                    In in = (In)expression;
                    Expression v = in.value();
                    Seq list = in.list();
                    if (in.inSetConvertible()) {
                        return new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                    }
                }
                throw new MatchError((Object)expression);
            });
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<2)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<(1+1))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=2) or (ds=20170102 and h<2))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("getPartitionsByFilter: chunk contains bb", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).contains((Expression)package.expressions$.MODULE$.stringToLiteral("bb")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("getPartitionsByFilter: chunk startsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("getPartitionsByFilter: chunk endsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).endsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("getPartitionsByFilter: ds<>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("getPartitionsByFilter: h<>0 and chunk<>ab and d<>2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$bang$eq((Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4), (Seq<String>)((Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)))), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("getPartitionsByFilter: d=2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("getPartitionsByFilter: d>2019-01-02", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-02"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        this.test("getPartitionsByFilter: In(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new In((Expression)this.attr("d"), (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)), Seq$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("getPartitionsByFilter: InSet(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new InSet((Expression)this.attr("d"), (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)).eval(package$.MODULE$.EmptyRow()), Set$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        this.test("getPartitionsByFilter: not in/inset string type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.chunkValue());
            Object[] objectArray = new Object[2];
            Literal qual$1 = Literal$.MODULE$.apply((Object)"aa");
            InternalRow x$1 = qual$1.eval$default$1();
            objectArray[0] = qual$1.eval(x$1);
            Literal qual$2 = Literal$.MODULE$.apply((Object)"ab");
            InternalRow x$2 = qual$2.eval$default$1();
            objectArray[1] = qual$2.eval(x$2);
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aa", "ab", null})))), this.chunkValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        this.test("getPartitionsByFilter: not in/inset date type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.dateValue());
            Object[] objectArray = new Object[2];
            Literal qual$3 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$3 = qual$3.eval$default$1();
            objectArray[0] = qual$3.eval(x$3);
            Literal qual$4 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$4 = qual$4.eval$default$1();
            objectArray[1] = qual$4.eval(x$4);
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            Object[] objectArray2 = new Object[3];
            Literal qual$5 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$5 = qual$5.eval$default$1();
            objectArray2[0] = qual$5.eval(x$5);
            Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$6 = qual$6.eval$default$1();
            objectArray2[1] = qual$6.eval(x$6);
            objectArray2[2] = null;
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2)))), this.dateValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.test("getPartitionsByFilter: cast(datestr as date)= 2020-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)filterExpr, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL with other filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)filterExpr).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        this.test("getPartitionsByFilter: d =!= 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        this.test("getPartitionsByFilter: d =!= 2019-01-01 || IS NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull()), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        this.test("getPartitionsByFilter: d <=> 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("getPartitionsByFilter: d <=> null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)new Literal(null, (DataType)DateType$.MODULE$)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        this.test("SPARK-35437: getPartitionsByFilter: substr(chunk,0,1)=a", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.chunkValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)this.attr("chunk"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)t._2()), this.dateValue(), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        this.test("SPARK-35437: getPartitionsByFilter: year(d)=2019", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)this.attr("d"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2019)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)t._2()), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        this.test("SPARK-35437: getPartitionsByFilter: datestr=concat(2020-,01-,01)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2020-01-01", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateStrValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).$eq$eq$eq((Expression)new Concat((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("2020-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01"), (List)Nil$.MODULE$))))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), (Seq<String>)((Seq)t._2())));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test(new StringBuilder(58).append("SPARK-35437: getPartitionsByFilter: ds=20170101 when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 1 * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        this.test("SPARK-35437: getPartitionsByFilter: relax cast if does not need timezone", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            if (!SQLConf$.MODULE$.get().ansiEnabled()) {
                String string = "20200104";
                ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"true", (Object)Nil$.MODULE$.$colon$colon((Object)string)), (List)new .colon.colon((Object)new Tuple2((Object)"false", this.dateStrValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    HivePartitionFilteringSuite.$anonfun$new$66(this, x0$4);
                    return BoxedUnit.UNIT;
                });
                ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)pruningFastFallbackEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
    }
}

