/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.apache.spark.sql.hive.test.TestHiveSessionStateBuilder;
import org.apache.spark.sql.hive.test.TestHiveSharedState;
import org.apache.spark.sql.hive.test.TestHiveSharedState$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession$TestTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\rh!\u0002 @\u0001\u0005[\u0005\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011\u0002-\t\u0011u\u0003!\u0011!Q\u0001\neC\u0001\"\u001a\u0001\u0003\u0006\u0004%IA\u001a\u0005\t]\u0002\u0011\t\u0011)A\u0005O\"A\u0001\u000f\u0001BC\u0002\u0013%\u0011\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003s\u0011!Q\bA!b\u0001\n\u0013Y\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005=\u0001bBA\u0001\u0001\u0011\u0005\u0011Q\u0003\u0005\u000b\u0003W\u0001\u0001R1A\u0005B\u00055\u0002BCA\u0019\u0001!\u0015\r\u0011\"\u0011\u00024!Q\u0011q\u0007\u0001\t\u0006\u0004%\t!!\u000f\t\r\u0011\u0003A\u0011IA\u001e\u0011\u001d\t)\b\u0001C!\u0003oBq!!\u001f\u0001\t\u0003\nY\b\u0003\u0005\u0002~\u0001\u0001\r\u0011\"\u0003|\u0011%\ty\b\u0001a\u0001\n\u0013\t\t\tC\u0004\u0002\u000e\u0002\u0001\u000b\u0015\u0002?\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"Q\u0011q\u0013\u0001\t\u0006\u0004%\t!!'\t\u0015\u00055\u0006\u0001#b\u0001\n\u0003\tI\nC\u0004\u00020\u0002!I!!-\t\u0013\u0005]\u0006A1A\u0005\u0002\u0005e\u0006\u0002CA^\u0001\u0001\u0006I!!(\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\n\u00033\u0004!\u0019!C\u0001\u00037D\u0001\"!<\u0001A\u0003%\u0011Q\u001c\u0004\u0007\u0003_\u0004\u0001)!=\t\u0015\t\u0015\u0001E!f\u0001\n\u0003\u00119\u0001\u0003\u0006\u0003\n\u0001\u0012\t\u0012)A\u0005\u0003KB!Ba\u0003!\u0005+\u0007I\u0011\u0001B\u0007\u0011)\u0011Y\u0002\tB\tB\u0003%!q\u0002\u0005\b\u0003\u0003\u0001C\u0011\u0001B\u000f\u0011%\u00119\u0003IA\u0001\n\u0003\u0012I\u0003C\u0005\u0003,\u0001\n\t\u0011\"\u0001\u0003.!I!Q\u0007\u0011\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u0003\u0002\u0013\u0011!C!\u0005\u0007B\u0011B!\u0015!\u0003\u0003%\tAa\u0015\t\u0013\t]\u0003%!A\u0005B\te\u0003\"\u0003B.A\u0005\u0005I\u0011\tB/\u0011%\u0011y\u0006IA\u0001\n\u0003\u0012\tgB\u0005\u0003f\u0001\t\t\u0011#\u0001\u0003h\u0019I\u0011q\u001e\u0001\u0002\u0002#\u0005!\u0011\u000e\u0005\b\u0003\u0003yC\u0011\u0001B<\u0011%\u0011YfLA\u0001\n\u000b\u0012i\u0006C\u0005\u0003z=\n\t\u0011\"!\u0003|!I!\u0011Q\u0018\u0002\u0002\u0013\u0005%1\u0011\u0004\b\u0005C\u0003\u0011\"\u0011BR\u0011%!EG!A!\u0002\u0013\t)\u0007C\u0004\u0002\u0002Q\"\tA!*\t\u000f\t-F\u0007\"\u0001\u0003.\"Q!q\u0016\u0001\u0002\u0002\u0013M\u0011I!-\t\u0015\tU\u0006\u0001#b\u0001\n\u0003\u00119\fC\u0004\u0003H\u0002!\tA!3\t\u000f\t=\u0007\u0001\"\u0001\u0003R\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0002\u0015)\u0016\u001cH\u000fS5wKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u000b\u0005\u0001\u000b\u0015\u0001\u0002;fgRT!AQ\"\u0002\t!Lg/\u001a\u0006\u0003\t\u0016\u000b1a]9m\u0015\t1u)A\u0003ta\u0006\u00148N\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<7c\u0001\u0001M!B\u0011QJT\u0007\u0002\u0007&\u0011qj\u0011\u0002\r'B\f'o[*fgNLwN\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0016\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003+J\u0013q\u0001T8hO&tw-\u0001\u0002tG\u000e\u0001Q#A-\u0011\u0005i[V\"A#\n\u0005q+%\u0001D*qCJ\\7i\u001c8uKb$\u0018aA:dA!\u0012!a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\niJ\fgn]5f]R\f1#\u001a=jgRLgnZ*iCJ,Gm\u0015;bi\u0016,\u0012a\u001a\t\u0004A\"T\u0017BA5b\u0005\u0019y\u0005\u000f^5p]B\u00111\u000e\\\u0007\u0002\u007f%\u0011Qn\u0010\u0002\u0014)\u0016\u001cH\u000fS5wKNC\u0017M]3e'R\fG/Z\u0001\u0015KbL7\u000f^5oONC\u0017M]3e'R\fG/\u001a\u0011)\u0005\u0011y\u0016A\u00059be\u0016tGoU3tg&|gn\u0015;bi\u0016,\u0012A\u001d\t\u0004A\"\u001c\bC\u0001;w\u001b\u0005)(BA*D\u0013\t9XO\u0001\u0007TKN\u001c\u0018n\u001c8Ti\u0006$X-A\nqCJ,g\u000e^*fgNLwN\\*uCR,\u0007\u0005\u000b\u0002\u0007?\u0006qAn\\1e)\u0016\u001cH\u000fV1cY\u0016\u001cX#\u0001?\u0011\u0005\u0001l\u0018B\u0001@b\u0005\u001d\u0011un\u001c7fC:\fq\u0002\\8bIR+7\u000f\u001e+bE2,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002l\u0001!)a+\u0003a\u00013\")Q-\u0003a\u0001O\")\u0001/\u0003a\u0001e\")!0\u0003a\u0001yR1\u0011QAA\t\u0003'AQA\u0016\u0006A\u0002eCQA\u001f\u0006A\u0002q$\u0002\"!\u0002\u0002\u0018\u0005e\u0011\u0011\u0006\u0005\u0006-.\u0001\r!\u0017\u0005\b\u00037Y\u0001\u0019AA\u000f\u0003)A\u0017N^3DY&,g\u000e\u001e\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111E!\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t9#!\t\u0003\u0015!Kg/Z\"mS\u0016tG\u000fC\u0003{\u0017\u0001\u0007A0A\u0006tQ\u0006\u0014X\rZ*uCR,W#\u00016)\u00051y\u0016\u0001D:fgNLwN\\*uCR,W#A:)\u00055y\u0016\u0001D7fi\u0006$\u0017\r^1ISZ,WCAA\u000f)\u0011\ti$!\u0019\u0011\t\u0005}\u00121\f\b\u0005\u0003\u0003\n9F\u0004\u0003\u0002D\u0005Uc\u0002BA#\u0003'rA!a\u0012\u0002R9!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N]\u000ba\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005!K\u0015B\u0001$H\u0013\t!U)C\u0002\u0002Z\r\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002^\u0005}#!\u0003#bi\u00064%/Y7f\u0015\r\tIf\u0011\u0005\b\u0003Gz\u0001\u0019AA3\u0003\u001d\u0019\u0018\u000f\u001c+fqR\u0004B!a\u001a\u0002p9!\u0011\u0011NA6!\r\tI%Y\u0005\u0004\u0003[\n\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002r\u0005M$AB*ue&twMC\u0002\u0002n\u0005\f!B\\3x'\u0016\u001c8/[8o)\t\t)!\u0001\u0007dY>tWmU3tg&|g\u000eF\u0001M\u0003-\u0019\u0017m\u00195f)\u0006\u0014G.Z:\u0002\u001f\r\f7\r[3UC\ndWm]0%KF$B!a!\u0002\nB\u0019\u0001-!\"\n\u0007\u0005\u001d\u0015M\u0001\u0003V]&$\b\u0002CAF'\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0013'\u0001\u0007dC\u000eDW\rV1cY\u0016\u001c\b%\u0001\btKR\u001c\u0015m\u00195f)\u0006\u0014G.Z:\u0015\t\u0005\r\u00151\u0013\u0005\u0007\u0003++\u0002\u0019\u0001?\u0002\u0003\r\f\u0001\u0002[5wK\"{W.Z\u000b\u0003\u00037\u0003B\u0001\u00195\u0002\u001eB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016AA5p\u0015\t\t9+\u0001\u0003kCZ\f\u0017\u0002BAV\u0003C\u0013AAR5mK\u0006Y\u0001.\u001b<f\t\u00164\bj\\7f\u00031)gN\u001e,beR{g)\u001b7f)\u0011\tY*a-\t\u000f\u0005U\u0006\u00041\u0001\u0002f\u00051QM\u001c<WCJ\fQ\u0002[5wK\u001aKG.Z:UK6\u0004XCAAO\u00039A\u0017N^3GS2,7\u000fV3na\u0002\n1bZ3u\u0011&4XMR5mKR!\u0011QTAa\u0011\u001d\t\u0019m\u0007a\u0001\u0003K\nA\u0001]1uQ\u0006i\u0011/^8uK\"Kg/\u001a$jY\u0016$B!!3\u0002TB!\u00111ZAi\u001b\t\tiM\u0003\u0003\u0002P\u0006\u0015\u0016\u0001\u00027b]\u001eLA!!\u001d\u0002N\"9\u00111\u0019\u000fA\u0002\u0005\u0015\u0014\u0001E4fi^\u000b'/\u001a5pkN,\u0007+\u0019;i)\t\t)'\u0001\beKN\u001c'/\u001b2fIR\u000b'\r\\3\u0016\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\t[\u0006$8\r[5oO*\u0019\u0011q]1\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\f\tOA\u0003SK\u001e,\u00070A\beKN\u001c'/\u001b2fIR\u000b'\r\\3!\u0005%!Vm\u001d;UC\ndWmE\u0004!\u0003g\fI0a@\u0011\u0007\u0001\f)0C\u0002\u0002x\u0006\u0014a!\u00118z%\u00164\u0007c\u00011\u0002|&\u0019\u0011Q`1\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0001M!\u0001\n\u0007\t\r\u0011M\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003oC6,WCAA3\u0003\u0015q\u0017-\\3!\u0003!\u0019w.\\7b]\u0012\u001cXC\u0001B\b!\u0015\u0001'\u0011\u0003B\u000b\u0013\r\u0011\u0019\"\u0019\u0002\u000byI,\u0007/Z1uK\u0012t\u0004#\u00021\u0003\u0018\u0005\r\u0015b\u0001B\rC\nIa)\u001e8di&|g\u000eM\u0001\nG>lW.\u00198eg\u0002\"bAa\b\u0003$\t\u0015\u0002c\u0001B\u0011A5\t\u0001\u0001C\u0004\u0003\u0006\u0015\u0002\r!!\u001a\t\u000f\t-Q\u00051\u0001\u0003\u0010\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!3\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t=\u0002c\u00011\u00032%\u0019!1G1\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\te\"q\b\t\u0004A\nm\u0012b\u0001B\u001fC\n\u0019\u0011I\\=\t\u0013\u0005-\u0005&!AA\u0002\t=\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0003C\u0002B$\u0005\u001b\u0012I$\u0004\u0002\u0003J)\u0019!1J1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003P\t%#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001 B+\u0011%\tYIKA\u0001\u0002\u0004\u0011I$\u0001\u0005iCND7i\u001c3f)\t\u0011y#\u0001\u0005u_N#(/\u001b8h)\t\tI-\u0001\u0004fcV\fGn\u001d\u000b\u0004y\n\r\u0004\"CAF[\u0005\u0005\t\u0019\u0001B\u001d\u0003%!Vm\u001d;UC\ndW\rE\u0002\u0003\"=\u001aRa\fB6\u0003\u007f\u0004\"B!\u001c\u0003t\u0005\u0015$q\u0002B\u0010\u001b\t\u0011yGC\u0002\u0003r\u0005\fqA];oi&lW-\u0003\u0003\u0003v\t=$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!qM\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005?\u0011iHa \t\u000f\t\u0015!\u00071\u0001\u0002f!9!1\u0002\u001aA\u0002\t=\u0011AC;oCB\u0004H._*fcR!!Q\u0011BO!\u0011\u0001\u0007Na\"\u0011\u000f\u0001\u0014I)!\u001a\u0003\u000e&\u0019!1R1\u0003\rQ+\b\u000f\\33!\u0019\u0011yIa&\u0003\u00169!!\u0011\u0013BK\u001d\u0011\tIEa%\n\u0003\tL1!!\u0017b\u0013\u0011\u0011IJa'\u0003\u0007M+\u0017OC\u0002\u0002Z\u0005D\u0011Ba(4\u0003\u0003\u0005\rAa\b\u0002\u0007a$\u0003G\u0001\u0004Tc2\u001cU\u000eZ\n\u0004i\u0005MH\u0003\u0002BT\u0005S\u00032A!\t5\u0011\u0019!e\u00071\u0001\u0002f\u0005\u00191-\u001c3\u0016\u0005\tU\u0011AB*rY\u000ekG\r\u0006\u0003\u0003(\nM\u0006B\u0002#9\u0001\u0004\t)'\u0001\u0006uKN$H+\u00192mKN,\"A!/\u0011\u0011\tm&\u0011YA3\u0005?i!A!0\u000b\t\t}&\u0011J\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011\u0019M!0\u0003\u000f!\u000b7\u000f['ba\"\u0012\u0011hX\u0001\u0012e\u0016<\u0017n\u001d;feR+7\u000f\u001e+bE2,G\u0003BAB\u0005\u0017DqA!4;\u0001\u0004\u0011y\"A\u0005uKN$H+\u00192mK\u0006yq-\u001a;M_\u0006$W\r\u001a+bE2,7/\u0006\u0002\u0003TB1!1\u0018Bk\u0003KJAAa6\u0003>\n9\u0001*Y:i'\u0016$\u0018!\u00047pC\u0012$Vm\u001d;UC\ndW\r\u0006\u0003\u0002\u0004\nu\u0007b\u0002B\u0003y\u0001\u0007\u0011QM\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0003\u0003\u0007\u0003")
public class TestHiveSparkSession
extends SparkSession {
    private transient TestHiveSharedState sharedState;
    private transient SessionState sessionState;
    private HiveClient metadataHive;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private volatile TestHiveSparkSession$TestTable$ TestTable$module;
    private transient HashMap<String, TestTable> testTables;
    private final transient SparkContext sc;
    private transient Option<TestHiveSharedState> existingSharedState;
    private final transient Option<SessionState> parentSessionState;
    private final boolean loadTestTables;
    private boolean cacheTables;
    private final File hiveFilesTemp;
    private final Regex describedTable;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public TestHiveSparkSession$TestTable$ TestTable() {
        if (this.TestTable$module == null) {
            this.TestTable$lzycompute$1();
        }
        return this.TestTable$module;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private Option<TestHiveSharedState> existingSharedState() {
        return this.existingSharedState;
    }

    private Option<SessionState> parentSessionState() {
        return this.parentSessionState;
    }

    private boolean loadTestTables() {
        return this.loadTestTables;
    }

    private TestHiveSharedState sharedState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.sharedState = (TestHiveSharedState)((Object)this.existingSharedState().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TestHiveSharedState(this.sc(), TestHiveSharedState$.MODULE$.$lessinit$greater$default$2())));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        this.existingSharedState = null;
        return this.sharedState;
    }

    public TestHiveSharedState sharedState() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.sharedState$lzycompute();
        }
        return this.sharedState;
    }

    private SessionState sessionState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sessionState = new TestHiveSessionStateBuilder(this, this.parentSessionState()).build();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.sessionState;
    }

    public SessionState sessionState() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.sessionState$lzycompute();
        }
        return this.sessionState;
    }

    private HiveClient metadataHive$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataHive = ((HiveExternalCatalog)this.sharedState().externalCatalog().unwrapped()).client().newSession();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataHive;
    }

    public HiveClient metadataHive() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataHive$lzycompute();
        }
        return this.metadataHive;
    }

    public Dataset<Row> sql(String sqlText) {
        return (Dataset)this.withActive((Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = this.sessionState().sqlParser().parsePlan(sqlText);
            return Dataset$.MODULE$.ofRows((SparkSession)this, plan);
        });
    }

    public TestHiveSparkSession newSession() {
        return (TestHiveSparkSession)((Object)this.withActive((Function0 & Serializable & scala.Serializable)() -> new TestHiveSparkSession(this.sc(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)None$.MODULE$, this.loadTestTables())));
    }

    public SparkSession cloneSession() {
        return (SparkSession)this.withActive((Function0 & Serializable & scala.Serializable)() -> {
            TestHiveSparkSession result = new TestHiveSparkSession(this.sparkContext(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)new Some((Object)this.sessionState()), this.loadTestTables());
            result.sessionState();
            return result;
        });
    }

    private boolean cacheTables() {
        return this.cacheTables;
    }

    private void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void setCacheTables(boolean c) {
        this.cacheTables_$eq(c);
    }

    private Option<File> hiveHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hiveHome;
    }

    public Option<File> hiveHome() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hiveHome$lzycompute();
        }
        return this.hiveHome;
    }

    private Option<File> hiveDevHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hiveDevHome;
    }

    public Option<File> hiveDevHome() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.hiveDevHome$lzycompute();
        }
        return this.hiveDevHome;
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1));
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File getHiveFile(String path) {
        return new File(Thread.currentThread().getContextClassLoader().getResource(path).getFile());
    }

    private String quoteHiveFile(String path) {
        if (Utils$.MODULE$.isWindows()) {
            return this.getHiveFile(path).getPath().replace('\\', '/');
        }
        return this.getHiveFile(path).getPath();
    }

    public String getWarehousePath() {
        SQLConf tempConf = new SQLConf();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().conf().getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$getWarehousePath$1(tempConf, x0$1);
            return BoxedUnit.UNIT;
        });
        return tempConf.warehousePath();
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public SqlCmd SqlCmd(String sql) {
        return new SqlCmd(this, sql);
    }

    private HashMap<String, TestTable> testTables$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.testTables = new HashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.testTables;
    }

    public HashMap<String, TestTable> testTables() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.testTables$lzycompute();
        }
        return this.testTables;
    }

    public void registerTestTable(TestTable testTable) {
        this.testTables().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public HashSet<String> getLoadedTables() {
        return this.sharedState().loadedTables();
    }

    public void loadTestTable(String name) {
        if (this.sessionState().catalog().getTempView(name).isEmpty() && !this.sharedState().loadedTables().contains((Object)name)) {
            Object object;
            this.sharedState().loadedTables().$plus$eq((Object)name);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loading test table ").append(name).toString());
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.commands()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(19).append("Unknown test table ").append(name).toString()));
            if (this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY()) == null) {
                object = SQLExecution$.MODULE$.withNewExecutionId(new QueryExecution((SparkSession)this, (LogicalPlan)new OneRowRelation(), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4()), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> createCmds.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }));
            } else {
                createCmds.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
            if (this.cacheTables()) {
                new SQLContext((SparkSession)this).cacheTable(name);
                return;
            }
            return;
        }
    }

    public void reset() {
        try {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$reset$1(x0$1);
                return BoxedUnit.UNIT;
            });
            File warehouseDir = new File(new URI(this.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key())).getPath());
            Utils$.MODULE$.deleteRecursively(warehouseDir);
            warehouseDir.mkdir();
            this.sharedState().cacheManager().clearCache();
            this.sharedState().loadedTables().clear();
            this.sessionState().catalog().reset();
            this.metadataHive().reset();
            Configuration hadoopConf = this.sessionState().newHadoopConf();
            Path location = new Path(hadoopConf.get(HiveConf.ConfVars.SCRATCHDIR.varname));
            FileSystem fs = location.getFileSystem(hadoopConf);
            fs.delete(location, true);
            this.sessionState().conf().setConfString("fs.defaultFS", new File(".").toURI().toString());
            this.metadataHive().runSqlHive("RESET");
            this.metadataHive().runSqlHive("set hive.table.parameters.default=");
            this.metadataHive().runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.sessionState().catalog().setCurrentDatabase("default");
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "FATAL ERROR: Failed to reset TestDB state.", e);
        }
    }

    private final void TestTable$lzycompute$1() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if (this.TestTable$module == null) {
                this.TestTable$module = new TestHiveSparkSession$TestTable$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHiveSparkSession $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.sc().hadoopConfiguration().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getWarehousePath$1(SQLConf tempConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            tempConf$1.setConfString(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String createTableSQL$1(String tblName) {
        return new StringBuilder(56).append("CREATE TABLE ").append(tblName).append(" (key INT, value STRING) STORED AS textfile").toString();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestHiveSparkSession $this, String ds$1, String hr) {
        $this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(118).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart PARTITION (ds='").append(ds$1).append("',hr='").append(hr).append("')\n          ").toString())).stripMargin()).cmd().apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHiveSparkSession $this, String ds) {
        ((IterableLike)new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)hr -> {
            TestHiveSparkSession.$anonfun$new$5($this, ds, hr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestHiveSparkSession $this, String ds) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)hr -> $this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart1 PARTITION (ds='").append(ds).append("',hr='").append(hr).append("')\n          ").toString())).stripMargin()).cmd().apply$mcV$sp());
    }

    public static final /* synthetic */ void $anonfun$reset$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LoggerConfig log = (LoggerConfig)tuple2._2();
            if (!log.getName().contains("org.apache.spark")) {
                log.setLevel(Level.WARN);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TestHiveSparkSession(SparkContext sc, Option<TestHiveSharedState> existingSharedState, Option<SessionState> parentSessionState, boolean loadTestTables) {
        block0: {
            this.sc = sc;
            this.existingSharedState = existingSharedState;
            this.parentSessionState = parentSessionState;
            this.loadTestTables = loadTestTables;
            super(sc);
            SparkSession$.MODULE$.setDefaultSession((SparkSession)this);
            SparkSession$.MODULE$.setActiveSession((SparkSession)this);
            Map metastoreTempConf = HiveUtils$.MODULE$.newTemporaryConfiguration(false).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_INTEGER_JDO_PUSHDOWN.varname), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SCRATCHDIR.varname), (Object)TestHiveContext$.MODULE$.makeScratchDir().toURI().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY.varname), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(existingSharedState.map((Function1 & Serializable & scala.Serializable)state -> {
                String connKey = state.sparkContext().hadoopConfiguration().get(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname), (Object)connKey);
            })));
            metastoreTempConf.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$new$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            Object object = sc.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
            String string = "hive";
            Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null));
            this.cacheTables = false;
            System.clearProperty("spark.hostPort");
            Object object2 = parentSessionState.isEmpty() ? System.setProperty("test.tmp.dir", Utils$.MODULE$.createTempDir().toURI().getPath()) : BoxedUnit.UNIT;
            this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
            this.hiveFilesTemp().delete();
            this.hiveFilesTemp().mkdir();
            ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
            this.describedTable = new StringOps(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)")).r();
            if (!loadTestTables) break block0;
            Seq hiveQTestUtilTables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src")).cmd(), this.SqlCmd(new StringBuilder(40).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv1.txt")).append("' INTO TABLE src").toString()).cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src1")).cmd(), this.SqlCmd(new StringBuilder(41).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv3.txt")).append("' INTO TABLE src1").toString()).cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringBuilder(38).append(TestHiveSparkSession.createTableSQL$1("srcpart")).append(" PARTITIONED BY (ds STRING, hr STRING)").toString()).cmd().apply$mcV$sp();
                ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$4(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringBuilder(35).append(TestHiveSparkSession.createTableSQL$1("srcpart1")).append(" PARTITIONED BY (ds STRING, hr INT)").toString()).cmd().apply$mcV$sp();
                ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$7(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(330).append("\n           |CREATE TABLE src_thrift(fake INT)\n           |ROW FORMAT SERDE '").append(ThriftDeserializer.class.getName()).append("'\n           |WITH SERDEPROPERTIES(\n           |  'serialization.class'='org.apache.spark.sql.hive.test.Complex',\n           |  'serialization.format'='").append(TBinaryProtocol.class.getName()).append("'\n           |)\n           |STORED AS\n           |INPUTFORMAT '").append(SequenceFileInputFormat.class.getName()).append("'\n           |OUTPUTFORMAT '").append(SequenceFileOutputFormat.class.getName()).append("'\n        ").toString())).stripMargin()).cmd().apply$mcV$sp();
                this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/complex.seq")).append("'\n           |INTO TABLE src_thrift\n        ").toString())).stripMargin()).cmd().apply$mcV$sp();
            }})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("CREATE TABLE serdeins (key INT, value STRING)\n           |ROW FORMAT SERDE '").append(LazySimpleSerDe.class.getCanonicalName()).append("'\n           |WITH SERDEPROPERTIES ('field.delim'='\\t')\n         ").toString())).stripMargin()).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/episodes.avro")).append("'\n           |INTO TABLE episodes\n         ").toString())).stripMargin()).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n           |PARTITIONED BY (doctor_pt INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("\n           |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n          ")).stripMargin()).cmd(), this.SqlCmd("\n          INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n          SELECT title, air_date, doctor FROM episodes\n        ").cmd()})), new TestTable(this, "src_json", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE src_json (json STRING) STORED AS TEXTFILE\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringBuilder(45).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/json.txt")).append("' INTO TABLE src_json").toString()).cmd()}))}));
            hiveQTestUtilTables.foreach((Function1 & Serializable & scala.Serializable)testTable -> {
                this.registerTestTable(testTable);
                return BoxedUnit.UNIT;
            });
        }
    }

    public TestHiveSparkSession(SparkContext sc, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)None$.MODULE$, (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public TestHiveSparkSession(SparkContext sc, HiveClient hiveClient, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)new Some((Object)new TestHiveSharedState(sc, (Option<HiveClient>)new Some((Object)hiveClient))), (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public class SqlCmd {
        private final String sql;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Function0<BoxedUnit> cmd() {
            return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TestHiveQueryExecution($this.sql).executedPlan().executeCollect();
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveSparkSession $outer, String sql) {
            this.sql = sql;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    scala.Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.commands();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveSparkSession $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

