/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.NonJVMResource;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.ui.SparkUI$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M4Qa\u0006\r\u0001=\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u00191\u0005\u0001)A\u0005w!9q\t\u0001b\u0001\n\u0013Q\u0004B\u0002%\u0001A\u0003%1\bC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r9\u0003\u0001\u0015!\u0003L\u0011\u001dy\u0005A1A\u0005\niBa\u0001\u0015\u0001!\u0002\u0013Y\u0004bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\u000f]\u0003!\u0019!C\u00051\"1A\f\u0001Q\u0001\neCq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019!\u0007\u0001)A\u00053\"9Q\r\u0001b\u0001\n\u0013A\u0006B\u00024\u0001A\u0003%\u0011\fC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003o\u0001\u0011\u0005sN\u0001\fCCNL7\r\u0012:jm\u0016\u0014h)Z1ukJ,7\u000b^3q\u0015\tI\"$\u0001\u0005gK\u0006$XO]3t\u0015\tYB$A\u0002lqMT!!\b\u0010\u0002\r\u0011,\u0007\u000f\\8z\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003aI!A\f\r\u00037-+(-\u001a:oKR,7OR3biV\u0014XmQ8oM&<7\u000b^3q\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011!gM\u0007\u00025%\u0011AG\u0007\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t9\u0004\b\u0005\u0002-\u0001!)qF\u0001a\u0001c\u0005iAM]5wKJ\u0004v\u000e\u001a(b[\u0016,\u0012a\u000f\t\u0003y\rs!!P!\u0011\u0005y:S\"A \u000b\u0005\u0001\u0003\u0014A\u0002\u001fs_>$h(\u0003\u0002CO\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011u%\u0001\bee&4XM\u001d)pI:\u000bW.\u001a\u0011\u0002)\u0011\u0014\u0018N^3s\u0007>tG/Y5oKJLU.Y4f\u0003U!'/\u001b<fe\u000e{g\u000e^1j]\u0016\u0014\u0018*\\1hK\u0002\na\u0002\u001a:jm\u0016\u00148\t];D_J,7/F\u0001L!\t1C*\u0003\u0002NO\t\u0019\u0011J\u001c;\u0002\u001f\u0011\u0014\u0018N^3s\u0007B,8i\u001c:fg\u0002\n!\u0003\u001a:jm\u0016\u00148i\u001c:fgJ+\u0017/^3ti\u0006\u0019BM]5wKJ\u001cuN]3t%\u0016\fX/Z:uA\u0005\u0001BM]5wKJd\u0015.\\5u\u0007>\u0014Xm]\u000b\u0002'B\u0019a\u0005V\u001e\n\u0005U;#AB(qi&|g.A\tee&4XM\u001d'j[&$8i\u001c:fg\u0002\nq\u0002\u001a:jm\u0016\u0014X*Z7pefl\u0015NQ\u000b\u00023B\u0011aEW\u0005\u00037\u001e\u0012A\u0001T8oO\u0006\u0001BM]5wKJlU-\\8ss6K'\tI\u0001\u000f_Z,'\u000f[3bI\u001a\u000b7\r^8s+\u0005y\u0006C\u0001\u0014a\u0013\t\twE\u0001\u0004E_V\u0014G.Z\u0001\u0010_Z,'\u000f[3bI\u001a\u000b7\r^8sA\u0005\tR.Z7pef|e/\u001a:iK\u0006$W*\u001b\"\u0002%5,Wn\u001c:z\u001fZ,'\u000f[3bI6K'\tI\u0001\u001cIJLg/\u001a:NK6|'/_,ji\"|e/\u001a:iK\u0006$W*\u001b\"\u00029\u0011\u0014\u0018N^3s\u001b\u0016lwN]=XSRDwJ^3sQ\u0016\fG-T5CA\u0005a1m\u001c8gS\u001e,(/\u001a)pIR\u0011\u0011\u000e\u001c\t\u0003e)L!a\u001b\u000e\u0003\u0011M\u0003\u0018M]6Q_\u0012DQ!\\\u000bA\u0002%\f1\u0001]8e\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0003A\u0004B\u0001P9<w%\u0011!/\u0012\u0002\u0004\u001b\u0006\u0004\b")
public class BasicDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesDriverConf conf;
    private final String driverPodName;
    private final String driverContainerImage;
    private final int driverCpuCores;
    private final String driverCoresRequest;
    private final Option<String> driverLimitCores;
    private final long driverMemoryMiB;
    private final double overheadFactor;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private int driverCpuCores() {
        return this.driverCpuCores;
    }

    private String driverCoresRequest() {
        return this.driverCoresRequest;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    private long driverMemoryMiB() {
        return this.driverMemoryMiB;
    }

    private double overheadFactor() {
        return this.overheadFactor;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Seq driverCustomEnvs = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.conf.appId())}))).$plus$plus(this.conf.environment(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build(), Seq$.MODULE$.canBuildFrom());
        Quantity driverCpuQuantity = new Quantity(this.driverCoresRequest());
        Quantity driverMemoryQuantity = new Quantity(new StringBuilder(2).append(this.driverMemoryWithOverheadMiB()).append("Mi").toString());
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> new Tuple2((Object)"cpu", (Object)new Quantity(limitCores)));
        scala.collection.immutable.Map<String, Quantity> driverResourceQuantities = KubernetesUtils$.MODULE$.buildResourcesQuantities(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), this.conf.sparkConf());
        int driverPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        int driverUIPort = SparkUI$.MODULE$.getUIPort(this.conf.sparkConf());
        Container driverContainer = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).withName((String)Option$.MODULE$.apply((Object)pod.container().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_DRIVER_CONTAINER_NAME()))).withImage(this.driverContainerImage())).withImagePullPolicy(this.conf.imagePullPolicy())).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverUIPort)).withProtocol("TCP")).endPort()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverCustomEnvs).asJava())).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).editOrNewResources().addToRequests("cpu", driverCpuQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap(Predef$.MODULE$.$conforms())).asJava()).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(driverResourceQuantities).asJava())).endResources()).build();
        Pod driverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.labels()).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.annotations()).asJava())).endMetadata()).editOrNewSpec().withRestartPolicy("Never").addToNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.conf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(driverPod, driverContainer);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        scala.collection.mutable.Map additionalProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)this.driverPodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)this.conf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()), (Object)((Object)BoxesRunTime.boxToDouble((double)this.overheadFactor())).toString())}));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{org.apache.spark.internal.config.package$.MODULE$.JARS(), org.apache.spark.internal.config.package$.MODULE$.FILES(), org.apache.spark.internal.config.package$.MODULE$.ARCHIVES(), org.apache.spark.internal.config.package$.MODULE$.SUBMIT_PYTHON_FILES()}))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            BoxedUnit boxedUnit;
            Seq uris = (Seq)((TraversableLike)$this.conf.get(key)).filter((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.MODULE$.isLocalAndResolvable(uri)));
            ConfigEntry configEntry = key;
            ConfigEntry configEntry2 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
            Seq value = !(configEntry != null ? !configEntry.equals(configEntry2) : configEntry2 != null) ? (Seq)((TraversableLike)uris.map((Function1 & Serializable & scala.Serializable)x$1 -> UriBuilder.fromUri((String)x$1).fragment(null).build(new Object[0]), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom()) : uris;
            Iterable resolved = KubernetesUtils$.MODULE$.uploadAndTransformFileUris((Iterable<String>)value, (Option<SparkConf>)new Some((Object)$this.conf.sparkConf()));
            if (resolved.nonEmpty()) {
                ConfigEntry configEntry3 = key;
                ConfigEntry configEntry4 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
                Iterable resolvedValue = !(configEntry3 != null ? !configEntry3.equals(configEntry4) : configEntry4 != null) ? (Iterable)((TraversableLike)uris.zip(resolved, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String uri = (String)tuple2._1();
                    String r = (String)tuple2._2();
                    String string = UriBuilder.fromUri((String)r).fragment(new URI(uri).getFragment()).build(new Object[0]).toString();
                    return string;
                }, Seq$.MODULE$.canBuildFrom()) : resolved;
                boxedUnit = additionalProps.put((Object)key.key(), (Object)resolvedValue.mkString(","));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return additionalProps.toMap(Predef$.MODULE$.$conforms());
    }

    public BasicDriverFeatureStep(KubernetesDriverConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.driverPodName = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append($this.conf.resourceNamePrefix()).append("-driver").toString());
        this.driverContainerImage = (String)conf.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the driver container image");
        });
        this.driverCpuCores = BoxesRunTime.unboxToInt(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES()));
        this.driverCoresRequest = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REQUEST_CORES())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToInteger((int)this.driverCpuCores())).toString());
        this.driverLimitCores = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.driverMemoryMiB = BoxesRunTime.unboxToLong(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.overheadFactor = conf.mainAppResource() instanceof NonJVMResource ? (conf.contains(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) : Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR()) : BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(this.overheadFactor() * (double)this.driverMemoryMiB())), ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.driverMemoryWithOverheadMiB = this.driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

