/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.TestingUtils;
import org.scalatest.exceptions.TestFailedException;
import scala.math.package$;

public final class TestingUtils$ {
    public static TestingUtils$ MODULE$;
    private final String ABS_TOL_MSG;
    private final String REL_TOL_MSG;

    static {
        new TestingUtils$();
    }

    public String ABS_TOL_MSG() {
        return this.ABS_TOL_MSG;
    }

    public String REL_TOL_MSG() {
        return this.REL_TOL_MSG;
    }

    public boolean org$apache$spark$ml$util$TestingUtils$$RelativeErrorComparison(double x, double y, double eps) {
        boolean bl;
        if (Double.isNaN(x) && Double.isNaN(y)) {
            return true;
        }
        double absX = package$.MODULE$.abs(x);
        double absY = package$.MODULE$.abs(y);
        double diff = package$.MODULE$.abs(x - y);
        if (x == y) {
            bl = true;
        } else {
            if (absX < Double.MIN_VALUE || absY < Double.MIN_VALUE) {
                throw new TestFailedException(new StringBuilder(74).append(x).append(" or ").append(y).append(" is extremely close to zero, so the relative tolerance is meaningless.").toString(), 0);
            }
            bl = diff < eps * package$.MODULE$.min(absX, absY);
        }
        return bl;
    }

    public boolean AbsoluteErrorComparison(double x, double y, double eps) {
        if (Double.isNaN(x) && Double.isNaN(y)) {
            return true;
        }
        return package$.MODULE$.abs(x - y) < eps;
    }

    public TestingUtils.DoubleWithAlmostEquals DoubleWithAlmostEquals(double x) {
        return new TestingUtils.DoubleWithAlmostEquals(x);
    }

    public TestingUtils.VectorWithAlmostEquals VectorWithAlmostEquals(Vector x) {
        return new TestingUtils.VectorWithAlmostEquals(x);
    }

    public TestingUtils.MatrixWithAlmostEquals MatrixWithAlmostEquals(Matrix x) {
        return new TestingUtils.MatrixWithAlmostEquals(x);
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.ABS_TOL_MSG = " using absolute tolerance";
        this.REL_TOL_MSG = " using relative tolerance";
    }
}

