/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.impl.estimator;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.impl.estimator.PredictorParams;
import org.apache.spark.ml.impl.estimator.PredictorParams$class;
import org.apache.spark.ml.param.HasFeaturesCol$class;
import org.apache.spark.ml.param.HasLabelCol$class;
import org.apache.spark.ml.param.HasPredictionCol$class;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params$;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001m4a!\u0001\u0002\u0002\u0002!q!a\u0004)sK\u0012L7\r^5p]6{G-\u001a7\u000b\u0005\r!\u0011!C3ti&l\u0017\r^8s\u0015\t)a!\u0001\u0003j[Bd'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h+\ry1EF\n\u0004\u0001AI\u0003cA\t\u0013)5\ta!\u0003\u0002\u0014\r\t)Qj\u001c3fYB\u0011QC\u0006\u0007\u0001\t\u00159\u0002A1\u0001\u001a\u0005\u0005i5\u0001A\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0003\"\u0001\t\"R\"\u0001\u0002\u0011\u0005U\u0019C!\u0002\u0013\u0001\u0005\u0004)#\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001\u000e'!\tYr%\u0003\u0002)9\t\u0019\u0011I\\=\u0011\u0005\u0005R\u0013BA\u0016\u0003\u0005=\u0001&/\u001a3jGR|'\u000fU1sC6\u001c\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u0001!\u0011\u0015\u0001\u0004\u0001\"\u00012\u00039\u0019X\r\u001e$fCR,(/Z:D_2$\"\u0001\u0006\u001a\t\u000bMz\u0003\u0019\u0001\u001b\u0002\u000bY\fG.^3\u0011\u0005UBdBA\u000e7\u0013\t9D$\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\u001d\u0011\u0015a\u0004\u0001\"\u0001>\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002\u0015}!)1g\u000fa\u0001i!)\u0001\t\u0001C\t\u0003\u0006\u0001b-Z1ukJ,7\u000fR1uCRK\b/Z\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u000f\"\t1a]9m\u0013\tIEI\u0001\u0005ECR\fG+\u001f9fQ\ty4\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ak%\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007\"\u0002*\u0001\t\u0003\u001a\u0016a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\u0007Q;\u0016\f\u0005\u0002D+&\u0011a\u000b\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002-R\u0001\u0004!\u0016AB:dQ\u0016l\u0017\rC\u0003[#\u0002\u00071,\u0001\u0005qCJ\fW.T1q!\tav,D\u0001^\u0015\tqf!A\u0003qCJ\fW.\u0003\u0002a;\nA\u0001+\u0019:b[6\u000b\u0007\u000fC\u0003c\u0001\u0011\u00053-A\u0005ue\u0006t7OZ8s[R\u0019A\r\u001b6\u0011\u0005\u00154W\"\u0001$\n\u0005\u001d4%!\u0003#bi\u00064%/Y7f\u0011\u0015I\u0017\r1\u0001e\u0003\u001d!\u0017\r^1tKRDQAW1A\u0002mCQ\u0001\u001c\u0001\u0007\u00125\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002ocB\u00111d\\\u0005\u0003ar\u0011a\u0001R8vE2,\u0007\"\u0002:l\u0001\u0004\u0011\u0013\u0001\u00034fCR,(/Z:)\u0005-\\\u0005\"B;\u0001\r#1\u0018\u0001B2paf$\u0012\u0001\u0006\u0015\u0003\u0001a\u0004\"\u0001T=\n\u0005il%AD!ma\"\f7i\\7q_:,g\u000e\u001e")
public abstract class PredictionModel<FeaturesType, M extends PredictionModel<FeaturesType, M>>
extends Model<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, ParamMap paramMap, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, paramMap, fitting, featuresDataType);
    }

    @Override
    public Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    public M setFeaturesCol(String value) {
        return (M)((PredictionModel)this.set(this.featuresCol(), value));
    }

    public M setPredictionCol(String value) {
        return (M)((PredictionModel)this.set(this.predictionCol(), value));
    }

    @DeveloperApi
    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema, ParamMap paramMap) {
        return this.validateAndTransformSchema(schema, paramMap, false, this.featuresDataType());
    }

    @Override
    public DataFrame transform(DataFrame dataset, ParamMap paramMap) {
        DataFrame dataFrame;
        PredictionModel<FeaturesType, M> predictionModel;
        this.transformSchema(dataset.schema(), paramMap, true);
        ParamMap map = this.paramMap().$plus$plus(paramMap);
        if (paramMap.size() != 0) {
            M tmpModel = this.copy();
            Params$.MODULE$.inheritValues(paramMap, this.parent(), tmpModel);
            predictionModel = tmpModel;
        } else {
            predictionModel = this;
        }
        PredictionModel tmpModel = predictionModel;
        String string = map.apply(this.predictionCol());
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PredictionModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Predictor.transform() was called as NOOP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uid()}))).append((Object)" since no output columns were set.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            dataFrame = dataset;
        } else {
            Serializable pred = new Serializable(this, tmpModel){
                public static final long serialVersionUID = 0L;
                private final PredictionModel tmpModel$1;

                public final double apply(FeaturesType features) {
                    return this.tmpModel$1.predict(features);
                }
                {
                    this.tmpModel$1 = tmpModel$1;
                }
            };
            dataFrame = dataset.withColumn(map.apply(this.predictionCol()), functions$.MODULE$.callUDF((Function1)pred, (DataType)DoubleType$.MODULE$, functions$.MODULE$.col(map.apply(this.featuresCol()))));
        }
        return dataFrame;
    }

    @DeveloperApi
    public abstract double predict(FeaturesType var1);

    public abstract M copy();

    public PredictionModel() {
        HasLabelCol$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        PredictorParams$class.$init$(this);
    }
}

