/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.impl.estimator;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.impl.estimator.PredictionModel;
import org.apache.spark.ml.impl.estimator.PredictorParams;
import org.apache.spark.ml.impl.estimator.PredictorParams$class;
import org.apache.spark.ml.param.HasFeaturesCol$class;
import org.apache.spark.ml.param.HasLabelCol$class;
import org.apache.spark.ml.param.HasPredictionCol$class;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dbAB\u0001\u0003\u0003\u0003AaBA\u0005Qe\u0016$\u0017n\u0019;pe*\u00111\u0001B\u0001\nKN$\u0018.\\1u_JT!!\u0002\u0004\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e,BaD\u00134-M\u0019\u0001\u0001E\u0016\u0011\u0007E\u0011B#D\u0001\u0007\u0013\t\u0019bAA\u0005FgRLW.\u0019;peB\u0011QC\u0006\u0007\u0001\t\u00159\u0002A1\u0001\u001a\u0005\u0005i5\u0001A\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0003\"E\u0011\"R\"\u0001\u0002\n\u0005\r\u0012!a\u0004)sK\u0012L7\r^5p]6{G-\u001a7\u0011\u0005U)C!\u0002\u0014\u0001\u0005\u00049#\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001\u000e)!\tY\u0012&\u0003\u0002+9\t\u0019\u0011I\\=\u0011\u0005\u0005b\u0013BA\u0017\u0003\u0005=\u0001&/\u001a3jGR|'\u000fU1sC6\u001c\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00012!\u0015\t\u0003\u0001\n\u001a\u0015!\t)2\u0007B\u00035\u0001\t\u0007QGA\u0004MK\u0006\u0014h.\u001a:\u0012\u0005i\t\u0004\"B\u001c\u0001\t\u0003A\u0014aC:fi2\u000b'-\u001a7D_2$\"AM\u001d\t\u000bi2\u0004\u0019A\u001e\u0002\u000bY\fG.^3\u0011\u0005qzdBA\u000e>\u0013\tqD$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 \u001d\u0011\u0015\u0019\u0005\u0001\"\u0001E\u00039\u0019X\r\u001e$fCR,(/Z:D_2$\"AM#\t\u000bi\u0012\u0005\u0019A\u001e\t\u000b\u001d\u0003A\u0011\u0001%\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u0001\u001aJ\u0011\u0015Qd\t1\u0001<\u0011\u0015Y\u0005\u0001\"\u0011M\u0003\r1\u0017\u000e\u001e\u000b\u0004)5+\u0006\"\u0002(K\u0001\u0004y\u0015a\u00023bi\u0006\u001cX\r\u001e\t\u0003!Nk\u0011!\u0015\u0006\u0003%\"\t1a]9m\u0013\t!\u0016KA\u0005ECR\fgI]1nK\")aK\u0013a\u0001/\u0006A\u0001/\u0019:b[6\u000b\u0007\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[\r\u0005)\u0001/\u0019:b[&\u0011A,\u0017\u0002\t!\u0006\u0014\u0018-\\'ba\")a\f\u0001D\t?\u0006)AO]1j]R\u0019A\u0003Y1\t\u000b9k\u0006\u0019A(\t\u000bYk\u0006\u0019A,)\u0005u\u001b\u0007C\u00013h\u001b\u0005)'B\u00014\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003Q\u0016\u0014A\u0002R3wK2|\u0007/\u001a:Ba&DQA\u001b\u0001\u0005\u0012-\f\u0001CZ3biV\u0014Xm\u001d#bi\u0006$\u0016\u0010]3\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\)\u0002\u000bQL\b/Z:\n\u0005Et'\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005%\u001c\u0007\"\u0002;\u0001\t\u0003*\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\u0007YL8\u0010\u0005\u0002no&\u0011\u0001P\u001c\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002>t\u0001\u00041\u0018AB:dQ\u0016l\u0017\rC\u0003Wg\u0002\u0007q\u000bC\u0003~\u0001\u0011Ea0\u0001\u000bfqR\u0014\u0018m\u0019;MC\n,G.\u001a3Q_&tGo\u001d\u000b\u0006\u007f\u0006m\u0011Q\u0004\t\u0007\u0003\u0003\t9!a\u0003\u000e\u0005\u0005\r!bAA\u0003\u0011\u0005\u0019!\u000f\u001a3\n\t\u0005%\u00111\u0001\u0002\u0004%\u0012#\u0005\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u000be\u0016<'/Z:tS>t'bAA\u000b\u0011\u0005)Q\u000e\u001c7jE&!\u0011\u0011DA\b\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011\u0015qE\u00101\u0001P\u0011\u00151F\u00101\u0001XQ\r\u0001\u0011\u0011\u0005\t\u0004I\u0006\r\u0012bAA\u0013K\nq\u0011\t\u001c9iC\u000e{W\u000e]8oK:$\b")
public abstract class Predictor<FeaturesType, Learner extends Predictor<FeaturesType, Learner, M>, M extends PredictionModel<FeaturesType, M>>
extends Estimator<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, ParamMap paramMap, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, paramMap, fitting, featuresDataType);
    }

    @Override
    public Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    public Learner setLabelCol(String value) {
        return (Learner)((Predictor)this.set(this.labelCol(), value));
    }

    public Learner setFeaturesCol(String value) {
        return (Learner)((Predictor)this.set(this.featuresCol(), value));
    }

    public Learner setPredictionCol(String value) {
        return (Learner)((Predictor)this.set(this.predictionCol(), value));
    }

    @Override
    public M fit(DataFrame dataset, ParamMap paramMap) {
        this.transformSchema(dataset.schema(), paramMap, true);
        ParamMap map = this.paramMap().$plus$plus(paramMap);
        M model = this.train(dataset, map);
        Params$.MODULE$.inheritValues(map, this, model);
        return model;
    }

    @DeveloperApi
    public abstract M train(DataFrame var1, ParamMap var2);

    @DeveloperApi
    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema, ParamMap paramMap) {
        return this.validateAndTransformSchema(schema, paramMap, true, this.featuresDataType());
    }

    public RDD<LabeledPoint> extractLabeledPoints(DataFrame dataset, ParamMap paramMap) {
        ParamMap map = this.paramMap().$plus$plus(paramMap);
        return dataset.select(map.apply(this.labelCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{map.apply(this.featuresCol())})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public Predictor() {
        HasLabelCol$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        PredictorParams$class.$init$(this);
    }
}

