/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.api.python.MatrixFactorizationModelWrapper;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoWithSGD;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.CorrelationNames$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Losses$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015g!B\u0001\u0003\u0001\tq!A\u0004)zi\"|g.\u0014'MS\n\f\u0005+\u0013\u0006\u0003\u0007\u0011\ta\u0001]=uQ>t'BA\u0003\u0007\u0003\r\t\u0007/\u001b\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00063\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003 \u0001\u0011\u0005\u0001%A\tm_\u0006$G*\u00192fY\u0016$\u0007k\\5oiN$B!\t\u00184yA\u0019!E\n\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\t)\fg/\u0019\u0006\u0003\u000b!I!aJ\u0012\u0003\u000f)\u000bg/\u0019*E\tB\u0011\u0011\u0006L\u0007\u0002U)\u00111FB\u0001\u000be\u0016<'/Z:tS>t\u0017BA\u0017+\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011\u0015yc\u00041\u00011\u0003\rQ7o\u0019\t\u0003EEJ!AM\u0012\u0003!)\u000bg/Y*qCJ\\7i\u001c8uKb$\b\"\u0002\u001b\u001f\u0001\u0004)\u0014\u0001\u00029bi\"\u0004\"AN\u001d\u000f\u0005A9\u0014B\u0001\u001d\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\n\u0002\"B\u001f\u001f\u0001\u0004q\u0014!D7j]B\u000b'\u000f^5uS>t7\u000f\u0005\u0002\u0011\u007f%\u0011\u0001)\u0005\u0002\u0004\u0013:$\b\"\u0002\"\u0001\t\u0013\u0019\u0015\u0001\u0006;sC&t'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0006\u0003E#\n$\u0007cA#J\u00176\taI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005!\u0013B\u0001&G\u0005\u0011a\u0015n\u001d;\u0011\u00051{U\"A'\u000b\u00059C\u0015\u0001\u00027b]\u001eL!\u0001U'\u0003\r=\u0013'.Z2u\u0011\u0015\u0011\u0016\t1\u0001T\u0003\u001daW-\u0019:oKJ\u0004$\u0001V-\u0011\u0007%*v+\u0003\u0002WU\tQr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:BY\u001e|'/\u001b;i[B\u0011\u0001,\u0017\u0007\u0001\t%Q\u0016+!A\u0001\u0002\u000b\u00051LA\u0002`IE\n\"\u0001X0\u0011\u0005Ai\u0016B\u00010\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u000b1\n\u0005\u0005T#AF$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be6{G-\u001a7\t\u000b\r\f\u0005\u0019A\u0011\u0002\t\u0011\fG/\u0019\u0005\u0006K\u0006\u0003\rAZ\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t!\t9'.D\u0001i\u0015\tIg!\u0001\u0004mS:\fGnZ\u0005\u0003W\"\u0014aAV3di>\u0014\b\"B7\u0001\t\u0003q\u0017\u0001F4fiV\u0003H-\u0019;fe\u001a\u0013x.\\*ue&tw\r\u0006\u0002pkB\u0011\u0001o]\u0007\u0002c*\u0011!OB\u0001\r_B$\u0018.\\5{CRLwN\\\u0005\u0003iF\u0014q!\u00169eCR,'\u000fC\u0003wY\u0002\u0007Q'A\u0004sK\u001e$\u0016\u0010]3\t\u000ba\u0004A\u0011A=\u0002CQ\u0014\u0018-\u001b8MS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7XSRD7k\u0012#\u0015\u001d\u0011S80`A\u0003\u0003\u0013\tY!a\u0004\u0002\u0012!)1m\u001ea\u0001C!)Ap\u001ea\u0001}\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]NDQA`<A\u0002}\f\u0001b\u001d;faNK'0\u001a\t\u0004!\u0005\u0005\u0011bAA\u0002#\t1Ai\\;cY\u0016Da!a\u0002x\u0001\u0004y\u0018!E7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\")Qm\u001ea\u0001M\"1\u0011QB<A\u0002}\f\u0001B]3h!\u0006\u0014\u0018-\u001c\u0005\u0006m^\u0004\r!\u000e\u0005\b\u0003'9\b\u0019AA\u000b\u0003%Ig\u000e^3sG\u0016\u0004H\u000fE\u0002\u0011\u0003/I1!!\u0007\u0012\u0005\u001d\u0011un\u001c7fC:Dq!!\b\u0001\t\u0003\ty\"\u0001\fue\u0006Lg\u000eT1tg>lu\u000eZ3m/&$\bnU$E)5!\u0015\u0011EA\u0012\u0003K\t9#!\u000b\u0002,!11-a\u0007A\u0002\u0005Ba\u0001`A\u000e\u0001\u0004q\u0004B\u0002@\u0002\u001c\u0001\u0007q\u0010C\u0004\u0002\u000e\u0005m\u0001\u0019A@\t\u000f\u0005\u001d\u00111\u0004a\u0001\u007f\"1Q-a\u0007A\u0002\u0019Dq!a\f\u0001\t\u0003\t\t$\u0001\fue\u0006LgNU5eO\u0016lu\u000eZ3m/&$\bnU$E)5!\u00151GA\u001b\u0003o\tI$a\u000f\u0002>!11-!\fA\u0002\u0005Ba\u0001`A\u0017\u0001\u0004q\u0004B\u0002@\u0002.\u0001\u0007q\u0010C\u0004\u0002\u000e\u00055\u0002\u0019A@\t\u000f\u0005\u001d\u0011Q\u0006a\u0001\u007f\"1Q-!\fA\u0002\u0019Dq!!\u0011\u0001\t\u0003\t\u0019%\u0001\u000bue\u0006Lgn\u0015,N\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\u0012\t\u0006\u0015\u0013qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0003BB2\u0002@\u0001\u0007\u0011\u0005\u0003\u0004}\u0003\u007f\u0001\rA\u0010\u0005\u0007}\u0006}\u0002\u0019A@\t\u000f\u00055\u0011q\ba\u0001\u007f\"9\u0011qAA \u0001\u0004y\bBB3\u0002@\u0001\u0007a\r\u0003\u0004w\u0003\u007f\u0001\r!\u000e\u0005\t\u0003'\ty\u00041\u0001\u0002\u0016!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013a\t;sC&tGj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\u0012\t\u0006m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u0004BB2\u0002V\u0001\u0007\u0011\u0005\u0003\u0004}\u0003+\u0002\rA\u0010\u0005\u0007}\u0006U\u0003\u0019A@\t\u000f\u0005\u001d\u0011Q\u000ba\u0001\u007f\"1Q-!\u0016A\u0002\u0019Dq!!\u0004\u0002V\u0001\u0007q\u0010\u0003\u0004w\u0003+\u0002\r!\u000e\u0005\t\u0003'\t)\u00061\u0001\u0002\u0016!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014!\n;sC&tGj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,ji\"d%IR$T)E!\u0015\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014\u0011\u0011\u0005\u0007G\u0006-\u0004\u0019A\u0011\t\rq\fY\u00071\u0001?\u0011\u0019)\u00171\u000ea\u0001M\"9\u0011QBA6\u0001\u0004y\bB\u0002<\u0002l\u0001\u0007Q\u0007\u0003\u0005\u0002\u0014\u0005-\u0004\u0019AA\u000b\u0011\u001d\ty(a\u001bA\u0002y\n1bY8se\u0016\u001cG/[8og\"9\u00111QA6\u0001\u0004y\u0018!\u0003;pY\u0016\u0014\u0018M\\2f\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013\u000bq\u0002\u001e:bS:t\u0015-\u001b<f\u0005\u0006LXm\u001d\u000b\u0006\t\u0006-\u0015Q\u0012\u0005\u0007G\u0006\u0015\u0005\u0019A\u0011\t\u000f\u0005=\u0015Q\u0011a\u0001\u007f\u00061A.Y7cI\u0006Dq!a%\u0001\t\u0003\t)*\u0001\tue\u0006LgnS'fC:\u001cXj\u001c3fYRq\u0011qSAR\u0003O\u000bY+a,\u00024\u0006]\u0006\u0003BAM\u0003?k!!a'\u000b\u0007\u0005ue!\u0001\u0006dYV\u001cH/\u001a:j]\u001eLA!!)\u0002\u001c\nY1*T3b]Nlu\u000eZ3m\u0011\u001d\u0019\u0017\u0011\u0013a\u0001\u0003K\u00032A\t\u0014g\u0011\u001d\tI+!%A\u0002y\n\u0011a\u001b\u0005\b\u0003[\u000b\t\n1\u0001?\u00035i\u0017\r_%uKJ\fG/[8og\"9\u0011\u0011WAI\u0001\u0004q\u0014\u0001\u0002:v]NDq!!.\u0002\u0012\u0002\u0007Q'\u0001\nj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,\u0007\u0002CA]\u0003#\u0003\r!a/\u0002\tM,W\r\u001a\t\u0004\u0019\u0006u\u0016bAA`\u001b\n!Aj\u001c8h\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b\fA\u0003\u001e:bS:<\u0015-^:tS\u0006tW*\u001b=ukJ,Gc\u0003#\u0002H\u0006%\u00171ZAh\u0003#DqaYAa\u0001\u0004\t)\u000bC\u0004\u0002*\u0006\u0005\u0007\u0019\u0001 \t\u000f\u00055\u0017\u0011\u0019a\u0001\u007f\u0006q1m\u001c8wKJ<WM\\2f)>d\u0007bBAW\u0003\u0003\u0004\rA\u0010\u0005\t\u0003s\u000b\t\r1\u0001\u0002<\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0017A\u00049sK\u0012L7\r^*pMR<U*\u0014\u000b\u000b\u00033\fY/!<\u0002r\u0006]\bCBAn\u0003C\f)/\u0004\u0002\u0002^*\u0019\u0011q\u001c\u0005\u0002\u0007I$G-\u0003\u0003\u0002d\u0006u'a\u0001*E\tB!\u0001#a:\u0000\u0013\r\tI/\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\bG\u0006M\u0007\u0019AAS\u0011\u001d\ty/a5A\u0002-\u000b!a\u001e;\t\u0011\u0005M\u00181\u001ba\u0001\u0003k\f!!\\;\u0011\tA\t9o\u0013\u0005\t\u0003s\f\u0019\u000e1\u0001\u0002v\u0006\u00111/\u001b\u0005\b\u0003{\u0004A\u0011AA\u0000\u00035!(/Y5o\u00032\u001bVj\u001c3fYR\u0001\"\u0011\u0001B\u0007\u00053\u0011iB!\t\u0003$\t\u001d\"1\u0006\t\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!q\u0001\u0004\u0002\u001dI,7m\\7nK:$\u0017\r^5p]&!!1\u0002B\u0003\u0005ai\u0015\r\u001e:jq\u001a\u000b7\r^8sSj\fG/[8o\u001b>$W\r\u001c\u0005\t\u0005\u001f\tY\u00101\u0001\u0003\u0012\u0005Y!/\u0019;j]\u001e\u001c(J\u0015#E!\u0011\u0011cEa\u0005\u0011\t\t\r!QC\u0005\u0005\u0005/\u0011)A\u0001\u0004SCRLgn\u001a\u0005\b\u00057\tY\u00101\u0001?\u0003\u0011\u0011\u0018M\\6\t\u000f\t}\u00111 a\u0001}\u0005Q\u0011\u000e^3sCRLwN\\:\t\u000f\u0005=\u00151 a\u0001\u007f\"9!QEA~\u0001\u0004q\u0014A\u00022m_\u000e\\7\u000f\u0003\u0005\u0003*\u0005m\b\u0019AA\u000b\u0003-qwN\u001c8fO\u0006$\u0018N^3\t\u0011\u0005e\u00161 a\u0001\u0003wCqAa\f\u0001\t\u0003\u0011\t$A\u000bue\u0006Lg.S7qY&\u001c\u0017\u000e^!M'6{G-\u001a7\u0015%\t\u0005!1\u0007B\u001b\u0005o\u0011IDa\u000f\u0003>\t\u0005#1\t\u0005\t\u0005\u001f\u0011i\u00031\u0001\u0003\u0012!9!1\u0004B\u0017\u0001\u0004q\u0004b\u0002B\u0010\u0005[\u0001\rA\u0010\u0005\b\u0003\u001f\u0013i\u00031\u0001\u0000\u0011\u001d\u0011)C!\fA\u0002yBqAa\u0010\u0003.\u0001\u0007q0A\u0003bYBD\u0017\r\u0003\u0005\u0003*\t5\u0002\u0019AA\u000b\u0011!\tIL!\fA\u0002\u0005m\u0006b\u0002B$\u0001\u0011\u0005!\u0011J\u0001\u0010]>\u0014X.\u00197ju\u00164Vm\u0019;peR)aMa\u0013\u0003P!9!Q\nB#\u0001\u0004y\u0018!\u00019\t\u000f\tE#Q\ta\u0001M\u00061a/Z2u_JDqAa\u0012\u0001\t\u0003\u0011)\u0006\u0006\u0004\u0002&\n]#\u0011\f\u0005\b\u0005\u001b\u0012\u0019\u00061\u0001\u0000\u0011!\tyNa\u0015A\u0002\u0005\u0015\u0006b\u0002B/\u0001\u0011\u0005!qL\u0001\u0012M&$8\u000b^1oI\u0006\u0014HmU2bY\u0016\u0014H\u0003\u0003B1\u0005[\u0012\tH!\u001e\u0011\t\t\r$\u0011N\u0007\u0003\u0005KR1Aa\u001a\u0007\u0003\u001d1W-\u0019;ve\u0016LAAa\u001b\u0003f\t\u00192\u000b^1oI\u0006\u0014HmU2bY\u0016\u0014Xj\u001c3fY\"A!q\u000eB.\u0001\u0004\t)\"\u0001\u0005xSRDW*Z1o\u0011!\u0011\u0019Ha\u0017A\u0002\u0005U\u0011aB<ji\"\u001cF\u000f\u001a\u0005\bG\nm\u0003\u0019AAS\u0011\u001d\u0011I\b\u0001C\u0001\u0005w\naAZ5u\u0013\u00123EC\u0002B?\u0005\u0007\u00139\t\u0005\u0003\u0003d\t}\u0014\u0002\u0002BA\u0005K\u0012\u0001\"\u0013#G\u001b>$W\r\u001c\u0005\b\u0005\u000b\u00139\b1\u0001?\u0003)i\u0017N\u001c#pG\u001a\u0013X-\u001d\u0005\t\u0005\u0013\u00139\b1\u0001\u0002&\u00069A-\u0019;bg\u0016$\bb\u0002BG\u0001\u0011\u0005!qR\u0001\u000eiJ\f\u0017N\\,pe\u0012\u0014d+Z2\u0015\u001d\tE%\u0011\u001bBo\u0005C\u0014)O!;\u0003lB!!1\u0013BK\u001b\u0005\u0001aa\u0002BL\u0001\u0001\u0011!\u0011\u0014\u0002\u0015/>\u0014HM\r,fG6{G-\u001a7Xe\u0006\u0004\b/\u001a:\u0014\u0007\tUu\u0002C\u0006\u0003\u001e\nU%\u0011!Q\u0001\n\t}\u0015!B7pI\u0016d\u0007\u0003\u0002B2\u0005CKAAa)\u0003f\tiqk\u001c:eeY+7-T8eK2Dq!\u0007BK\t\u0003\u00119\u000b\u0006\u0003\u0003\u0012\n%\u0006\u0002\u0003BO\u0005K\u0003\rAa(\t\u0011\t5&Q\u0013C\u0001\u0005_\u000b\u0011\u0002\u001e:b]N4wN]7\u0015\u0007\u0019\u0014\t\fC\u0004\u00034\n-\u0006\u0019A\u001b\u0002\t]|'\u000f\u001a\u0005\t\u0005[\u0013)\n\"\u0001\u00038R!\u0011Q\u0015B]\u0011!\tyN!.A\u0002\tm\u0006c\u0001\u0012'k!A!q\u0018BK\t\u0003\u0011\t-\u0001\u0007gS:$7+\u001f8p]fl7\u000fF\u0003E\u0005\u0007\u0014)\rC\u0004\u00034\nu\u0006\u0019A\u001b\t\u000f\t\u001d'Q\u0018a\u0001}\u0005\u0019a.^7\t\u0011\t}&Q\u0013C\u0001\u0005\u0017$R\u0001\u0012Bg\u0005\u001fDqA!\u0015\u0003J\u0002\u0007a\rC\u0004\u0003H\n%\u0007\u0019\u0001 \t\u0011\tM'1\u0012a\u0001\u0005+\f\u0001\u0002Z1uC*\u0013F\t\u0012\t\u0005E\u0019\u00129\u000e\u0005\u0003F\u00053,\u0014b\u0001Bn\r\nI\u0011I\u001d:bs2K7\u000f\u001e\u0005\b\u0005?\u0014Y\t1\u0001?\u0003)1Xm\u0019;peNK'0\u001a\u0005\b\u0005G\u0014Y\t1\u0001\u0000\u00031aW-\u0019:oS:<'+\u0019;f\u0011\u001d\u00119Oa#A\u0002y\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002?\u0003\f\u0002\u0007a\b\u0003\u0005\u0002:\n-\u0005\u0019\u0001Bw!\r\u0001\"q^\u0005\u0004\u0003\u007f\u000b\u0002b\u0002Bz\u0001\u0011\u0005!Q_\u0001\u0017iJ\f\u0017N\u001c#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fYR!\"q_B\u0003\u0007\u000f\u0019Yaa\u0004\u0004\u001a\ru1\u0011EB\u0013\u0007S\u0001BA!?\u0004\u00025\u0011!1 \u0006\u0005\u0005;\u0013iPC\u0002\u0003\u0000\u001a\tA\u0001\u001e:fK&!11\u0001B~\u0005E!UmY5tS>tGK]3f\u001b>$W\r\u001c\u0005\u0007G\nE\b\u0019A\u0011\t\u000f\r%!\u0011\u001fa\u0001k\u00059\u0011\r\\4p'R\u0014\bbBB\u0007\u0005c\u0004\rAP\u0001\u000b]Vl7\t\\1tg\u0016\u001c\b\u0002CB\t\u0005c\u0004\raa\u0005\u0002/\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:J]\u001a|\u0007#B#\u0004\u0016yr\u0014bAB\f\r\n\u0019Q*\u00199\t\u000f\rm!\u0011\u001fa\u0001k\u0005Y\u0011.\u001c9ve&$\u0018p\u0015;s\u0011\u001d\u0019yB!=A\u0002y\n\u0001\"\\1y\t\u0016\u0004H\u000f\u001b\u0005\b\u0007G\u0011\t\u00101\u0001?\u0003\u001di\u0017\r\u001f\"j]NDqaa\n\u0003r\u0002\u0007a(A\nnS:Len\u001d;b]\u000e,7\u000fU3s\u001d>$W\rC\u0004\u0004,\tE\b\u0019A@\u0002\u00175Lg.\u00138g_\u001e\u000b\u0017N\u001c\u0005\b\u0007_\u0001A\u0011AB\u0019\u0003Y!(/Y5o%\u0006tGm\\7G_J,7\u000f^'pI\u0016dGCFB\u001a\u0007s\u0019Yd!\u0010\u0004@\r\u00053QIB%\u0007\u0017\u001aiea\u0014\u0011\t\te8QG\u0005\u0005\u0007o\u0011YPA\tSC:$w.\u001c$pe\u0016\u001cH/T8eK2DaaYB\u0017\u0001\u0004\t\u0003bBB\u0005\u0007[\u0001\r!\u000e\u0005\b\u0007\u001b\u0019i\u00031\u0001?\u0011!\u0019\tb!\fA\u0002\rM\u0001bBB\"\u0007[\u0001\rAP\u0001\t]VlGK]3fg\"91qIB\u0017\u0001\u0004)\u0014!\u00064fCR,(/Z*vEN,Go\u0015;sCR,w-\u001f\u0005\b\u00077\u0019i\u00031\u00016\u0011\u001d\u0019yb!\fA\u0002yBqaa\t\u0004.\u0001\u0007a\bC\u0004\u0002:\u000e5\u0002\u0019\u0001 \t\u000f\rM\u0003\u0001\"\u0001\u0004V\u0005qBO]1j]\u001e\u0013\u0018\rZ5f]R\u0014un\\:uK\u0012$&/Z3t\u001b>$W\r\u001c\u000b\u0011\u0007/\u001aifa\u0018\u0004b\r\r4qMB5\u0007W\u0002BA!?\u0004Z%!11\fB~\u0005e9%/\u00193jK:$(i\\8ti\u0016$GK]3fg6{G-\u001a7\t\r\r\u001c\t\u00061\u0001\"\u0011\u001d\u0019Ia!\u0015A\u0002UB\u0001b!\u0005\u0004R\u0001\u000711\u0003\u0005\b\u0007K\u001a\t\u00061\u00016\u0003\u001dawn]:TiJDa\u0001`B)\u0001\u0004q\u0004b\u0002Br\u0007#\u0002\ra \u0005\b\u0007?\u0019\t\u00061\u0001?\u0011\u001d\u0019y\u0007\u0001C\u0001\u0007c\n\u0001bY8m'R\fGo\u001d\u000b\u0005\u0007g\u001ay\b\u0005\u0003\u0004v\rmTBAB<\u0015\r\u0019IHB\u0001\u0005gR\fG/\u0003\u0003\u0004~\r]$AH'vYRLg/\u0019:jCR,7\u000b^1uSN$\u0018nY1m'VlW.\u0019:z\u0011!\tyn!\u001cA\u0002\u0005\u0015\u0006bBBB\u0001\u0011\u00051QQ\u0001\u0005G>\u0014(\u000f\u0006\u0004\u0004\b\u000e55\u0011\u0013\t\u0004O\u000e%\u0015bABFQ\n1Q*\u0019;sSbD\u0001ba$\u0004\u0002\u0002\u0007\u0011QU\u0001\u0002q\"911SBA\u0001\u0004)\u0014AB7fi\"|G\rC\u0004\u0004\u0004\u0002!\taa&\u0015\u000f}\u001cIj!(\u0004\"\"A1qRBK\u0001\u0004\u0019Y\nE\u0002#M}D\u0001ba(\u0004\u0016\u0002\u000711T\u0001\u0002s\"911SBK\u0001\u0004)\u0004bBBS\u0001\u0011\u00051qU\u0001\nG\"L7+\u001d+fgR$ba!+\u00046\u000ee\u0006\u0003BBV\u0007ck!a!,\u000b\t\r=6qO\u0001\u0005i\u0016\u001cH/\u0003\u0003\u00044\u000e5&aD\"iSN\u000bH+Z:u%\u0016\u001cX\u000f\u001c;\t\u000f\r]61\u0015a\u0001M\u0006AqNY:feZ,G\rC\u0004\u0004<\u000e\r\u0006\u0019\u00014\u0002\u0011\u0015D\b/Z2uK\u0012Dqa!*\u0001\t\u0003\u0019y\f\u0006\u0003\u0004*\u000e\u0005\u0007\u0002CB\\\u0007{\u0003\raa\"\t\u000f\r\u0015\u0006\u0001\"\u0001\u0004FR!1qYBe!\u0015\u0001\u0012q]BU\u0011\u0019\u001971\u0019a\u0001C!91Q\u001a\u0001\u0005\n\r=\u0017\u0001F4fi\u000e{'O\u001d(b[\u0016|%\u000fR3gCVdG\u000fF\u00026\u0007#Dqaa%\u0004L\u0002\u0007Q\u0007C\u0004\u0004V\u0002!Iaa6\u0002!\u001d,GoU3fI>\u0013H)\u001a4bk2$H\u0003\u0002Bw\u00073D\u0001\"!/\u0004T\u0002\u0007\u00111\u0018\u0005\b\u0007;\u0004A\u0011BBp\u0003e9W\r\u001e(v[B\u000b'\u000f^5uS>t7o\u0014:EK\u001a\fW\u000f\u001c;\u0015\u000by\u001a\to!;\t\u0011\t\u001d81\u001ca\u0001\u0007G\u00042\u0001TBs\u0013\r\u00199/\u0014\u0002\b\u0013:$XmZ3s\u0011\u0019y31\u001ca\u0001a!91Q\u001e\u0001\u0005\u0002\r=\u0018AC;oS\u001a|'/\u001c*E\tRQ11TBy\u0007g\u001c9p!?\t\r=\u001aY\u000f1\u00011\u0011!\u0019)pa;A\u0002\t5\u0018\u0001B:ju\u0016D\u0001Ba:\u0004l\u0002\u000711\u001d\u0005\t\u0003s\u001bY\u000f1\u0001\u0002<\"91Q \u0001\u0005\u0002\r}\u0018!\u00038pe6\fGN\u0015#E))\u0019Y\n\"\u0001\u0005\u0004\u0011\u0015Aq\u0001\u0005\u0007_\rm\b\u0019\u0001\u0019\t\u0011\rU81 a\u0001\u0005[D\u0001Ba:\u0004|\u0002\u000711\u001d\u0005\t\u0003s\u001bY\u00101\u0001\u0002<\"9A1\u0002\u0001\u0005\u0002\u00115\u0011\u0001\u00047pO:{'/\\1m%\u0012#ECDBN\t\u001f!\t\u0002\"\u0006\u0005\u001a\u0011mAQ\u0004\u0005\u0007_\u0011%\u0001\u0019\u0001\u0019\t\u000f\u0011MA\u0011\u0002a\u0001\u007f\u0006!Q.Z1o\u0011\u001d!9\u0002\"\u0003A\u0002}\f1a\u001d;e\u0011!\u0019)\u0010\"\u0003A\u0002\t5\b\u0002\u0003Bt\t\u0013\u0001\raa9\t\u0011\u0005eF\u0011\u0002a\u0001\u0003wCq\u0001\"\t\u0001\t\u0003!\u0019#\u0001\u0006q_&\u001c8o\u001c8S\t\u0012#Bba'\u0005&\u0011\u001dB\u0011\u0006C\u0016\t[Aaa\fC\u0010\u0001\u0004\u0001\u0004b\u0002C\n\t?\u0001\ra \u0005\t\u0007k$y\u00021\u0001\u0003n\"A!q\u001dC\u0010\u0001\u0004\u0019\u0019\u000f\u0003\u0005\u0002:\u0012}\u0001\u0019AA^\u0011\u001d!\t\u0004\u0001C\u0001\tg\ta\"\u001a=q_:,g\u000e^5bYJ#E\t\u0006\u0007\u0004\u001c\u0012UBq\u0007C\u001d\tw!i\u0004\u0003\u00040\t_\u0001\r\u0001\r\u0005\b\t'!y\u00031\u0001\u0000\u0011!\u0019)\u0010b\fA\u0002\t5\b\u0002\u0003Bt\t_\u0001\raa9\t\u0011\u0005eFq\u0006a\u0001\u0003wCq\u0001\"\u0011\u0001\t\u0003!\u0019%\u0001\u0005hC6l\u0017M\u0015#E)9\u0019Y\n\"\u0012\u0005H\u0011-Cq\nC)\t'Baa\fC \u0001\u0004\u0001\u0004b\u0002C%\t\u007f\u0001\ra`\u0001\u0006g\"\f\u0007/\u001a\u0005\b\t\u001b\"y\u00041\u0001\u0000\u0003\u0015\u00198-\u00197f\u0011!\u0019)\u0010b\u0010A\u0002\t5\b\u0002\u0003Bt\t\u007f\u0001\raa9\t\u0011\u0005eFq\ba\u0001\u0003wCq\u0001b\u0016\u0001\t\u0003!I&\u0001\tv]&4wN]7WK\u000e$xN\u001d*E\tRa\u0011Q\u0015C.\t;\"\t\u0007\"\u001a\u0005h!1q\u0006\"\u0016A\u0002AB\u0001\u0002b\u0018\u0005V\u0001\u0007!Q^\u0001\b]Vl'k\\<t\u0011\u001d!\u0019\u0007\"\u0016A\u0002y\nqA\\;n\u0007>d7\u000f\u0003\u0005\u0003h\u0012U\u0003\u0019ABr\u0011!\tI\f\"\u0016A\u0002\u0005m\u0006b\u0002C6\u0001\u0011\u0005AQN\u0001\u0010]>\u0014X.\u00197WK\u000e$xN\u001d*E\tRa\u0011Q\u0015C8\tc\"\u0019\b\"\u001e\u0005x!1q\u0006\"\u001bA\u0002AB\u0001\u0002b\u0018\u0005j\u0001\u0007!Q\u001e\u0005\b\tG\"I\u00071\u0001?\u0011!\u00119\u000f\"\u001bA\u0002\r\r\b\u0002CA]\tS\u0002\r!a/\t\u000f\u0011m\u0004\u0001\"\u0001\u0005~\u0005\u0011Bn\\4O_Jl\u0017\r\u001c,fGR|'O\u0015#E)A\t)\u000bb \u0005\u0002\u0012\rEQ\u0011CD\t\u0013#Y\t\u0003\u00040\ts\u0002\r\u0001\r\u0005\b\t'!I\b1\u0001\u0000\u0011\u001d!9\u0002\"\u001fA\u0002}D\u0001\u0002b\u0018\u0005z\u0001\u0007!Q\u001e\u0005\b\tG\"I\b1\u0001?\u0011!\u00119\u000f\"\u001fA\u0002\r\r\b\u0002CA]\ts\u0002\r!a/\t\u000f\u0011=\u0005\u0001\"\u0001\u0005\u0012\u0006\u0001\u0002o\\5tg>tg+Z2u_J\u0014F\t\u0012\u000b\u000f\u0003K#\u0019\n\"&\u0005\u0018\u0012eE1\u0014CO\u0011\u0019yCQ\u0012a\u0001a!9A1\u0003CG\u0001\u0004y\b\u0002\u0003C0\t\u001b\u0003\rA!<\t\u000f\u0011\rDQ\u0012a\u0001}!A!q\u001dCG\u0001\u0004\u0019\u0019\u000f\u0003\u0005\u0002:\u00125\u0005\u0019AA^\u0011\u001d!\t\u000b\u0001C\u0001\tG\u000bA#\u001a=q_:,g\u000e^5bYZ+7\r^8s%\u0012#ECDAS\tK#9\u000b\"+\u0005,\u00125Fq\u0016\u0005\u0007_\u0011}\u0005\u0019\u0001\u0019\t\u000f\u0011MAq\u0014a\u0001\u007f\"AAq\fCP\u0001\u0004\u0011i\u000fC\u0004\u0005d\u0011}\u0005\u0019\u0001 \t\u0011\t\u001dHq\u0014a\u0001\u0007GD\u0001\"!/\u0005 \u0002\u0007\u00111\u0018\u0005\b\tg\u0003A\u0011\u0001C[\u000399\u0017-\\7b-\u0016\u001cGo\u001c:S\t\u0012#\u0002#!*\u00058\u0012eF1\u0018C_\t\u007f#\t\rb1\t\r=\"\t\f1\u00011\u0011\u001d!I\u0005\"-A\u0002}Dq\u0001\"\u0014\u00052\u0002\u0007q\u0010\u0003\u0005\u0005`\u0011E\u0006\u0019\u0001Bw\u0011\u001d!\u0019\u0007\"-A\u0002yB\u0001Ba:\u00052\u0002\u000711\u001d\u0005\t\u0003s#\t\f1\u0001\u0002<\u0002")
public class PythonMLLibAPI
implements Serializable {
    public JavaRDD<LabeledPoint> loadLabeledPoints(JavaSparkContext jsc, String path, int minPartitions) {
        return JavaRDD$.MODULE$.fromRDD(MLUtils$.MODULE$.loadLabeledPoints(jsc.sc(), path, minPartitions), ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    private List<Object> trainRegressionModel(GeneralizedLinearAlgorithm<? extends GeneralizedLinearModel> learner, JavaRDD<LabeledPoint> data, Vector initialWeights) {
        try {
            GeneralizedLinearModel model = learner.run((RDD<LabeledPoint>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()), initialWeights);
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.weights(), BoxesRunTime.boxToDouble((double)model.intercept())})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$1) {
                    return x$1;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public Updater getUpdaterFromString(String regType) {
        block6: {
            Updater updater;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            String string = regType;
                            String string2 = "l2";
                            if (string != null ? !string.equals(string2) : string2 != null) break block2;
                            updater = new SquaredL2Updater();
                            break block3;
                        }
                        String string = regType;
                        String string3 = "l1";
                        if (string != null ? !string.equals(string3) : string3 != null) break block4;
                        updater = new L1Updater();
                        break block3;
                    }
                    if (regType == null) break block5;
                    String string = regType;
                    String string4 = "none";
                    if (string != null ? !string.equals(string4) : string4 != null) break block6;
                }
                updater = new SimpleUpdater();
            }
            return updater;
        }
        throw new IllegalArgumentException("Invalid value for 'regType' parameter. Can only be initialized using the following string values: ['l1', 'l2', None].");
    }

    public List<Object> trainLinearRegressionModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double miniBatchFraction, Vector initialWeights, double regParam, String regType, boolean intercept) {
        LinearRegressionWithSGD lrAlg = new LinearRegressionWithSGD();
        lrAlg.setIntercept(intercept);
        lrAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        lrAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(lrAlg, data, initialWeights);
    }

    public List<Object> trainLassoModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights) {
        LassoWithSGD lassoAlg = new LassoWithSGD();
        lassoAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        return this.trainRegressionModel(lassoAlg, data, initialWeights);
    }

    public List<Object> trainRidgeModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights) {
        RidgeRegressionWithSGD ridgeAlg = new RidgeRegressionWithSGD();
        ridgeAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        return this.trainRegressionModel(ridgeAlg, data, initialWeights);
    }

    public List<Object> trainSVMModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights, String regType, boolean intercept) {
        SVMWithSGD SVMAlg = new SVMWithSGD();
        SVMAlg.setIntercept(intercept);
        SVMAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        SVMAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(SVMAlg, data, initialWeights);
    }

    public List<Object> trainLogisticRegressionModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double miniBatchFraction, Vector initialWeights, double regParam, String regType, boolean intercept) {
        LogisticRegressionWithSGD LogRegAlg = new LogisticRegressionWithSGD();
        LogRegAlg.setIntercept(intercept);
        LogRegAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        LogRegAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(LogRegAlg, data, initialWeights);
    }

    public List<Object> trainLogisticRegressionModelWithLBFGS(JavaRDD<LabeledPoint> data, int numIterations, Vector initialWeights, double regParam, String regType, boolean intercept, int corrections, double tolerance) {
        LogisticRegressionWithLBFGS LogRegAlg = new LogisticRegressionWithLBFGS();
        LogRegAlg.setIntercept(intercept);
        LogRegAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setNumCorrections(corrections).setConvergenceTol(tolerance);
        LogRegAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(LogRegAlg, data, initialWeights);
    }

    public List<Object> trainNaiveBayes(JavaRDD<LabeledPoint> data, double lambda) {
        NaiveBayesModel model = NaiveBayes$.MODULE$.train((RDD<LabeledPoint>)data.rdd(), lambda);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{Vectors$.MODULE$.dense(model.labels()), Vectors$.MODULE$.dense(model.pi()), model.theta()})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x$2) {
                return x$2;
            }
        }, List$.MODULE$.canBuildFrom())).asJava();
    }

    public KMeansModel trainKMeansModel(JavaRDD<Vector> data, int k, int maxIterations, int runs, String initializationMode, Long seed) {
        KMeans kMeansAlg = new KMeans().setK(k).setMaxIterations(maxIterations).setRuns(runs).setInitializationMode(initializationMode);
        Object object = seed == null ? BoxedUnit.UNIT : kMeansAlg.setSeed(Predef$.MODULE$.Long2long(seed));
        try {
            return kMeansAlg.run((RDD<Vector>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()));
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public List<Object> trainGaussianMixture(JavaRDD<Vector> data, int k, double convergenceTol, int maxIterations, Long seed) {
        GaussianMixture gmmAlg = new GaussianMixture().setK(k).setConvergenceTol(convergenceTol).setMaxIterations(maxIterations);
        Object object = seed == null ? BoxedUnit.UNIT : gmmAlg.setSeed(Predef$.MODULE$.Long2long(seed));
        try {
            GaussianMixtureModel model = gmmAlg.run((RDD<Vector>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()));
            ObjectRef wt = new ObjectRef((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()));
            ObjectRef mu = new ObjectRef((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()));
            ObjectRef sigma = new ObjectRef((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), model.k()).foreach((Function1)new Serializable(this, model, wt, mu, sigma){
                public static final long serialVersionUID = 0L;
                private final GaussianMixtureModel model$1;
                private final ObjectRef wt$1;
                private final ObjectRef mu$1;
                private final ObjectRef sigma$1;

                public final ArrayBuffer<Matrix> apply(int i) {
                    ((ArrayBuffer)this.wt$1.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.model$1.weights()[i]));
                    ((ArrayBuffer)this.mu$1.elem).$plus$eq((Object)this.model$1.gaussians()[i].mu());
                    return ((ArrayBuffer)this.sigma$1.elem).$plus$eq((Object)this.model$1.gaussians()[i].sigma());
                }
                {
                    this.model$1 = model$1;
                    this.wt$1 = wt$1;
                    this.mu$1 = mu$1;
                    this.sigma$1 = sigma$1;
                }
            });
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{((ArrayBuffer)wt.elem).toArray(ClassTag$.MODULE$.Double()), ((ArrayBuffer)mu.elem).toArray(ClassTag$.MODULE$.apply(Vector.class)), ((ArrayBuffer)sigma.elem).toArray(ClassTag$.MODULE$.apply(Matrix.class))})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$3) {
                    return x$3;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public RDD<double[]> predictSoftGMM(JavaRDD<Vector> data, Object wt, Object[] mu, Object[] si) {
        double[] weight = (double[])wt;
        DenseVector[] mean2 = (DenseVector[])Predef$.MODULE$.refArrayOps(mu).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector apply(Object x$4) {
                return (DenseVector)x$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DenseVector.class)));
        DenseMatrix[] sigma = (DenseMatrix[])Predef$.MODULE$.refArrayOps(si).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseMatrix apply(Object x$5) {
                return (DenseMatrix)x$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DenseMatrix.class)));
        MultivariateGaussian[] gaussians = (MultivariateGaussian[])Array$.MODULE$.tabulate(weight.length, (Function1)new Serializable(this, mean2, sigma){
            public static final long serialVersionUID = 0L;
            private final DenseVector[] mean$1;
            private final DenseMatrix[] sigma$2;

            public final MultivariateGaussian apply(int i) {
                return new MultivariateGaussian(this.mean$1[i], this.sigma$2[i]);
            }
            {
                this.mean$1 = mean$1;
                this.sigma$2 = sigma$2;
            }
        }, ClassTag$.MODULE$.apply(MultivariateGaussian.class));
        GaussianMixtureModel model = new GaussianMixtureModel(weight, gaussians);
        return model.predictSoft((RDD<Vector>)JavaRDD$.MODULE$.toRDD(data));
    }

    public MatrixFactorizationModel trainALSModel(JavaRDD<Rating> ratingsJRDD, int rank, int iterations, double lambda, int blocks, boolean nonnegative, Long seed) {
        ALS als = new ALS().setRank(rank).setIterations(iterations).setLambda(lambda).setBlocks(blocks).setNonnegative(nonnegative);
        Object object = seed == null ? BoxedUnit.UNIT : als.setSeed(Predef$.MODULE$.Long2long(seed));
        MatrixFactorizationModel model = als.run((RDD<Rating>)ratingsJRDD.rdd());
        return new MatrixFactorizationModelWrapper(model);
    }

    public MatrixFactorizationModel trainImplicitALSModel(JavaRDD<Rating> ratingsJRDD, int rank, int iterations, double lambda, int blocks, double alpha, boolean nonnegative, Long seed) {
        ALS als = new ALS().setImplicitPrefs(true).setRank(rank).setIterations(iterations).setLambda(lambda).setBlocks(blocks).setAlpha(alpha).setNonnegative(nonnegative);
        Object object = seed == null ? BoxedUnit.UNIT : als.setSeed(Predef$.MODULE$.Long2long(seed));
        MatrixFactorizationModel model = als.run((RDD<Rating>)ratingsJRDD.rdd());
        return new MatrixFactorizationModelWrapper(model);
    }

    public Vector normalizeVector(double p, Vector vector) {
        return new Normalizer(p).transform(vector);
    }

    public JavaRDD<Vector> normalizeVector(double p, JavaRDD<Vector> rdd) {
        return new Normalizer(p).transform(rdd);
    }

    public StandardScalerModel fitStandardScaler(boolean withMean, boolean withStd, JavaRDD<Vector> data) {
        return new StandardScaler(withMean, withStd).fit((RDD<Vector>)data.rdd());
    }

    public IDFModel fitIDF(int minDocFreq, JavaRDD<Vector> dataset) {
        return new IDF(minDocFreq).fit(dataset);
    }

    public Word2VecModelWrapper trainWord2Vec(JavaRDD<ArrayList<String>> dataJRDD, int vectorSize, double learningRate, int numPartitions, int numIterations, long seed) {
        Word2Vec word2vec = new Word2Vec().setVectorSize(vectorSize).setLearningRate(learningRate).setNumPartitions(numPartitions).setNumIterations(numIterations).setSeed(seed);
        try {
            Word2VecModel model = word2vec.fit(JavaRDD$.MODULE$.fromRDD(dataJRDD.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER()), ClassTag$.MODULE$.apply(ArrayList.class)));
            return new Word2VecModelWrapper(this, model);
        }
        finally {
            dataJRDD.rdd().unpersist(false);
        }
    }

    public DecisionTreeModel trainDecisionTreeModel(JavaRDD<LabeledPoint> data, String algoStr, int numClasses, Map<Object, Object> categoricalFeaturesInfo, String impurityStr, int maxDepth, int maxBins, int minInstancesPerNode, double minInfoGain) {
        Enumeration.Value algo = Algo$.MODULE$.fromString(algoStr);
        Impurity impurity = Impurities$.MODULE$.fromString(impurityStr);
        Enumeration.Value x$9 = algo;
        Impurity x$10 = impurity;
        int x$11 = maxDepth;
        int x$12 = numClasses;
        int x$13 = maxBins;
        scala.collection.immutable.Map x$14 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms());
        int x$15 = minInstancesPerNode;
        double x$16 = minInfoGain;
        Enumeration.Value x$17 = Strategy$.MODULE$.$lessinit$greater$default$6();
        int x$18 = Strategy$.MODULE$.$lessinit$greater$default$10();
        double x$19 = Strategy$.MODULE$.$lessinit$greater$default$11();
        boolean x$20 = Strategy$.MODULE$.$lessinit$greater$default$12();
        int x$21 = Strategy$.MODULE$.$lessinit$greater$default$13();
        Strategy strategy = new Strategy(x$9, x$10, x$11, x$12, x$13, x$17, (scala.collection.immutable.Map<Object, Object>)x$14, x$15, x$16, x$18, x$19, x$20, x$21);
        try {
            return DecisionTree$.MODULE$.train((RDD<LabeledPoint>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()), strategy);
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public RandomForestModel trainRandomForestModel(JavaRDD<LabeledPoint> data, String algoStr, int numClasses, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurityStr, int maxDepth, int maxBins, int seed) {
        Enumeration.Value algo = Algo$.MODULE$.fromString(algoStr);
        Impurity impurity = Impurities$.MODULE$.fromString(impurityStr);
        Enumeration.Value x$22 = algo;
        Impurity x$23 = impurity;
        int x$24 = maxDepth;
        int x$25 = numClasses;
        int x$26 = maxBins;
        scala.collection.immutable.Map x$27 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms());
        Enumeration.Value x$28 = Strategy$.MODULE$.$lessinit$greater$default$6();
        int x$29 = Strategy$.MODULE$.$lessinit$greater$default$8();
        double x$30 = Strategy$.MODULE$.$lessinit$greater$default$9();
        int x$31 = Strategy$.MODULE$.$lessinit$greater$default$10();
        double x$32 = Strategy$.MODULE$.$lessinit$greater$default$11();
        boolean x$33 = Strategy$.MODULE$.$lessinit$greater$default$12();
        int x$34 = Strategy$.MODULE$.$lessinit$greater$default$13();
        Strategy strategy = new Strategy(x$22, x$23, x$24, x$25, x$26, x$28, (scala.collection.immutable.Map<Object, Object>)x$27, x$29, x$30, x$31, x$32, x$33, x$34);
        RDD cached = data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        try {
            Enumeration.Value value = algo;
            Enumeration.Value value2 = Algo$.MODULE$.Classification();
            RandomForestModel randomForestModel = !(value != null ? !value.equals(value2) : value2 != null) ? RandomForest$.MODULE$.trainClassifier((RDD<LabeledPoint>)cached, strategy, numTrees, featureSubsetStrategy, seed) : RandomForest$.MODULE$.trainRegressor((RDD<LabeledPoint>)cached, strategy, numTrees, featureSubsetStrategy, seed);
            return randomForestModel;
        }
        finally {
            cached.unpersist(false);
        }
    }

    public GradientBoostedTreesModel trainGradientBoostedTreesModel(JavaRDD<LabeledPoint> data, String algoStr, Map<Object, Object> categoricalFeaturesInfo, String lossStr, int numIterations, double learningRate, int maxDepth) {
        BoostingStrategy boostingStrategy = BoostingStrategy$.MODULE$.defaultParams(algoStr);
        boostingStrategy.setLoss(Losses$.MODULE$.fromString(lossStr));
        boostingStrategy.setNumIterations(numIterations);
        boostingStrategy.setLearningRate(learningRate);
        boostingStrategy.treeStrategy().setMaxDepth(maxDepth);
        boostingStrategy.treeStrategy().categoricalFeaturesInfo_$eq((scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()));
        RDD cached = data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        try {
            return GradientBoostedTrees$.MODULE$.train((RDD<LabeledPoint>)cached, boostingStrategy);
        }
        finally {
            cached.unpersist(false);
        }
    }

    public MultivariateStatisticalSummary colStats(JavaRDD<Vector> rdd) {
        return Statistics$.MODULE$.colStats((RDD<Vector>)rdd.rdd());
    }

    public Matrix corr(JavaRDD<Vector> x, String method) {
        return Statistics$.MODULE$.corr((RDD<Vector>)x.rdd(), this.getCorrNameOrDefault(method));
    }

    public double corr(JavaRDD<Object> x, JavaRDD<Object> y, String method) {
        return Statistics$.MODULE$.corr((RDD<Object>)x.rdd(), (RDD<Object>)y.rdd(), this.getCorrNameOrDefault(method));
    }

    public ChiSqTestResult chiSqTest(Vector observed, Vector expected) {
        return expected == null ? Statistics$.MODULE$.chiSqTest(observed) : Statistics$.MODULE$.chiSqTest(observed, expected);
    }

    public ChiSqTestResult chiSqTest(Matrix observed) {
        return Statistics$.MODULE$.chiSqTest(observed);
    }

    public ChiSqTestResult[] chiSqTest(JavaRDD<LabeledPoint> data) {
        return Statistics$.MODULE$.chiSqTest((RDD<LabeledPoint>)data.rdd());
    }

    private String getCorrNameOrDefault(String method) {
        return method == null ? CorrelationNames$.MODULE$.defaultCorrName() : method;
    }

    private long getSeedOrDefault(Long seed) {
        return seed == null ? Utils$.MODULE$.random().nextLong() : Predef$.MODULE$.Long2long(seed);
    }

    private int getNumPartitionsOrDefault(Integer numPartitions, JavaSparkContext jsc) {
        return numPartitions == null ? jsc.sc().defaultParallelism() : Predef$.MODULE$.Integer2int(numPartitions);
    }

    public JavaRDD<Object> uniformRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformRDD(jsc.sc(), size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> normalRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalRDD(jsc.sc(), size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> logNormalRDD(JavaSparkContext jsc, double mean2, double std, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.logNormalRDD(jsc.sc(), mean2, std, size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> poissonRDD(JavaSparkContext jsc, double mean2, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonRDD(jsc.sc(), mean2, size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> exponentialRDD(JavaSparkContext jsc, double mean2, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.exponentialRDD(jsc.sc(), mean2, size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> gammaRDD(JavaSparkContext jsc, double shape, double scale, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.gammaRDD(jsc.sc(), shape, scale, size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Vector> uniformVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformVectorRDD(jsc.sc(), numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> normalVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalVectorRDD(jsc.sc(), numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> logNormalVectorRDD(JavaSparkContext jsc, double mean2, double std, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.logNormalVectorRDD(jsc.sc(), mean2, std, numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> poissonVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> exponentialVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.exponentialVectorRDD(jsc.sc(), mean2, numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> gammaVectorRDD(JavaSparkContext jsc, double shape, double scale, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.gammaVectorRDD(jsc.sc(), shape, scale, numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public class Word2VecModelWrapper {
        public final Word2VecModel org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model;
        public final /* synthetic */ PythonMLLibAPI $outer;

        public Vector transform(String word) {
            return this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.transform(word);
        }

        public JavaRDD<Vector> transform(JavaRDD<String> rdd) {
            return JavaRDD$.MODULE$.fromRDD(rdd.rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Word2VecModelWrapper $outer;

                public final Vector apply(String word) {
                    return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.transform(word);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Vector.class)), ClassTag$.MODULE$.apply(Vector.class));
        }

        public List<Object> findSynonyms(String word, int num) {
            Vector vec = this.transform(word);
            return this.findSynonyms(vec, num);
        }

        public List<Object> findSynonyms(Vector vector, int num) {
            Tuple2<String, Object>[] result = this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.findSynonyms(vector, num);
            Vector similarity = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<String, Object> x$6) {
                    return x$6._2$mcD$sp();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            String[] words = (String[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x$7) {
                    return (String)x$7._1();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{words, similarity})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$8) {
                    return x$8;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
        }

        public /* synthetic */ PythonMLLibAPI org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$$outer() {
            return this.$outer;
        }

        public Word2VecModelWrapper(PythonMLLibAPI $outer, Word2VecModel model) {
            this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model = model;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

