/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.normalize$;
import breeze.linalg.sum$;
import breeze.storage.Zero;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.DistributedLDAModel$$anonfun$describeTopics$2$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.BoundedPriorityQueue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.IndexedSeq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u00015\u00111\u0003R5tiJL'-\u001e;fI2#\u0015)T8eK2T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005!aE)Q'pI\u0016d\u0007\u0002C\n\u0001\u0005\u000b\u0007I\u0011\u0002\u000b\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0016\u0003U\u0001BAF\r\u001cE5\tqC\u0003\u0002\u0019\r\u00051qM]1qQbL!AG\f\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0005qybBA\b\u001e\u0013\tq\"!A\u0002M\t\u0006K!\u0001I\u0011\u0003\u0017Q{\u0007/[2D_VtGo\u001d\u0006\u0003=\t\u0001\"\u0001H\u0012\n\u0005\u0011\n#A\u0003+pW\u0016t7i\\;oi\"Aa\u0005\u0001B\u0001B\u0003%Q#\u0001\u0004he\u0006\u0004\b\u000e\t\u0005\tQ\u0001\u0011)\u0019!C\u0005S\u0005\tr\r\\8cC2$v\u000e]5d)>$\u0018\r\\:\u0016\u0003mA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0013O2|'-\u00197U_BL7\rV8uC2\u001c\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003\u0005YW#A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u0007%sG\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00030\u0003\tY\u0007\u0005\u0003\u00059\u0001\t\u0015\r\u0011\"\u0001/\u0003%1xnY1c'&TX\r\u0003\u0005;\u0001\t\u0005\t\u0015!\u00030\u0003)1xnY1c'&TX\r\t\u0005\ty\u0001\u0011)\u0019!C\u0005{\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002}A\u0011\u0001gP\u0005\u0003\u0001F\u0012a\u0001R8vE2,\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002#\u0011|7mQ8oG\u0016tGO]1uS>t\u0007\u0005\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0003>\u0003I!x\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\t\u0011\u0019\u0003!\u0011!Q\u0001\ny\n1\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B\u0011\u0002\u0013\u0001\u0003\u0006\u0004%\tAB%\u0002\u001d%$XM]1uS>tG+[7fgV\t!\nE\u00021\u0017zJ!\u0001T\u0019\u0003\u000b\u0005\u0013(/Y=\t\u00119\u0003!\u0011!Q\u0001\n)\u000bq\"\u001b;fe\u0006$\u0018n\u001c8US6,7\u000f\t\u0005\u0006!\u0002!I!U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011I\u001bF+\u0016,X1f\u0003\"a\u0004\u0001\t\u000bMy\u0005\u0019A\u000b\t\u000b!z\u0005\u0019A\u000e\t\u000b5z\u0005\u0019A\u0018\t\u000baz\u0005\u0019A\u0018\t\u000bqz\u0005\u0019\u0001 \t\u000b\u0011{\u0005\u0019\u0001 \t\u000b!{\u0005\u0019\u0001&\t\rA\u0003A\u0011\u0001\u0002\\)\r\u0011F,\u0019\u0005\u0006;j\u0003\rAX\u0001\u0006gR\fG/\u001a\t\u00039}K!\u0001Y\u0011\u0003\u0017\u0015ku\n\u001d;j[&TXM\u001d\u0005\u0006\u0011j\u0003\rA\u0013\u0005\u0006G\u0002!\t\u0001Z\u0001\bi>dunY1m+\u0005)\u0007CA\bg\u0013\t9'AA\u0007M_\u000e\fG\u000e\u0014#B\u001b>$W\r\u001c\u0005\tS\u0002A)\u0019!C!U\u0006aAo\u001c9jGNl\u0015\r\u001e:jqV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o\t\u00051A.\u001b8bY\u001eL!\u0001]7\u0003\r5\u000bGO]5y\u0011!\u0011\b\u0001#A!B\u0013Y\u0017!\u0004;pa&\u001c7/T1ue&D\b\u0005C\u0003u\u0001\u0011\u0005S/\u0001\beKN\u001c'/\u001b2f)>\u0004\u0018nY:\u0015\u0005Y\\\bc\u0001\u0019LoB!\u0001\u0007\u001f>K\u0013\tI\u0018G\u0001\u0004UkBdWM\r\t\u0004a-{\u0003\"\u0002?t\u0001\u0004y\u0013\u0001E7bqR+'/\\:QKJ$v\u000e]5d\u0011!q\b\u0001#b\u0001\n\u0003i\u0014!\u00047pO2K7.\u001a7jQ>|G\rC\u0005\u0002\u0002\u0001A\t\u0011)Q\u0005}\u0005qAn\\4MS.,G.\u001b5p_\u0012\u0004\u0003\"CA\u0003\u0001!\u0015\r\u0011\"\u0001>\u0003!awn\u001a)sS>\u0014\b\"CA\u0005\u0001!\u0005\t\u0015)\u0003?\u0003%awn\u001a)sS>\u0014\b\u0005C\u0004\u0002\u000e\u0001!\t!a\u0004\u0002%Q|\u0007/[2ESN$(/\u001b2vi&|gn]\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001a\u0005uQBAA\u000b\u0015\r\t9BB\u0001\u0004e\u0012$\u0017\u0002BA\u000e\u0003+\u00111A\u0015#E!\u0019\u0001\u00040a\b\u0002&A\u0019\u0001'!\t\n\u0007\u0005\r\u0012G\u0001\u0003M_:<\u0007c\u00017\u0002(%\u0019\u0011\u0011F7\u0003\rY+7\r^8sQ\r\u0001\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u0005E\"\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class DistributedLDAModel
extends LDAModel {
    private final Graph<DenseVector<Object>, Object> graph;
    private final DenseVector<Object> globalTopicTotals;
    private final int k;
    private final int vocabSize;
    private final double docConcentration;
    private final double topicConcentration;
    private final double[] iterationTimes;
    private org.apache.spark.mllib.linalg.Matrix topicsMatrix;
    private double logLikelihood;
    private double logPrior;
    private volatile byte bitmap$0;

    private org.apache.spark.mllib.linalg.Matrix topicsMatrix$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2[] termTopicCounts = (Tuple2[])this.graph().vertices().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, DenseVector<Object>> x$3) {
                        return x$3._1$mcJ$sp() < 0L;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> x0$1) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            long termIndex = tuple2._1$mcJ$sp();
                            DenseVector cnts = (DenseVector)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)LDA$.MODULE$.index2term(termIndex)), (Object)cnts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                DenseMatrix brzTopics = DenseMatrix$.MODULE$.zeros$mDc$sp(this.vocabSize(), this.k(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Predef$.MODULE$.refArrayOps((Object[])termTopicCounts).foreach((Function1)new Serializable(this, brzTopics){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DistributedLDAModel $outer;
                    private final DenseMatrix brzTopics$2;

                    public final void apply(Tuple2<Object, DenseVector<Object>> x0$2) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int term = tuple2._1$mcI$sp();
                            DenseVector cnts = (DenseVector)tuple2._2();
                            for (int j = 0; j < this.$outer.k(); ++j) {
                                this.brzTopics$2.update$mcD$sp(term, j, cnts.apply$mcD$sp(j));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.brzTopics$2 = brzTopics$2;
                    }
                });
                this.topicsMatrix = Matrices$.MODULE$.fromBreeze((Matrix<Object>)brzTopics);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.topicsMatrix;
        }
    }

    private double logLikelihood$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                double eta = this.topicConcentration();
                double alpha = this.docConcentration();
                Predef$.MODULE$.assert(eta > 1.0);
                Predef$.MODULE$.assert(alpha > 1.0);
                DenseVector<Object> N_k = this.globalTopicTotals();
                DenseVector smoothed_N_k = (DenseVector)N_k.$plus((Object)BoxesRunTime.boxToDouble((double)((double)this.vocabSize() * (eta - 1.0))), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                Serializable sendMsg = new Serializable(this, eta, alpha, smoothed_N_k){
                    public static final long serialVersionUID = 0L;
                    private final double eta$1;
                    private final double alpha$1;
                    private final DenseVector smoothed_N_k$1;

                    public final void apply(EdgeContext<DenseVector<Object>, Object, Object> edgeContext) {
                        double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
                        DenseVector smoothed_N_wk = (DenseVector)((NumericOps)edgeContext.dstAttr()).$plus((Object)BoxesRunTime.boxToDouble((double)(this.eta$1 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                        DenseVector smoothed_N_kj = (DenseVector)((NumericOps)edgeContext.srcAttr()).$plus((Object)BoxesRunTime.boxToDouble((double)(this.alpha$1 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                        DenseVector phi_wk = (DenseVector)smoothed_N_wk.$colon$div((Object)this.smoothed_N_k$1, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
                        DenseVector theta_kj = (DenseVector)normalize$.MODULE$.apply((Object)smoothed_N_kj, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                        double tokenLogLikelihood = N_wj * scala.math.package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)phi_wk.dot((Object)theta_kj, DenseVector$.MODULE$.canDotD())));
                        edgeContext.sendToDst((Object)BoxesRunTime.boxToDouble((double)tokenLogLikelihood));
                    }
                    {
                        this.eta$1 = eta$1;
                        this.alpha$1 = alpha$1;
                        this.smoothed_N_k$1 = smoothed_N_k$1;
                    }
                };
                this.logLikelihood = BoxesRunTime.unboxToDouble((Object)this.graph().aggregateMessages((Function1)sendMsg, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$7, double x$8) {
                        return this.apply$mcDDD$sp(x$7, x$8);
                    }

                    public double apply$mcDDD$sp(double x$7, double x$8) {
                        return x$7 + x$8;
                    }
                }, this.graph().aggregateMessages$default$3(), ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$9) {
                        return x$9._2$mcD$sp();
                    }
                }, ClassTag$.MODULE$.Double()).fold((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$10, double x$11) {
                        return this.apply$mcDDD$sp(x$10, x$11);
                    }

                    public double apply$mcDDD$sp(double x$10, double x$11) {
                        return x$10 + x$11;
                    }
                }));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logLikelihood;
        }
    }

    private double logPrior$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                double eta = this.topicConcentration();
                double alpha = this.docConcentration();
                DenseVector<Object> N_k = this.globalTopicTotals();
                DenseVector smoothed_N_k = (DenseVector)N_k.$plus((Object)BoxesRunTime.boxToDouble((double)((double)this.vocabSize() * (eta - 1.0))), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                Serializable seqOp = new Serializable(this, eta, alpha, smoothed_N_k){
                    public static final long serialVersionUID = 0L;
                    private final double eta$2;
                    private final double alpha$2;
                    private final DenseVector smoothed_N_k$2;

                    public final double apply(double x0$4, Tuple2<Object, DenseVector<Object>> x1$1) {
                        Tuple2 vertex;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$4), x1$1);
                        if (tuple2 != null && (vertex = (Tuple2)tuple2._2()) != null) {
                            double d;
                            Tuple2 tuple22 = vertex;
                            if (LDA$.MODULE$.isTermVertex(tuple22)) {
                                DenseVector N_wk = (DenseVector)tuple22._2();
                                DenseVector smoothed_N_wk = (DenseVector)N_wk.$plus((Object)BoxesRunTime.boxToDouble((double)(this.eta$2 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                                DenseVector phi_wk = (DenseVector)smoothed_N_wk.$colon$div((Object)this.smoothed_N_k$2, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
                                d = (this.eta$2 - 1.0) * BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(phi_wk.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(double x) {
                                        return this.apply$mcDD$sp(x);
                                    }

                                    public double apply$mcDD$sp(double x) {
                                        return scala.math.package$.MODULE$.log(x);
                                    }
                                }, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            } else {
                                DenseVector N_kj = (DenseVector)tuple22._2();
                                DenseVector smoothed_N_kj = (DenseVector)N_kj.$plus((Object)BoxesRunTime.boxToDouble((double)(this.alpha$2 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                                DenseVector theta_kj = (DenseVector)normalize$.MODULE$.apply((Object)smoothed_N_kj, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                                d = (this.alpha$2 - 1.0) * BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(theta_kj.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(double x) {
                                        return this.apply$mcDD$sp(x);
                                    }

                                    public double apply$mcDD$sp(double x) {
                                        return scala.math.package$.MODULE$.log(x);
                                    }
                                }, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            }
                            double d2 = d;
                            return d2;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.eta$2 = eta$2;
                        this.alpha$2 = alpha$2;
                        this.smoothed_N_k$2 = smoothed_N_k$2;
                    }
                };
                this.logPrior = BoxesRunTime.unboxToDouble((Object)this.graph().vertices().aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)seqOp, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$12, double x$13) {
                        return this.apply$mcDDD$sp(x$12, x$13);
                    }

                    public double apply$mcDDD$sp(double x$12, double x$13) {
                        return x$12 + x$13;
                    }
                }, ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.logPrior;
        }
    }

    private Graph<DenseVector<Object>, Object> graph() {
        return this.graph;
    }

    private DenseVector<Object> globalTopicTotals() {
        return this.globalTopicTotals;
    }

    @Override
    public int k() {
        return this.k;
    }

    @Override
    public int vocabSize() {
        return this.vocabSize;
    }

    private double docConcentration() {
        return this.docConcentration;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    public double[] iterationTimes() {
        return this.iterationTimes;
    }

    public LocalLDAModel toLocal() {
        return new LocalLDAModel(this.topicsMatrix());
    }

    @Override
    public org.apache.spark.mllib.linalg.Matrix topicsMatrix() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.topicsMatrix$lzycompute() : this.topicsMatrix;
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        int numTopics = this.k();
        DenseVector<Object> N_k = this.globalTopicTotals();
        VertexRDD qual$1 = this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isTermVertex(v);
            }
        });
        Serializable x$14 = new Serializable(this, maxTermsPerTopic, numTopics, N_k){
            public static final long serialVersionUID = 0L;
            public final int maxTermsPerTopic$2;
            public final int numTopics$1;
            public final DenseVector N_k$1;

            public final Iterator<BoundedPriorityQueue<Tuple2<Object, Object>>[]> apply(Iterator<Tuple2<Object, DenseVector<Object>>> termVertices) {
                BoundedPriorityQueue[] queues = (BoundedPriorityQueue[])Array$.MODULE$.fill(this.numTopics$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply() {
                        return new BoundedPriorityQueue(this.$outer.maxTermsPerTopic$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
                termVertices.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, DenseVector<Object>> check$ifrefutable$1) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, queues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final BoundedPriorityQueue[] queues$1;

                    public final void apply(Tuple2<Object, DenseVector<Object>> x$4) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x$4;
                        if (tuple2 != null) {
                            long termId = tuple2._1$mcJ$sp();
                            DenseVector n_wk = (DenseVector)tuple2._2();
                            for (int topic = 0; topic < this.$outer.numTopics$1; ++topic) {
                                this.queues$1[topic].$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)(n_wk.apply$mcD$sp(topic) / this.$outer.N_k$1.apply$mcD$sp(topic)))), (Object)BoxesRunTime.boxToInteger((int)LDA$.MODULE$.index2term((int)termId))));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.queues$1 = queues$1;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundedPriorityQueue[][]{queues}));
            }
            {
                this.maxTermsPerTopic$2 = maxTermsPerTopic$2;
                this.numTopics$1 = numTopics$1;
                this.N_k$1 = N_k$1;
            }
        };
        boolean x$15 = qual$1.mapPartitions$default$2();
        BoundedPriorityQueue[] topicsInQueues = (BoundedPriorityQueue[])qual$1.mapPartitions((Function1)x$14, x$15, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BoundedPriorityQueue.class))).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BoundedPriorityQueue<Tuple2<Object, Object>>[] apply(BoundedPriorityQueue<Tuple2<Object, Object>>[] q1, BoundedPriorityQueue<Tuple2<Object, Object>>[] q2) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])q1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])q2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply(Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> x0$3) {
                        Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            BoundedPriorityQueue a = (BoundedPriorityQueue)tuple2._1();
                            BoundedPriorityQueue b = (BoundedPriorityQueue)tuple2._2();
                            BoundedPriorityQueue boundedPriorityQueue = a.$plus$plus$eq((TraversableOnce)b);
                            return boundedPriorityQueue;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                return q1;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])topicsInQueues).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<int[], double[]> apply(BoundedPriorityQueue<Tuple2<Object, Object>> q) {
                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])q.toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new $anonfun$describeTopics$2$$anonfun$8(this), (Ordering)Ordering.Double$.MODULE$)).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    IndexedSeq termWeights = (IndexedSeq)tuple2._1();
                    IndexedSeq terms = (IndexedSeq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)termWeights, (Object)terms);
                    IndexedSeq termWeights2 = (IndexedSeq)tuple23._1();
                    IndexedSeq terms2 = (IndexedSeq)tuple23._2();
                    return new Tuple2(terms2.toArray(ClassTag$.MODULE$.Int()), termWeights2.toArray(ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public double logLikelihood() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logLikelihood$lzycompute() : this.logLikelihood;
    }

    public double logPrior() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logPrior$lzycompute() : this.logPrior;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions() {
        return this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isDocumentVertex(v);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(Tuple2<Object, DenseVector<Object>> x0$5) {
                Tuple2<Object, DenseVector<Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    long docID = tuple2._1$mcJ$sp();
                    DenseVector topicCounts = (DenseVector)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docID), (Object)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)normalize$.MODULE$.apply((Object)topicCounts, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double())))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private DistributedLDAModel(Graph<DenseVector<Object>, Object> graph, DenseVector<Object> globalTopicTotals, int k, int vocabSize, double docConcentration, double topicConcentration, double[] iterationTimes) {
        this.graph = graph;
        this.globalTopicTotals = globalTopicTotals;
        this.k = k;
        this.vocabSize = vocabSize;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.iterationTimes = iterationTimes;
    }

    public DistributedLDAModel(LDA.EMOptimizer state, double[] iterationTimes) {
        this(state.graph(), state.globalTopicTotals(), state.k(), state.vocabSize(), state.docConcentration(), state.topicConcentration(), iterationTimes);
    }
}

