/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.storage.Zero;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.impl.GraphImpl;
import org.apache.spark.graphx.impl.GraphImpl$;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.impl.PeriodicGraphCheckpointer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u00015\u00111\u0001\u0014#B\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u00051\u0011BA\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0004%IAG\u0001\u0002WV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0002\u0011\u0002\u000b-|F%Z9\u0015\u0005\u0005\"\u0003CA\b#\u0013\t\u0019\u0003C\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\raG\u0001\u0004q\u0012\n\u0004\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0015B\u000e\u0002\u0005-\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0007I\u0011\u0002\u000e\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011!Y\u0003A!a\u0001\n\u0013a\u0013!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0011\u0011%\f\u0005\bK)\n\t\u00111\u0001\u001c\u0011!y\u0003A!A!B\u0013Y\u0012AD7bq&#XM]1uS>t7\u000f\t\u0005\tc\u0001\u0011\t\u0019!C\u0005e\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002gA\u0011q\u0002N\u0005\u0003kA\u0011a\u0001R8vE2,\u0007\u0002C\u001c\u0001\u0005\u0003\u0007I\u0011\u0002\u001d\u0002)\u0011|7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\t\u0013\bC\u0004&m\u0005\u0005\t\u0019A\u001a\t\u0011m\u0002!\u0011!Q!\nM\n\u0011\u0003Z8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8!\u0011!i\u0004A!a\u0001\n\u0013\u0011\u0014A\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:D\u0001b\u0010\u0001\u0003\u0002\u0004%I\u0001Q\u0001\u0017i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|gn\u0018\u0013fcR\u0011\u0011%\u0011\u0005\bKy\n\t\u00111\u00014\u0011!\u0019\u0005A!A!B\u0013\u0019\u0014a\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:\u0004\u0003\u0002C#\u0001\u0005\u0003\u0007I\u0011\u0002$\u0002\tM,W\rZ\u000b\u0002\u000fB\u0011q\u0002S\u0005\u0003\u0013B\u0011A\u0001T8oO\"A1\n\u0001BA\u0002\u0013%A*\u0001\u0005tK\u0016$w\fJ3r)\t\tS\nC\u0004&\u0015\u0006\u0005\t\u0019A$\t\u0011=\u0003!\u0011!Q!\n\u001d\u000bQa]3fI\u0002B\u0001\"\u0015\u0001\u0003\u0002\u0004%IAG\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0003\u0005T\u0001\t\u0005\r\u0011\"\u0003U\u0003Y\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197`I\u0015\fHCA\u0011V\u0011\u001d)#+!AA\u0002mA\u0001b\u0016\u0001\u0003\u0002\u0003\u0006KaG\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\u00063\u0002!IAW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fmkfl\u00181bEB\u0011A\fA\u0007\u0002\u0005!)\u0011\u0004\u0017a\u00017!)\u0011\u0006\u0017a\u00017!)\u0011\u0007\u0017a\u0001g!)Q\b\u0017a\u0001g!)Q\t\u0017a\u0001\u000f\")\u0011\u000b\u0017a\u00017!)\u0011\f\u0001C\u0001IR\t1\fC\u0003g\u0001\u0011\u0005!$\u0001\u0003hKR\\\u0005\"\u00025\u0001\t\u0003I\u0017\u0001B:fi.#\"A[6\u000e\u0003\u0001AQ!G4A\u0002mAQ!\u001c\u0001\u0005\u0002I\n1cZ3u\t>\u001c7i\u001c8dK:$(/\u0019;j_:DQa\u001c\u0001\u0005\u0002A\f1c]3u\t>\u001c7i\u001c8dK:$(/\u0019;j_:$\"A[9\t\u000bEr\u0007\u0019A\u001a\t\u000bM\u0004A\u0011\u0001\u001a\u0002\u0011\u001d,G/\u00117qQ\u0006DQ!\u001e\u0001\u0005\u0002Y\f\u0001b]3u\u00032\u0004\b.\u0019\u000b\u0003U^DQ\u0001\u001f;A\u0002M\nQ!\u00197qQ\u0006DQA\u001f\u0001\u0005\u0002I\nQcZ3u)>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g\u000eC\u0003}\u0001\u0011\u0005Q0A\u000btKR$v\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0015\u0005)t\b\"B\u001f|\u0001\u0004\u0019\u0004BBA\u0001\u0001\u0011\u0005!'A\u0004hKR\u0014U\r^1\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u000591/\u001a;CKR\fGc\u00016\u0002\n!9\u00111BA\u0002\u0001\u0004\u0019\u0014\u0001\u00022fi\u0006Da!a\u0004\u0001\t\u0003Q\u0012\u0001E4fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\t\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\u0007)\f9\u0002\u0003\u0004*\u0003#\u0001\ra\u0007\u0005\u0007\u00037\u0001A\u0011\u0001$\u0002\u000f\u001d,GoU3fI\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012aB:fiN+W\r\u001a\u000b\u0004U\u0006\r\u0002BB#\u0002\u001e\u0001\u0007q\t\u0003\u0004\u0002(\u0001!\tAG\u0001\u0016O\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\tQc]3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000eF\u0002k\u0003_Aa!UA\u0015\u0001\u0004Y\u0002bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0004eVtG\u0003BA\u001c\u0003{\u00012\u0001XA\u001d\u0013\r\tYD\u0001\u0002\u0014\t&\u001cHO]5ckR,G\r\u0014#B\u001b>$W\r\u001c\u0005\t\u0003\u007f\t\t\u00041\u0001\u0002B\u0005IAm\\2v[\u0016tGo\u001d\t\u0007\u0003\u0007\nI%!\u0014\u000e\u0005\u0005\u0015#bAA$\r\u0005\u0019!\u000f\u001a3\n\t\u0005-\u0013Q\t\u0002\u0004%\u0012#\u0005CB\b\u0002P\u001d\u000b\u0019&C\u0002\u0002RA\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005eC!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003;\n9F\u0001\u0004WK\u000e$xN\u001d\u0005\b\u0003g\u0001A\u0011AA1)\u0011\t9$a\u0019\t\u0011\u0005}\u0012q\fa\u0001\u0003K\u0002\u0002\"a\u001a\u0002r\u0005U\u00141K\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!!.\u0019<b\u0015\r\tyGB\u0001\u0004CBL\u0017\u0002BA:\u0003S\u00121BS1wCB\u000b\u0017N\u001d*E\tB!\u0011qOA@\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014\u0001\u00027b]\u001eT!!a\u001b\n\u0007%\u000bI\bK\u0002\u0001\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u00133\u0011AC1o]>$\u0018\r^5p]&!\u0011QRAD\u00051)\u0005\u0010]3sS6,g\u000e^1m\u000f!\t\tJ\u0001E\u0001\u0005\u0005M\u0015a\u0001'E\u0003B\u0019A,!&\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0002\u0018N\u0019\u0011Q\u0013\b\t\u000fe\u000b)\n\"\u0001\u0002\u001cR\u0011\u00111S\u0003\t\u0003?\u000b)\n\u0001\u0002\u0002\"\nYAk\u001c9jG\u000e{WO\u001c;t!\u0015\t\u0019+a+4\u001b\t\t)K\u0003\u0003\u0002Z\u0005\u001d&BAAU\u0003\u0019\u0011'/Z3{K&!\u0011QVAS\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0006\u000f\u0005E\u0016Q\u0013\u0001\u0003g\tQAk\\6f]\u000e{WO\u001c;\t\u0013\u0005U\u0016Q\u0013C\u0001\u0005\u0005]\u0016A\u0003;fe6\u0014\u0014N\u001c3fqR\u0019q)!/\t\u000f\u0005m\u00161\u0017a\u00017\u0005!A/\u001a:n\u0011%\ty,!&\u0005\u0002\t\t\t-\u0001\u0006j]\u0012,\u0007P\r;fe6$2aGAb\u0011\u001d\t)-!0A\u0002\u001d\u000b\u0011\u0002^3s[&sG-\u001a=\t\u0013\u0005%\u0017Q\u0013C\u0001\u0005\u0005-\u0017\u0001E5t\t>\u001cW/\\3oiZ+'\u000f^3y)\u0011\ti-a5\u0011\u0007=\ty-C\u0002\u0002RB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002V\u0006\u001d\u0007\u0019AAl\u0003\u00051\b\u0007BAm\u0005\u000f\u0001raDA(\u00037\u0014\u0019\u0001\u0005\u0003\u0002^\u0006uh\u0002BAp\u0003otA!!9\u0002t:!\u00111]Ay\u001d\u0011\t)/a<\u000f\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003k4\u0011AB4sCBD\u00070\u0003\u0003\u0002z\u0006m\u0018a\u00029bG.\fw-\u001a\u0006\u0004\u0003k4\u0011\u0002BA\u0000\u0005\u0003\u0011\u0001BV3si\u0016D\u0018\n\u001a\u0006\u0005\u0003s\fY\u0010\u0005\u0003\u0003\u0006\t\u001dA\u0002\u0001\u0003\r\u0005\u0013\t\u0019.!A\u0001\u0002\u000b\u0005!1\u0002\u0002\u0004?\u0012\n\u0014\u0003\u0002B\u0007\u0005'\u00012a\u0004B\b\u0013\r\u0011\t\u0002\u0005\u0002\b\u001d>$\b.\u001b8h!\ry!QC\u0005\u0004\u0005/\u0001\"aA!os\"I!1DAK\t\u0003\u0011!QD\u0001\rSN$VM]7WKJ$X\r\u001f\u000b\u0005\u0003\u001b\u0014y\u0002\u0003\u0005\u0002V\ne\u0001\u0019\u0001B\u0011a\u0011\u0011\u0019Ca\n\u0011\u000f=\ty%a7\u0003&A!!Q\u0001B\u0014\t1\u0011ICa\b\u0002\u0002\u0003\u0005)\u0011\u0001B\u0006\u0005\ryFE\r\u0004\t\u0005[\t)\n\u0001\u0002\u00030\tYQ)T(qi&l\u0017N_3s'\r\u0011YC\u0004\u0005\f\u0005g\u0011YC!a\u0001\n\u0003\u0011)$A\u0003he\u0006\u0004\b.\u0006\u0002\u00038AA!\u0011\bB\u001e\u0005\u007f\u0011\u0019%\u0004\u0002\u0002|&!!QHA~\u0005\u00159%/\u00199i!\u0011\u0011\t%!(\u000e\u0005\u0005U\u0005\u0003\u0002B!\u0003_C1Ba\u0012\u0003,\t\u0005\r\u0011\"\u0001\u0003J\u0005IqM]1qQ~#S-\u001d\u000b\u0004C\t-\u0003\"C\u0013\u0003F\u0005\u0005\t\u0019\u0001B\u001c\u0011-\u0011yEa\u000b\u0003\u0002\u0003\u0006KAa\u000e\u0002\r\u001d\u0014\u0018\r\u001d5!\u0011%I\"1\u0006BC\u0002\u0013\u0005!\u0004C\u0005(\u0005W\u0011\t\u0011)A\u00057!Q!q\u000bB\u0016\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u0013Y|7-\u00192TSj,\u0007B\u0003B.\u0005W\u0011\t\u0011)A\u00057\u0005Qao\\2bENK'0\u001a\u0011\t\u0013E\u0012YC!b\u0001\n\u0003\u0011\u0004\"C\u001e\u0003,\t\u0005\t\u0015!\u00034\u0011%i$1\u0006BC\u0002\u0013\u0005!\u0007C\u0005D\u0005W\u0011\t\u0011)A\u0005g!I\u0011Ka\u000b\u0003\u0002\u0003\u0006Ia\u0007\u0005\b3\n-B\u0011\u0001B5)9\u0011YG!\u001c\u0003p\tE$1\u000fB;\u0005o\u0002BA!\u0011\u0003,!A!1\u0007B4\u0001\u0004\u00119\u0004\u0003\u0004\u001a\u0005O\u0002\ra\u0007\u0005\b\u0005/\u00129\u00071\u0001\u001c\u0011\u0019\t$q\ra\u0001g!1QHa\u001aA\u0002MBa!\u0015B4\u0001\u0004Y\u0002\u0002\u0004B>\u0005W\u0011\r\u0011\"\u0001\u0002\u0016\nu\u0014!E4sCBD7\t[3dWB|\u0017N\u001c;feV\u0011!q\u0010\t\t\u0005\u0003\u00139Ia\u0010\u0003D5\u0011!1\u0011\u0006\u0004\u0005\u000b#\u0011\u0001B5na2LAA!#\u0003\u0004\nI\u0002+\u001a:j_\u0012L7m\u0012:ba\"\u001c\u0005.Z2la>Lg\u000e^3s\u0011%\u0011iIa\u000b!\u0002\u0013\u0011y(\u0001\nhe\u0006\u0004\bn\u00115fG.\u0004x.\u001b8uKJ\u0004\u0003\u0002\u0003BI\u0005W!\tAa%\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0005WB!Ba&\u0003,\u0001\u0007I\u0011\u0001BM\u0003E9Gn\u001c2bYR{\u0007/[2U_R\fGn]\u000b\u0003\u0005\u007fA!B!(\u0003,\u0001\u0007I\u0011\u0001BP\u0003U9Gn\u001c2bYR{\u0007/[2U_R\fGn]0%KF$2!\tBQ\u0011%)#1TA\u0001\u0002\u0004\u0011y\u0004C\u0005\u0003&\n-\u0002\u0015)\u0003\u0003@\u0005\u0011r\r\\8cC2$v\u000e]5d)>$\u0018\r\\:!\u0011!\u0011IKa\u000b\u0005\n\t-\u0016\u0001G2p[B,H/Z$m_\n\fG\u000eV8qS\u000e$v\u000e^1mgR\u0011!q\b\u0005\t\u0005_\u000b)\n\"\u0003\u00032\u0006i1m\\7qkR,\u0007\u000bV8qS\u000e$bBa\u0010\u00034\n]&1\u0018B`\u0005\u0003\u0014)\r\u0003\u0005\u00036\n5\u0006\u0019\u0001B \u00039!wn\u0019+pa&\u001c7i\\;oiND\u0001B!/\u0003.\u0002\u0007!qH\u0001\u0010i\u0016\u0014X\u000eV8qS\u000e\u001cu.\u001e8ug\"A!Q\u0018BW\u0001\u0004\u0011y$\u0001\tu_R\fG\u000eV8qS\u000e\u001cu.\u001e8ug\"9!q\u000bBW\u0001\u0004Y\u0002b\u0002Bb\u0005[\u0003\raM\u0001\u0004KR\f\u0007B\u0002=\u0003.\u0002\u00071\u0007\u0003\u0005\u0003J\u0006UE\u0011\u0002Bf\u00031Ig.\u001b;jC2\u001cF/\u0019;f)9\u0011YG!4\u0003R\nM'Q\u001bBl\u00057D\u0001Ba4\u0003H\u0002\u0007\u0011\u0011I\u0001\u0005I>\u001c7\u000f\u0003\u0004\u001a\u0005\u000f\u0004\ra\u0007\u0005\u0007c\t\u001d\u0007\u0019A\u001a\t\ru\u00129\r1\u00014\u0011\u001d\u0011INa2A\u0002\u001d\u000b!B]1oI>l7+Z3e\u0011\u0019\t&q\u0019a\u00017\u0001")
public class LDA
implements Logging {
    private int k;
    private int maxIterations;
    private double docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(double x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    public int getK() {
        return this.k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA k (number of clusters) must be > 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public double getDocConcentration() {
        return this.docConcentration() == (double)-1 ? 50.0 / (double)this.k() + 1.0 : this.docConcentration();
    }

    public LDA setDocConcentration(double docConcentration) {
        Predef$.MODULE$.require(docConcentration > 1.0 || docConcentration == -1.0, (Function0)new Serializable(this, docConcentration){
            public static final long serialVersionUID = 0L;
            private final double docConcentration$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA docConcentration must be > 1.0 (or -1 for auto), but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.docConcentration$1)}));
            }
            {
                this.docConcentration$1 = docConcentration$1;
            }
        });
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration() == (double)-1 ? 1.1 : this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        Predef$.MODULE$.require(topicConcentration > 1.0 || topicConcentration == -1.0, (Function0)new Serializable(this, topicConcentration){
            public static final long serialVersionUID = 0L;
            private final double topicConcentration$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA topicConcentration must be > 1.0 (or -1 for auto), but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.topicConcentration$1)}));
            }
            {
                this.topicConcentration$1 = topicConcentration$1;
            }
        });
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setBeta(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    public DistributedLDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        EMOptimizer state = LDA$.MODULE$.org$apache$spark$mllib$clustering$LDA$$initialState(documents, this.k(), this.getDocConcentration(), this.getTopicConcentration(), this.seed(), this.checkpointInterval());
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        }
        state.graphCheckpointer().deleteAllCheckpoints();
        return new DistributedLDAModel(state, iterationTimes);
    }

    public DistributedLDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, double docConcentration, double topicConcentration, long seed, int checkpointInterval) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        Logging.class.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, -1.0, -1.0, Utils$.MODULE$.random().nextLong(), 10);
    }

    public static class EMOptimizer {
        private Graph<DenseVector<Object>, Object> graph;
        private final int k;
        private final int vocabSize;
        private final double docConcentration;
        private final double topicConcentration;
        private final PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer;
        private DenseVector<Object> globalTopicTotals;

        public Graph<DenseVector<Object>, Object> graph() {
            return this.graph;
        }

        public void graph_$eq(Graph<DenseVector<Object>, Object> x$1) {
            this.graph = x$1;
        }

        public int k() {
            return this.k;
        }

        public int vocabSize() {
            return this.vocabSize;
        }

        public double docConcentration() {
            return this.docConcentration;
        }

        public double topicConcentration() {
            return this.topicConcentration;
        }

        public PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer() {
            return this.graphCheckpointer;
        }

        public EMOptimizer next() {
            double eta = this.topicConcentration();
            int W = this.vocabSize();
            double alpha = this.docConcentration();
            DenseVector<Object> N_k = this.globalTopicTotals();
            Serializable sendMsg = new Serializable(this, eta, W, alpha, N_k){
                public static final long serialVersionUID = 0L;
                private final double eta$1;
                private final int W$1;
                private final double alpha$1;
                private final DenseVector N_k$1;

                public final void apply(EdgeContext<DenseVector<Object>, Object, Tuple2<Object, DenseVector<Object>>> edgeContext) {
                    double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
                    DenseVector scaledTopicDistribution = (DenseVector)LDA$.MODULE$.org$apache$spark$mllib$clustering$LDA$$computePTopic((DenseVector<Object>)((DenseVector)edgeContext.srcAttr()), (DenseVector<Object>)((DenseVector)edgeContext.dstAttr()), (DenseVector<Object>)this.N_k$1, this.W$1, this.eta$1, this.alpha$1).$times$eq((Object)BoxesRunTime.boxToDouble((double)N_wj), DenseVector$.MODULE$.canScaleIntoD());
                    edgeContext.sendToDst((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
                    edgeContext.sendToSrc((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
                }
                {
                    this.eta$1 = eta$1;
                    this.W$1 = W$1;
                    this.alpha$1 = alpha$1;
                    this.N_k$1 = N_k$1;
                }
            };
            Serializable mergeMsg = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> m0, Tuple2<Object, DenseVector<Object>> m1) {
                    DenseVector sum = m0._1$mcZ$sp() ? (DenseVector)((NumericOps)m0._2()).$plus$eq(m1._2(), DenseVector$.MODULE$.canAddIntoD()) : (m1._1$mcZ$sp() ? (DenseVector)((NumericOps)m1._2()).$plus$eq(m0._2(), DenseVector$.MODULE$.canAddIntoD()) : (DenseVector)((NumericOps)m0._2()).$plus(m1._2(), DenseVector$.MODULE$.canAddD()));
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)sum);
                }
            };
            Graph<DenseVector<Object>, Object> qual$1 = this.graph();
            Serializable x$7 = sendMsg;
            Serializable x$8 = mergeMsg;
            TripletFields x$9 = qual$1.aggregateMessages$default$3();
            VertexRDD docTopicDistributions = qual$1.aggregateMessages((Function1)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(Tuple2.class)).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DenseVector<Object> apply(Tuple2<Object, DenseVector<Object>> x$1) {
                    return (DenseVector)x$1._2();
                }
            }, ClassTag$.MODULE$.apply(DenseVector.class));
            GraphImpl newGraph = GraphImpl$.MODULE$.fromExistingRDDs(docTopicDistributions, this.graph().edges(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            this.graph_$eq((Graph<DenseVector<Object>, Object>)newGraph);
            this.graphCheckpointer().updateGraph((Graph<DenseVector<Object>, Object>)newGraph);
            this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
            return this;
        }

        public DenseVector<Object> globalTopicTotals() {
            return this.globalTopicTotals;
        }

        public void globalTopicTotals_$eq(DenseVector<Object> x$1) {
            this.globalTopicTotals = x$1;
        }

        private DenseVector<Object> computeGlobalTopicTotals() {
            int numTopics = this.k();
            return (DenseVector)RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.graph().vertices().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, ?> v) {
                    return LDA$.MODULE$.isTermVertex(v);
                }
            }), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)DenseVector$.MODULE$.zeros$mDc$sp(numTopics, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DenseVector<Object> apply(DenseVector<Object> x$2, DenseVector<Object> x$3) {
                    return (DenseVector)x$2.$plus$eq(x$3, DenseVector$.MODULE$.canAddIntoD());
                }
            });
        }

        public EMOptimizer(Graph<DenseVector<Object>, Object> graph, int k, int vocabSize, double docConcentration, double topicConcentration, int checkpointInterval) {
            this.graph = graph;
            this.k = k;
            this.vocabSize = vocabSize;
            this.docConcentration = docConcentration;
            this.topicConcentration = topicConcentration;
            this.graphCheckpointer = new PeriodicGraphCheckpointer<DenseVector<Object>, Object>(this.graph(), checkpointInterval);
            this.globalTopicTotals = this.computeGlobalTopicTotals();
        }
    }
}

