/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.clustering.StreamingKMeans$;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u00015\u0011qb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\r%\u0011qC\u0002\u0002\b\u0019><w-\u001b8h\u0011!I\u0002A!a\u0001\n\u0003Q\u0012!A6\u0016\u0003m\u0001\"a\u0004\u000f\n\u0005u\u0001\"aA%oi\"Aq\u0004\u0001BA\u0002\u0013\u0005\u0001%A\u0003l?\u0012*\u0017\u000f\u0006\u0002\"IA\u0011qBI\u0005\u0003GA\u0011A!\u00168ji\"9QEHA\u0001\u0002\u0004Y\u0012a\u0001=%c!Aq\u0005\u0001B\u0001B\u0003&1$\u0001\u0002lA!A\u0011\u0006\u0001BA\u0002\u0013\u0005!&A\u0006eK\u000e\f\u0017PR1di>\u0014X#A\u0016\u0011\u0005=a\u0013BA\u0017\u0011\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001BA\u0002\u0013\u0005\u0001'A\beK\u000e\f\u0017PR1di>\u0014x\fJ3r)\t\t\u0013\u0007C\u0004&]\u0005\u0005\t\u0019A\u0016\t\u0011M\u0002!\u0011!Q!\n-\nA\u0002Z3dCf4\u0015m\u0019;pe\u0002B\u0001\"\u000e\u0001\u0003\u0002\u0004%\tAN\u0001\ti&lW-\u00168jiV\tq\u0007\u0005\u00029w9\u0011q\"O\u0005\u0003uA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!\b\u0005\u0005\t\u007f\u0001\u0011\t\u0019!C\u0001\u0001\u0006aA/[7f+:LGo\u0018\u0013fcR\u0011\u0011%\u0011\u0005\bKy\n\t\u00111\u00018\u0011!\u0019\u0005A!A!B\u00139\u0014!\u0003;j[\u0016,f.\u001b;!\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q!q)\u0013&L!\tA\u0005!D\u0001\u0003\u0011\u0015IB\t1\u0001\u001c\u0011\u0015IC\t1\u0001,\u0011\u0015)D\t1\u00018\u0011\u0015)\u0005\u0001\"\u0001N)\u00059\u0005bB(\u0001\u0001\u0004%\t\u0002U\u0001\u0006[>$W\r\\\u000b\u0002#B\u0011\u0001JU\u0005\u0003'\n\u0011Ac\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn]'pI\u0016d\u0007bB+\u0001\u0001\u0004%\tBV\u0001\n[>$W\r\\0%KF$\"!I,\t\u000f\u0015\"\u0016\u0011!a\u0001#\"1\u0011\f\u0001Q!\nE\u000ba!\\8eK2\u0004\u0003\"B.\u0001\t\u0003a\u0016\u0001B:fi.#\"!\u00180\u000e\u0003\u0001AQ!\u0007.A\u0002mAQ\u0001\u0019\u0001\u0005\u0002\u0005\fab]3u\t\u0016\u001c\u0017-\u001f$bGR|'\u000f\u0006\u0002^E\")1m\u0018a\u0001W\u0005\t\u0011\rC\u0003f\u0001\u0011\u0005a-A\u0006tKRD\u0015\r\u001c4MS\u001a,GcA/hS\")\u0001\u000e\u001aa\u0001W\u0005A\u0001.\u00197g\u0019&4W\rC\u00036I\u0002\u0007q\u0007C\u0003l\u0001\u0011\u0005A.A\ttKRLe.\u001b;jC2\u001cUM\u001c;feN$2!X7y\u0011\u0015q'\u000e1\u0001p\u0003\u001d\u0019WM\u001c;feN\u00042a\u00049s\u0013\t\t\bCA\u0003BeJ\f\u0017\u0010\u0005\u0002tm6\tAO\u0003\u0002v\t\u00051A.\u001b8bY\u001eL!a\u001e;\u0003\rY+7\r^8s\u0011\u0015I(\u000e1\u0001{\u0003\u001d9X-[4iiN\u00042a\u00049,\u0011\u0015a\b\u0001\"\u0001~\u0003A\u0019X\r\u001e*b]\u0012|WnQ3oi\u0016\u00148\u000f\u0006\u0004^}\u0006\u0005\u0011Q\u0001\u0005\u0006\u007fn\u0004\raG\u0001\u0004I&l\u0007BBA\u0002w\u0002\u00071&\u0001\u0004xK&<\u0007\u000e\u001e\u0005\n\u0003\u000fY\b\u0013!a\u0001\u0003\u0013\tAa]3fIB\u0019q\"a\u0003\n\u0007\u00055\u0001C\u0001\u0003M_:<\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\fY\u0006$Xm\u001d;N_\u0012,G\u000eF\u0001R\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tq\u0001\u001e:bS:|e\u000eF\u0002\"\u00037A\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\u0005I\u0006$\u0018\rE\u0003\u0002\"\u0005-\"/\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u001d!7\u000f\u001e:fC6T1!!\u000b\u0007\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002.\u0005\r\"a\u0002#TiJ,\u0017-\u001c\u0005\b\u0003c\u0001A\u0011AA\u001a\u0003%\u0001(/\u001a3jGR|e\u000e\u0006\u0003\u00026\u0005]\u0002#BA\u0011\u0003WY\u0002\u0002CA\u000f\u0003_\u0001\r!a\b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005y\u0001O]3eS\u000e$xJ\u001c,bYV,7/\u0006\u0003\u0002@\u0005=C\u0003BA!\u0003c\"B!a\u0011\u0002bA1\u0011\u0011EA\u0016\u0003\u000b\u0002baDA$\u0003\u0017Z\u0012bAA%!\t1A+\u001e9mKJ\u0002B!!\u0014\u0002P1\u0001A\u0001CA)\u0003s\u0011\r!a\u0015\u0003\u0003-\u000bB!!\u0016\u0002\\A\u0019q\"a\u0016\n\u0007\u0005e\u0003CA\u0004O_RD\u0017N\\4\u0011\u0007=\ti&C\u0002\u0002`A\u00111!\u00118z\u0011)\t\u0019'!\u000f\u0002\u0002\u0003\u000f\u0011QM\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBA4\u0003[\nY%\u0004\u0002\u0002j)\u0019\u00111\u000e\t\u0002\u000fI,g\r\\3di&!\u0011qNA5\u0005!\u0019E.Y:t)\u0006<\u0007\u0002CA\u000f\u0003s\u0001\r!a\u001d\u0011\r\u0005\u0005\u00121FA;!\u0019y\u0011qIA&e\"A\u0011\u0011\u0010\u0001!\n\u0013\tY(A\tbgN,'\u000f^%oSRL\u0017\r\\5{K\u0012$\u0012!\t\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003\u0003\u000b!d]3u%\u0006tGm\\7DK:$XM]:%I\u00164\u0017-\u001e7uIM*\"!a!+\t\u0005%\u0011QQ\u0016\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0013\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0006-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a\u0001!!'\u0011\t\u0005m\u0015qT\u0007\u0003\u0003;S1!!%\u0007\u0013\u0011\t\t+!(\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u0011\u0005\u0015&\u0001#\u0001\u0003\u0003O\u000bqb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\t\u0004\u0011\u0006%faB\u0001\u0003\u0011\u0003\u0011\u00111V\n\u0004\u0003Ss\u0001bB#\u0002*\u0012\u0005\u0011q\u0016\u000b\u0003\u0003OC!\"a-\u0002*\n\u0007IQAA[\u0003\u001d\u0011\u0015\tV\"I\u000bN+\"!a.\u0010\u0005\u0005e\u0016EAA^\u0003\u001d\u0011\u0017\r^2iKND\u0011\"a0\u0002*\u0002\u0006i!a.\u0002\u0011\t\u000bEk\u0011%F'\u0002B!\"a1\u0002*\n\u0007IQAAc\u0003\u0019\u0001v*\u0013(U'V\u0011\u0011qY\b\u0003\u0003\u0013\f#!a3\u0002\rA|\u0017N\u001c;t\u0011%\ty-!+!\u0002\u001b\t9-A\u0004Q\u001f&sEk\u0015\u0011")
public class StreamingKMeans
implements Logging {
    private int k;
    private double decayFactor;
    private String timeUnit;
    private StreamingKMeansModel model;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String POINTS() {
        return StreamingKMeans$.MODULE$.POINTS();
    }

    public static String BATCHES() {
        return StreamingKMeans$.MODULE$.BATCHES();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public double decayFactor() {
        return this.decayFactor;
    }

    public void decayFactor_$eq(double x$1) {
        this.decayFactor = x$1;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public void timeUnit_$eq(String x$1) {
        this.timeUnit = x$1;
    }

    public StreamingKMeansModel model() {
        return this.model;
    }

    public void model_$eq(StreamingKMeansModel x$1) {
        this.model = x$1;
    }

    public StreamingKMeans setK(int k) {
        this.k_$eq(k);
        return this;
    }

    public StreamingKMeans setDecayFactor(double a) {
        this.decayFactor_$eq(this.decayFactor());
        return this;
    }

    public StreamingKMeans setHalfLife(double halfLife, String timeUnit) {
        block3: {
            block2: {
                String string = timeUnit;
                String string2 = "batches";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = timeUnit;
                String string4 = "points";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.decayFactor_$eq(package$.MODULE$.exp(package$.MODULE$.log(0.5) / halfLife));
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingKMeans $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Setting decay factor to: %g ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.decayFactor())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.timeUnit_$eq(timeUnit);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid time unit for decay: ").append((Object)timeUnit).toString());
    }

    public StreamingKMeans setInitialCenters(Vector[] centers, double[] weights) {
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public StreamingKMeans setRandomCenters(int dim, double weight, long seed) {
        XORShiftRandom random = new XORShiftRandom(seed);
        Vector[] centers = (Vector[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, dim, random){
            public static final long serialVersionUID = 0L;
            private final int dim$1;
            public final XORShiftRandom random$1;

            public final Vector apply() {
                return Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.dim$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.random$1.nextGaussian();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.dim$1 = dim$1;
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        double[] weights = (double[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, weight){
            public static final long serialVersionUID = 0L;
            private final double weight$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.weight$1;
            }
            {
                this.weight$1 = weight$1;
            }
        }, ClassTag$.MODULE$.Double());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public long setRandomCenters$default$3() {
        return Utils$.MODULE$.random().nextLong();
    }

    public StreamingKMeansModel latestModel() {
        return this.model();
    }

    public void trainOn(DStream<Vector> data) {
        this.assertInitialized();
        data.foreachRDD((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeans $outer;

            public final void apply(RDD<Vector> rdd, Time time) {
                this.$outer.model_$eq(this.$outer.model().update(rdd, this.$outer.decayFactor(), this.$outer.timeUnit()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        this.assertInitialized();
        StreamingKMeansModel streamingKMeansModel = this.model();
        return data.map((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$1$1;

            public final int apply(Vector point) {
                return this.eta$0$1$1.predict(point);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        this.assertInitialized();
        DStream<Tuple2<K, Vector>> x$5 = data;
        ClassTag<K> x$6 = evidence$1;
        ClassTag x$7 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$8 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$5);
        StreamingKMeansModel streamingKMeansModel = this.model();
        return DStream$.MODULE$.toPairDStreamFunctions(x$5, x$6, x$7, null).mapValues((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$2$1;

            public final int apply(Vector point) {
                return this.eta$0$2$1.predict(point);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    private void assertInitialized() {
        if (this.model().clusterCenters() == null) {
            throw new IllegalStateException("Initial cluster centers must be set before starting predictions");
        }
    }

    public StreamingKMeans(int k, double decayFactor, String timeUnit) {
        this.k = k;
        this.decayFactor = decayFactor;
        this.timeUnit = timeUnit;
        Logging.class.$init$((Logging)this);
        this.model = new StreamingKMeansModel(null, null);
    }

    public StreamingKMeans() {
        this(2, 1.0, "batches");
    }
}

