/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\tq!+\u00198lS:<W*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tqAf\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003M\u0001(/\u001a3jGRLwN\\!oI2\u000b'-\u001a7t!\ry\"\u0005J\u0007\u0002A)\u0011\u0011EB\u0001\u0004e\u0012$\u0017BA\u0012!\u0005\r\u0011F\t\u0012\t\u0005!\u0015:s%\u0003\u0002'#\t1A+\u001e9mKJ\u00022\u0001\u0005\u0015+\u0013\tI\u0013CA\u0003BeJ\f\u0017\u0010\u0005\u0002,Y1\u0001A!B\u0017\u0001\u0005\u0004q#!\u0001+\u0012\u0005=\u0012\u0004C\u0001\t1\u0013\t\t\u0014CA\u0004O_RD\u0017N\\4\u0011\u0005A\u0019\u0014B\u0001\u001b\u0012\u0005\r\te.\u001f\u0005\tm\u0001\u0011\u0019\u0011)A\u0006o\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007aZ$&D\u0001:\u0015\tQ\u0014#A\u0004sK\u001adWm\u0019;\n\u0005qJ$\u0001C\"mCN\u001cH+Y4\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\t\u0001E\t\u0006\u0002B\u0007B\u0019!\t\u0001\u0016\u000e\u0003\tAQAN\u001fA\u0004]BQ!H\u001fA\u0002yAQA\u0012\u0001\u0005\u0002\u001d\u000b1\u0002\u001d:fG&\u001c\u0018n\u001c8BiR\u0011\u0001j\u0013\t\u0003!%K!AS\t\u0003\r\u0011{WO\u00197f\u0011\u0015aU\t1\u0001N\u0003\u0005Y\u0007C\u0001\tO\u0013\ty\u0015CA\u0002J]RD\u0001\"\u0015\u0001\t\u0006\u0004%\tAU\u0001\u0015[\u0016\fg.\u0011<fe\u0006<W\r\u0015:fG&\u001c\u0018n\u001c8\u0016\u0003!C\u0001\u0002\u0016\u0001\t\u0002\u0003\u0006K\u0001S\u0001\u0016[\u0016\fg.\u0011<fe\u0006<W\r\u0015:fG&\u001c\u0018n\u001c8!\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019qGmY4BiR\u0011\u0001\n\u0017\u0005\u0006\u0019V\u0003\r!\u0014\u0015\u0003\u0001i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002`9\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class RankingMetrics<T>
implements Logging,
Serializable {
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private double meanAveragePrecision;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RankingMetrics $outer;

                    public final double apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double d;
                            Object pred = tuple2._1();
                            Object lab = tuple2._2();
                            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                            if (labSet.nonEmpty()) {
                                int cnt = 0;
                                double precSum = 0.0;
                                int n = ScalaRunTime$.MODULE$.array_length(pred);
                                for (int i = 0; i < n; ++i) {
                                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                                    precSum += (double)(++cnt) / (double)(i + 1);
                                }
                                d = precSum / (double)labSet.size();
                            } else {
                                this.$outer.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Empty ground truth set, check input data";
                                    }
                                });
                                d = 0.0;
                            }
                            double d2 = d;
                            return d2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
            return this.meanAveragePrecision;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ranking position k should be positive";
            }
        });
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RankingMetrics $outer;
            private final int k$1;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double d;
                    Object pred = tuple2._1();
                    Object lab = tuple2._2();
                    Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                    if (labSet.nonEmpty()) {
                        int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), this.k$1);
                        int cnt = 0;
                        for (int i = 0; i < n; ++i) {
                            if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                            ++cnt;
                        }
                        d = (double)cnt / (double)this.k$1;
                    } else {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Empty ground truth set, check input data";
                            }
                        });
                        d = 0.0;
                    }
                    double d2 = d;
                    return d2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.k$1 = k$1;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    public double meanAveragePrecision() {
        return this.bitmap$0 ? this.meanAveragePrecision : this.meanAveragePrecision$lzycompute();
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ranking position k should be positive";
            }
        });
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RankingMetrics $outer;
            private final int k$2;

            public final double apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    double d;
                    Object pred = tuple2._1();
                    Object lab = tuple2._2();
                    Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                    if (labSet.nonEmpty()) {
                        int labSetSize = labSet.size();
                        int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), this.k$2);
                        double maxDcg = 0.0;
                        double dcg = 0.0;
                        for (int i = 0; i < n; ++i) {
                            double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                            if (labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                                dcg += gain;
                            }
                            if (i >= labSetSize) continue;
                            maxDcg += gain;
                        }
                        d = dcg / maxDcg;
                    } else {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Empty ground truth set, check input data";
                            }
                        });
                        d = 0.0;
                    }
                    double d2 = d;
                    return d2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.k$2 = k$2;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.class.$init$((Logging)this);
    }
}

