/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001b\tQaj\u001c:nC2L'0\u001a:\u000b\u0005\r!\u0011a\u00024fCR,(/\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0005,fGR|'\u000f\u0016:b]N4wN]7fe\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0001q!\ty1$\u0003\u0002\u001d!\t1Ai\\;cY\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDC\u0001\u0011\"!\t)\u0002\u0001C\u0003\u001a;\u0001\u0007!\u0004C\u0003\u001f\u0001\u0011\u00051\u0005F\u0001!\u0011\u0015)\u0003\u0001\"\u0011'\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002([A\u0011\u0001fK\u0007\u0002S)\u0011!\u0006B\u0001\u0007Y&t\u0017\r\\4\n\u00051J#A\u0002,fGR|'\u000fC\u0003/I\u0001\u0007q%\u0001\u0004wK\u000e$xN\u001d\u0015\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00026e\taQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class Normalizer
implements VectorTransformer {
    private final double p;

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        double norm = Vectors$.MODULE$.norm(vector, this.p);
        if (norm != 0.0) {
            Vector vector3;
            DenseVector denseVector;
            Option<double[]> option;
            Vector vector4 = vector;
            if (vector4 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector4)).isEmpty()) {
                double[] vs = (double[])option.get();
                double[] values = (double[])vs.clone();
                int size = Predef$.MODULE$.doubleArrayOps(values).size();
                int i = 0;
                while (i < size) {
                    int n = i++;
                    values[n] = values[n] / norm;
                }
                vector3 = Vectors$.MODULE$.dense(values);
            } else {
                SparseVector sparseVector;
                Option<Tuple3<Object, int[], double[]>> option2;
                if (!(vector4 instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector4)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
                int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
                int[] ids = (int[])((Tuple3)option2.get())._2();
                double[] vs = (double[])((Tuple3)option2.get())._3();
                double[] values = (double[])vs.clone();
                int nnz = Predef$.MODULE$.doubleArrayOps(values).size();
                int i = 0;
                while (i < nnz) {
                    int n = i++;
                    values[n] = values[n] / norm;
                }
                vector3 = Vectors$.MODULE$.sparse(size, ids, values);
            }
            vector2 = vector3;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public Normalizer(double p) {
        this.p = p;
        VectorTransformer$class.$init$(this);
        Predef$.MODULE$.require(p >= 1.0);
    }

    public Normalizer() {
        this(2.0);
    }
}

